/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class AbstractMethodOverridesAbstractMethodInspection
extends BaseInspection {
    public boolean ignoreJavaDoc = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.display.name", new Object[0]);
        if (string == null) {
            AbstractMethodOverridesAbstractMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AbstractMethodOverridesAbstractMethodFix();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.problem.descriptor", new Object[0]);
        if (string == null) {
            AbstractMethodOverridesAbstractMethodInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.ignore.different.javadoc.option", new Object[0]), "ignoreJavaDoc");
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AbstractMethodOverridesAbstractMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/inheritance/AbstractMethodOverridesAbstractMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class AbstractMethodOverridesAbstractMethodVisitor
    extends BaseInspectionVisitor {
        private AbstractMethodOverridesAbstractMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod[] superMethods;
            if (method == null) {
                AbstractMethodOverridesAbstractMethodVisitor.$$$reportNull$$$0(0);
            }
            if (method.isConstructor() || !method.hasModifierProperty("abstract")) {
                return;
            }
            boolean overrideDefault = false;
            boolean accept = false;
            for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                overrideDefault |= superMethod.hasModifierProperty("default");
                if (!superMethod.hasModifierProperty("abstract")) continue;
                if (overrideDefault) {
                    return;
                }
                accept |= this.methodsHaveSameReturnTypes(method, superMethod) && this.haveSameExceptionSignatures(method, superMethod) && method.isVarArgs() == superMethod.isVarArgs();
                if (AbstractMethodOverridesAbstractMethodInspection.this.ignoreJavaDoc && !this.haveSameJavaDoc(method, superMethod)) {
                    return;
                }
                if (this.methodsHaveSameAnnotationsAndModifiers(method, superMethod)) continue;
                return;
            }
            if (accept && !overrideDefault) {
                this.registerMethodError(method, new Object[0]);
            }
        }

        private boolean methodsHaveSameAnnotationsAndModifiers(PsiMethod method, PsiMethod superMethod) {
            if (!MethodUtils.haveEquivalentModifierLists(method, superMethod)) {
                return false;
            }
            PsiParameter[] superParameters = superMethod.getParameterList().getParameters();
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (parameters2.length != superParameters.length) {
                return false;
            }
            int length = superParameters.length;
            for (int i = 0; i < length; ++i) {
                if (this.haveSameAnnotations((PsiModifierListOwner)parameters2[i], (PsiModifierListOwner)superParameters[i])) continue;
                return false;
            }
            return true;
        }

        private boolean haveSameAnnotations(PsiModifierListOwner owner1, PsiModifierListOwner owner2) {
            PsiModifierList modifierList = owner1.getModifierList();
            PsiModifierList superModifierList = owner2.getModifierList();
            if (superModifierList == null) {
                return modifierList == null;
            }
            if (modifierList == null) {
                return false;
            }
            return AnnotationUtil.equal((PsiAnnotation[])modifierList.getAnnotations(), (PsiAnnotation[])superModifierList.getAnnotations());
        }

        private boolean haveSameJavaDoc(PsiMethod method, PsiMethod superMethod) {
            PsiDocComment superDocComment = superMethod.getDocComment();
            PsiDocComment docComment = method.getDocComment();
            return !(superDocComment == null ? docComment != null : docComment != null && !superDocComment.getText().equals(docComment.getText()));
        }

        private boolean haveSameExceptionSignatures(PsiMethod method1, PsiMethod method2) {
            PsiReferenceList list2;
            PsiClassType[] exceptions2;
            PsiReferenceList list1 = method1.getThrowsList();
            PsiClassType[] exceptions1 = list1.getReferencedTypes();
            if (exceptions1.length != (exceptions2 = (list2 = method2.getThrowsList()).getReferencedTypes()).length) {
                return false;
            }
            HashSet<PsiClassType> set1 = new HashSet<PsiClassType>(Arrays.asList(exceptions1));
            for (PsiClassType anException : exceptions2) {
                if (set1.contains(anException)) continue;
                return false;
            }
            return true;
        }

        private boolean methodsHaveSameReturnTypes(PsiMethod method1, PsiMethod method2) {
            PsiType type1 = method1.getReturnType();
            if (type1 == null) {
                return false;
            }
            PsiClass superClass = method2.getContainingClass();
            PsiClass aClass = method1.getContainingClass();
            if (aClass == null || superClass == null) {
                return false;
            }
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiType type2 = method2.getReturnType();
            return Comparing.equal((Object)type1, (Object)substitutor.substitute(type2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/inheritance/AbstractMethodOverridesAbstractMethodInspection$AbstractMethodOverridesAbstractMethodVisitor", "visitMethod"));
        }
    }

    private static class AbstractMethodOverridesAbstractMethodFix
    extends InspectionGadgetsFix {
        private AbstractMethodOverridesAbstractMethodFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.remove.quickfix", new Object[0]);
            if (string == null) {
                AbstractMethodOverridesAbstractMethodFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)methodNameIdentifier.getParent();
            assert (method != null);
            PsiMethod[] superMethods = method.findSuperMethods();
            Collection references = ReferencesSearch.search((PsiElement)method).findAll();
            List elements = (List)references.stream().map(ref -> ref.getElement()).filter(a -> a instanceof PsiDocMethodOrFieldRef).collect(Collectors.toCollection(() -> new SmartList()));
            elements.add(method);
            if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)elements)) {
                return;
            }
            WriteAction.run(() -> {
                AbstractMethodOverridesAbstractMethodFix.deleteElement((PsiElement)method);
                references.forEach(a -> a.bindToElement((PsiElement)superMethods[0]));
            });
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/AbstractMethodOverridesAbstractMethodInspection$AbstractMethodOverridesAbstractMethodFix", "getFamilyName"));
        }
    }
}

