/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class ThisEscapedInConstructorInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ThisEscapedInObjectConstruction" == null) {
            ThisEscapedInConstructorInspection.$$$reportNull$$$0(0);
        }
        return "ThisEscapedInObjectConstruction";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("this.reference.escaped.in.construction.display.name", new Object[0]);
        if (string == null) {
            ThisEscapedInConstructorInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("this.reference.escaped.in.construction.problem.descriptor", new Object[0]);
        if (string == null) {
            ThisEscapedInConstructorInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThisExposedInConstructorInspectionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/initialization/ThisEscapedInConstructorInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ThisExposedInConstructorInspectionVisitor
    extends BaseInspectionVisitor {
        private ThisExposedInConstructorInspectionVisitor() {
        }

        public void visitThisExpression(PsiThisExpression expression2) {
            PsiElement parent;
            super.visitThisExpression(expression2);
            if (!ThisExposedInConstructorInspectionVisitor.isInInitializer((PsiElement)expression2)) {
                return;
            }
            PsiJavaCodeReferenceElement qualifier = expression2.getQualifier();
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)expression2);
            if (qualifier != null) {
                PsiElement element = qualifier.resolve();
                if (!(element instanceof PsiClass)) {
                    return;
                }
                PsiClass aClass = (PsiClass)element;
                if (!aClass.equals(containingClass)) {
                    return;
                }
            }
            if ((parent = expression2.getParent()) instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                if (!ThisExposedInConstructorInspectionVisitor.thisEscapesToField(expression2, assignmentExpression)) {
                    return;
                }
                this.registerError((PsiElement)expression2, new Object[0]);
            } else if (parent instanceof PsiExpressionList) {
                PsiElement grandParent = parent.getParent();
                if (grandParent instanceof PsiNewExpression) {
                    PsiNewExpression newExpression = (PsiNewExpression)grandParent;
                    if (!ThisExposedInConstructorInspectionVisitor.thisEscapesToConstructor(expression2, newExpression)) {
                        return;
                    }
                    this.registerError((PsiElement)expression2, new Object[0]);
                } else if (grandParent instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                    if (!ThisExposedInConstructorInspectionVisitor.thisEscapesToMethod(expression2, methodCallExpression)) {
                        return;
                    }
                    this.registerError((PsiElement)expression2, new Object[0]);
                }
            }
        }

        private static boolean thisEscapesToMethod(PsiThisExpression expression2, PsiMethodCallExpression methodCallExpression) {
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)expression2);
            if (containingClass == null) {
                return false;
            }
            PsiClass methodClass = method.getContainingClass();
            if (method.hasModifierProperty("static")) {
                return true;
            }
            return methodClass != null && !containingClass.isInheritor(methodClass, true);
        }

        private static boolean thisEscapesToConstructor(PsiThisExpression expression2, PsiNewExpression newExpression) {
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)expression2);
            PsiJavaCodeReferenceElement referenceElement = newExpression.getClassReference();
            if (referenceElement == null) {
                return false;
            }
            PsiElement element = referenceElement.resolve();
            if (!(element instanceof PsiClass)) {
                return false;
            }
            PsiClass constructorClass = (PsiClass)element;
            return !PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)constructorClass, (boolean)false) || constructorClass.hasModifierProperty("static");
        }

        private static boolean thisEscapesToField(PsiThisExpression expression2, PsiAssignmentExpression assignmentExpression) {
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (!expression2.equals(rhs)) {
                return false;
            }
            PsiExpression lExpression = assignmentExpression.getLExpression();
            if (!(lExpression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression leftExpression = (PsiReferenceExpression)lExpression;
            PsiElement element = leftExpression.resolve();
            if (!(element instanceof PsiField)) {
                return false;
            }
            PsiField field = (PsiField)element;
            if (field.hasModifierProperty("static")) {
                return true;
            }
            PsiClass assignmentClass = ClassUtils.getContainingClass((PsiElement)assignmentExpression);
            PsiClass fieldClass = field.getContainingClass();
            return assignmentClass != null && fieldClass != null && !assignmentClass.isInheritor(fieldClass, true) && !PsiTreeUtil.isAncestor((PsiElement)assignmentClass, (PsiElement)fieldClass, (boolean)false);
        }

        private static boolean isInInitializer(PsiElement call) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            if (method != null) {
                return method.isConstructor();
            }
            PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)call, PsiField.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
            if (field != null) {
                return true;
            }
            PsiClassInitializer classInitializer = (PsiClassInitializer)PsiTreeUtil.getParentOfType((PsiElement)call, PsiClassInitializer.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
            return classInitializer != null && !classInitializer.hasModifierProperty("static");
        }
    }
}

