/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCallInLoopConditionInspectionBase
extends BaseInspection {
    public boolean ignoreIterationMethods = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.call.in.loop.condition.display.name", new Object[0]);
        if (string == null) {
            MethodCallInLoopConditionInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.call.in.loop.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            MethodCallInLoopConditionInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Ignore iteration method calls", (InspectionProfileEntry)this, "ignoreIterationMethods");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCallInLoopConditionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/j2me/MethodCallInLoopConditionInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MethodCallInLoopConditionVisitor
    extends BaseInspectionVisitor {
        private MethodCallInLoopConditionVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                MethodCallInLoopConditionVisitor.$$$reportNull$$$0(0);
            }
            super.visitForStatement(statement);
            PsiExpression condition2 = statement.getCondition();
            if (condition2 == null) {
                return;
            }
            this.checkForMethodCalls(condition2);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                MethodCallInLoopConditionVisitor.$$$reportNull$$$0(1);
            }
            super.visitWhileStatement(statement);
            PsiExpression condition2 = statement.getCondition();
            if (condition2 == null) {
                return;
            }
            this.checkForMethodCalls(condition2);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                MethodCallInLoopConditionVisitor.$$$reportNull$$$0(2);
            }
            super.visitDoWhileStatement(statement);
            PsiExpression condition2 = statement.getCondition();
            if (condition2 == null) {
                return;
            }
            this.checkForMethodCalls(condition2);
        }

        private void checkForMethodCalls(PsiExpression condition2) {
            JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

                public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
                    if (expression2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitMethodCallExpression(expression2);
                    if (MethodCallInLoopConditionInspectionBase.this.ignoreIterationMethods) {
                        PsiMethod method = expression2.resolveMethod();
                        if (MethodCallUtils.isCallToMethod(expression2, "java.util.Iterator", (PsiType)PsiType.BOOLEAN, "hasNext", new PsiType[0]) || MethodCallUtils.isCallToMethod(expression2, "java.util.ListIterator", (PsiType)PsiType.BOOLEAN, "hasPrevious", new PsiType[0]) || MethodCallUtils.isCallToMethod(expression2, "java.sql.ResultSet", (PsiType)PsiType.BOOLEAN, "next", new PsiType[0]) || MethodCallUtils.isCallToMethod(expression2, "java.util.Enumeration", (PsiType)PsiType.BOOLEAN, "hasMoreElements", new PsiType[0])) {
                            return;
                        }
                    }
                    MethodCallInLoopConditionVisitor.this.registerMethodCallError(expression2, new Object[0]);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/j2me/MethodCallInLoopConditionInspectionBase$MethodCallInLoopConditionVisitor$1", "visitMethodCallExpression"));
                }
            };
            condition2.accept((PsiElementVisitor)visitor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/siyeh/ig/j2me/MethodCallInLoopConditionInspectionBase$MethodCallInLoopConditionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDoWhileStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

