/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.intention.impl.AddOnDemandStaticImportAction;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.actions.CleanupInspectionUtil;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringManager;
import com.intellij.refactoring.migration.MigrationManager;
import com.intellij.refactoring.migration.MigrationMap;
import com.intellij.refactoring.migration.MigrationProcessor;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.JUnit5AssertionsConverterInspection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnit5ConverterInspection
extends BaseInspection {
    private static final List<String> ruleAnnotations = Arrays.asList("org.junit.Rule", "org.junit.ClassRule");

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("junit5.converter.display.name", new Object[0]);
        if (string == null) {
            JUnit5ConverterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if ("#ref can be JUnit 5 test" == null) {
            JUnit5ConverterInspection.$$$reportNull$$$0(1);
        }
        return "#ref can be JUnit 5 test";
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        if (!JavaVersionService.getInstance().isAtLeast((PsiElement)file, JavaSdkVersion.JDK_1_8)) {
            return false;
        }
        if (JavaPsiFacade.getInstance((Project)file.getProject()).findClass("org.junit.jupiter.api.Assertions", file.getResolveScope()) == null) {
            return false;
        }
        return super.shouldInspect(file);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MigrateToJUnit5();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            public void visitClass(PsiClass aClass) {
                TestFramework framework = TestFrameworks.detectFramework((PsiClass)aClass);
                if (framework == null || !"JUnit4".equals(framework.getName())) {
                    return;
                }
                if (!JUnit5ConverterInspection.canBeConvertedToJUnit5(aClass)) {
                    return;
                }
                this.registerClassError(aClass, new Object[0]);
            }
        };
    }

    protected static boolean canBeConvertedToJUnit5(PsiClass aClass) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"org.junit.runner.RunWith", (int)1)) {
            return false;
        }
        for (PsiField psiField : aClass.getAllFields()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiField, ruleAnnotations, (int)0)) continue;
            return false;
        }
        for (PsiField psiField : aClass.getMethods()) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiField, ruleAnnotations, (int)0)) {
                return false;
            }
            PsiAnnotation testAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiField, (boolean)true, (String[])new String[]{"org.junit.Test"});
            if (testAnnotation == null || testAnnotation.getParameterList().getAttributes().length <= 0) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/JUnit5ConverterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyDescriptionBasedUsageInfo
    extends UsageInfo {
        private final ProblemDescriptor myDescriptor;

        public MyDescriptionBasedUsageInfo(ProblemDescriptor descriptor) {
            super(descriptor.getPsiElement());
            this.myDescriptor = descriptor;
        }
    }

    private static class MigrateToJUnit5
    extends InspectionGadgetsFix
    implements BatchQuickFix {
        private MigrateToJUnit5() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("junit5.converter.fix.name", new Object[0]);
            if (string == null) {
                MigrateToJUnit5.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            MigrationManager manager;
            MigrationMap migrationMap;
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiClass.class);
            if (psiClass != null && (migrationMap = (manager = RefactoringManager.getInstance(project).getMigrateManager()).findMigrationMap("JUnit (4.x -> 5.0)")) != null) {
                new MyJUnit5MigrationProcessor(project, migrationMap, Collections.singleton(psiClass.getContainingFile())).run();
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull List psiElementsToIgnore, @Nullable Runnable refreshViews) {
            MigrationManager manager;
            MigrationMap migrationMap;
            Set<PsiFile> files;
            if (project == null) {
                MigrateToJUnit5.$$$reportNull$$$0(1);
            }
            if (descriptors == null) {
                MigrateToJUnit5.$$$reportNull$$$0(2);
            }
            if (psiElementsToIgnore == null) {
                MigrateToJUnit5.$$$reportNull$$$0(3);
            }
            if (!(files = Arrays.stream(descriptors).map(descriptor -> ((ProblemDescriptor)descriptor).getPsiElement()).filter(Objects::nonNull).map(element -> element.getContainingFile()).collect(Collectors.toSet())).isEmpty() && (migrationMap = (manager = RefactoringManager.getInstance(project).getMigrateManager()).findMigrationMap("JUnit (4.x -> 5.0)")) != null) {
                new MyJUnit5MigrationProcessor(project, migrationMap, files).run();
                if (refreshViews != null) {
                    refreshViews.run();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/junit/JUnit5ConverterInspection$MigrateToJUnit5";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElementsToIgnore";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/junit/JUnit5ConverterInspection$MigrateToJUnit5";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class MyJUnit5MigrationProcessor
        extends MigrationProcessor {
            private final Project myProject;
            private final Set<PsiFile> myFiles;
            List<SmartPsiElementPointer<PsiElement>> myReplacedRefs = new ArrayList<SmartPsiElementPointer<PsiElement>>();

            public MyJUnit5MigrationProcessor(Project project, MigrationMap migrationMap, Set<PsiFile> files) {
                super(project, migrationMap, GlobalSearchScope.filesWithoutLibrariesScope((Project)project, (Collection)ContainerUtil.map(files, file -> file.getVirtualFile())));
                this.setPrepareSuccessfulSwingThreadCallback(EmptyRunnable.INSTANCE);
                this.myProject = project;
                this.myFiles = files;
            }

            @Override
            protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
                if (refUsages == null) {
                    MyJUnit5MigrationProcessor.$$$reportNull$$$0(0);
                }
                MultiMap conflicts = new MultiMap();
                for (PsiFile file : this.myFiles) {
                    for (PsiClass psiClass : ((PsiClassOwner)file).getClasses()) {
                        HashSet inheritors = new HashSet();
                        ClassInheritorsSearch.search((PsiClass)psiClass).forEach(inheritor -> {
                            if (!JUnit5ConverterInspection.canBeConvertedToJUnit5(inheritor)) {
                                inheritors.add(inheritor);
                                return false;
                            }
                            return true;
                        });
                        if (inheritors.isEmpty()) continue;
                        conflicts.putValue((Object)psiClass, (Object)("Class " + RefactoringUIUtil.getDescription((PsiElement)psiClass, (boolean)true) + " can't be converted to JUnit 5, cause there are incompatible inheritor(s): " + StringUtil.join(inheritors, aClass -> aClass.getQualifiedName(), (String)", ")));
                    }
                }
                this.setPreviewUsages(true);
                return this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
            }

            @Override
            @NotNull
            protected UsageInfo[] findUsages() {
                Object[] usages = super.findUsages();
                InspectionManager inspectionManager = InspectionManager.getInstance((Project)this.myProject);
                GlobalInspectionContext globalContext = inspectionManager.createNewGlobalContext(false);
                LocalInspectionToolWrapper assertionsConverter = new LocalInspectionToolWrapper((LocalInspectionTool)new JUnit5AssertionsConverterInspection("JUnit4"));
                Stream<MyDescriptionBasedUsageInfo> stream = this.myFiles.stream().flatMap(file -> InspectionEngine.runInspectionOnFile((PsiFile)file, (InspectionToolWrapper)assertionsConverter, (GlobalInspectionContext)globalContext).stream());
                Object[] descriptors = (UsageInfo[])stream.map(descriptor -> new MyDescriptionBasedUsageInfo((ProblemDescriptor)descriptor)).toArray(UsageInfo[]::new);
                UsageInfo[] usageInfoArray = (UsageInfo[])ArrayUtil.mergeArrays((Object[])usages, (Object[])descriptors);
                if (usageInfoArray == null) {
                    MyJUnit5MigrationProcessor.$$$reportNull$$$0(1);
                }
                return usageInfoArray;
            }

            @Override
            protected void performRefactoring(@NotNull UsageInfo[] usages) {
                if (usages == null) {
                    MyJUnit5MigrationProcessor.$$$reportNull$$$0(2);
                }
                ArrayList<UsageInfo> migrateUsages = new ArrayList<UsageInfo>();
                ArrayList<ProblemDescriptor> descriptions = new ArrayList<ProblemDescriptor>();
                SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
                for (UsageInfo usage : usages) {
                    if (usage instanceof MyDescriptionBasedUsageInfo) {
                        ProblemDescriptor descriptor = ((MyDescriptionBasedUsageInfo)usage).myDescriptor;
                        descriptions.add(descriptor);
                        this.markUsagesImportedThroughStaticImport(smartPointerManager, descriptor);
                        continue;
                    }
                    migrateUsages.add(usage);
                }
                super.performRefactoring(migrateUsages.toArray(new UsageInfo[migrateUsages.size()]));
                CleanupInspectionUtil.getInstance().applyFixes(this.myProject, "Convert Assertions", descriptions, JUnit5AssertionsConverterInspection.ReplaceObsoleteAssertsFix.class, false);
            }

            @Override
            protected void performPsiSpoilingRefactoring() {
                super.performPsiSpoilingRefactoring();
                this.tryToRestoreStaticImportsOnNewAssertions();
            }

            private void markUsagesImportedThroughStaticImport(SmartPointerManager smartPointerManager, ProblemDescriptor descriptor) {
                PsiElement element = descriptor.getPsiElement();
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
                if (callExpression != null) {
                    PsiElement scope;
                    PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
                    PsiElement psiElement = scope = methodExpression.getQualifierExpression() == null ? methodExpression.advancedResolve(false).getCurrentFileResolveScope() : null;
                    if (scope instanceof PsiImportStaticStatement && ((PsiImportStaticStatement)scope).isOnDemand()) {
                        this.myReplacedRefs.add((SmartPsiElementPointer<PsiElement>)smartPointerManager.createSmartPsiElementPointer((PsiElement)callExpression));
                    }
                }
            }

            private void tryToRestoreStaticImportsOnNewAssertions() {
                for (SmartPsiElementPointer<PsiElement> ref : this.myReplacedRefs) {
                    PsiImportStatementBase importReferenceTo;
                    PsiExpression qualifierExpression2;
                    PsiElement element = ref.getElement();
                    if (!(element instanceof PsiMethodCallExpression) || (qualifierExpression2 = ((PsiMethodCallExpression)element).getMethodExpression().getQualifierExpression()) == null) continue;
                    PsiElement referenceNameElement = ((PsiReferenceExpression)qualifierExpression2).getReferenceNameElement();
                    PsiClass aClass = referenceNameElement != null ? AddOnDemandStaticImportAction.getClassToPerformStaticImport(referenceNameElement) : null;
                    PsiFile containingFile = element.getContainingFile();
                    if (aClass == null || AddOnDemandStaticImportAction.invoke(this.myProject, containingFile, null, referenceNameElement) || (importReferenceTo = (PsiImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)((PsiJavaFile)containingFile).findImportReferenceTo(aClass), PsiImportStatementBase.class)) == null) continue;
                    importReferenceTo.delete();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refUsages";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/siyeh/ig/junit/JUnit5ConverterInspection$MigrateToJUnit5$MyJUnit5MigrationProcessor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "usages";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/siyeh/ig/junit/JUnit5ConverterInspection$MigrateToJUnit5$MyJUnit5MigrationProcessor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findUsages";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "preprocessUsages";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "performRefactoring";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

