/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MultipleExceptionsDeclaredOnTestMethodInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("multiple.exceptions.declared.on.test.method.display.name", new Object[0]);
        if (string == null) {
            MultipleExceptionsDeclaredOnTestMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("multiple.exceptions.declared.on.test.method.problem.descriptor", new Object[0]);
        if (string == null) {
            MultipleExceptionsDeclaredOnTestMethodInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MultipleExceptionsDeclaredOnTestMethodFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantExceptionDeclarationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/MultipleExceptionsDeclaredOnTestMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class RedundantExceptionDeclarationVisitor
    extends BaseInspectionVisitor {
        private RedundantExceptionDeclarationVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!TestUtils.isJUnitTestMethod(method)) {
                return;
            }
            PsiReferenceList throwsList = method.getThrowsList();
            PsiJavaCodeReferenceElement[] referenceElements = throwsList.getReferenceElements();
            if (referenceElements.length < 2) {
                return;
            }
            Query query = MethodReferencesSearch.search((PsiMethod)method);
            PsiReference firstReference = (PsiReference)query.findFirst();
            if (firstReference != null) {
                return;
            }
            this.registerError((PsiElement)throwsList, new Object[0]);
        }
    }

    private static class MultipleExceptionsDeclaredOnTestMethodFix
    extends InspectionGadgetsFix {
        private MultipleExceptionsDeclaredOnTestMethodFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("multiple.exceptions.declared.on.test.method.quickfix", new Object[0]);
            if (string == null) {
                MultipleExceptionsDeclaredOnTestMethodFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiJavaCodeReferenceElement[] referenceElements;
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiReferenceList)) {
                return;
            }
            PsiReferenceList referenceList = (PsiReferenceList)element;
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = referenceList.getReferenceElements()) {
                referenceElement.delete();
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            GlobalSearchScope scope = referenceList.getResolveScope();
            PsiJavaCodeReferenceElement referenceElement = factory.createReferenceElementByFQClassName("java.lang.Exception", scope);
            referenceList.add((PsiElement)referenceElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/MultipleExceptionsDeclaredOnTestMethodInspection$MultipleExceptionsDeclaredOnTestMethodFix", "getFamilyName"));
        }
    }
}

