/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TestMethodIsPublicVoidNoArgInspectionBase
extends BaseInspection {
    public final List<String> ignorableAnnotations = new ArrayList<String>(Collections.singletonList("mockit.Mocked"));

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.display.name", new Object[0]);
        if (string == null) {
            TestMethodIsPublicVoidNoArgInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("TestMethodWithIncorrectSignature" == null) {
            TestMethodIsPublicVoidNoArgInspectionBase.$$$reportNull$$$0(1);
        }
        return "TestMethodWithIncorrectSignature";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Problem problem = (Problem)((Object)infos[0]);
        switch (problem) {
            case PARAMETER: {
                String string = InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.problem.descriptor1", new Object[0]);
                if (string == null) {
                    TestMethodIsPublicVoidNoArgInspectionBase.$$$reportNull$$$0(2);
                }
                return string;
            }
            case NOT_PUBLIC_VOID: {
                String string = InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.problem.descriptor2", new Object[0]);
                if (string == null) {
                    TestMethodIsPublicVoidNoArgInspectionBase.$$$reportNull$$$0(3);
                }
                return string;
            }
            case STATIC: {
                String string = InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.problem.descriptor3", new Object[0]);
                if (string == null) {
                    TestMethodIsPublicVoidNoArgInspectionBase.$$$reportNull$$$0(4);
                }
                return string;
            }
        }
        throw new AssertionError();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestMethodIsPublicVoidNoArgVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/TestMethodIsPublicVoidNoArgInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class TestMethodIsPublicVoidNoArgVisitor
    extends BaseInspectionVisitor {
        private TestMethodIsPublicVoidNoArgVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiType returnType;
            if (method == null) {
                TestMethodIsPublicVoidNoArgVisitor.$$$reportNull$$$0(0);
            }
            if (method.isConstructor()) {
                return;
            }
            if (!TestUtils.isJUnit3TestMethod(method) && !TestUtils.isJUnit4TestMethod(method)) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || AnnotationUtil.isAnnotated((PsiModifierListOwner)containingClass, (String)"org.junit.runner.RunWith", (int)1)) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (method.hasModifierProperty("static")) {
                this.registerMethodError(method, new Object[]{Problem.STATIC, method});
                return;
            }
            if (parameterList.getParametersCount() != 0) {
                PsiParameter[] parameters2 = parameterList.getParameters();
                boolean annotated = true;
                for (PsiParameter parameter2 : parameters2) {
                    if (AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter2, TestMethodIsPublicVoidNoArgInspectionBase.this.ignorableAnnotations, (int)0)) continue;
                    annotated = false;
                    break;
                }
                if (!annotated) {
                    this.registerMethodError(method, new Object[]{Problem.PARAMETER, method});
                    return;
                }
            }
            if (!PsiType.VOID.equals((Object)(returnType = method.getReturnType())) || !method.hasModifierProperty("public")) {
                this.registerMethodError(method, new Object[]{Problem.NOT_PUBLIC_VOID, method});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/junit/TestMethodIsPublicVoidNoArgInspectionBase$TestMethodIsPublicVoidNoArgVisitor", "visitMethod"));
        }
    }

    static enum Problem {
        STATIC,
        NOT_PUBLIC_VOID,
        PARAMETER;

    }
}

