/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.migration.EnumerationCanBeIterationInspectionBase;
import com.siyeh.ig.psiutils.PsiElementOrderComparator;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumerationCanBeIterationInspection
extends EnumerationCanBeIterationInspectionBase {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new EnumerationCanBeIterationFix();
    }

    private static class EnumerationCanBeIterationFix
    extends InspectionGadgetsFix {
        private EnumerationCanBeIterationFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("enumeration.can.be.iteration.quickfix", new Object[0]);
            if (string == null) {
                EnumerationCanBeIterationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiVariable variable;
            PsiElement element = descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)element.getParent();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)methodExpression.getParent();
            PsiElement parent = methodCallExpression.getParent();
            if (parent instanceof PsiVariable) {
                variable = (PsiVariable)parent;
            } else if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                PsiExpression lhs = assignmentExpression.getLExpression();
                if (!(lhs instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return;
                }
                variable = (PsiVariable)target;
            } else {
                return;
            }
            String variableName = EnumerationCanBeIterationFix.createVariableName(element);
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
            if (statement == null) {
                return;
            }
            int result = EnumerationCanBeIterationFix.replaceMethodCalls(variable, statement.getTextOffset(), variableName);
            PsiType variableType = variable.getType();
            if (!(variableType instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)variableType;
            PsiType[] parameterTypes = classType.getParameters();
            PsiType parameterType = parameterTypes.length > 0 ? parameterTypes[0] : null;
            PsiStatement newStatement = EnumerationCanBeIterationFix.createDeclaration(methodCallExpression, variableName, parameterType);
            if (newStatement == null) {
                return;
            }
            if (parent.equals(variable)) {
                if (result == 0) {
                    statement.replace((PsiElement)newStatement);
                } else {
                    PsiExpression initializer;
                    EnumerationCanBeIterationFix.insertNewStatement(statement, newStatement);
                    if (result != 1 && (initializer = variable.getInitializer()) != null) {
                        initializer.delete();
                    }
                }
            } else if (result == 0 || result == 2) {
                statement.replace((PsiElement)newStatement);
            } else {
                EnumerationCanBeIterationFix.insertNewStatement(statement, newStatement);
            }
        }

        private static void insertNewStatement(PsiStatement anchor, PsiStatement newStatement) throws IncorrectOperationException {
            PsiElement statementParent = anchor.getParent();
            if (statementParent instanceof PsiForStatement) {
                PsiElement statementGrandParent = statementParent.getParent();
                statementGrandParent.addBefore((PsiElement)newStatement, statementParent);
            } else {
                statementParent.addAfter((PsiElement)newStatement, (PsiElement)anchor);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        private static PsiStatement createDeclaration(PsiMethodCallExpression methodCallExpression, String variableName, PsiType parameterType) throws IncorrectOperationException {
            StringBuilder newStatementText = new StringBuilder();
            Project project = methodCallExpression.getProject();
            CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project);
            if (((JavaCodeStyleSettings)codeStyleSettings.getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_LOCALS) {
                newStatementText.append("final ");
            }
            newStatementText.append("java.util.Iterator");
            if (parameterType != null) {
                String typeText = parameterType.getCanonicalText();
                newStatementText.append('<');
                newStatementText.append(typeText);
                newStatementText.append('>');
            }
            newStatementText.append(' ');
            newStatementText.append(variableName);
            newStatementText.append('=');
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            String qualifierText = qualifier == null ? "" : qualifier.getText() + '.';
            newStatementText.append(qualifierText);
            String methodName = methodExpression.getReferenceName();
            if ("elements".equals(methodName)) {
                if (TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.util.Vector")) {
                    newStatementText.append("iterator()");
                } else {
                    if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.util.Hashtable")) return null;
                    newStatementText.append("values().iterator()");
                }
            } else {
                if (!"keys".equals(methodName)) return null;
                if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.util.Hashtable")) return null;
                newStatementText.append("keySet().iterator()");
            }
            newStatementText.append(';');
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiStatement statement = factory.createStatementFromText(newStatementText.toString(), (PsiElement)methodExpression);
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
            styleManager.shortenClassReferences((PsiElement)statement);
            return statement;
        }

        private static int replaceMethodCalls(PsiVariable enumerationVariable, int startOffset, String newVariableName) throws IncorrectOperationException {
            PsiManager manager = enumerationVariable.getManager();
            Project project = manager.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = facade.getElementFactory();
            Query query = ReferencesSearch.search((PsiElement)enumerationVariable);
            ArrayList<PsiElement> referenceElements = new ArrayList<PsiElement>();
            for (PsiReference reference : query) {
                PsiElement referenceElement = reference.getElement();
                referenceElements.add(referenceElement);
            }
            Collections.sort(referenceElements, PsiElementOrderComparator.getInstance());
            int result = 0;
            for (PsiElement referenceElement : referenceElements) {
                String newExpressionText;
                if (!(referenceElement instanceof PsiReferenceExpression)) {
                    result = 2;
                    continue;
                }
                if (referenceElement.getTextOffset() <= startOffset) {
                    result = 2;
                    continue;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)referenceElement;
                PsiElement referenceParent = referenceExpression.getParent();
                if (!(referenceParent instanceof PsiReferenceExpression)) {
                    if (referenceParent instanceof PsiAssignmentExpression) {
                        result = 2;
                        break;
                    }
                    result = 1;
                    continue;
                }
                PsiElement referenceGrandParent = referenceParent.getParent();
                if (!(referenceGrandParent instanceof PsiMethodCallExpression)) {
                    result = 1;
                    continue;
                }
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)referenceGrandParent;
                PsiReferenceExpression foundReferenceExpression = callExpression.getMethodExpression();
                String foundName = foundReferenceExpression.getReferenceName();
                if ("hasMoreElements".equals(foundName)) {
                    newExpressionText = newVariableName + ".hasNext()";
                } else if ("nextElement".equals(foundName)) {
                    newExpressionText = newVariableName + ".next()";
                } else {
                    result = 1;
                    continue;
                }
                PsiExpression newExpression = factory.createExpressionFromText(newExpressionText, (PsiElement)callExpression);
                callExpression.replace((PsiElement)newExpression);
            }
            return result;
        }

        @NonNls
        private static String createVariableName(PsiElement context) {
            Project project = context.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = facade.getElementFactory();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            PsiClass iteratorClass = facade.findClass("java.util.Iterator", scope);
            if (iteratorClass == null) {
                return "iterator";
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            PsiClassType iteratorType = factory.createType(iteratorClass);
            SuggestedNameInfo baseNameInfo = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, (PsiType)iteratorType);
            SuggestedNameInfo nameInfo = codeStyleManager.suggestUniqueVariableName(baseNameInfo, context, true);
            if (nameInfo.names.length <= 0) {
                return "iterator";
            }
            return nameInfo.names[0];
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EnumerationCanBeIterationInspection$EnumerationCanBeIterationFix", "getFamilyName"));
        }
    }
}

