/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.naming.MethodNameSameAsClassNameInspectionBase;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MethodNameSameAsClassNameInspection
extends MethodNameSameAsClassNameInspectionBase {
    private static final Set<String> MODIFIERS_ALLOWED_ON_CONSTRUCTORS = ContainerUtil.set((Object[])new String[]{"public", "protected", "private"});

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        Boolean onTheFly = (Boolean)infos[0];
        Boolean canBeConvertedToConstructor = (Boolean)infos[1];
        ArrayList<InspectionGadgetsFix> fixes = new ArrayList<InspectionGadgetsFix>();
        if (onTheFly.booleanValue()) {
            fixes.add(new RenameFix());
        }
        if (canBeConvertedToConstructor.booleanValue()) {
            fixes.add(new MethodNameSameAsClassNameFix());
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = fixes.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        if (inspectionGadgetsFixArray == null) {
            MethodNameSameAsClassNameInspection.$$$reportNull$$$0(0);
        }
        return inspectionGadgetsFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/MethodNameSameAsClassNameInspection", "buildFixes"));
    }

    private static class MethodNameSameAsClassNameFix
    extends InspectionGadgetsFix {
        private MethodNameSameAsClassNameFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("make.method.ctr.quickfix", new Object[0]);
            if (string == null) {
                MethodNameSameAsClassNameFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)element.getParent(), PsiMethod.class);
            if (method == null) {
                return;
            }
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            if (returnTypeElement == null) {
                return;
            }
            PsiModifierList modifiers = method.getModifierList();
            for (String modifier : PsiModifier.MODIFIERS) {
                if (MODIFIERS_ALLOWED_ON_CONSTRUCTORS.contains(modifier)) continue;
                modifiers.setModifierProperty(modifier, false);
            }
            returnTypeElement.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/MethodNameSameAsClassNameInspection$MethodNameSameAsClassNameFix", "getFamilyName"));
        }
    }
}

