/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.naming.NonExceptionNameEndsWithExceptionInspectionBase;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class NonExceptionNameEndsWithExceptionInspection
extends NonExceptionNameEndsWithExceptionInspectionBase {
    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        String name = (String)infos[0];
        Boolean onTheFly = (Boolean)infos[1];
        if (onTheFly.booleanValue()) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new RenameFix(), new ExtendExceptionFix(name)};
            if (inspectionGadgetsFixArray == null) {
                NonExceptionNameEndsWithExceptionInspection.$$$reportNull$$$0(0);
            }
            return inspectionGadgetsFixArray;
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new ExtendExceptionFix(name)};
        if (inspectionGadgetsFixArray == null) {
            NonExceptionNameEndsWithExceptionInspection.$$$reportNull$$$0(1);
        }
        return inspectionGadgetsFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/NonExceptionNameEndsWithExceptionInspection", "buildFixes"));
    }

    private static class ExtendExceptionFix
    extends InspectionGadgetsFix {
        private final String name;

        ExtendExceptionFix(String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("non.exception.name.ends.with.exception.quickfix", this.name);
            if (string == null) {
                ExtendExceptionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Make class extend 'Exception'" == null) {
                ExtendExceptionFix.$$$reportNull$$$0(1);
            }
            return "Make class extend 'Exception'";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiJavaCodeReferenceElement[] referenceElements;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)parent;
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = facade.getElementFactory();
            GlobalSearchScope scope = aClass.getResolveScope();
            PsiJavaCodeReferenceElement reference = factory.createReferenceElementByFQClassName("java.lang.Exception", scope);
            CommentTracker tracker = new CommentTracker();
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
                tracker.delete((PsiElement)referenceElement);
            }
            tracker.insertCommentsBefore(extendsList.add((PsiElement)reference));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/naming/NonExceptionNameEndsWithExceptionInspection$ExtendExceptionFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

