/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class ObjectAllocationInLoopInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("object.allocation.in.loop.display.name", new Object[0]);
        if (string == null) {
            ObjectAllocationInLoopInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("object.allocation.in.loop.problem.descriptor", new Object[0]);
        if (string == null) {
            ObjectAllocationInLoopInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectAllocationInLoopsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/ObjectAllocationInLoopInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ObjectAllocationInLoopsVisitor
    extends BaseInspectionVisitor {
        private ObjectAllocationInLoopsVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            if (expression2 == null) {
                ObjectAllocationInLoopsVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression2);
            if (!ControlFlowUtils.isInLoop((PsiElement)expression2)) {
                return;
            }
            if (ControlFlowUtils.isInExitStatement((PsiExpression)expression2)) {
                return;
            }
            PsiStatement newExpressionStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiStatement.class);
            if (newExpressionStatement == null) {
                return;
            }
            PsiStatement parentStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)newExpressionStatement, PsiStatement.class);
            if (!ControlFlowUtils.statementMayCompleteNormally(parentStatement)) {
                return;
            }
            if (ObjectAllocationInLoopsVisitor.isAllocatedOnlyOnce(expression2)) {
                return;
            }
            this.registerNewExpressionError(expression2, new Object[0]);
        }

        private static boolean isAllocatedOnlyOnce(PsiNewExpression expression2) {
            PsiElement parent = expression2.getParent();
            if (!(parent instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression lExpression = assignmentExpression.getLExpression();
            if (!(lExpression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)assignmentExpression, PsiIfStatement.class);
            if (ifStatement == null) {
                return false;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            if (!(condition2 instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition2;
            if (binaryExpression.getOperationTokenType() != JavaTokenType.EQEQ) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lExpression;
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (lhs instanceof PsiLiteralExpression) {
                if (!"null".equals(lhs.getText())) {
                    return false;
                }
                if (!(rhs instanceof PsiReferenceExpression)) {
                    return false;
                }
                return referenceExpression.getText().equals(rhs.getText());
            }
            if (rhs instanceof PsiLiteralExpression) {
                if (!"null".equals(rhs.getText())) {
                    return false;
                }
                if (!(lhs instanceof PsiReferenceExpression)) {
                    return false;
                }
                return referenceExpression.getText().equals(lhs.getText());
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/ObjectAllocationInLoopInspection$ObjectAllocationInLoopsVisitor", "visitNewExpression"));
        }
    }
}

