/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockUtils {
    public static PsiStatement addBefore(PsiStatement anchor, PsiStatement ... newStatements) {
        if (newStatements.length == 0) {
            throw new IllegalArgumentException();
        }
        PsiStatement oldStatement = anchor;
        PsiElement parent = oldStatement.getParent();
        while (parent instanceof PsiLabeledStatement) {
            oldStatement = (PsiStatement)parent;
            parent = oldStatement.getParent();
        }
        if (newStatements.length == 1 && oldStatement instanceof PsiEmptyStatement) {
            return (PsiStatement)oldStatement.replace((PsiElement)newStatements[0]);
        }
        if (!(parent instanceof PsiCodeBlock)) {
            oldStatement = BlockUtils.expandSingleStatementToBlockStatement(oldStatement);
            parent = oldStatement.getParent();
        }
        PsiElement result = null;
        for (PsiStatement statement : newStatements) {
            result = parent.addBefore((PsiElement)statement, (PsiElement)oldStatement);
        }
        return (PsiStatement)result;
    }

    public static PsiStatement addAfter(PsiStatement anchor, PsiStatement newStatement) {
        PsiStatement oldStatement = anchor;
        PsiElement parent = oldStatement.getParent();
        while (parent instanceof PsiLabeledStatement) {
            oldStatement = (PsiStatement)parent;
            parent = oldStatement.getParent();
        }
        if (!(parent instanceof PsiCodeBlock)) {
            oldStatement = BlockUtils.expandSingleStatementToBlockStatement(oldStatement);
            parent = oldStatement.getParent();
        }
        return (PsiStatement)parent.addAfter((PsiElement)newStatement, (PsiElement)oldStatement);
    }

    public static <T extends PsiStatement> T expandSingleStatementToBlockStatement(@NotNull T statement) {
        if (statement == null) {
            BlockUtils.$$$reportNull$$$0(0);
        }
        if (statement instanceof PsiBlockStatement) {
            return statement;
        }
        PsiBlockStatement blockStatement = (PsiBlockStatement)JavaPsiFacade.getElementFactory((Project)statement.getProject()).createStatementFromText("{}", statement);
        blockStatement.getCodeBlock().add(statement);
        PsiBlockStatement result = (PsiBlockStatement)statement.replace((PsiElement)blockStatement);
        PsiElement sibling = result.getNextSibling();
        if (sibling instanceof PsiWhiteSpace && PsiUtil.isJavaToken((PsiElement)sibling.getNextSibling(), (IElementType)JavaTokenType.ELSE_KEYWORD)) {
            sibling.delete();
        }
        return (T)result.getCodeBlock().getStatements()[0];
    }

    @Nullable
    public static PsiElement getBody(PsiElement element) {
        if (element instanceof PsiLoopStatement) {
            PsiStatement loopBody = ((PsiLoopStatement)element).getBody();
            return loopBody instanceof PsiBlockStatement ? ((PsiBlockStatement)loopBody).getCodeBlock() : loopBody;
        }
        if (element instanceof PsiParameterListOwner) {
            return ((PsiParameterListOwner)element).getBody();
        }
        if (element instanceof PsiSynchronizedStatement) {
            return ((PsiSynchronizedStatement)element).getBody();
        }
        if (element instanceof PsiSwitchStatement) {
            return ((PsiSwitchStatement)element).getBody();
        }
        if (element instanceof PsiClassInitializer) {
            return ((PsiClassInitializer)element).getBody();
        }
        if (element instanceof PsiCatchSection) {
            return ((PsiCatchSection)element).getCatchBlock();
        }
        throw new AssertionError((Object)("can't get body from " + element));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/BlockUtils", "expandSingleStatementToBlockStatement"));
    }
}

