/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.annotation;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.siyeh.ig.JavaOverridingMethodUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Stream;

class AnnotateOverriddenMethodsPredicate
implements PsiElementPredicate {
    AnnotateOverriddenMethodsPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiMethod method;
        int parameterIndex;
        if (!(element instanceof PsiAnnotation)) {
            return false;
        }
        PsiAnnotation annotation = (PsiAnnotation)element;
        String annotationName = annotation.getQualifiedName();
        if (annotationName == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiModifierList)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof PsiMethod)) {
            if (!(grandParent instanceof PsiParameter)) {
                return false;
            }
            PsiParameter parameter2 = (PsiParameter)grandParent;
            PsiElement greatGrandParent = grandParent.getParent();
            if (!(greatGrandParent instanceof PsiParameterList)) {
                return false;
            }
            PsiParameterList parameterList = (PsiParameterList)greatGrandParent;
            parameterIndex = parameterList.getParameterIndex(parameter2);
            PsiElement greatGreatGrandParent = greatGrandParent.getParent();
            if (!(greatGreatGrandParent instanceof PsiMethod)) {
                return false;
            }
            method = (PsiMethod)greatGreatGrandParent;
        } else {
            parameterIndex = -1;
            method = (PsiMethod)grandParent;
        }
        String annotationShortName = StringUtil.getShortName((String)annotationName);
        Predicate<PsiMethod> preFilter = m -> {
            if (parameterIndex == -1) {
                return !JavaOverridingMethodUtil.containsAnnotationWithName((PsiModifierListOwner)m, annotationShortName);
            }
            JvmParameter[] parameters2 = m.getParameters();
            if (parameters2.length <= parameterIndex) {
                return false;
            }
            PsiModifierListOwner parameter2 = (PsiModifierListOwner)parameters2[parameterIndex];
            return !JavaOverridingMethodUtil.containsAnnotationWithName(parameter2, annotationShortName);
        };
        Stream<PsiMethod> overridenMethods = JavaOverridingMethodUtil.getOverridingMethodsIfCheapEnough(method, null, preFilter);
        if (overridenMethods == null) {
            return true;
        }
        Iterator it = overridenMethods.iterator();
        while (it.hasNext()) {
            PsiMethod overridingMethod = (PsiMethod)it.next();
            if (parameterIndex == -1) {
                PsiAnnotation foundAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)overridingMethod, (String[])new String[]{annotationName});
                if (foundAnnotation != null) continue;
                return true;
            }
            PsiParameterList parameterList = overridingMethod.getParameterList();
            PsiParameter[] parameters2 = parameterList.getParameters();
            PsiParameter parameter3 = parameters2[parameterIndex];
            PsiAnnotation foundAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter3, (String[])new String[]{annotationName});
            if (foundAnnotation != null) continue;
            return true;
        }
        return false;
    }
}

