/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.forloop.IterableForEachLoopPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceForEachLoopWithIteratorForLoopIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        IterableForEachLoopPredicate iterableForEachLoopPredicate = new IterableForEachLoopPredicate();
        if (iterableForEachLoopPredicate == null) {
            ReplaceForEachLoopWithIteratorForLoopIntention.$$$reportNull$$$0(0);
        }
        return iterableForEachLoopPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiForeachStatement statement;
        if (element == null) {
            ReplaceForEachLoopWithIteratorForLoopIntention.$$$reportNull$$$0(1);
        }
        if ((statement = (PsiForeachStatement)element.getParent()) == null) {
            return;
        }
        PsiExpression iteratedValue2 = statement.getIteratedValue();
        if (iteratedValue2 == null) {
            return;
        }
        PsiType iteratedValueType = iteratedValue2.getType();
        if (!(iteratedValueType instanceof PsiClassType)) {
            return;
        }
        CommentTracker tracker = new CommentTracker();
        StringBuilder methodCall = new StringBuilder();
        if (ParenthesesUtils.getPrecedence(iteratedValue2) > 1) {
            methodCall.append('(').append(tracker.markUnchanged(iteratedValue2).getText()).append(')');
        } else {
            methodCall.append(tracker.markUnchanged(iteratedValue2).getText());
        }
        methodCall.append(".iterator()");
        Project project = statement.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiExpression iteratorCall = factory.createExpressionFromText(methodCall.toString(), (PsiElement)iteratedValue2);
        PsiType variableType = GenericsUtil.getVariableTypeByExpressionType((PsiType)iteratorCall.getType());
        if (variableType == null) {
            return;
        }
        StringBuilder newStatement = new StringBuilder();
        newStatement.append("for(").append(variableType.getCanonicalText()).append(' ');
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        String iterator = codeStyleManager.suggestUniqueVariableName("iterator", (PsiElement)statement, true);
        newStatement.append(iterator).append("=").append(iteratorCall.getText()).append(';');
        newStatement.append(iterator).append(".hasNext();) {");
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project);
        if (((JavaCodeStyleSettings)codeStyleSettings.getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_LOCALS) {
            newStatement.append("final ");
        }
        PsiParameter iterationParameter = statement.getIterationParameter();
        PsiType parameterType = iterationParameter.getType();
        String typeText = parameterType.getCanonicalText();
        newStatement.append(typeText).append(' ').append(iterationParameter.getName()).append(" = ").append(iterator).append(".next();");
        PsiStatement body2 = statement.getBody();
        if (body2 == null) {
            return;
        }
        if (body2 instanceof PsiBlockStatement) {
            PsiCodeBlock block = ((PsiBlockStatement)body2).getCodeBlock();
            PsiElement[] children = block.getChildren();
            for (int i = 1; i < children.length - 1; ++i) {
                newStatement.append(tracker.markUnchanged(children[i]).getText());
            }
        } else {
            newStatement.append(tracker.markUnchanged(body2).getText());
        }
        newStatement.append('}');
        PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)statement, newStatement.toString(), tracker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/forloop/ReplaceForEachLoopWithIteratorForLoopIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/forloop/ReplaceForEachLoopWithIteratorForLoopIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

