/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.imports;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.imports.OnDemandImportPredicate;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ReplaceOnDemandImportIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        OnDemandImportPredicate onDemandImportPredicate = new OnDemandImportPredicate();
        if (onDemandImportPredicate == null) {
            ReplaceOnDemandImportIntention.$$$reportNull$$$0(0);
        }
        return onDemandImportPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiImportStatementBase importStatementBase;
        if (element == null) {
            ReplaceOnDemandImportIntention.$$$reportNull$$$0(1);
        }
        if ((importStatementBase = (PsiImportStatementBase)element) instanceof PsiImportStatement) {
            PsiImportStatement importStatement = (PsiImportStatement)importStatementBase;
            PsiJavaFile javaFile = (PsiJavaFile)importStatement.getContainingFile();
            PsiClass[] classes2 = javaFile.getClasses();
            String qualifiedName = importStatement.getQualifiedName();
            ClassCollector visitor = new ClassCollector(qualifiedName);
            for (PsiClass aClass : classes2) {
                aClass.accept((PsiElementVisitor)visitor);
            }
            PsiClass[] importedClasses = visitor.getImportedClasses();
            Arrays.sort(importedClasses, new PsiClassComparator());
            PsiManager manager = importStatement.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            PsiElement importList = importStatement.getParent();
            for (PsiClass importedClass : importedClasses) {
                PsiImportStatement newImportStatement = factory.createImportStatement(importedClass);
                importList.add((PsiElement)newImportStatement);
            }
            new CommentTracker().deleteAndRestoreComments((PsiElement)importStatement);
        } else if (importStatementBase instanceof PsiImportStaticStatement) {
            // empty if block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/imports/ReplaceOnDemandImportIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/imports/ReplaceOnDemandImportIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PsiClassComparator
    implements Comparator<PsiClass> {
        private PsiClassComparator() {
        }

        @Override
        public int compare(PsiClass class1, PsiClass class2) {
            String qualifiedName1 = class1.getQualifiedName();
            String qualifiedName2 = class2.getQualifiedName();
            if (qualifiedName1 == null) {
                return -1;
            }
            return qualifiedName1.compareTo(qualifiedName2);
        }
    }

    private static class ClassCollector
    extends JavaRecursiveElementWalkingVisitor {
        private final String importedPackageName;
        private final Set<PsiClass> importedClasses = new HashSet<PsiClass>();

        ClassCollector(String importedPackageName) {
            this.importedPackageName = importedPackageName;
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            if (reference.isQualified()) {
                return;
            }
            PsiElement element = reference.resolve();
            if (!(element instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)element;
            String qualifiedName = aClass.getQualifiedName();
            String packageName = ClassUtil.extractPackageName((String)qualifiedName);
            if (!this.importedPackageName.equals(packageName)) {
                return;
            }
            this.importedClasses.add(aClass);
        }

        public PsiClass[] getImportedClasses() {
            return this.importedClasses.toArray(new PsiClass[this.importedClasses.size()]);
        }
    }
}

