/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.junit;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.junit.AssertLiteralPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceAssertLiteralWithAssertEqualsIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        assert (methodName != null);
        String postfix = methodName.substring("assert".length());
        PsiExpression lastArgument = arguments[arguments.length - 1];
        if (lastArgument instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)lastArgument;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if ("assertTrue".equals(methodName) && JavaTokenType.EQEQ.equals(tokenType) || "assertFalse".equals(methodName) && JavaTokenType.NE.equals(tokenType)) {
                return IntentionPowerPackBundle.message("replace.assert.literal.with.assert.equals.intention.name2", methodName);
            }
        }
        String literal = postfix.toLowerCase();
        if (arguments.length == 1) {
            return IntentionPowerPackBundle.message("replace.assert.literal.with.assert.equals.intention.name", methodName, literal);
        }
        return IntentionPowerPackBundle.message("replace.assert.literal.with.assert.equals.intention.name1", methodName, literal);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        AssertLiteralPredicate assertLiteralPredicate = new AssertLiteralPredicate();
        if (assertLiteralPredicate == null) {
            ReplaceAssertLiteralWithAssertEqualsIntention.$$$reportNull$$$0(0);
        }
        return assertLiteralPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiExpression lastArgument;
        PsiMethodCallExpression call;
        PsiReferenceExpression methodExpression;
        String methodName;
        if (element == null) {
            ReplaceAssertLiteralWithAssertEqualsIntention.$$$reportNull$$$0(1);
        }
        if ((methodName = (methodExpression = (call = (PsiMethodCallExpression)element).getMethodExpression()).getReferenceName()) == null) {
            return;
        }
        StringBuilder newExpression = new StringBuilder();
        PsiElement qualifier = methodExpression.getQualifier();
        if (qualifier == null) {
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"junit.framework.Assert") && !ImportUtils.addStaticImport("org.junit.Assert", "assertEquals", element)) {
                newExpression.append("org.junit.Assert.");
            }
        } else {
            newExpression.append(qualifier.getText());
            newExpression.append('.');
        }
        newExpression.append("assertEquals(");
        String postfix = methodName.substring("assert".length());
        String literal = postfix.toLowerCase();
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        CommentTracker commentTracker = new CommentTracker();
        if (arguments.length > 1) {
            newExpression.append(commentTracker.markUnchanged(arguments[0]).getText()).append(", ");
        }
        if ((lastArgument = arguments[arguments.length - 1]) instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)lastArgument;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if ("assertTrue".equals(methodName) && JavaTokenType.EQEQ.equals(tokenType) || "assertFalse".equals(methodName) && JavaTokenType.NE.equals(tokenType)) {
                PsiExpression lhs = binaryExpression.getLOperand();
                newExpression.append(commentTracker.markUnchanged(lhs).getText()).append(", ");
                PsiExpression rhs = binaryExpression.getROperand();
                if (rhs != null) {
                    newExpression.append(commentTracker.markUnchanged(rhs).getText());
                }
            } else {
                newExpression.append(literal).append(", ").append(commentTracker.markUnchanged(lastArgument).getText());
            }
        } else {
            newExpression.append(literal).append(", ").append(commentTracker.markUnchanged(lastArgument).getText());
        }
        newExpression.append(')');
        PsiReplacementUtil.replaceExpression((PsiExpression)call, newExpression.toString(), commentTracker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/junit/ReplaceAssertLiteralWithAssertEqualsIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/junit/ReplaceAssertLiteralWithAssertEqualsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

