/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.modifiers;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.JavaThrownExceptionInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.modifiers.ModifierPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ModifierIntention
extends Intention
implements LowPriorityAction {
    ModifierIntention() {
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            ModifierIntention.$$$reportNull$$$0(0);
        }
        return currentFile;
    }

    @Override
    @NotNull
    protected final PsiElementPredicate getElementPredicate() {
        ModifierPredicate modifierPredicate = new ModifierPredicate(this.getModifier());
        if (modifierPredicate == null) {
            ModifierIntention.$$$reportNull$$$0(1);
        }
        return modifierPredicate;
    }

    @Override
    protected final void processIntention(@NotNull PsiElement element) {
        boolean conflictsDialogOK;
        PsiMember member;
        PsiModifierList modifierList;
        if (element == null) {
            ModifierIntention.$$$reportNull$$$0(2);
        }
        if ((modifierList = (member = (PsiMember)element.getParent()).getModifierList()) == null) {
            return;
        }
        MultiMap<PsiElement, String> conflicts = this.checkForConflicts(member);
        if (conflicts == null) {
            return;
        }
        Project project = member.getProject();
        if (conflicts.isEmpty()) {
            conflictsDialogOK = true;
        } else {
            ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts, () -> this.changeModifier(modifierList));
            conflictsDialogOK = conflictsDialog.showAndGet();
        }
        if (conflictsDialogOK) {
            this.changeModifier(modifierList);
        }
    }

    private void changeModifier(PsiModifierList modifierList) {
        PsiElement parent = modifierList.getParent();
        String modifier = this.getModifier();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            new ChangeSignatureProcessor(parent.getProject(), method, false, modifier, method.getName(), method.getReturnType(), ParameterInfoImpl.fromMethod(method), JavaThrownExceptionInfo.extractExceptions(method)).run();
            return;
        }
        WriteAction.run(() -> {
            modifierList.setModifierProperty(modifier, true);
            if (!"packageLocal".equals(modifier)) {
                Project project = modifierList.getProject();
                PsiElement whitespace = PsiParserFacade.SERVICE.getInstance((Project)project).createWhiteSpaceFromText(" ");
                PsiElement sibling = modifierList.getNextSibling();
                if (sibling instanceof PsiWhiteSpace) {
                    sibling.replace(whitespace);
                    CodeStyleManager.getInstance((Project)project).reformatRange(parent, modifierList.getTextOffset(), modifierList.getNextSibling().getTextOffset());
                }
            }
        });
    }

    private MultiMap<PsiElement, String> checkForConflicts(@NotNull PsiMember member) {
        if (member == null) {
            ModifierIntention.$$$reportNull$$$0(3);
        }
        if (member instanceof PsiClass && this.getModifier().equals("public")) {
            String className;
            PsiClass aClass = (PsiClass)member;
            PsiElement parent = aClass.getParent();
            if (!(parent instanceof PsiJavaFile)) {
                return MultiMap.emptyInstance();
            }
            PsiJavaFile javaFile = (PsiJavaFile)parent;
            String name = FileUtil.getNameWithoutExtension((String)javaFile.getName());
            if (name.equals(className = aClass.getName())) {
                return MultiMap.emptyInstance();
            }
            MultiMap conflicts = new MultiMap();
            conflicts.putValue((Object)aClass, (Object)IntentionPowerPackBundle.message("0.is.declared.in.1.but.when.public.should.be.declared.in.a.file.named.2", RefactoringUIUtil.getDescription((PsiElement)aClass, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)javaFile, (boolean)false), CommonRefactoringUtil.htmlEmphasize((String)(className + ".java"))));
            return conflicts;
        }
        PsiModifierList modifierList = member.getModifierList();
        if (modifierList == null || modifierList.hasModifierProperty("private")) {
            return MultiMap.emptyInstance();
        }
        PsiModifierList copy = (PsiModifierList)modifierList.copy();
        copy.setModifierProperty(this.getModifier(), true);
        SearchScope useScope = member.getUseScope();
        MultiMap conflicts = new MultiMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (member == null) {
                ModifierIntention.$$$reportNull$$$0(4);
            }
            if (member instanceof PsiMethod) {
                JavaChangeSignatureUsageProcessor.ConflictSearcher.searchForHierarchyConflicts((PsiMethod)member, (MultiMap<PsiElement, String>)conflicts, this.getModifier());
            }
            Query search = ReferencesSearch.search((PsiElement)member, (SearchScope)useScope);
            search.forEach(reference -> {
                if (member == null) {
                    ModifierIntention.$$$reportNull$$$0(5);
                }
                PsiElement element = reference.getElement();
                if (JavaResolveUtil.isAccessible(member, member.getContainingClass(), copy, element, null, null)) {
                    return true;
                }
                PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiField.class, PsiClass.class, PsiFile.class});
                if (context == null) {
                    return true;
                }
                conflicts.putValue((Object)element, (Object)RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false), PsiBundle.visibilityPresentation((String)this.getModifier()), RefactoringUIUtil.getDescription((PsiElement)context, (boolean)true)}));
                return true;
            });
        }, RefactoringBundle.message((String)"detecting.possible.conflicts"), true, member.getProject())) {
            return null;
        }
        return conflicts;
    }

    @VisibilityConstant
    protected abstract String getModifier();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/modifiers/ModifierIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/modifiers/ModifierIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkForConflicts";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkForConflicts$3";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static @interface VisibilityConstant {
    }
}

