/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;

class ReplaceIfWithConditionalPredicate
implements PsiElementPredicate {
    ReplaceIfWithConditionalPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        PsiElement parent = token.getParent();
        if (!(parent instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)parent;
        if (ErrorUtil.containsError((PsiElement)ifStatement)) {
            return false;
        }
        PsiExpression condition2 = ifStatement.getCondition();
        if (condition2 == null) {
            return false;
        }
        if (ReplaceIfWithConditionalPredicate.isReplaceableAssignment(ifStatement)) {
            return true;
        }
        if (ReplaceIfWithConditionalPredicate.isReplaceableReturn(ifStatement)) {
            return true;
        }
        if (ReplaceIfWithConditionalPredicate.isReplaceableMethodCall(ifStatement)) {
            return true;
        }
        return ReplaceIfWithConditionalPredicate.isReplaceableImplicitReturn(ifStatement);
    }

    public static boolean isReplaceableMethodCall(PsiIfStatement ifStatement) {
        PsiExpressionList elseArgumentList;
        PsiExpression[] elseArguments;
        PsiStatement thenBranch = ifStatement.getThenBranch();
        PsiStatement elseBranch = ifStatement.getElseBranch();
        PsiStatement thenStatement = ControlFlowUtils.stripBraces(thenBranch);
        if (thenStatement == null) {
            return false;
        }
        PsiStatement elseStatement = ControlFlowUtils.stripBraces(elseBranch);
        if (elseStatement == null) {
            return false;
        }
        if (!(thenStatement instanceof PsiExpressionStatement) || !(elseStatement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement thenExpressionStatement = (PsiExpressionStatement)thenStatement;
        PsiExpression thenExpression2 = thenExpressionStatement.getExpression();
        PsiExpressionStatement elseExpressionStatement = (PsiExpressionStatement)elseStatement;
        PsiExpression elseExpression2 = elseExpressionStatement.getExpression();
        if (!(thenExpression2 instanceof PsiMethodCallExpression) || !(elseExpression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression thenMethodCallExpression = (PsiMethodCallExpression)thenExpression2;
        PsiMethodCallExpression elseMethodCallExpression = (PsiMethodCallExpression)elseExpression2;
        PsiReferenceExpression thenMethodExpression = thenMethodCallExpression.getMethodExpression();
        PsiReferenceExpression elseMethodExpression = elseMethodCallExpression.getMethodExpression();
        if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)thenMethodExpression, (PsiExpression)elseMethodExpression)) {
            return false;
        }
        PsiExpressionList thenArgumentList = thenMethodCallExpression.getArgumentList();
        PsiExpression[] thenArguments = thenArgumentList.getExpressions();
        if (thenArguments.length != (elseArguments = (elseArgumentList = elseMethodCallExpression.getArgumentList()).getExpressions()).length) {
            return false;
        }
        int differences = 0;
        int length = thenArguments.length;
        for (int i = 0; i < length; ++i) {
            PsiExpression thenArgument = thenArguments[i];
            PsiExpression elseArgument = elseArguments[i];
            if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenArgument, elseArgument)) continue;
            ++differences;
        }
        return differences == 1;
    }

    public static boolean isReplaceableImplicitReturn(PsiIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (!((thenBranch = ControlFlowUtils.stripBraces(thenBranch)) instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement thenReturnStatement = (PsiReturnStatement)thenBranch;
        PsiExpression thenReturn = thenReturnStatement.getReturnValue();
        if (thenReturn == null) {
            return false;
        }
        PsiType thenType = thenReturn.getType();
        if (thenType == null) {
            return false;
        }
        PsiElement nextStatement = PsiTreeUtil.skipWhitespacesForward((PsiElement)ifStatement);
        if (!(nextStatement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement elseReturnStatement = (PsiReturnStatement)nextStatement;
        PsiExpression elseReturn = elseReturnStatement.getReturnValue();
        if (elseReturn == null) {
            return false;
        }
        PsiType elseType = elseReturn.getType();
        if (elseType == null) {
            return false;
        }
        return thenType.isAssignableFrom(elseType) || elseType.isAssignableFrom(thenType);
    }

    public static boolean isReplaceableReturn(PsiIfStatement ifStatement) {
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ControlFlowUtils.stripBraces(thenBranch);
        PsiStatement elseBranch = ifStatement.getElseBranch();
        elseBranch = ControlFlowUtils.stripBraces(elseBranch);
        if (!(thenBranch instanceof PsiReturnStatement) || !(elseBranch instanceof PsiReturnStatement)) {
            return false;
        }
        PsiExpression thenReturn = ((PsiReturnStatement)thenBranch).getReturnValue();
        if (thenReturn == null) {
            return false;
        }
        PsiExpression elseReturn = ((PsiReturnStatement)elseBranch).getReturnValue();
        if (elseReturn == null) {
            return false;
        }
        PsiType thenType = thenReturn.getType();
        PsiType elseType = elseReturn.getType();
        if (thenType == null || elseType == null) {
            return false;
        }
        return thenType.isAssignableFrom(elseType) || elseType.isAssignableFrom(thenType);
    }

    public static boolean isReplaceableAssignment(PsiIfStatement ifStatement) {
        IElementType elseTokenType;
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        PsiStatement elseBranch = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
        if (thenBranch == null || elseBranch == null) {
            return false;
        }
        if (!(thenBranch instanceof PsiExpressionStatement) || !(elseBranch instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement thenExpressionStatement = (PsiExpressionStatement)thenBranch;
        PsiExpressionStatement elseExpressionStatement = (PsiExpressionStatement)elseBranch;
        PsiExpression thenExpression2 = thenExpressionStatement.getExpression();
        PsiExpression elseExpression2 = elseExpressionStatement.getExpression();
        if (!(thenExpression2 instanceof PsiAssignmentExpression) || !(elseExpression2 instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression thenAssignmentExpression = (PsiAssignmentExpression)thenExpression2;
        PsiAssignmentExpression elseAssignmentExpression = (PsiAssignmentExpression)elseExpression2;
        PsiExpression thenRhs = thenAssignmentExpression.getRExpression();
        PsiExpression elseRhs = elseAssignmentExpression.getRExpression();
        if (thenRhs == null || elseRhs == null) {
            return false;
        }
        IElementType thenTokenType = thenAssignmentExpression.getOperationTokenType();
        if (!thenTokenType.equals(elseTokenType = elseAssignmentExpression.getOperationTokenType())) {
            return false;
        }
        PsiExpression thenLhs = thenAssignmentExpression.getLExpression();
        PsiExpression elseLhs = elseAssignmentExpression.getLExpression();
        return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenLhs, elseLhs);
    }
}

