/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.clientBundle;

import com.intellij.gwt.clientBundle.jam.ClientBundleMethodJamElement;
import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.gwt.uiBinder.declarations.UiStyleElement;
import com.intellij.gwt.uiBinder.declarations.UiXmlDeclarationsManager;
import com.intellij.gwt.uiBinder.declarations.UiXmlVariableDeclaration;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientBundleUtil {
    @NonNls
    public static final String DEFAULT_EXTENSIONS_ANNOTATION = "com.google.gwt.resources.ext.DefaultExtensions";
    @NonNls
    public static final String CLIENT_BUNDLE_INTERFACE = "com.google.gwt.resources.client.ClientBundle";
    @NonNls
    public static final String SOURCE_ANNOTATION = "com.google.gwt.resources.client.ClientBundle.Source";
    @NonNls
    public static final String CSS_RESOURCE_INTERFACE = "com.google.gwt.resources.client.CssResource";
    @NonNls
    public static final String IMAGE_RESOURCE_INTERFACE = "com.google.gwt.resources.client.ImageResource";
    @NonNls
    public static final String CLASS_NAME_ANNOTATION = "com.google.gwt.resources.client.CssResource.ClassName";

    private ClientBundleUtil() {
    }

    public static Set<PsiClass> getCssInterfaces(@NotNull StylesheetFile stylesheetFile) {
        PsiClass sourceAnnotation;
        if (stylesheetFile == null) {
            ClientBundleUtil.$$$reportNull$$$0(0);
        }
        if ((sourceAnnotation = ClientBundleUtil.findSourceAnnotation((PsiElement)stylesheetFile)) == null) {
            return Collections.emptySet();
        }
        HashSet<PsiClass> result = new HashSet<PsiClass>();
        AnnotatedElementsSearch.searchPsiMethods((PsiClass)sourceAnnotation, (SearchScope)stylesheetFile.getUseScope()).forEach(psiMethod -> {
            ClientBundleMethodJamElement element;
            if (stylesheetFile == null) {
                ClientBundleUtil.$$$reportNull$$$0(6);
            }
            if ((element = ClientBundleMethodJamElement.getElement(psiMethod)) != null) {
                PsiType returnType = psiMethod.getReturnType();
                if (element.getSourceFiles(true).contains(stylesheetFile) && returnType instanceof PsiClassType) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)((PsiClassType)returnType).resolve());
                }
            }
            return true;
        });
        return result;
    }

    public static Set<StylesheetFile> getStylesheetFiles(@NotNull PsiClass cssResourceClass, boolean addLocalized, boolean processSubClasses) {
        if (cssResourceClass == null) {
            ClientBundleUtil.$$$reportNull$$$0(1);
        }
        HashSet<StylesheetFile> result = new HashSet<StylesheetFile>();
        SearchScope scope = cssResourceClass.getUseScope();
        if (!(scope instanceof GlobalSearchScope)) {
            scope = GlobalSearchScope.fileScope((PsiFile)cssResourceClass.getContainingFile());
        }
        ReferencesSearch.search((PsiElement)cssResourceClass, (SearchScope)scope.intersectWith((SearchScope)UiBinderUtil.UI_XML_FILES_SCOPE)).forEach(reference -> {
            if (cssResourceClass == null) {
                ClientBundleUtil.$$$reportNull$$$0(5);
            }
            PsiFile file = reference.getElement().getContainingFile();
            for (UiXmlVariableDeclaration element : UiXmlDeclarationsManager.getDeclarations((XmlFile)file)) {
                UiStyleElement styleElement;
                String type;
                if (!(element instanceof UiStyleElement) || (type = (styleElement = (UiStyleElement)element).getType()) == null || !type.equals(cssResourceClass.getQualifiedName())) continue;
                result.addAll(styleElement.getStylesheetFiles());
            }
        });
        PsiClass sourceAnnotation = ClientBundleUtil.findSourceAnnotation((PsiElement)cssResourceClass);
        if (sourceAnnotation == null) {
            return result;
        }
        AnnotatedElementsSearch.searchPsiMethods((PsiClass)sourceAnnotation, (SearchScope)scope).forEach(psiMethod -> {
            PsiClass psiClass;
            PsiType type;
            ClientBundleMethodJamElement element;
            if (cssResourceClass == null) {
                ClientBundleUtil.$$$reportNull$$$0(4);
            }
            if ((element = ClientBundleMethodJamElement.getElement(psiMethod)) != null && (type = psiMethod.getReturnType()) instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null && (psiClass.getManager().areElementsEquivalent((PsiElement)psiClass, (PsiElement)cssResourceClass) || processSubClasses && psiClass.isInheritor(cssResourceClass, true))) {
                for (PsiFile psiFile : element.getSourceFiles(addLocalized)) {
                    if (!(psiFile instanceof StylesheetFile)) continue;
                    result.add((StylesheetFile)psiFile);
                }
            }
            return true;
        });
        return result;
    }

    @Nullable
    private static PsiClass findSourceAnnotation(@NotNull PsiElement context) {
        if (context == null) {
            ClientBundleUtil.$$$reportNull$$$0(2);
        }
        return JavaPsiFacade.getInstance((Project)context.getProject()).findClass(SOURCE_ANNOTATION, context.getResolveScope());
    }

    public static boolean isImplementationProvidedByGwt(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ClientBundleUtil.$$$reportNull$$$0(3);
        }
        if (!psiClass.isInterface()) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"com.google.gwt.resources.client.ResourcePrototype") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"com.google.gwt.i18n.shared.Localizable");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stylesheetFile";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssResourceClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/gwt/clientBundle/ClientBundleUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCssInterfaces";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getStylesheetFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findSourceAnnotation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplementationProvidedByGwt";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getStylesheetFiles$2";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getStylesheetFiles$1";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getCssInterfaces$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

