/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.CompositeAnnotations;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawTypeImpl;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.EnhancedTypeAnnotations;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.EnhancementResult;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.JavaTypeQualifiers;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.MutabilityQualifier;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.NotNullTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.NullabilityQualifier;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.Result;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.SimpleResult;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeComponentPosition;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeEnhancementKt$WhenMappings;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.platform.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeEnhancementKt {
    private static final EnhancedTypeAnnotations ENHANCED_NULLABILITY_ANNOTATIONS;
    private static final EnhancedTypeAnnotations ENHANCED_MUTABILITY_ANNOTATIONS;

    @Nullable
    public static final KotlinType enhance(@NotNull KotlinType $receiver, @NotNull Function1<? super Integer, JavaTypeQualifiers> qualifiers) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(qualifiers, (String)"qualifiers");
        return TypeEnhancementKt.enhancePossiblyFlexible($receiver.unwrap(), qualifiers, 0).getTypeIfChanged();
    }

    public static final boolean hasEnhancedNullability(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION");
        return annotations2.findAnnotation(fqName2) != null;
    }

    private static final Result enhancePossiblyFlexible(@NotNull UnwrappedType $receiver, Function1<? super Integer, JavaTypeQualifiers> qualifiers, int index) {
        Result result;
        if (KotlinTypeKt.isError($receiver)) {
            return new Result($receiver, 1, false);
        }
        UnwrappedType unwrappedType = $receiver;
        if (unwrappedType instanceof FlexibleType) {
            KotlinType enhancement2;
            boolean bl;
            SimpleResult lowerResult = TypeEnhancementKt.enhanceInflexible(((FlexibleType)$receiver).getLowerBound(), qualifiers, index, TypeComponentPosition.FLEXIBLE_LOWER);
            SimpleResult upperResult = TypeEnhancementKt.enhanceInflexible(((FlexibleType)$receiver).getUpperBound(), qualifiers, index, TypeComponentPosition.FLEXIBLE_UPPER);
            boolean bl2 = bl = lowerResult.getSubtreeSize() == upperResult.getSubtreeSize();
            if (_Assertions.ENABLED && !bl) {
                String string = "Different tree sizes of bounds: " + "lower = (" + ((FlexibleType)$receiver).getLowerBound() + ", " + lowerResult.getSubtreeSize() + "), " + "upper = (" + ((FlexibleType)$receiver).getUpperBound() + ", " + upperResult.getSubtreeSize() + ')';
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            boolean wereChanges = lowerResult.getWereChanges() || upperResult.getWereChanges();
            KotlinType kotlinType = TypeWithEnhancementKt.getEnhancement(lowerResult.getType());
            if (kotlinType == null) {
                kotlinType = enhancement2 = TypeWithEnhancementKt.getEnhancement(upperResult.getType());
            }
            UnwrappedType type2 = !wereChanges ? $receiver : TypeWithEnhancementKt.wrapEnhancement($receiver instanceof RawTypeImpl ? (UnwrappedType)new RawTypeImpl(lowerResult.getType(), upperResult.getType()) : KotlinTypeFactory.flexibleType(lowerResult.getType(), upperResult.getType()), enhancement2);
            result = new Result(type2, lowerResult.getSubtreeSize(), wereChanges);
        } else if (unwrappedType instanceof SimpleType) {
            result = TypeEnhancementKt.enhanceInflexible((SimpleType)$receiver, qualifiers, index, TypeComponentPosition.INFLEXIBLE);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final SimpleResult enhanceInflexible(@NotNull SimpleType $receiver, Function1<? super Integer, JavaTypeQualifiers> qualifiers, int index, TypeComponentPosition position) {
        UnwrappedType result;
        void enhancedNullability;
        void $receiver$iv$iv;
        Iterable $receiver$iv22;
        void enhancedClassifier;
        boolean shouldEnhance = TypeEnhancementKt.shouldEnhance(position);
        if (!shouldEnhance && $receiver.getArguments().isEmpty()) {
            return new SimpleResult($receiver, 1, false);
        }
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return new SimpleResult($receiver, 1, false);
        }
        ClassifierDescriptor originalClass = classifierDescriptor;
        JavaTypeQualifiers effectiveQualifiers = (JavaTypeQualifiers)qualifiers.invoke((Object)index);
        ClassifierDescriptor classifierDescriptor2 = originalClass;
        Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptor2, (String)"originalClass");
        EnhancementResult<ClassifierDescriptor> enhancementResult2 = TypeEnhancementKt.enhanceMutability(classifierDescriptor2, effectiveQualifiers, position);
        ClassifierDescriptor classifierDescriptor3 = enhancementResult2.component1();
        Annotations enhancedMutabilityAnnotations = enhancementResult2.component2();
        TypeConstructor typeConstructor2 = enhancedClassifier.getTypeConstructor();
        int globalArgIndex = index + 1;
        boolean wereChanges = enhancedMutabilityAnnotations != null;
        Iterable iterable = $receiver$iv22 = (Iterable)$receiver.getArguments();
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv22, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            TypeProjection typeProjection;
            void localArgIndex;
            void arg;
            int n = index$iv$iv++;
            TypeProjection typeProjection2 = (TypeProjection)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            if (arg.isStarProjection()) {
                int n3 = globalArgIndex;
                globalArgIndex = n3 + 1;
                TypeConstructor typeConstructor3 = enhancedClassifier.getTypeConstructor();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor3, (String)"enhancedClassifier.typeConstructor");
                typeProjection = TypeUtils.makeStarProjection(typeConstructor3.getParameters().get((int)localArgIndex));
            } else {
                Result enhanced = TypeEnhancementKt.enhancePossiblyFlexible(arg.getType().unwrap(), qualifiers, globalArgIndex);
                wereChanges = wereChanges || enhanced.getWereChanges();
                globalArgIndex += enhanced.getSubtreeSize();
                KotlinType kotlinType = enhanced.getType();
                Variance variance = arg.getProjectionKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)variance), (String)"arg.projectionKind");
                TypeConstructor typeConstructor4 = typeConstructor2;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor4, (String)"typeConstructor");
                typeProjection = TypeUtilsKt.createProjection(kotlinType, variance, typeConstructor4.getParameters().get((int)localArgIndex));
            }
            TypeProjection typeProjection3 = typeProjection;
            collection.add(typeProjection3);
        }
        List enhancedArguments = (List)destination$iv$iv;
        destination$iv$iv = TypeEnhancementKt.getEnhancedNullability($receiver, effectiveQualifiers, position);
        boolean $receiver$iv22 = (Boolean)((EnhancementResult)destination$iv$iv).component1();
        Annotations enhancedNullabilityAnnotations = ((EnhancementResult)destination$iv$iv).component2();
        wereChanges = wereChanges || enhancedNullabilityAnnotations != null;
        int subtreeSize = globalArgIndex - index;
        if (!wereChanges) {
            return new SimpleResult($receiver, subtreeSize, false);
        }
        Annotations newAnnotations = TypeEnhancementKt.compositeAnnotationsOrSingle(CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])new Annotations[]{$receiver.getAnnotations(), enhancedMutabilityAnnotations, enhancedNullabilityAnnotations})));
        TypeConstructor typeConstructor5 = typeConstructor2;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor5, (String)"typeConstructor");
        SimpleType enhancedType = KotlinTypeFactory.simpleType(newAnnotations, typeConstructor5, enhancedArguments, (boolean)enhancedNullability);
        SimpleType enhancement2 = effectiveQualifiers.isNotNullTypeParameter$descriptors_jvm() ? (SimpleType)new NotNullTypeParameter(enhancedType) : enhancedType;
        boolean nullabilityForWarning = enhancedNullabilityAnnotations != null && effectiveQualifiers.isNullabilityQualifierForWarning$descriptors_jvm();
        UnwrappedType unwrappedType = result = nullabilityForWarning ? TypeWithEnhancementKt.wrapEnhancement($receiver, enhancement2) : (UnwrappedType)enhancement2;
        if (unwrappedType == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        }
        return new SimpleResult((SimpleType)unwrappedType, subtreeSize, true);
    }

    private static final Annotations compositeAnnotationsOrSingle(@NotNull List<? extends Annotations> $receiver) {
        Annotations annotations2;
        switch ($receiver.size()) {
            case 0: {
                String string = "At least one Annotations object expected";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            case 1: {
                annotations2 = (Annotations)CollectionsKt.single($receiver);
                break;
            }
            default: {
                annotations2 = new CompositeAnnotations(CollectionsKt.toList((Iterable)$receiver));
            }
        }
        return annotations2;
    }

    private static final boolean shouldEnhance(@NotNull TypeComponentPosition $receiver) {
        return Intrinsics.areEqual((Object)((Object)$receiver), (Object)((Object)TypeComponentPosition.INFLEXIBLE)) ^ true;
    }

    private static final <T> EnhancementResult<T> noChange(T $receiver) {
        return new EnhancementResult<T>($receiver, null);
    }

    private static final <T> EnhancementResult<T> enhancedNullability(T $receiver) {
        return new EnhancementResult<T>($receiver, ENHANCED_NULLABILITY_ANNOTATIONS);
    }

    private static final <T> EnhancementResult<T> enhancedMutability(T $receiver) {
        return new EnhancementResult<T>($receiver, ENHANCED_MUTABILITY_ANNOTATIONS);
    }

    private static final EnhancementResult<ClassifierDescriptor> enhanceMutability(@NotNull ClassifierDescriptor $receiver, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        if (!TypeEnhancementKt.shouldEnhance(position)) {
            return TypeEnhancementKt.noChange($receiver);
        }
        if (!($receiver instanceof ClassDescriptor)) {
            return TypeEnhancementKt.noChange($receiver);
        }
        JavaToKotlinClassMap mapping = JavaToKotlinClassMap.INSTANCE;
        MutabilityQualifier mutabilityQualifier = qualifiers.getMutability();
        if (mutabilityQualifier != null) {
            switch (TypeEnhancementKt$WhenMappings.$EnumSwitchMapping$0[mutabilityQualifier.ordinal()]) {
                case 1: {
                    if (!Intrinsics.areEqual((Object)((Object)position), (Object)((Object)TypeComponentPosition.FLEXIBLE_LOWER)) || !mapping.isMutable((ClassDescriptor)$receiver)) break;
                    return TypeEnhancementKt.enhancedMutability(mapping.convertMutableToReadOnly((ClassDescriptor)$receiver));
                }
                case 2: {
                    if (!Intrinsics.areEqual((Object)((Object)position), (Object)((Object)TypeComponentPosition.FLEXIBLE_UPPER)) || !mapping.isReadOnly((ClassDescriptor)$receiver)) break;
                    return TypeEnhancementKt.enhancedMutability(mapping.convertReadOnlyToMutable((ClassDescriptor)$receiver));
                }
            }
        }
        return TypeEnhancementKt.noChange($receiver);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final EnhancementResult<Boolean> getEnhancedNullability(@NotNull KotlinType $receiver, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        EnhancementResult<Boolean> enhancementResult2;
        if (!TypeEnhancementKt.shouldEnhance(position)) {
            return TypeEnhancementKt.noChange($receiver.isMarkedNullable());
        }
        NullabilityQualifier nullabilityQualifier = qualifiers.getNullability();
        if (nullabilityQualifier != null) {
            switch (TypeEnhancementKt$WhenMappings.$EnumSwitchMapping$1[nullabilityQualifier.ordinal()]) {
                case 1: {
                    enhancementResult2 = TypeEnhancementKt.enhancedNullability(true);
                    return enhancementResult2;
                }
                case 2: {
                    enhancementResult2 = TypeEnhancementKt.enhancedNullability(false);
                    return enhancementResult2;
                }
            }
        }
        enhancementResult2 = TypeEnhancementKt.noChange($receiver.isMarkedNullable());
        return enhancementResult2;
    }

    static {
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION");
        ENHANCED_NULLABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName2);
        FqName fqName3 = JvmAnnotationNames.ENHANCED_MUTABILITY_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"JvmAnnotationNames.ENHANCED_MUTABILITY_ANNOTATION");
        ENHANCED_MUTABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName3);
    }
}

