/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LazyPasswordField;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.AuthType;
import com.intellij.ssh.config.OpenSSHClientConfig;
import com.intellij.ssh.config.OpenSSHConfigService;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SingleAlarm;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSshSslPanel {
    private final Project myProject;
    private final LocalDataSource myDataSource;
    private final DataSourceConfigurable myDialog;
    private final SingleAlarm myUpdateAlarm;
    private JPanel myPanel;
    private JBTextField myProxyHostField;
    private JBTextField myProxyPortField;
    private JBTextField myUserField;
    private JBPasswordField myPasswordField;
    private JCheckBox myUseSshCheckBox;
    private JPanel mySettingContainerPanel;
    private ComboBox<AuthType> myAuthTypeCombo;
    private JBPasswordField myPassphraseField;
    private TextFieldWithBrowseButton myPrivateKeyFileField;
    private JBCheckBox myUseSSLJBCheckBox;
    private JPanel mySslPanel;
    private LinkLabel mySslCopyFrom;
    private LinkLabel mySshCopyFrom;
    private TextFieldWithBrowseButton myCaCertFileField;
    private TextFieldWithBrowseButton myClientCertFileField;
    private TextFieldWithBrowseButton myClientKeyFileField;
    private JCheckBox myRememberPasswordCheckBox;
    private JPanel myPasswordPanel;
    private JPanel myCertificatePanel;
    private JButton myTestConnectionButton;
    private JPanel myCertificatePlaceholder;
    private JPanel myPasswordPlaceholder;
    private DataSourceUiUtil.StatusPanel myStatusPanel;
    private String myHiddenPassword;
    private String myHiddenPassphrase;
    private LazyPasswordField myPasswordLazyField;
    private LazyPasswordField myPassphraseLazyField;

    public DataSourceSshSslPanel(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DataSourceConfigurable dialog) {
        if (project == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(1);
        }
        if (dialog == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myDataSource = dataSource;
        this.myDialog = dialog;
        this.myUpdateAlarm = new SingleAlarm(this::updateAlarmCallback, 100, ModalityState.any(), (Disposable)dialog);
        this.$$$setupUI$$$();
        this.myPanel.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        DataSourceSshTunnelConfiguration ssh = this.myDataSource.getSshConfiguration();
        DataSourceSslConfiguration ssl = this.myDataSource.getSslCfg();
        this.setupFromSshCfg(ssh);
        this.setupFromSslCfg(ssl);
        this.myRememberPasswordCheckBox.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.MINI));
        this.myUseSshCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DataSourceSshSslPanel.this.updateSshPanel();
            }
        });
        this.myAuthTypeCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(Arrays.asList(AuthType.values()), (Object)(ssh == null ? AuthType.PASSWORD : ssh.getAuthType())));
        this.myAuthTypeCombo.setRenderer((ListCellRenderer)new ColoredListCellRenderer<AuthType>(){

            protected void customizeCellRenderer(@NotNull JList<? extends AuthType> list, AuthType value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.append(value.getDisplayName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/dataSource/DataSourceSshSslPanel$2", "customizeCellRenderer"));
            }
        });
        this.myAuthTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSourceSshSslPanel.this.updateSshPanel();
            }
        });
        this.myProxyHostField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                DataSourceSshSslPanel.this.myUpdateAlarm.cancelAndRequest();
            }
        });
        this.myUseSSLJBCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DataSourceSshSslPanel.this.updateSslPanel();
            }
        });
        this.myPrivateKeyFileField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                DataSourceSshSslPanel.this.updateNeedsPassphrase();
            }
        });
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, true, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return true;
            }
        };
        if ((SystemInfo.isLinux || SystemInfo.isMac) && StringUtil.isEmptyOrSpaces((String)this.myPrivateKeyFileField.getText())) {
            this.myPrivateKeyFileField.setText(DataSourceSshSslPanel.getSshDirectory());
        }
        this.myPrivateKeyFileField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener("Choose Private Key File", "", (ComponentWithBrowseButton)this.myPrivateKeyFileField, null, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
        this.myTestConnectionButton.setAction(dialog.getTestAction());
        DataSourceSshSslPanel.addActionListener("Choose SSL Certificate Authority File", this.myCaCertFileField);
        DataSourceSshSslPanel.addActionListener("Choose Client Certificate File", this.myClientCertFileField);
        DataSourceSshSslPanel.addActionListener("Choose Client Key File", this.myClientKeyFileField);
        this.updateSshPanel();
        this.updateSslPanel();
    }

    private void updateAlarmCallback() {
        this.updateOpenSSHPortUser();
    }

    public void updateSslPanel() {
        UIUtil.setEnabled((Component)this.mySslPanel, (boolean)this.myUseSSLJBCheckBox.isSelected(), (boolean)true);
        this.mySslCopyFrom.setVisible(this.myUseSSLJBCheckBox.isSelected());
    }

    private static void addActionListener(String title, TextFieldWithBrowseButton field) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, true, false, false);
        field.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener(title, "", (ComponentWithBrowseButton)field, null, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
    }

    @NotNull
    private static String getSshDirectory() {
        String string = SystemProperties.getUserHome() + "/.ssh/";
        if (string == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void updateNeedsPassphrase() {
        if (!this.myPrivateKeyFileField.isValid()) {
            return;
        }
        if (StringUtil.isNotEmpty((String)this.myPrivateKeyFileField.getText())) {
            boolean needsPassphrase = true;
            File file = new File(this.myPrivateKeyFileField.getText());
            if (file.isFile() && file.canRead()) {
                try {
                    KeyPair keyPair = KeyPair.load((JSch)new JSch(), (String)file.getAbsolutePath());
                    needsPassphrase = keyPair == null || keyPair.isEncrypted();
                }
                catch (JSchException jSchException) {
                    // empty catch block
                }
            }
            if (needsPassphrase) {
                if (!this.myPassphraseField.isEnabled()) {
                    this.myPassphraseField.setEnabled(true);
                }
            } else {
                this.myPassphraseField.setEnabled(false);
            }
        } else {
            this.myPasswordField.setEnabled(true);
        }
    }

    private void updateSshPanel() {
        AuthType authType = (AuthType)this.myAuthTypeCombo.getSelectedItem();
        boolean useSsh = this.myUseSshCheckBox.isSelected();
        if (authType == AuthType.PASSWORD) {
            this.myPasswordPlaceholder.add((Component)this.myRememberPasswordCheckBox, "Center");
        } else if (authType == AuthType.KEY_PAIR) {
            this.myCertificatePlaceholder.add((Component)this.myRememberPasswordCheckBox, "Center");
        }
        this.myUpdateAlarm.cancelAndRequest();
        UIUtil.setEnabled((Component)this.myPasswordPanel, (useSsh && authType == AuthType.PASSWORD ? 1 : 0) != 0, (boolean)true);
        this.myPasswordPanel.setVisible(authType == AuthType.PASSWORD);
        UIUtil.setEnabled((Component)this.myCertificatePanel, (authType == AuthType.KEY_PAIR ? 1 : 0) != 0, (boolean)true);
        this.myCertificatePanel.setVisible(authType == AuthType.KEY_PAIR);
        this.updateNeedsPassphrase();
        UIUtil.setEnabled((Component)this.mySettingContainerPanel, (boolean)this.myUseSshCheckBox.isSelected(), (boolean)true);
        this.mySshCopyFrom.setVisible(this.myUseSshCheckBox.isSelected());
    }

    private void updateOpenSSHPortUser() {
        AuthType authType = (AuthType)this.myAuthTypeCombo.getSelectedItem();
        if (authType != AuthType.OPEN_SSH) {
            for (JBTextField field : Arrays.asList(this.myProxyPortField, this.myUserField)) {
                String text2 = field.getEmptyText().getText();
                if (!StringUtil.isNotEmpty((String)text2)) continue;
                field.getEmptyText().clear();
            }
            return;
        }
        OpenSSHClientConfig openSSHConfig = OpenSSHConfigService.getInstance().getConfig();
        if (openSSHConfig == null) {
            return;
        }
        OpenSSHClientConfig.HostConfig hostConfig = openSSHConfig.getConfig(this.myProxyHostField.getText().trim());
        int port = hostConfig.getPort();
        this.myProxyPortField.getEmptyText().setText(port == -1 ? "" : String.valueOf(port));
        String user = hostConfig.getUser();
        this.myUserField.getEmptyText().setText(user == null ? "" : user);
    }

    public void updateInfoLabel() {
        LocalDataSource dataSource = this.myDialog.getTempDataSource();
        DatabaseDriver driver = dataSource.getDatabaseDriver();
        if (driver == null) {
            this.myUseSshCheckBox.setToolTipText("SSH tunnelling not supported for standalone data sources");
            return;
        }
        Pair.NonNull<String, String> hostPort = JdbcUrlParserUtil.extractHostPort(driver.getJDBCUrlParsers(), StringUtil.notNullize((String)dataSource.getUrl()), null);
        if (hostPort == null) {
            this.myUseSshCheckBox.setToolTipText("Unable to find remote host/port in URL");
        } else {
            this.myUseSshCheckBox.setToolTipText("Remote host is " + (String)hostPort.first + " : " + (String)hostPort.second);
        }
    }

    @NotNull
    protected JPanel getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @Nullable
    public DataSourceSshTunnelConfiguration createSshConfig(@NotNull LocalDataSource ds, boolean copyCredentials) {
        if (ds == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(5);
        }
        boolean storeLocal = ds.getUniqueId() == null;
        String password = storeLocal && copyCredentials ? PasswordUtil.encodePassword((char[])this.getPassword()) : "";
        String passphrase = storeLocal && copyCredentials ? PasswordUtil.encodePassword((char[])this.getPassphrase()) : "";
        DataSourceSshTunnelConfiguration result2 = new DataSourceSshTunnelConfiguration(this.myProxyHostField.getText().trim(), this.myProxyPortField.getText(), this.myRememberPasswordCheckBox.isSelected(), this.myUserField.getText().trim(), (AuthType)ObjectUtils.notNull((Object)this.myAuthTypeCombo.getSelectedItem()), password, this.myPrivateKeyFileField.getText().equals(DataSourceSshSslPanel.getSshDirectory()) ? "" : this.myPrivateKeyFileField.getText(), passphrase, this.myUseSshCheckBox.isSelected());
        return result2.isEmpty() ? null : result2;
    }

    private void setupFromSshCfg(@Nullable DataSourceSshTunnelConfiguration c) {
        this.myRememberPasswordCheckBox.setSelected(c != null && c.isUseMasterKeyStorage());
        this.myProxyHostField.setText(c == null ? "" : c.getProxyHost());
        this.myProxyPortField.setText(c == null ? "" : c.getProxyPort());
        this.myUserField.setText(c == null ? "" : c.getUser());
        this.myUseSshCheckBox.setSelected(c != null && c.isEnabled());
        this.myAuthTypeCombo.setSelectedItem((Object)(c == null ? AuthType.PASSWORD : c.getAuthType()));
        this.myHiddenPassphrase = null;
        this.myHiddenPassword = null;
        this.myPasswordLazyField.setPassword(c == null ? null : StringUtil.nullize((String)PasswordUtil.decodePassword((String)c.getPassword())));
        this.myPassphraseLazyField.setPassword(c == null ? null : StringUtil.nullize((String)PasswordUtil.decodePassword((String)c.getPassphrase())));
        this.myPrivateKeyFileField.setText(c == null ? "" : c.getPrivateKeyPath());
    }

    private void createUIComponents() {
        this.mySslCopyFrom = this.createLabel((Condition<LocalDataSource>)((Condition)ds -> ds.getSslCfg() != null), (Consumer<LocalDataSource>)((Consumer)dataSource -> {
            DataSourceSslConfiguration ssl = dataSource.getSslCfg();
            if (ssl == null) {
                return;
            }
            DataSourceSslConfiguration cfg = new DataSourceSslConfiguration(ssl.myCaCertPath, ssl.myClientCertPath, ssl.myClientKeyPath, true);
            this.setupFromSslCfg(cfg);
        }), "No data sources with SSL");
        this.mySshCopyFrom = this.createLabel((Condition<LocalDataSource>)((Condition)ds -> ds.getSshConfiguration() != null), (Consumer<LocalDataSource>)((Consumer)dataSource -> {
            DataSourceConfigurable configurable = this.myDialog.getController().getConfigurable(dataSource, false, DataSourceConfigurable.class);
            LocalDataSource actualDataSource = configurable != null ? configurable.getTempDataSourceForConnection() : dataSource;
            DataSourceSshTunnelConfiguration configuration = (DataSourceSshTunnelConfiguration)ObjectUtils.notNull((Object)actualDataSource.getSshConfiguration());
            configuration = new DataSourceSshTunnelConfiguration(configuration.getProxyHost(), configuration.getProxyPort(), configuration.isUseMasterKeyStorage(), configuration.getUser(), configuration.getAuthType(), "", configuration.getPrivateKeyPath(), "", true);
            this.setupFromSshCfg(configuration);
            Pair<String, String> credentials = this.myDialog.getSecretService().getSshCredentials(actualDataSource);
            this.myHiddenPassword = PasswordUtil.encodePassword((String)((String)credentials.first));
            this.myHiddenPassphrase = PasswordUtil.encodePassword((String)((String)credentials.second));
            this.updateSshPanel();
        }), "No data sources with SSH");
        this.myPasswordField = new JBPasswordField();
        this.myPasswordLazyField = new LazyPasswordField(this.myPasswordField, (Getter<char[]>)((Getter)() -> {
            if (this.myHiddenPassword != null) {
                return PasswordUtil.decodePasswordAsCharArray((String)this.myHiddenPassword);
            }
            return ((String)this.myDialog.getSecretService().getSshCredentials((LocalDataSource)((LocalDataSource)this.myDialog.getDataSource())).first).toCharArray();
        }));
        this.myPassphraseField = new JBPasswordField();
        this.myPassphraseLazyField = new LazyPasswordField(this.myPassphraseField, (Getter<char[]>)((Getter)() -> {
            if (this.myHiddenPassphrase != null) {
                return PasswordUtil.decodePasswordAsCharArray((String)this.myHiddenPassphrase);
            }
            return ((String)this.myDialog.getSecretService().getSshCredentials((LocalDataSource)((LocalDataSource)this.myDialog.getDataSource())).second).toCharArray();
        }));
    }

    @NotNull
    private LinkLabel createLabel(final @NotNull Condition<LocalDataSource> condition, final @NotNull Consumer<LocalDataSource> processor, final @NotNull String emptyText) {
        if (condition == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(7);
        }
        if (emptyText == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(8);
        }
        LinkLabel linkLabel = new LinkLabel("Copy from ...", null, (LinkListener)new LinkListener<Void>(){

            public void linkSelected(LinkLabel src, Void data) {
                List sources = DataSourceSshSslPanel.this.findAvailableDataSources((Condition<LocalDataSource>)condition);
                JBList list = new JBList((Collection)sources);
                if (sources.isEmpty()) {
                    JBList emptyList = new JBList((Object[])new String[]{emptyText});
                    emptyList.installCellRenderer(dom -> {
                        JBLabel label = new JBLabel((String)dom, null, 2);
                        label.setBorder((Border)JBUI.Borders.empty((int)2, (int)4));
                        return label;
                    });
                    JBPopupFactory.getInstance().createListPopupBuilder((JList)emptyList).setRequestFocus(true).createPopup().showUnderneathOf((Component)src);
                    return;
                }
                list.installCellRenderer(o -> {
                    JBLabel label = new JBLabel(((LocalDataSource)o).getName(), ((LocalDataSource)o).getBaseIcon(), 2);
                    label.setBorder((Border)JBUI.Borders.empty((int)2, (int)4));
                    return label;
                });
                JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setRequestFocus(true).setItemChoosenCallback(() -> {
                    int i2;
                    if (processor == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    if ((i2 = list.getSelectedIndex()) < 0) {
                        return;
                    }
                    LocalDataSource source = (LocalDataSource)sources.get(i2);
                    processor.consume((Object)source);
                }).createPopup().showUnderneathOf((Component)src);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/dataSource/DataSourceSshSslPanel$8", "lambda$linkSelected$2"));
            }
        });
        if (linkLabel == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(9);
        }
        return linkLabel;
    }

    @NotNull
    private List<LocalDataSource> findAvailableDataSources(Condition<LocalDataSource> condition) {
        List dataSources2 = DbPsiFacade.getInstance((Project)this.myProject).getDataSources();
        List list = JBIterable.from((Iterable)dataSources2).map(DbElement::getDelegate).filter(LocalDataSource.class).filter(o -> o != this.myDataSource).filter(condition).toList();
        if (list == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(10);
        }
        return list;
    }

    private void setupFromSslCfg(@Nullable DataSourceSslConfiguration ssl) {
        if (ssl == null) {
            return;
        }
        this.myUseSSLJBCheckBox.setSelected(ssl.myEnabled);
        this.myCaCertFileField.setText(ssl.myCaCertPath);
        this.myClientCertFileField.setText(ssl.myClientCertPath);
        this.myClientKeyFileField.setText(ssl.myClientKeyPath);
    }

    public void reset(@NotNull LocalDataSource ds) {
        if (ds == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(11);
        }
        this.setupFromSshCfg(ds.getSshConfiguration());
        this.setupFromSslCfg(ds.getSslCfg());
    }

    public void saveData(@NotNull LocalDataSource ds, boolean copyCredentials) {
        if (ds == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(12);
        }
        DataSourceSshTunnelConfiguration newSsh = this.createSshConfig(ds, copyCredentials);
        DataSourceSshTunnelConfiguration prevSsh = ds.getSshConfiguration();
        ds.setSshConfiguration(newSsh);
        if (copyCredentials) {
            boolean newUseMasterKey;
            boolean prevUseMasterKey = prevSsh != null && prevSsh.isUseMasterKeyStorage();
            boolean bl = newUseMasterKey = newSsh != null && newSsh.isUseMasterKeyStorage();
            if (prevSsh != null && prevUseMasterKey != newUseMasterKey) {
                this.myDialog.getSecretService().removeSshCredentials(ds);
            }
            if (newSsh != null) {
                this.myDialog.getSecretService().setSshCredentials(ds, this.getPassword(), this.getPassphrase(), newUseMasterKey);
            }
        }
        DataSourceSslConfiguration newSsl = this.getSslCfg();
        if (ds.getSslCfg() == null && !newSsl.isEmpty() || ds.getSslCfg() != null) {
            ds.setSslCfg(newSsl.isEmpty() ? null : newSsl);
        }
    }

    @NotNull
    public char[] getPassword() {
        char[] cArray = (char[])ObjectUtils.notNull((Object)(this.myAuthTypeCombo.getSelectedItem() == AuthType.PASSWORD ? this.myPasswordLazyField.getPassword() : null), (Object)ArrayUtil.EMPTY_CHAR_ARRAY);
        if (cArray == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(13);
        }
        return cArray;
    }

    @NotNull
    public char[] getPassphrase() {
        char[] cArray = (char[])ObjectUtils.notNull((Object)(this.myAuthTypeCombo.getSelectedItem() != AuthType.PASSWORD ? this.myPassphraseLazyField.getPassword() : null), (Object)ArrayUtil.EMPTY_CHAR_ARRAY);
        if (cArray == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(14);
        }
        return cArray;
    }

    @NotNull
    public DataSourceSslConfiguration getSslCfg() {
        DataSourceSslConfiguration dataSourceSslConfiguration = new DataSourceSslConfiguration(this.getCaCertFilePath(), this.getClientCertFilePath(), this.getClientKeyFilePath(), this.getUseSsl());
        if (dataSourceSslConfiguration == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(15);
        }
        return dataSourceSslConfiguration;
    }

    @NotNull
    public String getCaCertFilePath() {
        String string = this.myCaCertFileField.getText();
        if (string == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public String getClientCertFilePath() {
        String string = this.myClientCertFileField.getText();
        if (string == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public String getClientKeyFilePath() {
        String string = this.myClientKeyFileField.getText();
        if (string == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(18);
        }
        return string;
    }

    public boolean getUseSsl() {
        return this.myUseSSLJBCheckBox.isSelected();
    }

    public boolean isPasswordChanged() {
        return this.myPasswordLazyField.isModified() || this.myHiddenPassword != null;
    }

    public boolean isPassphraseChanged() {
        return this.myPassphraseLazyField.isModified() || this.myHiddenPassphrase != null;
    }

    public void onApply() {
        this.myPasswordLazyField.reset();
        this.myPassphraseLazyField.reset();
        this.myHiddenPassphrase = null;
        this.myHiddenPassword = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceSshSslPanel";
                break;
            }
            case 5: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceSshSslPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSshDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findAvailableDataSources";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPassword";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPassphrase";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSslCfg";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaCertFilePath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientCertFilePath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientKeyFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createSshConfig";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        DataSourceUiUtil.StatusPanel statusPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton4;
        JPanel jPanel5;
        ComboBox comboBox;
        JBTextField jBTextField;
        JBTextField jBTextField2;
        JBTextField jBTextField3;
        JPanel jPanel6;
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel7;
        this.createUIComponents();
        this.myPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myUseSshCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setHorizontalAlignment(0);
        jCheckBox2.setText("Use SSH tunnel");
        jCheckBox2.setMnemonic('H');
        jCheckBox2.setDisplayedMnemonicIndex(6);
        jPanel7.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        jPanel7.add((Component)titledSeparator, new GridConstraints(2, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        this.myUseSSLJBCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Use SSL");
        jBCheckBox.setMnemonic('L');
        jBCheckBox.setDisplayedMnemonicIndex(6);
        jPanel7.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySettingContainerPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel6, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Proxy host:");
        jBLabel.setDisplayedMnemonic('O');
        jBLabel.setDisplayedMnemonicIndex(7);
        jPanel6.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Proxy user:");
        jBLabel2.setDisplayedMnemonic('U');
        jBLabel2.setDisplayedMnemonicIndex(6);
        jPanel6.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myProxyHostField = jBTextField3 = new JBTextField();
        jPanel6.add((Component)jBTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel8, new GridConstraints(0, 2, 1, 1, 0, 3, 0, 0, null, null, null, 0, true));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Port:");
        jBLabel3.setDisplayedMnemonic('P');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myProxyPortField = jBTextField2 = new JBTextField();
        jBTextField2.setColumns(5);
        jBTextField2.setText("22");
        jPanel8.add((Component)jBTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myUserField = jBTextField = new JBTextField();
        jPanel6.add((Component)jBTextField, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myAuthTypeCombo = comboBox = new ComboBox();
        comboBox.setSwingPopup(true);
        jPanel6.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Auth type:");
        jBLabel4.setDisplayedMnemonic('T');
        jBLabel4.setDisplayedMnemonicIndex(5);
        jPanel6.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myCertificatePanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(4, 0, 1, 3, 0, 3, 7, 3, null, null, null, 0, true));
        this.myPrivateKeyFileField = textFieldWithBrowseButton4 = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton4, new GridConstraints(0, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Private key file:");
        jBLabel5.setDisplayedMnemonic('R');
        jBLabel5.setDisplayedMnemonicIndex(1);
        jPanel5.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, new Dimension(129, 15), null));
        JBPasswordField jBPasswordField = this.myPassphraseField;
        jBPasswordField.setColumns(10);
        jPanel5.add((Component)jBPasswordField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("Passphrase:");
        jBLabel6.setDisplayedMnemonic('S');
        jBLabel6.setDisplayedMnemonicIndex(2);
        jPanel5.add((Component)jBLabel6, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 0, null, new Dimension(129, 15), null));
        this.myCertificatePlaceholder = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel4, new GridConstraints(1, 2, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myPasswordPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel3, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setText("Proxy password:");
        jBLabel7.setDisplayedMnemonic('W');
        jBLabel7.setDisplayedMnemonicIndex(10);
        jPanel3.add((Component)jBLabel7, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, new Dimension(128, 15), null));
        JBPasswordField jBPasswordField2 = this.myPasswordField;
        jBPasswordField2.setColumns(10);
        jPanel3.add((Component)jBPasswordField2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myPasswordPlaceholder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 2, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myRememberPasswordCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(0);
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/DatabaseBundle").getString("remember.password"));
        jCheckBox.setVerticalAlignment(0);
        jPanel2.add((Component)jCheckBox, "Center");
        this.mySslPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel8 = new JBLabel();
        jBLabel8.setText("CA file:");
        jBLabel8.setDisplayedMnemonic('A');
        jBLabel8.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jBLabel8, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, new Dimension(130, 15), null));
        JBLabel jBLabel9 = new JBLabel();
        jBLabel9.setText("Client certificate file:");
        jBLabel9.setDisplayedMnemonic('C');
        jBLabel9.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel9, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 0, null, new Dimension(130, 15), null));
        this.myCaCertFileField = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(350, -1), null));
        this.myClientCertFileField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(350, -1), null));
        this.myClientKeyFileField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(350, -1), null));
        JBLabel jBLabel10 = new JBLabel();
        jBLabel10.setText("Client key file:");
        jBLabel10.setDisplayedMnemonic('K');
        jBLabel10.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jBLabel10, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 0, null, new Dimension(130, 15), null));
        LinkLabel linkLabel = this.mySslCopyFrom;
        linkLabel.setText("Copy from...");
        linkLabel.setVerticalAlignment(1);
        jPanel7.add((Component)linkLabel, new GridConstraints(3, 1, 1, 2, 4, 0, 0, 0, null, new Dimension(114, 12), null));
        LinkLabel linkLabel2 = this.mySshCopyFrom;
        linkLabel2.setText("Copy from...");
        linkLabel2.setVerticalAlignment(1);
        jPanel7.add((Component)linkLabel2, new GridConstraints(0, 2, 1, 1, 4, 0, 0, 0, null, new Dimension(114, 12), null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        jPanel7.add((Component)titledSeparator2, new GridConstraints(5, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel9, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 0, null, null, null));
        this.myStatusPanel = statusPanel = new DataSourceUiUtil.StatusPanel();
        jPanel9.add((Component)statusPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTestConnectionButton = jButton = new JButton();
        jButton.setText("Test Connection");
        jButton.setVerticalAlignment(0);
        jPanel9.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel9.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(7, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        jBLabel.setLabelFor((Component)jBTextField3);
        jBLabel2.setLabelFor((Component)jBTextField);
        jBLabel3.setLabelFor((Component)jBTextField2);
        jBLabel4.setLabelFor((Component)comboBox);
        jBLabel5.setLabelFor((Component)textFieldWithBrowseButton4);
        jBLabel6.setLabelFor((Component)jBPasswordField);
        jBLabel7.setLabelFor((Component)jBPasswordField2);
        jBLabel8.setLabelFor((Component)textFieldWithBrowseButton3);
        jBLabel9.setLabelFor((Component)textFieldWithBrowseButton2);
        jBLabel10.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

