/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url;

import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcUrlParserUtil {
    @Nullable
    public static StatelessJdbcUrlParser select(@NotNull Collection<StatelessJdbcUrlParser> parsers, @NotNull String url) {
        if (parsers == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(0);
        }
        if (url == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(1);
        }
        for (StatelessJdbcUrlParser p : parsers) {
            if (!p.isUrlValueValid(url)) continue;
            return p;
        }
        return null;
    }

    @Nullable
    public static StatelessJdbcUrlParser select(@NotNull Collection<StatelessJdbcUrlParser> parsers, @NotNull String url, @NotNull StatelessJdbcUrlParser.LocationType loc) {
        if (parsers == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(2);
        }
        if (url == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(3);
        }
        if (loc == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(4);
        }
        for (StatelessJdbcUrlParser p : parsers) {
            if (!p.getPossibleLocations().contains((Object)loc) || !p.isUrlValueValid(url)) continue;
            return p;
        }
        return null;
    }

    @Nullable
    public static JdbcUrlParser stateful(@Nullable StatelessJdbcUrlParser parser) {
        return parser == null ? null : parser.createStatefull();
    }

    @Nullable
    public static JdbcUrlParser parsed(@Nullable RawConnectionConfig config) {
        if (config == null) {
            return null;
        }
        JdbcUrlParser stateful = JdbcUrlParserUtil.stateful(JdbcUrlParserUtil.select(config));
        if (stateful == null) {
            return null;
        }
        stateful.setUrlText(config.getUrl());
        return stateful.isValid() ? stateful : null;
    }

    @Nullable
    public static Pair.NonNull<String, String> extractHostPort(@NotNull Collection<StatelessJdbcUrlParser> parsers, @NotNull String url, @Nullable Ref<JdbcUrlParser> p) {
        JdbcUrlParser parser;
        if (parsers == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(5);
        }
        if (url == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(6);
        }
        if ((parser = JdbcUrlParserUtil.stateful(JdbcUrlParserUtil.select(parsers, url, StatelessJdbcUrlParser.LocationType.REMOTE))) != null) {
            parser.setUrlText(url);
        }
        if (parser == null || !parser.isValid()) {
            return null;
        }
        String host = parser.getParameter("host");
        String port = parser.getParameter("port");
        if (StringUtil.isEmpty((String)port)) {
            port = parser.getParameterDefValue("port");
        }
        if (p != null) {
            p.set((Object)parser);
        }
        return StringUtil.isEmpty((String)host) || StringUtil.isEmpty((String)port) ? null : Pair.createNonNull((Object)host, (Object)port);
    }

    @Nullable
    public static StatelessJdbcUrlParser select(@NotNull RawConnectionConfig config) {
        DatabaseDriver driver;
        String url;
        if (config == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(7);
        }
        if ((url = config.getUrl()) == null) {
            return null;
        }
        if (config instanceof LocalDataSource && (driver = ((LocalDataSource)config).getDatabaseDriver()) != null) {
            return JdbcUrlParserUtil.select(driver.getJDBCUrlParsers(), url);
        }
        for (DatabaseDriver databaseDriver : DatabaseDriverManager.getInstance().getDrivers()) {
            StatelessJdbcUrlParser parser;
            if (!Comparing.equal((String)config.getDriverClass(), (String)databaseDriver.getDriverClass()) || (parser = JdbcUrlParserUtil.select(databaseDriver.getJDBCUrlParsers(), url)) == null) continue;
            return parser;
        }
        return null;
    }

    public static DatabaseConnectionPoint connectedTo(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ObjectPath needed) {
        DatabaseDriver.Bounds bounds;
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(8);
        }
        if (needed == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(9);
        }
        if (JdbcUrlParserUtil.inBoundsFast(bounds = JdbcUrlParserUtil.getBounds(connectionPoint), connectionPoint.isReadOnly()) || bounds.rewriteParameters.isEmpty()) {
            return connectionPoint;
        }
        String neededParam = JdbcUrlParserUtil.getObjectItem(needed, bounds.boundTo);
        if (neededParam == null) {
            return connectionPoint;
        }
        LazyStatefulParser parser = new LazyStatefulParser(connectionPoint);
        String parameter = JdbcUrlParserUtil.findParameter(parser, connectionPoint, bounds.rewriteParameters);
        if (StringUtil.isEmpty((String)parameter)) {
            parameter = bounds.defaultValue;
        }
        if (!JdbcUrlParserUtil.paramOutOfBounds(parameter, neededParam)) {
            return connectionPoint;
        }
        return JdbcUrlParserUtil.rebound(parser, connectionPoint, bounds, neededParam);
    }

    public static DatabaseConnectionPoint connectedTo(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ObjectPath current, @NotNull ObjectPath needed) {
        DatabaseDriver.Bounds bounds;
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(10);
        }
        if (current == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(11);
        }
        if (needed == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(12);
        }
        if (JdbcUrlParserUtil.inBoundsFast(bounds = JdbcUrlParserUtil.getBounds(connectionPoint), connectionPoint.isReadOnly()) || bounds.rewriteParameters.isEmpty()) {
            return connectionPoint;
        }
        String neededParam = JdbcUrlParserUtil.getObjectItem(needed, bounds.boundTo);
        if (neededParam == null) {
            return connectionPoint;
        }
        String parameter = JdbcUrlParserUtil.getObjectItem(current, bounds.boundTo);
        if (!JdbcUrlParserUtil.paramOutOfBounds(parameter, neededParam)) {
            return connectionPoint;
        }
        return JdbcUrlParserUtil.rebound(new LazyStatefulParser(connectionPoint), connectionPoint, bounds, neededParam);
    }

    public static boolean isBounded(@NotNull DatabaseConnectionPoint connectionPoint) {
        DatabaseDriver.Bounds bounds;
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(13);
        }
        return (bounds = JdbcUrlParserUtil.getBounds(connectionPoint)) != null && (!bounds.inReadOnlyMode || connectionPoint.isReadOnly());
    }

    public static boolean isDatabaseBounded(@NotNull DatabaseConnectionPoint connectionPoint) {
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(14);
        }
        if (!JdbcUrlParserUtil.isBounded(connectionPoint)) {
            return false;
        }
        DatabaseDriver.Bounds bounds = JdbcUrlParserUtil.getBounds(connectionPoint);
        return bounds != null && bounds.boundTo == ObjectKind.DATABASE;
    }

    @Nullable
    public static DatabaseDriver.Bounds getBounds(@Nullable DatabaseConnectionPoint connectionPoint) {
        return JdbcUrlParserUtil.getBounds(connectionPoint == null ? null : connectionPoint.getDatabaseDriver());
    }

    @Nullable
    private static DatabaseDriver.Bounds getBounds(@Nullable DatabaseDriver driver) {
        return driver == null ? null : driver.getConnectionBounds();
    }

    @NotNull
    private static DatabaseConnectionPoint rebound(@NotNull LazyStatefulParser parser, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull DatabaseDriver.Bounds bounds, final @NotNull String neededParam) {
        if (parser == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(15);
        }
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(16);
        }
        if (bounds == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(17);
        }
        if (neededParam == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(18);
        }
        if (bounds.rewriteParameters.isEmpty()) {
            DatabaseConnectionPoint databaseConnectionPoint = connectionPoint;
            if (databaseConnectionPoint == null) {
                JdbcUrlParserUtil.$$$reportNull$$$0(19);
            }
            return databaseConnectionPoint;
        }
        final Pair<String, Boolean> param = bounds.rewriteParameters.get(0);
        if (((Boolean)param.second).booleanValue()) {
            JdbcUrlParser urlParser = parser.getParser();
            if (urlParser == null) {
                DatabaseConnectionPoint databaseConnectionPoint = connectionPoint;
                if (databaseConnectionPoint == null) {
                    JdbcUrlParserUtil.$$$reportNull$$$0(20);
                }
                return databaseConnectionPoint;
            }
            urlParser.setParameter((String)param.first, neededParam);
            final String rewritten = urlParser.getUrlText();
            DatabaseConnectionPoint.Adapter adapter = new DatabaseConnectionPoint.Adapter(connectionPoint){

                @Override
                public String getUrl() {
                    return rewritten;
                }
            };
            if (adapter == null) {
                JdbcUrlParserUtil.$$$reportNull$$$0(21);
            }
            return adapter;
        }
        DatabaseConnectionPoint.Adapter adapter = new DatabaseConnectionPoint.Adapter(connectionPoint){

            @Override
            @NotNull
            public Properties getConnectionProperties() {
                Properties properties = super.getConnectionProperties();
                properties.setProperty((String)param.first, neededParam);
                Properties properties2 = properties;
                if (properties2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return properties2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/JdbcUrlParserUtil$2", "getConnectionProperties"));
            }
        };
        if (adapter == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(22);
        }
        return adapter;
    }

    public static boolean outOfBounds(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ObjectPath needed) {
        DatabaseDriver.Bounds bounds;
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(23);
        }
        if (needed == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(24);
        }
        if (JdbcUrlParserUtil.inBoundsFast(bounds = JdbcUrlParserUtil.getBounds(connectionPoint), connectionPoint.isReadOnly()) || bounds.rewriteParameters.isEmpty()) {
            return false;
        }
        String neededParam = JdbcUrlParserUtil.getObjectItem(needed, bounds.boundTo);
        if (neededParam == null) {
            return false;
        }
        LazyStatefulParser parser = new LazyStatefulParser(connectionPoint);
        String parameter = JdbcUrlParserUtil.findParameter(parser, connectionPoint, bounds.rewriteParameters);
        if (StringUtil.isEmpty((String)parameter)) {
            parameter = bounds.defaultValue;
        }
        return JdbcUrlParserUtil.paramOutOfBounds(parameter, neededParam);
    }

    public static boolean outOfBounds(@NotNull DatabaseConnectionPoint connectionPoint, @Nullable ObjectPath current, @NotNull ObjectPath needed) {
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(25);
        }
        if (needed == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(26);
        }
        if (current == null) {
            return JdbcUrlParserUtil.outOfBounds(connectionPoint, needed);
        }
        return JdbcUrlParserUtil.outOfBounds(connectionPoint.getDatabaseDriver(), connectionPoint.isReadOnly(), current, needed);
    }

    public static boolean outOfBounds(@Nullable DatabaseDriver driver, boolean isReadOnly, @NotNull ObjectPath current, @NotNull ObjectPath needed) {
        DatabaseDriver.Bounds bounds;
        if (current == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(27);
        }
        if (needed == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(28);
        }
        if (JdbcUrlParserUtil.inBoundsFast(bounds = JdbcUrlParserUtil.getBounds(driver), isReadOnly)) {
            return false;
        }
        String neededParam = JdbcUrlParserUtil.getObjectItem(needed, bounds.boundTo);
        if (neededParam == null) {
            return false;
        }
        return JdbcUrlParserUtil.paramOutOfBounds(JdbcUrlParserUtil.getObjectItem(current, bounds.boundTo), neededParam);
    }

    private static boolean paramOutOfBounds(@Nullable String currentParameter, @NotNull String neededParam) {
        if (neededParam == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(29);
        }
        if (currentParameter == null) {
            return true;
        }
        return !neededParam.equalsIgnoreCase(currentParameter);
    }

    private static boolean inBoundsFast(@Nullable DatabaseDriver.Bounds bounds, boolean isReadOnly) {
        return bounds == null || !isReadOnly && bounds.inReadOnlyMode;
    }

    @Nullable
    public static ObjectPath toBound(@NotNull DatabaseConnectionPoint connectionPoint, @Nullable ObjectPath path) {
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(30);
        }
        if (path == null || !JdbcUrlParserUtil.outOfBounds(connectionPoint, path)) {
            return null;
        }
        DatabaseDriver.Bounds bounds = JdbcUrlParserUtil.getBounds(connectionPoint);
        return bounds == null ? null : JdbcUrlParserUtil.getObjectPathTo(path, bounds.boundTo);
    }

    @Nullable
    public static String getObjectItem(@Nullable ObjectPath path, @NotNull ObjectKind kind) {
        if (kind == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(31);
        }
        if (path == null) {
            return null;
        }
        List p = path.path;
        int sz = p.size();
        if (path.kind == kind) {
            return sz == 0 ? null : (String)p.get(sz - 1);
        }
        if (DbImplUtil.isSchema(path.kind) && kind == ObjectKind.DATABASE) {
            return sz < 2 ? null : (String)p.get(sz - 2);
        }
        return null;
    }

    @Nullable
    public static ObjectPath getObjectPathTo(@Nullable ObjectPath path, @NotNull ObjectKind kind) {
        if (kind == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(32);
        }
        if (path == null || path.kind == kind) {
            return path;
        }
        List p = path.path;
        int sz = p.size();
        if (DbImplUtil.isSchema(path.kind) && kind == ObjectKind.DATABASE) {
            return sz < 2 ? null : new ObjectPath(kind, p.subList(0, sz - 1));
        }
        return null;
    }

    @Nullable
    private static String findParameter(@NotNull LazyStatefulParser parser, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull List<Pair<String, Boolean>> params2) {
        if (parser == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(33);
        }
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(34);
        }
        if (params2 == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(35);
        }
        HashMap properties = null;
        for (Pair<String, Boolean> param : params2) {
            String value;
            if (((Boolean)param.second).booleanValue()) {
                JdbcUrlParser urlParser = parser.getParser();
                value = urlParser != null ? urlParser.getParameter((String)param.first) : null;
            } else {
                if (properties == null) {
                    properties = ContainerUtil.newHashMap((Map)connectionPoint.getConnectionProperties());
                }
                value = (String)ObjectUtils.tryCast(properties.get(param.first), String.class);
            }
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsers";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loc";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 25: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionPoint";
                break;
            }
            case 9: 
            case 12: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "needed";
                break;
            }
            case 11: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 15: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 18: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "neededParam";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/JdbcUrlParserUtil";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/JdbcUrlParserUtil";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "rebound";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractHostPort";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "connectedTo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isBounded";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isDatabaseBounded";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "rebound";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "outOfBounds";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "paramOutOfBounds";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "toBound";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getObjectItem";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getObjectPathTo";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LazyStatefulParser {
        private final RawConnectionConfig myConfig;
        private Ref<JdbcUrlParser> myParser;

        private LazyStatefulParser(RawConnectionConfig config) {
            this.myConfig = config;
        }

        @Nullable
        JdbcUrlParser getParser() {
            if (this.myParser == null) {
                this.myParser = Ref.create((Object)JdbcUrlParserUtil.parsed(this.myConfig));
            }
            return (JdbcUrlParser)this.myParser.get();
        }
    }
}

