/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.DomainWrapper;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPositionWidget;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.IndexSet;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.NamedRow;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.TranspositionAwareDefaultExtractor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarInfo;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Mutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataGridUtil {
    public static final Logger LOG = Logger.getInstance(DataGridUtil.class);
    public static final int CSV_VALUE_SQL_TYPE = 239;
    public static final String FAILED_TO_LOAD_PREFIX = "<failed to load>";

    private DataGridUtil() {
    }

    @Nullable
    public static DataGrid getDataGrid(DataContext dataContext) {
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
        if (editor instanceof TableEditorBase) {
            return ((TableEditorBase)editor).getDataGrid();
        }
        return (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(dataContext);
    }

    @NotNull
    public static DataGrid createDataGrid(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> dataHookUp, @NotNull ActionGroup popupActions) {
        if (project == null) {
            DataGridUtil.$$$reportNull$$$0(0);
        }
        if (dataHookUp == null) {
            DataGridUtil.$$$reportNull$$$0(1);
        }
        if (popupActions == null) {
            DataGridUtil.$$$reportNull$$$0(2);
        }
        TableResultPanel tableResultPanel = new TableResultPanel(project, dataHookUp, popupActions, DataGrid.Place.EDITOR);
        if (tableResultPanel == null) {
            DataGridUtil.$$$reportNull$$$0(3);
        }
        return tableResultPanel;
    }

    public static DataGrid createPreviewDataGrid(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> dataHookUp) {
        if (project == null) {
            DataGridUtil.$$$reportNull$$$0(4);
        }
        if (dataHookUp == null) {
            DataGridUtil.$$$reportNull$$$0(5);
        }
        ActionGroup popup = (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.Csv.PreviewPopupGroup");
        return new TableResultPanel(project, dataHookUp, popup, popup, ActionGroup.EMPTY_GROUP, null, DataGrid.Place.DIALOG, false);
    }

    @NotNull
    public static ModelIndex<DataConsumer.Column> findColumn(@NotNull DataGrid dataGrid, @Nullable String name) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(6);
        }
        GridModel gridModel = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        for (ModelIndex c : gridModel.getColumnIndices().asIterable()) {
            DataConsumer.Column column2 = (DataConsumer.Column)gridModel.getColumn(c);
            if (column2 == null || !Comparing.strEqual((String)name, (String)column2.name)) continue;
            ModelIndex modelIndex = c;
            if (modelIndex == null) {
                DataGridUtil.$$$reportNull$$$0(7);
            }
            return modelIndex;
        }
        ModelIndex<DataConsumer.Column> modelIndex = ModelIndex.forColumn(dataGrid, -1);
        if (modelIndex == null) {
            DataGridUtil.$$$reportNull$$$0(8);
        }
        return modelIndex;
    }

    public static void updateWidgets(@Nullable DataGrid grid) {
        GridPositionWidget.Listener listener = (GridPositionWidget.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(GridPositionWidget.TOPIC);
        if (grid == null) {
            listener.closed();
            return;
        }
        listener.changed(grid);
    }

    @NotNull
    public static String getSqlType(@NotNull DataGrid grid, @Nullable DataConsumer.Column column2) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(9);
        }
        if (column2 == null) {
            if ("" == null) {
                DataGridUtil.$$$reportNull$$$0(10);
            }
            return "";
        }
        String typeNameSafe = StringUtil.notNullize((String)column2.typeName);
        DatabaseGridDataHookUp hookUp = DataGridUtil.getDatabaseHookUp(grid);
        if (hookUp == null) {
            String string = typeNameSafe;
            if (string == null) {
                DataGridUtil.$$$reportNull$$$0(11);
            }
            return string;
        }
        DasColumn dasColumn = DataGridUtil.getDatabaseColumn(grid, column2);
        if (dasColumn != null) {
            String string = dasColumn.getDataType().getSpecification();
            if (string == null) {
                DataGridUtil.$$$reportNull$$$0(12);
            }
            return string;
        }
        DataType type = DataTypeFactory.of(column2.schema, typeNameSafe, column2.precision, column2.scale, null, null, false, false, column2.type);
        String string = hookUp.getDatabaseDialect().getTypeName(type);
        if (string == null) {
            DataGridUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static void focusDataGrid(DataContext dataContext) {
        DataGridUtil.focusDataGrid(DataGridUtil.getDataGrid(dataContext));
    }

    public static void focusDataGrid(DataGrid grid) {
        if (grid != null) {
            JComponent toFocus = grid.getPreferredFocusedComponent();
            IdeFocusManager.findInstanceByComponent((Component)toFocus).requestFocus((Component)toFocus, true);
        }
    }

    public static void setupProgressIndicatingAuditor(final @NotNull DataGrid grid) {
        DataRequest.OwnerEx ownerEx;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(14);
        }
        if ((ownerEx = (DataRequest.OwnerEx)ObjectUtils.tryCast(grid.getDataHookup(), DataRequest.OwnerEx.class)) == null) {
            return;
        }
        ownerEx.getMessageBus().addAuditor(new DataAuditor.Adapter(){

            @Override
            public void print(@NotNull DataRequest.Context context, @Nullable String message) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (message != null && message.contains("retrieved starting")) {
                    return;
                }
                ((StatusBarInfo)DataGridUtil.getProject(grid).getMessageBus().syncPublisher(StatusBar.Info.TOPIC)).setInfo(message);
            }

            @Override
            public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
                if (request == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (producer == null) {
                    1.$$$reportNull$$$0(2);
                }
                DataGridUtil.setProgressMessage(grid, "Connecting...");
            }

            @Override
            public void requestStarted(@NotNull DataRequest.Context context) {
                if (context == null) {
                    1.$$$reportNull$$$0(3);
                }
                DataGridUtil.setProgressMessage(grid, "Processing...");
            }

            @Override
            public void beforeStatement(@NotNull DataRequest.Context context) {
                if (context == null) {
                    1.$$$reportNull$$$0(4);
                }
                DataGridUtil.setProgressMessage(grid, "Querying...");
            }

            @Override
            public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
                if (request == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (producer == null) {
                    1.$$$reportNull$$$0(6);
                }
                DataGridUtil.setProgressMessage(grid, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "request";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "producer";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/datagrid/DataGridUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "print";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jobSubmitted";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "requestStarted";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeStatement";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jobFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static void setProgressMessage(@NotNull DataGrid grid, @Nullable String message) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(15);
        }
        DbUIUtil.invokeLaterIfNeeded(() -> {
            if (grid == null) {
                DataGridUtil.$$$reportNull$$$0(67);
            }
            JBLoadingPanel loadingPanel = grid.getLoadingPanel();
            if (message != null) {
                loadingPanel.startLoading();
            } else {
                loadingPanel.stopLoading();
            }
            loadingPanel.setLoadingText(message);
        });
    }

    @Contract(value="null->null;!null->_")
    public static DasTable getDatabaseTable(@Nullable DataGrid grid) {
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        return hookup != null ? hookup.getDatabaseTable() : null;
    }

    @Nullable
    public static DasColumn getDatabaseColumn(@Nullable DataGrid grid, @Nullable DataConsumer.Column column2) {
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        return hookup != null ? hookup.getDatabaseColumn(column2) : null;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@Nullable DataGrid grid) {
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        DatabaseDialectEx databaseDialectEx = hookup != null ? hookup.getDatabaseDialect() : GenericDialect.INSTANCE;
        if (databaseDialectEx == null) {
            DataGridUtil.$$$reportNull$$$0(16);
        }
        return databaseDialectEx;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DataGrid grid) {
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect((DbElement)DataGridUtil.getDatabaseSystem(grid));
        if (sqlLanguageDialect == null) {
            DataGridUtil.$$$reportNull$$$0(17);
        }
        return sqlLanguageDialect;
    }

    @Contract(value="null->null;!null->_")
    public static DbDataSource getDatabaseSystem(@Nullable DataGrid grid) {
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        return hookup != null ? hookup.getDataSource() : null;
    }

    public static int getResultSetIndex(@Nullable DataGrid grid) {
        DataBusGridDataHookUp dataBusHookup = DataGridUtil.getDataBusHookUp(grid);
        return dataBusHookup != null ? dataBusHookup.getResultSetIndex() : 1;
    }

    @Contract(value="null->null;!null->_")
    public static String getQueryText(@Nullable DataGrid grid) {
        DataBusGridDataHookUp dataBusHookUp = DataGridUtil.getDataBusHookUp(grid);
        return dataBusHookUp != null ? dataBusHookUp.getQueryText() : null;
    }

    public static DataBusGridDataHookUp getDataBusHookUp(@Nullable DataGrid grid) {
        return DataGridUtil.getHookUp(grid, DataBusGridDataHookUp.class);
    }

    public static DatabaseGridDataHookUp getDatabaseHookUp(@Nullable DataGrid grid) {
        return DataGridUtil.getHookUp(grid, DatabaseGridDataHookUp.class);
    }

    @Contract(value="null,_->null;!null,_->_")
    public static <T extends GridDataHookUp<DataConsumer.Row, DataConsumer.Column>> T getHookUp(@Nullable DataGrid grid, Class<T> clazz) {
        GridDataHookUp hookup = grid != null ? grid.getDataHookup() : null;
        return (T)((GridDataHookUp)ObjectUtils.tryCast(hookup, clazz));
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull DataGrid grid) {
        DocumentDataHookUp up;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(18);
        }
        Document document = (up = DataGridUtil.getDocumentDataHookUp(grid)) == null ? null : up.getDocument();
        return document == null ? null : FileDocumentManager.getInstance().getFile(document);
    }

    @Nullable
    public static DocumentDataHookUp getDocumentDataHookUp(@NotNull DataGrid grid) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(19);
        }
        return DataGridUtil.getHookUp(grid, DocumentDataHookUp.class);
    }

    public static void addGridHeaderComponent(@NotNull DataGrid dataGrid, @Nullable VirtualFile virtualFile) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(20);
        }
        ActionManager actionManager = ActionManager.getInstance();
        boolean isConsoleResult = !DbImplUtil.isDatabaseVirtualFile(virtualFile);
        ActionGroup actions = (ActionGroup)actionManager.getAction(isConsoleResult ? "Console.TableResult.Group" : "Console.EditorTableResult.Group");
        ActionGroup secondaryActions = (ActionGroup)actionManager.getAction("Console.TableResult.Group.Secondary");
        ActionToolbar toolbar = actionManager.createActionToolbar("EditorToolbar", actions, true);
        ActionToolbar toolbarSecondary = actionManager.createActionToolbar("EditorToolbar", secondaryActions, true);
        toolbar.setTargetComponent(dataGrid.getComponent());
        toolbarSecondary.setTargetComponent(dataGrid.getComponent());
        toolbarSecondary.setReservePlaceAutoPopupIcon(false);
        EditorHeaderComponent header = new EditorHeaderComponent();
        header.add((Component)toolbar.getComponent(), "Center");
        header.add((Component)toolbarSecondary.getComponent(), "East");
        if (dataGrid.isFilteringSupported()) {
            header.add((Component)dataGrid.getFilterPanel(), "South");
        }
        dataGrid.setTopComponent((Component)header);
        if (virtualFile != null) {
            DatabaseEditorHelper.updateToolbarColor(DataGridUtil.getProject(dataGrid), virtualFile, (JComponent)header);
        }
    }

    public static void configureNumericEditor(@NotNull DataGrid grid, @NotNull Editor editor) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(21);
        }
        if (editor == null) {
            DataGridUtil.$$$reportNull$$$0(22);
        }
        if (!(editor instanceof EditorImpl)) {
            return;
        }
        EditorImpl editorImpl = (EditorImpl)editor;
        boolean transposed = grid.isTransposed();
        int textAlignment = transposed ? 0 : 1;
        int scrollbarOrientation = transposed ? 1 : 0;
        editorImpl.setHorizontalTextAlignment(textAlignment);
        editorImpl.setVerticalScrollbarOrientation(scrollbarOrientation);
    }

    public static boolean canBuildWhereClause(@NotNull DataGrid grid) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(23);
        }
        GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
        List columns2 = model.getColumns();
        DasTable table = DataGridUtil.getDatabaseTable(grid);
        return !DbImplUtil.getWhereClauseColumns(table, columns2, DataGridUtil.getDatabaseDialect(grid)).isEmpty();
    }

    public static ActionGroup getGridPopupActions() {
        return (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.PopupGroup");
    }

    public static ActionGroup getGridColumnHeaderPopupActions() {
        return (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.ColumnHeaderPopup");
    }

    public static DataConsumer createEDTSafeWrapper(final @NotNull DataConsumer handler, @NotNull Disposable disposableParent) {
        if (handler == null) {
            DataGridUtil.$$$reportNull$$$0(24);
        }
        if (disposableParent == null) {
            DataGridUtil.$$$reportNull$$$0(25);
        }
        final MergingUpdateQueue queue = new MergingUpdateQueue("DataConsumer[EDT]", 300, true, MergingUpdateQueue.ANY_COMPONENT, disposableParent);
        queue.setPassThrough(false);
        return new DataConsumer(){
            DataConsumer.Column[] columnInfos;

            @Override
            public void setColumns(final @NotNull DataRequest.Context context, final int resultSetIndex, final DataConsumer.Column[] infos, final int firstRowNum) {
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.columnInfos = infos;
                queue.queue(new Update("setColumns"){

                    public void run() {
                        handler.setColumns(context, resultSetIndex, infos, firstRowNum);
                    }
                });
            }

            @Override
            public void addRows(final @NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                ObjectFormatter.convertRows(rows, ContainerUtil.list((Object[])this.columnInfos));
                class AddRows
                extends Update {
                    final List<List<DataConsumer.Row>> rows;

                    public AddRows(List<DataConsumer.Row> rows) {
                        super(new Object());
                        this.rows = new SmartList();
                        this.rows.add(rows);
                    }

                    public boolean canEat(Update update2) {
                        if (update2 instanceof AddRows) {
                            this.rows.addAll(((AddRows)update2).rows);
                            return true;
                        }
                        return false;
                    }

                    public void run() {
                        List combined = this.rows.size() == 1 ? this.rows.get(0) : ContainerUtil.concat((List[])this.rows.toArray(new List[this.rows.size()]));
                        handler.addRows(context, combined);
                    }
                }
                queue.queue((Update)new AddRows(rows));
            }

            @Override
            public void afterLastRowAdded(final @NotNull DataRequest.Context context, final int total) {
                if (context == null) {
                    2.$$$reportNull$$$0(2);
                }
                this.columnInfos = null;
                queue.queue(new Update("afterLastRowAdded"){

                    public void run() {
                        handler.afterLastRowAdded(context, total);
                    }
                });
                queue.flush();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "context";
                objectArray2[1] = "com/intellij/database/datagrid/DataGridUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setColumns";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addRows";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterLastRowAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    public static ReservedCellValue getDefaultNullValue(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        DataConsumer.Column column2;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(26);
        }
        if (columnIdx == null) {
            DataGridUtil.$$$reportNull$$$0(27);
        }
        if (DbImplUtil.isRowId(column2 = grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(columnIdx))) {
            return ReservedCellValue.COMPUTED;
        }
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        DasColumn dasColumn = hookup != null ? hookup.getDatabaseColumn(column2) : null;
        return DataGridUtil.getDefaultNullValue(dasColumn);
    }

    @NotNull
    public static List<RowMutation> mergeAll(@NotNull List<CellMutation> mutations, @NotNull GridModel<DataConsumer.Row, DataConsumer.Column> model) {
        if (mutations == null) {
            DataGridUtil.$$$reportNull$$$0(28);
        }
        if (model == null) {
            DataGridUtil.$$$reportNull$$$0(29);
        }
        ArrayList copy = ContainerUtil.newArrayList(mutations);
        ArrayList rowMutations = ContainerUtil.newArrayList();
        while (!copy.isEmpty()) {
            rowMutations.add(DataGridUtil.merge(copy, model));
        }
        List<RowMutation> list = rowMutations.stream().filter(Objects::nonNull).sorted().collect(Collectors.toList());
        if (list == null) {
            DataGridUtil.$$$reportNull$$$0(30);
        }
        return list;
    }

    @Nullable
    private static RowMutation merge(@NotNull @Mutable List<CellMutation> mutations, @NotNull GridModel<DataConsumer.Row, DataConsumer.Column> model) {
        CellMutation item;
        if (mutations == null) {
            DataGridUtil.$$$reportNull$$$0(31);
        }
        if (model == null) {
            DataGridUtil.$$$reportNull$$$0(32);
        }
        if ((item = (CellMutation)ContainerUtil.getFirstItem(mutations)) == null) {
            throw new IllegalStateException("Shouldn't call merge() when there is no pending changes");
        }
        mutations.remove(item);
        List toMerge = ContainerUtil.filter(mutations, item::canMergeByRowWith);
        mutations.removeAll(toMerge);
        RowMutation merged = item.createRowMutation(model);
        for (CellMutation mutation : toMerge) {
            if (merged == null) {
                merged = mutation.createRowMutation(model);
                continue;
            }
            merged = merged.merge(mutation.createRowMutation(model));
        }
        return merged;
    }

    @Nullable
    public static ReservedCellValue getDefaultNullValue(@Nullable DasColumn dasColumn) {
        EnumSet<ReservedCellValue> opts = DbImplUtil.getSpecialValues(dasColumn);
        return opts.contains((Object)ReservedCellValue.GENERATED) ? ReservedCellValue.GENERATED : (opts.contains((Object)ReservedCellValue.COMPUTED) ? ReservedCellValue.COMPUTED : (opts.contains((Object)ReservedCellValue.DEFAULT) ? ReservedCellValue.DEFAULT : (opts.contains((Object)ReservedCellValue.NULL) ? ReservedCellValue.NULL : null)));
    }

    public static Project getProject(@NotNull DataGrid grid) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(33);
        }
        return (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)grid.getComponent()));
    }

    public static boolean isFailedToLoad(Object value) {
        return value instanceof String && StringUtil.startsWith((CharSequence)((String)value), (CharSequence)FAILED_TO_LOAD_PREFIX);
    }

    public static boolean showIgnoreUnsubmittedChangesYesNoDialog(@NotNull DataGrid grid) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(34);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        String title = "Ignore Unsubmitted Changes";
        String message = "Changes is not submitted. Data will be lost. Continue?";
        return 0 == Messages.showYesNoDialog((Component)grid.getComponent(), (String)message, (String)title, (Icon)AllIcons.General.NotificationWarning);
    }

    public static void showCannotApplyCellEditorChanges(@NotNull DataGrid grid) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(35);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        String title = "Cannot Apply Changes";
        String message = "This table is read-only. Cell editor changes cannot be applied.";
        Messages.showInfoMessage((Component)grid.getComponent(), (String)message, (String)title);
    }

    @NotNull
    public static CharOut extractSelectedValues(@NotNull DataGrid dataGrid, @NotNull DataExtractor extractor) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(36);
        }
        if (extractor == null) {
            DataGridUtil.$$$reportNull$$$0(37);
        }
        CharOut charOut = DataGridUtil.extractValues(dataGrid, extractor, CharOut.Util.newSink(), true, true);
        if (charOut == null) {
            DataGridUtil.$$$reportNull$$$0(38);
        }
        return charOut;
    }

    @NotNull
    public static CharOut extractSelectedValues(DataGrid dataGrid, DataExtractor extractor, CharOut out) {
        CharOut charOut = DataGridUtil.extractValues(dataGrid, extractor, out, true, true);
        if (charOut == null) {
            DataGridUtil.$$$reportNull$$$0(39);
        }
        return charOut;
    }

    @NotNull
    public static CharOut extractValues(@NotNull DataGrid dataGrid, @NotNull DataExtractor extractor, @NotNull CharOut out, boolean selection, boolean transpositionAllowed) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(40);
        }
        if (extractor == null) {
            DataGridUtil.$$$reportNull$$$0(41);
        }
        if (out == null) {
            DataGridUtil.$$$reportNull$$$0(42);
        }
        if (extractor instanceof TranspositionAwareDefaultExtractor) {
            boolean transposed = dataGrid.isTransposed() && transpositionAllowed;
            ((TranspositionAwareDefaultExtractor)extractor).setTransposedMode(transposed);
        }
        GridModel model = dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        int[] columns2 = (selection ? dataGrid.getSelectionModel().getSelectedColumns() : model.getColumnIndices()).asArray();
        List<DataConsumer.Row> rows = selection ? DataGridUtil.getSelectedRows(dataGrid) : model.getRows();
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(dataGrid);
        ExtractorsUtil.extract(out, dialect, false, model.getColumns(), extractor, rows, columns2);
        CharOut charOut = out;
        if (charOut == null) {
            DataGridUtil.$$$reportNull$$$0(43);
        }
        return charOut;
    }

    @NotNull
    public static List<DataConsumer.Row> getSelectedRows(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(44);
        }
        ModelIndexSet rowIndices = dataGrid.getSelectionModel().getSelectedRows();
        GridModel model = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        List<DataConsumer.Row> rows = model.getRows(rowIndices);
        List<DataConsumer.Row> list = rows.isEmpty() ? model.getRows() : rows;
        if (list == null) {
            DataGridUtil.$$$reportNull$$$0(45);
        }
        return list;
    }

    @NotNull
    public static List<CellMutation> createMutations(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns2, @Nullable Object value) {
        if (rows == null) {
            DataGridUtil.$$$reportNull$$$0(46);
        }
        if (columns2 == null) {
            DataGridUtil.$$$reportNull$$$0(47);
        }
        List<CellMutation> list = DataGridUtil.createMutations(rows, columns2, (Function<ModelIndex<DataConsumer.Row>, MutationType>)((Function)row -> MutationType.MODIFY), value);
        if (list == null) {
            DataGridUtil.$$$reportNull$$$0(48);
        }
        return list;
    }

    @NotNull
    public static List<CellMutation> createMutations(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns2, @NotNull Function<ModelIndex<DataConsumer.Row>, MutationType> mutationTypeProvider, @Nullable Object value) {
        if (rows == null) {
            DataGridUtil.$$$reportNull$$$0(49);
        }
        if (columns2 == null) {
            DataGridUtil.$$$reportNull$$$0(50);
        }
        if (mutationTypeProvider == null) {
            DataGridUtil.$$$reportNull$$$0(51);
        }
        ArrayList mutations = ContainerUtil.newArrayList();
        for (ModelIndex rowIdx : rows.asIterable()) {
            for (ModelIndex columnIdx : columns2.asIterable()) {
                mutations.add(new CellMutation(rowIdx, columnIdx, (MutationType)((Object)mutationTypeProvider.fun((Object)rowIdx)), value));
            }
        }
        ArrayList arrayList = mutations;
        if (arrayList == null) {
            DataGridUtil.$$$reportNull$$$0(52);
        }
        return arrayList;
    }

    @NotNull
    public static Domain unwrap(@NotNull Domain domain) {
        if (domain == null) {
            DataGridUtil.$$$reportNull$$$0(53);
        }
        Domain domain2 = domain instanceof DomainWrapper ? ((DomainWrapper)((Object)domain)).unwrap() : domain;
        if (domain2 == null) {
            DataGridUtil.$$$reportNull$$$0(54);
        }
        return domain2;
    }

    public static int min(@NotNull IndexSet<?> set) {
        OptionalInt min;
        if (set == null) {
            DataGridUtil.$$$reportNull$$$0(55);
        }
        return (min = set.asList().stream().mapToInt(Index::asInteger).min()).isPresent() ? min.getAsInt() : -1;
    }

    @NotNull
    public static String getRowName(@NotNull DataGrid grid, int relativeIndex) {
        GridDataHookUp dataHookup;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(56);
        }
        boolean trueRows = (dataHookup = grid.getDataHookup()) instanceof CsvDocumentDataHookUp && ((CsvDocumentDataHookUp)dataHookup).getFormat().rowNumbers;
        ModelIndex<DataConsumer.Row> rowIndex = trueRows ? ViewIndex.forRow(grid, relativeIndex).toModel(grid) : ModelIndex.forRow(grid, relativeIndex);
        DataConsumer.Row row = grid.getDataModel(DataAccessType.DATABASE_DATA).getRow(rowIndex);
        String string = row instanceof NamedRow ? ((NamedRow)row).name : String.valueOf(row == null ? "N/A" : Integer.valueOf(grid.isInsertedRow(rowIndex) ? DataGridUtil.getInsertedRowIdx(grid, relativeIndex) : row.rowNum));
        if (string == null) {
            DataGridUtil.$$$reportNull$$$0(57);
        }
        return string;
    }

    @Nullable
    public static String getResultSetName(@NotNull AnActionEvent e) {
        if (e == null) {
            DataGridUtil.$$$reportNull$$$0(58);
        }
        DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
        JdbcConsole console = JdbcConsole.findConsole(e);
        return DataGridUtil.getResultSetName(grid, console);
    }

    @Nullable
    public static String getResultSetName(@NotNull Project project, @NotNull DataGrid grid) {
        if (project == null) {
            DataGridUtil.$$$reportNull$$$0(59);
        }
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(60);
        }
        return DataGridUtil.getResultSetName(grid, DataGridUtil.findGridRelatedConsole(project, grid));
    }

    @Nullable
    public static String getResultSetName(@Nullable DataGrid grid, @Nullable JdbcConsole console) {
        DasTable table;
        DasTable dasTable = table = grid == null ? null : DataGridUtil.getDatabaseTable(grid);
        return table != null ? table.getName() : (console != null && grid != null ? DataGridUtil.getNameFromConsole(console, grid) : null);
    }

    @Nullable
    private static String getNameFromConsole(@NotNull JdbcConsole console, @NotNull DataGrid dataGrid) {
        Content content;
        if (console == null) {
            DataGridUtil.$$$reportNull$$$0(61);
        }
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(62);
        }
        return (content = console.getUi().getContentManager().getContent(dataGrid.getComponent())) == null ? null : content.getDisplayName();
    }

    private static int getInsertedRowIdx(@NotNull DataGrid grid, int relativeIndex) {
        ModelIndex<DataConsumer.Row> rowIdx;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(63);
        }
        DataConsumer.Row row = (rowIdx = DataGridUtil.getLastNotInsertedRow(grid)) == null ? null : grid.getDataModel(DataAccessType.DATABASE_DATA).getRow(rowIdx);
        int humanReadable = relativeIndex + 1;
        if (row == null) {
            return humanReadable;
        }
        int difference = relativeIndex - rowIdx.asInteger();
        return difference < 0 ? humanReadable : row.rowNum + difference;
    }

    @Nullable
    private static ModelIndex<DataConsumer.Row> getLastNotInsertedRow(@NotNull DataGrid grid) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(64);
        }
        List rows = grid.getDataModel(DataAccessType.DATABASE_DATA).getRowIndices().asList();
        for (int i2 = rows.size() - 1; i2 >= 0; --i2) {
            ModelIndex index = (ModelIndex)rows.get(i2);
            if (grid.isInsertedRow(index)) continue;
            return index;
        }
        return null;
    }

    @Nullable
    private static JdbcConsole findGridRelatedConsole(@NotNull Project project, @NotNull DataGrid grid) {
        if (project == null) {
            DataGridUtil.$$$reportNull$$$0(65);
        }
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(66);
        }
        List<JdbcConsole> consoles = JdbcConsole.getActiveConsoles(project);
        for (JdbcConsole console : consoles) {
            Content content = console.getUi().getContentManager().getContent(grid.getComponent());
            if (content == null) continue;
            return console;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 30: 
            case 38: 
            case 39: 
            case 43: 
            case 45: 
            case 48: 
            case 52: 
            case 54: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 30: 
            case 38: 
            case 39: 
            case 43: 
            case 45: 
            case 48: 
            case 52: 
            case 54: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHookUp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupActions";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 30: 
            case 38: 
            case 39: 
            case 43: 
            case 45: 
            case 48: 
            case 52: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DataGridUtil";
                break;
            }
            case 6: 
            case 20: 
            case 36: 
            case 40: 
            case 44: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 33: 
            case 34: 
            case 35: 
            case 56: 
            case 60: 
            case 63: 
            case 64: 
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutationTypeProvider";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DataGridUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataGrid";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findColumn";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeAll";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "extractSelectedValues";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "extractValues";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRows";
                break;
            }
            case 48: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createMutations";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDataGrid";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 30: 
            case 38: 
            case 39: 
            case 43: 
            case 45: 
            case 48: 
            case 52: 
            case 54: 
            case 57: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPreviewDataGrid";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findColumn";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSqlType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setupProgressIndicatingAuditor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setProgressMessage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentDataHookUp";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addGridHeaderComponent";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "configureNumericEditor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "canBuildWhereClause";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createEDTSafeWrapper";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultNullValue";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "mergeAll";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getProject";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "showIgnoreUnsubmittedChangesYesNoDialog";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "showCannotApplyCellEditorChanges";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "extractSelectedValues";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "extractValues";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRows";
                break;
            }
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createMutations";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "min";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getRowName";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getResultSetName";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromConsole";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getInsertedRowIdx";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getLastNotInsertedRow";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "findGridRelatedConsole";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setProgressMessage$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 30: 
            case 38: 
            case 39: 
            case 43: 
            case 45: 
            case 48: 
            case 52: 
            case 54: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

