/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.script.SqlReader;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDocumentDataHookUp
extends DocumentDataHookUp {
    private static final String COMMA = ",";
    private static final String SEMICOLON = ";";
    private final SqlReader myReader;
    private final SqlLanguageDialect myDialect;

    public SqlDocumentDataHookUp(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull Document document, @Nullable TextRange range) {
        if (project == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(0);
        }
        if (dialect == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(1);
        }
        if (document == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(2);
        }
        super(project, document, range);
        this.myReader = SqlPsiFacade.getInstance((Project)project).createSqlReader();
        this.myDialect = dialect;
    }

    @Override
    @Nullable
    protected SqlInsertsMarkup buildMarkup(@NotNull CharSequence sequence, @Nullable GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
        if (sequence == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(3);
        }
        return SqlDocumentDataHookUp.buildMarkup(sequence, this.myReader, this.myDialect);
    }

    @Nullable
    static SqlInsertsMarkup buildMarkup(@NotNull CharSequence sequence, @NotNull SqlReader reader, @NotNull SqlLanguageDialect dialect) {
        Ref insertTargetRef;
        JBIterable inserts;
        List blocks;
        if (sequence == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(4);
        }
        if (reader == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(5);
        }
        if (dialect == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(6);
        }
        return ContainerUtil.isEmpty((Collection)(blocks = ContainerUtil.mapNotNull((Iterable)(inserts = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)reader.getReadOnlyPsi(dialect, sequence))).forceDisregardTypes(Conditions.is((Object)GeneratedParserUtilBase.DUMMY_BLOCK)).expandAndSkip(Conditions.instanceOf(SqlBatchBlock.class))).filter(SqlInsertStatement.class)), arg_0 -> SqlDocumentDataHookUp.lambda$buildMarkup$0(dialect, insertTargetRef = Ref.create(), arg_0)))) ? null : new SqlInsertsMarkup(sequence, blocks, (InsertTarget)insertTargetRef.get());
    }

    @Nullable
    private static Block parseBlock(@NotNull SqlInsertStatement insertStatement, @NotNull SqlLanguageDialect dialect, @NotNull Ref<InsertTarget> insertTargetRef) {
        if (insertStatement == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(7);
        }
        if (dialect == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(8);
        }
        if (insertTargetRef == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(9);
        }
        return SqlDocumentDataHookUp.isOracleInsertAllStatement(insertStatement, dialect) ? SqlDocumentDataHookUp.parseMultiTableInsertBlock(insertStatement, insertTargetRef) : SqlDocumentDataHookUp.parseInsertBlock(insertStatement, insertTargetRef);
    }

    private static boolean isOracleInsertAllStatement(@NotNull SqlInsertStatement statement, @NotNull SqlLanguageDialect dialect) {
        if (statement == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(10);
        }
        if (dialect == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(11);
        }
        return dialect.getDatabaseDialect().getFamilyId().isOracle() && statement.getNode().findChildByType((IElementType)SqlCommonKeywords.SQL_ALL) != null;
    }

    @Nullable
    private static Block parseMultiTableInsertBlock(@NotNull SqlInsertStatement insertStatement, @NotNull Ref<InsertTarget> insertTargetRef) {
        if (insertStatement == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(12);
        }
        if (insertTargetRef == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(13);
        }
        List instructions = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)insertStatement, SqlDmlInstruction.class);
        List insertBlocks = ContainerUtil.mapNotNull((Collection)instructions, instruction -> {
            if (insertTargetRef == null) {
                SqlDocumentDataHookUp.$$$reportNull$$$0(26);
            }
            return SqlDocumentDataHookUp.parseInsertBlock(instruction, insertTargetRef, null, null);
        });
        TextRange separatorRange = SqlDocumentDataHookUp.getFollowingSeparatorRange((PsiElement)insertStatement, SEMICOLON);
        return insertBlocks.isEmpty() ? null : new MultiTableInsertBlock(insertStatement.getTextRange(), insertBlocks, separatorRange, instructions.size());
    }

    @Nullable
    private static InsertBlock parseInsertBlock(@NotNull SqlInsertStatement insertStatement, @NotNull Ref<InsertTarget> insertTargetRef) {
        if (insertStatement == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(14);
        }
        if (insertTargetRef == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(15);
        }
        SqlDmlInstruction dmlInstruction = (SqlDmlInstruction)PsiTreeUtil.getChildOfType((PsiElement)insertStatement, SqlDmlInstruction.class);
        TextRange separatorRange = SqlDocumentDataHookUp.getFollowingSeparatorRange((PsiElement)insertStatement, SEMICOLON);
        return dmlInstruction == null ? null : SqlDocumentDataHookUp.parseInsertBlock(dmlInstruction, insertTargetRef, insertStatement.getTextRange(), separatorRange);
    }

    @Nullable
    private static InsertBlock parseInsertBlock(@NotNull SqlDmlInstruction instruction, @NotNull Ref<InsertTarget> insertTargetRef, @Nullable TextRange insertStatementRange, @Nullable TextRange separatorRange) {
        SqlTableColumnsList columnsList;
        if (instruction == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(16);
        }
        if (insertTargetRef == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(17);
        }
        if ((columnsList = (SqlTableColumnsList)PsiTreeUtil.getChildOfType((PsiElement)instruction, SqlTableColumnsList.class)) == null || !insertTargetRef.isNull() && !((InsertTarget)insertTargetRef.get()).matches(columnsList)) {
            return null;
        }
        List<TextRange> columns2 = SqlDocumentDataHookUp.parseColumns(columnsList);
        List valuesBlocks = SqlDocumentDataHookUp.parseValuesBlocks(instruction, (InsertTarget)insertTargetRef.get());
        if (valuesBlocks.isEmpty()) {
            return null;
        }
        if (insertTargetRef.isNull()) {
            int columnCount = columns2 != null ? columns2.size() : valuesBlocks.get((int)0).values.size();
            insertTargetRef.set((Object)InsertTarget.create(columnsList, columnCount));
            if (insertTargetRef.isNull()) {
                return null;
            }
            valuesBlocks = ContainerUtil.filter(valuesBlocks, block -> block.values.size() == columnCount);
        }
        TextRange range = insertStatementRange != null ? insertStatementRange : instruction.getTextRange();
        return new InsertBlock(range, valuesBlocks, columns2, separatorRange);
    }

    @Nullable
    private static List<TextRange> parseColumns(@Nullable SqlTableColumnsList columnsList) {
        SqlReferenceList referenceList = columnsList != null ? columnsList.getColumnsReferenceList() : null;
        return referenceList == null ? null : ContainerUtil.map((Collection)referenceList.getReferenceList(), columnRef -> columnRef.getTextRange());
    }

    @NotNull
    private static List<ValuesBlock> parseValuesBlocks(@NotNull SqlDmlInstruction instruction, @Nullable InsertTarget insertTarget) {
        SqlValuesExpression valuesExpression;
        if (instruction == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(18);
        }
        if ((valuesExpression = (SqlValuesExpression)PsiTreeUtil.getChildOfType((PsiElement)instruction, SqlValuesExpression.class)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlDocumentDataHookUp.$$$reportNull$$$0(19);
            }
            return list;
        }
        List valuesBlocks = ContainerUtil.newSmartList();
        for (SqlExpression expression : valuesExpression.getExpressions()) {
            ContainerUtil.addIfNotNull((Collection)valuesBlocks, (Object)SqlDocumentDataHookUp.parseValuesBlock(expression, insertTarget));
        }
        List list = valuesBlocks;
        if (list == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(20);
        }
        return list;
    }

    @Nullable
    private static ValuesBlock parseValuesBlock(@NotNull SqlExpression expression, @Nullable InsertTarget insertTarget) {
        SqlParenthesizedExpression tuple;
        if (expression == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(21);
        }
        if ((tuple = (SqlParenthesizedExpression)ObjectUtils.tryCast((Object)expression, SqlParenthesizedExpression.class)) == null || insertTarget != null && !insertTarget.matches(tuple)) {
            return null;
        }
        TextRange range = expression.getTextRange();
        List valueRanges = ContainerUtil.map((Collection)tuple.getExpressionList(), expression1 -> expression1.getTextRange());
        return new ValuesBlock(range, valueRanges, SqlDocumentDataHookUp.getFollowingSeparatorRange((PsiElement)expression, COMMA));
    }

    @Nullable
    private static TextRange getFollowingSeparatorRange(@NotNull PsiElement element, @NotNull String separatorText) {
        PsiElement separator;
        if (element == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(22);
        }
        if (separatorText == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(23);
        }
        return (separator = SqlDocumentDataHookUp.getFollowingSeparator(element, separatorText)) != null ? separator.getTextRange() : null;
    }

    @Nullable
    private static PsiElement getFollowingSeparator(@NotNull PsiElement element, @NotNull String separatorText) {
        PsiElement separator;
        if (element == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(24);
        }
        if (separatorText == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(25);
        }
        return (separator = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element)) != null && separatorText.equals(separator.getText()) ? separator : null;
    }

    private static /* synthetic */ Block lambda$buildMarkup$0(@NotNull SqlLanguageDialect dialect, Ref insertTargetRef, SqlInsertStatement insertStatement) {
        if (dialect == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(27);
        }
        return SqlDocumentDataHookUp.parseBlock(insertStatement, dialect, (Ref<InsertTarget>)insertTargetRef);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 7: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertStatement";
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertTargetRef";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/SqlDocumentDataHookUp";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separatorText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "parseValuesBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildMarkup";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseBlock";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isOracleInsertAllStatement";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseMultiTableInsertBlock";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseInsertBlock";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseValuesBlocks";
                break;
            }
            case 19: 
            case 20: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseValuesBlock";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFollowingSeparatorRange";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFollowingSeparator";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$parseMultiTableInsertBlock$1";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildMarkup$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InsertTarget {
        private final String myTableIdentity;
        private final List<String> myColumnIdentities;
        private final int myColumnCount;

        private InsertTarget(@NotNull String tableIdentity, @Nullable List<String> columnIdentities, int count2) {
            if (tableIdentity == null) {
                InsertTarget.$$$reportNull$$$0(0);
            }
            this.myTableIdentity = tableIdentity;
            this.myColumnIdentities = columnIdentities;
            this.myColumnCount = count2;
        }

        public boolean matches(@Nullable SqlTableColumnsList tableColumnsList) {
            return tableColumnsList != null && this.myTableIdentity.equals(InsertTarget.getTableIdentity(tableColumnsList)) && Comparing.equal(this.myColumnIdentities, InsertTarget.getColumnIdentities(tableColumnsList));
        }

        public boolean matches(@Nullable SqlParenthesizedExpression valuesTuple) {
            return valuesTuple != null && valuesTuple.getExpressionList().size() == this.myColumnCount;
        }

        @NotNull
        public String getTableRefText() {
            String string = this.myTableIdentity;
            if (string == null) {
                InsertTarget.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isColumnListPresent() {
            return this.myColumnIdentities != null;
        }

        @Nullable
        public static InsertTarget create(@Nullable SqlTableColumnsList tableColumnsList, int columnCount) {
            if (tableColumnsList == null) {
                return null;
            }
            String tableIdentity = InsertTarget.getTableIdentity(tableColumnsList);
            if (tableIdentity == null) {
                return null;
            }
            List<String> columnIdentities = InsertTarget.getColumnIdentities(tableColumnsList);
            return columnIdentities != null && columnIdentities.size() != columnCount ? null : new InsertTarget(tableIdentity, columnIdentities, columnCount);
        }

        @Nullable
        private static List<String> getColumnIdentities(@NotNull SqlTableColumnsList tableColumnsList) {
            SqlReferenceList columnRefs;
            if (tableColumnsList == null) {
                InsertTarget.$$$reportNull$$$0(2);
            }
            return (columnRefs = tableColumnsList.getColumnsReferenceList()) == null ? null : ContainerUtil.map((Collection)columnRefs.getReferenceList(), expression -> expression.getText());
        }

        @Nullable
        private static String getTableIdentity(@NotNull SqlTableColumnsList tableColumnsList) {
            SqlReferenceExpression tableReference;
            if (tableColumnsList == null) {
                InsertTarget.$$$reportNull$$$0(3);
            }
            return (tableReference = tableColumnsList.getTableReference()) != null ? tableReference.getText() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableIdentity";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$InsertTarget";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableColumnsList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$InsertTarget";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTableRefText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumnIdentities";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getTableIdentity";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class RecursiveBlockVisitor {
        RecursiveBlockVisitor() {
        }

        protected boolean visitBlock(@NotNull Block block) {
            if (block == null) {
                RecursiveBlockVisitor.$$$reportNull$$$0(0);
            }
            return true;
        }

        protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
            if (block == null) {
                RecursiveBlockVisitor.$$$reportNull$$$0(1);
            }
            return true;
        }

        protected boolean visitInsertBlock(@NotNull InsertBlock block) {
            if (block == null) {
                RecursiveBlockVisitor.$$$reportNull$$$0(2);
            }
            return this.visitBlocks(block.valuesBlocks);
        }

        protected boolean visitInsertAllBlock(@NotNull MultiTableInsertBlock block) {
            if (block == null) {
                RecursiveBlockVisitor.$$$reportNull$$$0(3);
            }
            return this.visitBlocks(block.insertBlocks);
        }

        public boolean visitBlocks(@NotNull Iterable<? extends Block> blocks) {
            if (blocks == null) {
                RecursiveBlockVisitor.$$$reportNull$$$0(4);
            }
            for (Block block : blocks) {
                if (block.accept(this)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blocks";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$RecursiveBlockVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBlock";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitValuesBlock";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInsertBlock";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInsertAllBlock";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBlocks";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class MultiTableInsertBlock
    extends Block {
        public final List<InsertBlock> insertBlocks;
        public final int totalInsertBlocksCount;

        MultiTableInsertBlock(@NotNull TextRange range, @NotNull List<InsertBlock> insertBlocks, @Nullable TextRange separatorRange, int totalInsertBlocksCount) {
            if (range == null) {
                MultiTableInsertBlock.$$$reportNull$$$0(0);
            }
            if (insertBlocks == null) {
                MultiTableInsertBlock.$$$reportNull$$$0(1);
            }
            super(range, separatorRange);
            this.insertBlocks = insertBlocks;
            this.totalInsertBlocksCount = totalInsertBlocksCount;
        }

        @Override
        public boolean accept(@NotNull RecursiveBlockVisitor visitor) {
            if (visitor == null) {
                MultiTableInsertBlock.$$$reportNull$$$0(2);
            }
            return visitor.visitInsertAllBlock(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insertBlocks";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$MultiTableInsertBlock";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class InsertBlock
    extends Block {
        public final List<ValuesBlock> valuesBlocks;
        public final List<TextRange> columns;

        InsertBlock(@NotNull TextRange range, @NotNull List<ValuesBlock> blocks, @Nullable List<TextRange> columns2, @Nullable TextRange separatorRange) {
            if (range == null) {
                InsertBlock.$$$reportNull$$$0(0);
            }
            if (blocks == null) {
                InsertBlock.$$$reportNull$$$0(1);
            }
            super(range, separatorRange);
            this.columns = columns2;
            this.valuesBlocks = blocks;
        }

        @Override
        public boolean accept(@NotNull RecursiveBlockVisitor visitor) {
            if (visitor == null) {
                InsertBlock.$$$reportNull$$$0(2);
            }
            return visitor.visitInsertBlock(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blocks";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$InsertBlock";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ValuesBlock
    extends Block {
        public final List<TextRange> values;

        ValuesBlock(@NotNull TextRange range, @NotNull List<TextRange> values2, @Nullable TextRange separatorRange) {
            if (range == null) {
                ValuesBlock.$$$reportNull$$$0(0);
            }
            if (values2 == null) {
                ValuesBlock.$$$reportNull$$$0(1);
            }
            super(range, separatorRange);
            this.values = values2;
        }

        @Override
        public boolean accept(@NotNull RecursiveBlockVisitor visitor) {
            if (visitor == null) {
                ValuesBlock.$$$reportNull$$$0(2);
            }
            return visitor.visitValuesBlock(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$ValuesBlock";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class Block {
        public final TextRange range;
        public final TextRange separatorRange;

        Block(@NotNull TextRange range, @Nullable TextRange separatorRange) {
            if (range == null) {
                Block.$$$reportNull$$$0(0);
            }
            this.range = range;
            this.separatorRange = separatorRange;
        }

        public boolean accept(@NotNull RecursiveBlockVisitor visitor) {
            if (visitor == null) {
                Block.$$$reportNull$$$0(1);
            }
            return visitor.visitBlock(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$Block";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class SqlInsertsMarkup
    extends DocumentDataHookUp.DataMarkup {
        public final InsertTarget insertTarget;
        public final List<Block> blocks;

        public SqlInsertsMarkup(@NotNull CharSequence sequence, @NotNull List<Block> blocks, @NotNull InsertTarget insertTarget) {
            if (sequence == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(0);
            }
            if (blocks == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(1);
            }
            if (insertTarget == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(2);
            }
            super(SqlInsertsMarkup.columnsFromBlocks(sequence, blocks), SqlInsertsMarkup.rowsFromBlocks(sequence, blocks));
            this.blocks = blocks;
            this.insertTarget = insertTarget;
        }

        @Override
        protected boolean deleteRows(final @NotNull DocumentDataHookUp.UpdateSession session, final @NotNull List<DataConsumer.Row> sortedRows) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(3);
            }
            if (sortedRows == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(4);
            }
            new RecursiveBlockVisitor(){
                private int myRowIndex;
                private int myValuesTupleIdx;

                @Override
                protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
                    if (block == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ++this.myValuesTupleIdx;
                    return true;
                }

                @Override
                protected boolean visitInsertBlock(@NotNull InsertBlock block) {
                    List<ValuesBlock> tuples;
                    if (block == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (this.shouldDeleteNextValuesTuples((tuples = block.valuesBlocks).size())) {
                        return this.deleteBlockAndAdvance(block, tuples.size());
                    }
                    int leftToDeleteInThisBlock = 0;
                    for (int rowIdx = this.myRowIndex; rowIdx < sortedRows.size(); ++rowIdx) {
                        DataConsumer.Row row = (DataConsumer.Row)sortedRows.get(rowIdx);
                        int blockIdx = row.rowNum - 1;
                        if (blockIdx >= this.myValuesTupleIdx + tuples.size()) break;
                        ++leftToDeleteInThisBlock;
                    }
                    for (int tupleIdx = 0; tupleIdx < tuples.size() && leftToDeleteInThisBlock > 0; ++tupleIdx) {
                        boolean deleteAllSubsequentTuples;
                        ValuesBlock currentTuple = tuples.get(tupleIdx);
                        int nextTupleIdxToDelete = ((DataConsumer.Row)sortedRows.get((int)this.myRowIndex)).rowNum - 1 - this.myValuesTupleIdx;
                        if (tupleIdx == nextTupleIdxToDelete) {
                            this.deleteBlockAndAdvance(currentTuple, 1);
                            --leftToDeleteInThisBlock;
                            continue;
                        }
                        boolean bl = deleteAllSubsequentTuples = leftToDeleteInThisBlock == tuples.size() - tupleIdx - 1 && tupleIdx + 1 == nextTupleIdxToDelete;
                        if (deleteAllSubsequentTuples) {
                            ValuesBlock lastTuple = tuples.get(tuples.size() - 1);
                            int startOffset = currentTuple.separatorRange != null ? currentTuple.separatorRange.getStartOffset() : tuples.get((int)nextTupleIdxToDelete).range.getStartOffset();
                            int endOffset = lastTuple.separatorRange != null ? lastTuple.separatorRange.getEndOffset() : lastTuple.range.getEndOffset();
                            session.delete(SqlInsertsMarkup.includeWhitespaceUpToNextLine(session, TextRange.create((int)startOffset, (int)endOffset)));
                            this.myRowIndex += leftToDeleteInThisBlock;
                            this.myValuesTupleIdx += leftToDeleteInThisBlock;
                            break;
                        }
                        ++this.myValuesTupleIdx;
                    }
                    return super.visitInsertBlock(block);
                }

                @Override
                protected boolean visitInsertAllBlock(@NotNull MultiTableInsertBlock block) {
                    int intoBlocksCount;
                    if (block == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return block.totalInsertBlocksCount == (intoBlocksCount = block.insertBlocks.size()) && this.shouldDeleteNextValuesTuples(intoBlocksCount) ? this.deleteBlockAndAdvance(block, intoBlocksCount) : super.visitInsertAllBlock(block);
                }

                private boolean shouldDeleteNextValuesTuples(int count2) {
                    int currentRowNum;
                    int previousRowNum;
                    int nextValuesBlockIndex = ((DataConsumer.Row)sortedRows.get((int)this.myRowIndex)).rowNum - 1;
                    if (nextValuesBlockIndex != this.myValuesTupleIdx) {
                        return false;
                    }
                    int consecutiveRowsToDelete = 1;
                    for (int rowIdx = this.myRowIndex + 1; rowIdx < sortedRows.size() && consecutiveRowsToDelete != count2 && (previousRowNum = ((DataConsumer.Row)sortedRows.get((int)(rowIdx - 1))).rowNum) == (currentRowNum = ((DataConsumer.Row)sortedRows.get((int)rowIdx)).rowNum) - 1; ++consecutiveRowsToDelete, ++rowIdx) {
                    }
                    return count2 == consecutiveRowsToDelete;
                }

                private boolean deleteBlockAndAdvance(@NotNull Block block, int rows) {
                    if (block == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    TextRange range = block.separatorRange != null ? block.range.union(block.separatorRange) : block.range;
                    session.delete(SqlInsertsMarkup.includeWhitespaceUpToNextLine(session, range));
                    this.myRowIndex += rows;
                    this.myValuesTupleIdx += rows;
                    return this.myRowIndex < sortedRows.size();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "block";
                    objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitValuesBlock";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitInsertBlock";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitInsertAllBlock";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "deleteBlockAndAdvance";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.visitBlocks(this.blocks);
            return false;
        }

        @Override
        protected boolean insertRow(@NotNull DocumentDataHookUp.UpdateSession session) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(5);
            }
            this.insertRow(session, JBIterable.of((Object)"NULL").repeat(this.columns.size()).toList());
            return true;
        }

        @Override
        protected boolean cloneRow(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull DataConsumer.Row row) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(6);
            }
            if (row == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(7);
            }
            this.insertRow(session, ContainerUtil.map((Object[])row.values, (Function)Functions.TO_STRING()));
            return true;
        }

        @Override
        protected boolean deleteColumns(final @NotNull DocumentDataHookUp.UpdateSession session, final @NotNull List<DataConsumer.Column> sortedColumns) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(8);
            }
            if (sortedColumns == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(9);
            }
            if (sortedColumns.size() == this.columns.size()) {
                for (Block block : this.blocks) {
                    TextRange range = block.separatorRange != null ? block.range.union(block.separatorRange) : block.range;
                    session.delete(SqlInsertsMarkup.includeWhitespaceUpToNextLine(session, range));
                }
                return true;
            }
            new RecursiveBlockVisitor(){
                private final int myLastColumnToLeaveIdx;
                {
                    int columnCount = columns.size();
                    int tailColumnsToDelete = 0;
                    for (int i2 = 0; i2 < sortedColumns.size() && ((DataConsumer.Column)sortedColumns.get((int)(sortedColumns.size() - i2 - 1))).columnNum == columnCount - i2 - 1; ++i2) {
                        ++tailColumnsToDelete;
                    }
                    this.myLastColumnToLeaveIdx = columnCount - tailColumnsToDelete - 1;
                }

                @Override
                protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
                    if (block == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    this.deleteColumns(block.values);
                    return true;
                }

                @Override
                protected boolean visitInsertBlock(@NotNull InsertBlock block) {
                    if (block == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    this.deleteColumns(block.columns);
                    return super.visitInsertBlock(block);
                }

                private void deleteColumns(@NotNull List<TextRange> values2) {
                    JBIterator columnToDeleteIt;
                    if (values2 == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (!(columnToDeleteIt = JBIterator.from(sortedColumns.iterator())).advance()) {
                        return;
                    }
                    for (int valueIdx = 0; valueIdx < values2.size(); ++valueIdx) {
                        int endOffset;
                        int startOffset;
                        TextRange valueRange = values2.get(valueIdx);
                        if (valueIdx == this.myLastColumnToLeaveIdx) {
                            startOffset = valueRange.getEndOffset();
                            endOffset = values2.get(values2.size() - 1).getEndOffset();
                            session.delete(SqlInsertsMarkup.includeWhitespaceUpToNextLine(session, TextRange.create((int)startOffset, (int)endOffset)));
                            break;
                        }
                        if (valueIdx != ((DataConsumer.Column)columnToDeleteIt.current()).columnNum) continue;
                        startOffset = valueRange.getStartOffset();
                        endOffset = valueIdx + 1 < values2.size() ? values2.get(valueIdx + 1).getStartOffset() : valueRange.getEndOffset();
                        session.delete(SqlInsertsMarkup.includeWhitespaceUpToNextLine(session, TextRange.create((int)startOffset, (int)endOffset)));
                        if (!columnToDeleteIt.advance()) break;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "block";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "values";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitValuesBlock";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitInsertBlock";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "deleteColumns";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.visitBlocks(this.blocks);
            return true;
        }

        @Override
        protected boolean insertColumn(@NotNull DocumentDataHookUp.UpdateSession session) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(10);
            }
            this.insertColumn(session, null);
            return true;
        }

        @Override
        protected boolean cloneColumn(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull DataConsumer.Column column2) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(11);
            }
            if (column2 == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(12);
            }
            this.insertColumn(session, column2);
            return true;
        }

        @Override
        protected boolean update(final @NotNull DocumentDataHookUp.UpdateSession session, final @NotNull List<RowMutation> infos) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(13);
            }
            if (infos == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(14);
            }
            new RecursiveBlockVisitor(){
                private int myRowToUpdateIdx = 0;
                private int myCurrentRowNum = 0;

                @Override
                protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
                    if (block == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ++this.myCurrentRowNum;
                    RowMutation rowInfo = (RowMutation)infos.get(this.myRowToUpdateIdx);
                    DataConsumer.Row rowToUpdate = rowInfo.getRow();
                    if (rowToUpdate.rowNum == this.myCurrentRowNum) {
                        List<TextRange> valueRanges = block.values;
                        for (ColumnQueryData info : rowInfo.getData()) {
                            DataConsumer.Column column2 = info.getColumn();
                            Object newValue = info.getObject();
                            String valueText = newValue == null ? "NULL" : String.valueOf(newValue);
                            session.replace(valueRanges.get(column2.columnNum), valueText);
                        }
                        ++this.myRowToUpdateIdx;
                    }
                    return this.myRowToUpdateIdx < infos.size();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$3", "visitValuesBlock"));
                }
            }.visitBlocks(this.blocks);
            return true;
        }

        private void insertRow(final @NotNull DocumentDataHookUp.UpdateSession session, final @NotNull List<String> values2) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(15);
            }
            if (values2 == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(16);
            }
            ((Block)ObjectUtils.assertNotNull((Object)ContainerUtil.getLastItem(this.blocks))).accept(new RecursiveBlockVisitor(){

                @Override
                protected boolean visitInsertAllBlock(@NotNull MultiTableInsertBlock block) {
                    if (block == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    List<InsertBlock> insertBlocks = block.insertBlocks;
                    InsertBlock lastInsertBlock = (InsertBlock)ObjectUtils.assertNotNull((Object)ContainerUtil.getLastItem(insertBlocks));
                    int offset = lastInsertBlock.range.getEndOffset();
                    String intoText = this.appendIntoDmlInstruction(new StringBuilder().append("\n"), values2).toString();
                    session.insert(intoText, offset);
                    return false;
                }

                @Override
                protected boolean visitInsertBlock(@NotNull InsertBlock block) {
                    List<ValuesBlock> valuesBlocks;
                    if (block == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    if ((valuesBlocks = block.valuesBlocks).size() == 1) {
                        this.insertInsertStatement(block);
                    } else {
                        this.insertValuesTuple((ValuesBlock)ObjectUtils.assertNotNull((Object)ContainerUtil.getLastItem(valuesBlocks)));
                    }
                    return false;
                }

                private void insertValuesTuple(@NotNull ValuesBlock nextTo) {
                    if (nextTo == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    TextRange separatorRange = nextTo.separatorRange;
                    StringBuilder sb = new StringBuilder();
                    sb.append(separatorRange == null ? SqlDocumentDataHookUp.COMMA : "").append(" ");
                    String valuesTuple = SqlInsertsMarkup.appendValuesTuple(sb, values2).toString();
                    int offset = separatorRange != null ? separatorRange.getEndOffset() : nextTo.range.getEndOffset();
                    session.insert(valuesTuple, offset);
                }

                private void insertInsertStatement(@NotNull InsertBlock nextTo) {
                    if (nextTo == null) {
                        4.$$$reportNull$$$0(3);
                    }
                    TextRange separatorRange = nextTo.separatorRange;
                    StringBuilder sb = new StringBuilder();
                    sb.append(separatorRange == null ? SqlDocumentDataHookUp.SEMICOLON : "").append("\n");
                    String insertStatement = this.appendIntoDmlInstruction(sb.append("INSERT "), values2).toString();
                    int offset = separatorRange != null ? separatorRange.getEndOffset() : nextTo.range.getEndOffset();
                    session.insert(insertStatement, offset);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "block";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "nextTo";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitInsertAllBlock";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitInsertBlock";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "insertValuesTuple";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "insertInsertStatement";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private void insertColumn(final @NotNull DocumentDataHookUp.UpdateSession session, final @Nullable DataConsumer.Column columnToClone) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(17);
            }
            new RecursiveBlockVisitor(){
                private int myRowIndex = 0;

                @Override
                protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
                    if (block == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    int offset = ((TextRange)ObjectUtils.assertNotNull((Object)ContainerUtil.getLastItem(block.values))).getEndOffset();
                    String value = columnToClone != null ? String.valueOf(columnToClone.getValue((DataConsumer.Row)rows.get(this.myRowIndex))) : "NULL";
                    session.insert(", " + value, offset);
                    ++this.myRowIndex;
                    return true;
                }

                @Override
                protected boolean visitInsertBlock(@NotNull InsertBlock block) {
                    TextRange lastColumn;
                    if (block == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    if ((lastColumn = (TextRange)ContainerUtil.getLastItem(block.columns)) != null) {
                        int offset = lastColumn.getEndOffset();
                        session.insert(", column" + (columns.size() + 1), offset);
                    }
                    return super.visitInsertBlock(block);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "block";
                    objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$5";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitValuesBlock";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitInsertBlock";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.visitBlocks(this.blocks);
        }

        @NotNull
        private StringBuilder appendIntoDmlInstruction(@NotNull StringBuilder sb, @NotNull List<String> values2) {
            if (sb == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(18);
            }
            if (values2 == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(19);
            }
            String comma = ", ";
            sb.append("INTO ").append(this.insertTarget.getTableRefText());
            if (this.insertTarget.isColumnListPresent()) {
                sb.append("(");
                for (DataConsumer.Column column2 : this.columns) {
                    sb.append(column2.name).append(comma);
                }
                sb.setLength(sb.length() - comma.length());
                sb.append(")");
            }
            sb.append(" VALUES ");
            StringBuilder stringBuilder = SqlInsertsMarkup.appendValuesTuple(sb, values2);
            if (stringBuilder == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(20);
            }
            return stringBuilder;
        }

        @NotNull
        private static StringBuilder appendValuesTuple(@NotNull StringBuilder sb, @NotNull List<String> values2) {
            if (sb == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(21);
            }
            if (values2 == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(22);
            }
            sb.append("(");
            String comma = ", ";
            for (String value : values2) {
                sb.append(value).append(comma);
            }
            sb.setLength(sb.length() - comma.length());
            sb.append(")");
            StringBuilder stringBuilder = sb;
            if (stringBuilder == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(23);
            }
            return stringBuilder;
        }

        @NotNull
        private static List<DataConsumer.Column> columnsFromBlocks(@NotNull CharSequence sequence, @NotNull List<Block> blocks) {
            if (sequence == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(24);
            }
            if (blocks == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(25);
            }
            final Ref columnRanges = Ref.create();
            new RecursiveBlockVisitor(){

                @Override
                protected boolean visitInsertBlock(@NotNull InsertBlock block) {
                    if (block == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    if (block.columns != null) {
                        columnRanges.set(block.columns);
                        return false;
                    }
                    return super.visitInsertBlock(block);
                }

                @Override
                protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
                    if (block == null) {
                        6.$$$reportNull$$$0(1);
                    }
                    columnRanges.set(block.values);
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "block";
                    objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$6";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitInsertBlock";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitValuesBlock";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.visitBlocks(blocks);
            List ranges = (List)ObjectUtils.assertNotNull((Object)columnRanges.get());
            ArrayList columns2 = ContainerUtil.newArrayListWithCapacity((int)ranges.size());
            for (int i2 = 0; i2 < ranges.size(); ++i2) {
                String columnName = ((TextRange)ranges.get(i2)).subSequence(sequence).toString();
                columns2.add(new DataConsumer.Column(i2, columnName, 239, "String", "java.lang.String"));
            }
            ArrayList arrayList = columns2;
            if (arrayList == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(26);
            }
            return arrayList;
        }

        @NotNull
        private static List<DataConsumer.Row> rowsFromBlocks(final @NotNull CharSequence sequence, @NotNull List<Block> blocks) {
            if (sequence == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(27);
            }
            if (blocks == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(28);
            }
            final ArrayList rows = ContainerUtil.newArrayList();
            new RecursiveBlockVisitor(){

                @Override
                protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
                    if (block == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    List<TextRange> valueRanges = block.values;
                    Object[] values2 = new Object[valueRanges.size()];
                    for (int i2 = 0; i2 < values2.length; ++i2) {
                        values2[i2] = valueRanges.get(i2).subSequence(sequence).toString();
                    }
                    rows.add(DataConsumer.Row.create(rows.size(), values2));
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$7", "visitValuesBlock"));
                }
            }.visitBlocks(blocks);
            ArrayList arrayList = rows;
            if (arrayList == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(29);
            }
            return arrayList;
        }

        @NotNull
        private static TextRange includeWhitespaceUpToNextLine(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull TextRange range) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(30);
            }
            if (range == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(31);
            }
            int endOffset = range.getEndOffset();
            while (session.isValidOffset(endOffset) && Character.isWhitespace(session.charAt(endOffset)) && session.isValidOffset(++endOffset) && session.charAt(endOffset) != '\n') {
            }
            TextRange textRange = range.getEndOffset() == endOffset ? range : TextRange.create((int)range.getStartOffset(), (int)endOffset);
            if (textRange == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(32);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 20: 
                case 23: 
                case 26: 
                case 29: 
                case 32: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 20: 
                case 23: 
                case 26: 
                case 29: 
                case 32: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sequence";
                    break;
                }
                case 1: 
                case 25: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blocks";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insertTarget";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 13: 
                case 15: 
                case 17: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sortedRows";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sortedColumns";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 16: 
                case 19: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 18: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 20: 
                case 23: 
                case 26: 
                case 29: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup";
                    break;
                }
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appendIntoDmlInstruction";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appendValuesTuple";
                    break;
                }
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[1] = "columnsFromBlocks";
                    break;
                }
                case 29: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rowsFromBlocks";
                    break;
                }
                case 32: {
                    objectArray = objectArray2;
                    objectArray2[1] = "includeWhitespaceUpToNextLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteRows";
                    break;
                }
                case 5: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "insertRow";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneRow";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteColumns";
                    break;
                }
                case 10: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "insertColumn";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneColumn";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "appendIntoDmlInstruction";
                    break;
                }
                case 20: 
                case 23: 
                case 26: 
                case 29: 
                case 32: {
                    break;
                }
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "appendValuesTuple";
                    break;
                }
                case 24: 
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "columnsFromBlocks";
                    break;
                }
                case 27: 
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "rowsFromBlocks";
                    break;
                }
                case 30: 
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "includeWhitespaceUpToNextLine";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 20: 
                case 23: 
                case 26: 
                case 29: 
                case 32: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

