/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.diff.Migrator;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.ide.diff.AsyncDiffElement;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class DbDiffElement
extends DiffElement<DasObject>
implements AsyncDiffElement {
    public static final String IGNORE_ORDER = "IGNORE_ORDER";
    public static final String IGNORE_CASE = "IGNORE_CASE";
    private final DbDataSource myDataSource;
    private final DasObject myElement;
    private DirDiffSettings mySettings;

    public DbDiffElement(@NotNull DbDataSource dataSource, @NotNull DasObject element) {
        if (dataSource == null) {
            DbDiffElement.$$$reportNull$$$0(0);
        }
        if (element == null) {
            DbDiffElement.$$$reportNull$$$0(1);
        }
        this.myDataSource = dataSource;
        this.myElement = element;
    }

    @NotNull
    public DbDataSource getDataSource() {
        DbDataSource dbDataSource = this.myDataSource;
        if (dbDataSource == null) {
            DbDiffElement.$$$reportNull$$$0(2);
        }
        return dbDataSource;
    }

    public String getPresentablePath() {
        return this.myDataSource.getName() + ":/" + this.getPath();
    }

    public String getPath() {
        return this.getPath(this.getValue());
    }

    @NotNull
    private String getPath(@Nullable DasObject value) {
        if (value == null) {
            if ("" == null) {
                DbDiffElement.$$$reportNull$$$0(3);
            }
            return "";
        }
        String name = this.getIdentifierMode().apply(value.getName());
        DasObject parent = value.getDasParent();
        if (value instanceof DbColumn) {
            String string = this.getPath(parent) + DbDiffElement.getSeparator() + name;
            if (string == null) {
                DbDiffElement.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (value instanceof DbTable) {
            String string = this.getPath(parent) + name;
            if (string == null) {
                DbDiffElement.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = name.isEmpty() ? this.getPath(parent) : name + DbDiffElement.getSeparator();
        if (string == null) {
            DbDiffElement.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = (String)ReadAction.compute(() -> {
            String elementName = this.myElement.getName();
            if (StringUtil.isEmpty((String)elementName)) {
                if (this.myElement instanceof DasForeignKey) {
                    elementName = "foreign key";
                } else if (this.myElement instanceof DasTableKey) {
                    elementName = DasUtil.getPrimaryKey((DasTable)((DasTableKey)this.myElement).getTable()) == this.myElement ? "primary key" : "key";
                } else if (this.myElement instanceof DasIndex) {
                    boolean unique = ((DasIndex)this.myElement).isUnique();
                    elementName = unique ? "unique index" : "index";
                }
            }
            return this.getIdentifierMode().apply(elementName);
        });
        if (string == null) {
            DbDiffElement.$$$reportNull$$$0(7);
        }
        return string;
    }

    public long getSize() {
        return -1L;
    }

    public long getTimeStamp() {
        return -1L;
    }

    public FileType getFileType() {
        return SqlFileType.INSTANCE;
    }

    public boolean isContainer() {
        return !(this.myElement instanceof DasTableChild);
    }

    public DiffElement[] getChildren() {
        DasModel model = this.myDataSource.getDelegate().getModel();
        List list = ContainerUtil.map((Iterable)(this.myElement == this.myDataSource ? model.getModelRoots() : model.traverser().children((Object)this.myElement)), object -> {
            DbDiffElement element = new DbDiffElement(this.myDataSource, (DasObject)object);
            element.setSettings(this.mySettings);
            return element;
        });
        return list.isEmpty() ? EMPTY_ARRAY : list.toArray(new DiffElement[list.size()]);
    }

    @NotNull
    public byte[] getContent() throws IOException {
        byte[] byArray = (byte[])ReadAction.compute(() -> {
            String text2 = new DdlBuilder().sort(this.isIgnoreOrder()).keywordCase(this.getKeywordMode()).identifierCase(Casing.create((Case)this.getIdentifierMode(), (Case)this.getIdentifierMode())).element(this.myElement).getStatement();
            return text2.getBytes(this.getCharset());
        });
        if (byArray == null) {
            DbDiffElement.$$$reportNull$$$0(8);
        }
        return byArray;
    }

    @NotNull
    public DiffContent createDiffContent(@Nullable Project project, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        if (indicator == null) {
            DbDiffElement.$$$reportNull$$$0(9);
        }
        DiffContent diffContent = (DiffContent)ApplicationManager.getApplication().runReadAction((ThrowableComputable)new ThrowableComputable<DiffContent, DiffRequestProducerException>(){

            public DiffContent compute() throws DiffRequestProducerException {
                try {
                    Project project = DbDiffElement.this.myDataSource.getProject();
                    SqlLanguageDialect language = DbSqlUtil.getSqlDialect((DbElement)DbDiffElement.this.myDataSource);
                    PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
                    PsiFile psiFile = psiFileFactory.createFileFromText("a." + DbDiffElement.this.getFileType().getDefaultExtension(), (Language)language, (CharSequence)StringUtil.convertLineSeparators((String)new String(DbDiffElement.this.getContent(), DbDiffElement.this.getCharset())), false, true);
                    VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
                    if (virtualFile instanceof LightVirtualFile) {
                        ((LightVirtualFile)virtualFile).setWritable(false);
                    }
                    Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
                    assert (document != null);
                    DocumentContent content = DiffContentFactory.getInstance().create(project, document, virtualFile);
                    content.putUserData(DiffUserDataKeys.LANGUAGE, (Object)language);
                    return content;
                }
                catch (IOException e) {
                    throw new DiffRequestProducerException((Throwable)e);
                }
            }
        });
        if (diffContent == null) {
            DbDiffElement.$$$reportNull$$$0(10);
        }
        return diffContent;
    }

    @NotNull
    private Case getIdentifierMode() {
        Case case_ = this.isIgnoreCase() ? Case.LOWER : Case.MIXED;
        if (case_ == null) {
            DbDiffElement.$$$reportNull$$$0(11);
        }
        return case_;
    }

    @NotNull
    private Case getKeywordMode() {
        Case case_ = this.isIgnoreCase() ? Case.UPPER : Case.MIXED;
        if (case_ == null) {
            DbDiffElement.$$$reportNull$$$0(12);
        }
        return case_;
    }

    private boolean isIgnoreOrder() {
        return (Boolean)this.getSettings().customSettings.get(IGNORE_ORDER);
    }

    private boolean isIgnoreCase() {
        return (Boolean)this.getSettings().customSettings.get(IGNORE_CASE);
    }

    @NotNull
    public DasObject getValue() {
        DasObject dasObject = this.myElement;
        if (dasObject == null) {
            DbDiffElement.$$$reportNull$$$0(13);
        }
        return dasObject;
    }

    public Icon getIcon() {
        return DbPresentation.getIcon(this.getValue());
    }

    public DirDiffSettings getSettings() {
        return this.mySettings;
    }

    public void setSettings(DirDiffSettings settings) {
        this.mySettings = settings;
    }

    public void generateMigrationStatements(DdlBuilder builder, DdlBuilder addKeyBuilder, DdlBuilder dropKeyBuilder, DatabaseDialectEx targetDialect) {
        DasObject o = this.getValue();
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)this.myDataSource);
        Migrator<DasObject> migrator = Migrator.getMigrator(o);
        if (migrator != null) {
            migrator.script(o, builder, addKeyBuilder, dropKeyBuilder, targetDialect);
        } else {
            String action = targetDialect == null ? "drop" : "create";
            String kindName = dialect.getNameForKind(o.getKind());
            builder.plain(String.format("-- todo %s %s: %s", action, kindName, o.getName())).newLine();
        }
    }

    public boolean isOperationsEnabled() {
        return false;
    }

    @NotNull
    public Promise<DiffElement> copyToAsync(@NotNull DiffElement container, @Nullable DiffElement target2, @NotNull String relativePath) {
        if (container == null) {
            DbDiffElement.$$$reportNull$$$0(14);
        }
        if (relativePath == null) {
            DbDiffElement.$$$reportNull$$$0(15);
        }
        throw new AssertionError();
    }

    @NotNull
    public Promise<Void> deleteAsync() {
        throw new AssertionError();
    }

    public String toString() {
        return "DbDiffElement{kind=" + this.myElement.getKind() + ", name=" + QNameUtil.getQualifiedName(this.myElement) + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diff/DbDiffElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diff/DbDiffElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffContent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifierMode";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordMode";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDiffContent";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyToAsync";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

