/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.CompositeFormatter;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatter;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatterDelegate;
import com.intellij.database.run.ui.grid.editors.DateDelegate;
import com.intellij.database.run.ui.grid.editors.EraDateAndTimeFormatter;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.NumberFormatter;
import com.intellij.database.run.ui.grid.editors.ShortZonedTimeDelegate;
import com.intellij.database.run.ui.grid.editors.ShortZonedTimestampDelegate;
import com.intellij.database.run.ui.grid.editors.TimeDelegate;
import com.intellij.database.run.ui.grid.editors.TimestampDelegate;
import com.intellij.database.run.ui.grid.editors.ZonedTimeDelegate;
import com.intellij.database.run.ui.grid.editors.ZonedTimestampDelegate;
import com.intellij.util.Consumer;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatterCreator {
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String ERA_PATTERN = "[ ][GGG]";

    private FormatterCreator() {
    }

    @NotNull
    public static NumberFormatter newDecimalFormat() {
        NumberFormatter numberFormatter = FormatterCreator.configureDecimalFormat(new DecimalFormat());
        if (numberFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(0);
        }
        return numberFormatter;
    }

    @NotNull
    public static NumberFormatter newFloatFormat() {
        NumberFormatter numberFormatter = FormatterCreator.configureDecimalFormat(new DecimalFormat(){

            @Override
            public Number parse(String text2, ParsePosition pos) {
                Number n = super.parse(text2, pos);
                return n != null ? Float.valueOf(n.floatValue()) : null;
            }

            @Override
            public StringBuffer format(double number, StringBuffer result2, FieldPosition fieldPosition) {
                number = Double.valueOf(Float.toString((float)number));
                return super.format(number, result2, fieldPosition);
            }
        });
        if (numberFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(1);
        }
        return numberFormatter;
    }

    @NotNull
    public static CompositeFormatter newShortZonedTimeFormat() {
        CompositeFormatter compositeFormatter = FormatterCreator.newZonedTimeFormat(new ShortZonedTimeDelegate());
        if (compositeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(2);
        }
        return compositeFormatter;
    }

    @NotNull
    public static CompositeFormatter newZonedTimeFormat() {
        CompositeFormatter compositeFormatter = FormatterCreator.newZonedTimeFormat(new ZonedTimeDelegate());
        if (compositeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(3);
        }
        return compositeFormatter;
    }

    @NotNull
    public static DateAndTimeFormatter<Time, OffsetTime> newTimeFormat() {
        DateAndTimeFormatter<Time, OffsetTime> dateAndTimeFormatter = FormatterCreator.newTimeFormat(new TimeDelegate());
        if (dateAndTimeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(4);
        }
        return dateAndTimeFormatter;
    }

    @NotNull
    public static <T, V extends TemporalAccessor> DateAndTimeFormatter<T, V> newTimeFormat(@NotNull DateAndTimeFormatterDelegate<T, V> delegate) {
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(5);
        }
        Builders builders = new Builders();
        FormatterCreator.appendTime(builders);
        DateAndTimeFormatter<T, V> dateAndTimeFormatter = new DateAndTimeFormatter<T, V>(builders.sb.toString(), FormatterCreator.toFormatter(builders.fb), delegate);
        if (dateAndTimeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(6);
        }
        return dateAndTimeFormatter;
    }

    @NotNull
    public static DateAndTimeFormatter<Timestamp, OffsetDateTime> newTimestampFormat(int scale) {
        Builders builders = new Builders();
        FormatterCreator.appendDate(builders);
        builders.sb.append(' ');
        builders.fb.appendPattern("[ ]");
        FormatterCreator.appendTime(builders);
        FormatterCreator.appendFraction(builders, scale);
        DateAndTimeFormatter<Timestamp, OffsetDateTime> dateAndTimeFormatter = new DateAndTimeFormatter<Timestamp, OffsetDateTime>(builders.sb.toString(), FormatterCreator.toFormatter(builders.fb), new TimestampDelegate());
        if (dateAndTimeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(7);
        }
        return dateAndTimeFormatter;
    }

    @NotNull
    public static CompositeFormatter newZonedTimestampFormat(@NotNull DatabaseFamilyId family, @Nullable DataConsumer.Column column2, int scale) {
        if (family == null) {
            FormatterCreator.$$$reportNull$$$0(8);
        }
        CompositeFormatter compositeFormatter = FormatterCreator.newZonedTimestampFormat(family, new ZonedTimestampDelegate(), column2, scale);
        if (compositeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(9);
        }
        return compositeFormatter;
    }

    @NotNull
    public static <T, V extends TemporalAccessor> CompositeFormatter newZonedTimestampFormat(@NotNull DatabaseFamilyId family, @NotNull DateAndTimeFormatterDelegate<T, V> delegate, @Nullable DataConsumer.Column column2, int scale) {
        if (family == null) {
            FormatterCreator.$$$reportNull$$$0(10);
        }
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(11);
        }
        CompositeFormatter compositeFormatter = FormatterCreator.newZonedTimestampFormat(delegate, BoundaryValueResolver.getResolver(family, column2), scale);
        if (compositeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(12);
        }
        return compositeFormatter;
    }

    @NotNull
    public static <T, V extends TemporalAccessor> CompositeFormatter newZonedTimestampFormat(@NotNull DateAndTimeFormatterDelegate<T, V> delegate, @NotNull BoundaryValueResolver resolver, int scale) {
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(13);
        }
        if (resolver == null) {
            FormatterCreator.$$$reportNull$$$0(14);
        }
        Builders builders = FormatterCreator.createBuildersForTimestamp(scale);
        List<DateTimeFormatter> formatters = FormatterCreator.appendTimeZone(builders);
        String pattern = builders.sb.toString();
        List mapped = ContainerUtil.map(formatters, f -> {
            if (delegate == null) {
                FormatterCreator.$$$reportNull$$$0(49);
            }
            if (resolver == null) {
                FormatterCreator.$$$reportNull$$$0(50);
            }
            return FormatterCreator.eraFormatter(pattern, f, delegate, resolver);
        });
        CompositeFormatter compositeFormatter = new CompositeFormatter(mapped);
        if (compositeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(15);
        }
        return compositeFormatter;
    }

    @NotNull
    public static Formatter newEraTimestampFormat(@NotNull DatabaseFamilyId family, @Nullable DataConsumer.Column column2, int scale) {
        if (family == null) {
            FormatterCreator.$$$reportNull$$$0(16);
        }
        Builders builders = FormatterCreator.createBuildersForTimestamp(scale);
        EraDateAndTimeFormatter eraDateAndTimeFormatter = FormatterCreator.eraFormatter(builders.sb.toString(), FormatterCreator.toFormatter(builders.fb), new TimestampDelegate(), BoundaryValueResolver.getResolver(family, column2));
        if (eraDateAndTimeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(17);
        }
        return eraDateAndTimeFormatter;
    }

    @NotNull
    public static Formatter newShortEraZonedTimestampFormat(int scale) {
        Formatter formatter2 = FormatterCreator.newShortZonedTimestampFormat(scale, (PairFunction<DateTimeFormatter, String, Formatter>)((PairFunction)(formatter, pattern) -> FormatterCreator.eraFormatter(pattern, formatter, new ShortZonedTimestampDelegate(), BoundaryValueResolver.ALWAYS_NULL)));
        if (formatter2 == null) {
            FormatterCreator.$$$reportNull$$$0(18);
        }
        return formatter2;
    }

    @NotNull
    public static EraDateAndTimeFormatter newEraDateFormatter(@Nullable DatabaseFamilyId family, @Nullable DataConsumer.Column column2) {
        EraDateAndTimeFormatter eraDateAndTimeFormatter = FormatterCreator.newEraDateFormatter(new DateDelegate(), family, column2);
        if (eraDateAndTimeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(19);
        }
        return eraDateAndTimeFormatter;
    }

    @NotNull
    public static <T, V extends TemporalAccessor> EraDateAndTimeFormatter newEraDateFormatter(@NotNull DateAndTimeFormatterDelegate<T, V> delegate, @Nullable DatabaseFamilyId family, @Nullable DataConsumer.Column column2) {
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(20);
        }
        Builders builders = new Builders();
        FormatterCreator.appendDate(builders);
        BoundaryValueResolver resolver = BoundaryValueResolver.getResolver(family, column2);
        String pattern = builders.sb.toString();
        DateAndTimeFormatter<T, V> regular = new DateAndTimeFormatter<T, V>(pattern, FormatterCreator.toFormatter(builders.fb), delegate, resolver);
        builders.fb.appendPattern(ERA_PATTERN);
        DateAndTimeFormatter<T, V> era = new DateAndTimeFormatter<T, V>(pattern, FormatterCreator.toFormatter(builders.fb), delegate, resolver);
        EraDateAndTimeFormatter eraDateAndTimeFormatter = new EraDateAndTimeFormatter(regular, era);
        if (eraDateAndTimeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(21);
        }
        return eraDateAndTimeFormatter;
    }

    @NotNull
    public static DateAndTimeFormatter<Date, LocalDate> newDateFormatter() {
        Builders builders = new Builders();
        FormatterCreator.appendDate(builders);
        DateAndTimeFormatter<Date, LocalDate> dateAndTimeFormatter = new DateAndTimeFormatter<Date, LocalDate>(builders.sb.toString(), FormatterCreator.toFormatter(builders.fb), new DateDelegate());
        if (dateAndTimeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(22);
        }
        return dateAndTimeFormatter;
    }

    @NotNull
    public static <T, V extends TemporalAccessor> CompositeFormatter newZonedTimeFormat(@NotNull DateAndTimeFormatterDelegate<T, V> delegate) {
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(23);
        }
        Builders builders = new Builders();
        FormatterCreator.appendTime(builders);
        List<DateTimeFormatter> formatters = FormatterCreator.appendTimeZone(builders);
        String pattern = builders.sb.toString();
        List mapped = ContainerUtil.map(formatters, f -> {
            if (delegate == null) {
                FormatterCreator.$$$reportNull$$$0(48);
            }
            return new DateAndTimeFormatter(pattern, (DateTimeFormatter)f, delegate);
        });
        CompositeFormatter compositeFormatter = new CompositeFormatter(mapped);
        if (compositeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(24);
        }
        return compositeFormatter;
    }

    public static boolean supportsEra(@NotNull DatabaseFamilyId family) {
        if (family == null) {
            FormatterCreator.$$$reportNull$$$0(25);
        }
        return family.isPostgres() || family.isOracle();
    }

    @NotNull
    private static Formatter newShortZonedTimestampFormat(int scale, @NotNull PairFunction<DateTimeFormatter, String, Formatter> mapper) {
        if (mapper == null) {
            FormatterCreator.$$$reportNull$$$0(26);
        }
        Builders builders = FormatterCreator.createBuildersForTimestamp(scale);
        List<DateTimeFormatter> formatters = FormatterCreator.appendTimeZone(builders);
        String pattern = builders.sb.toString();
        CompositeFormatter compositeFormatter = new CompositeFormatter(ContainerUtil.map(formatters, formatter -> {
            if (mapper == null) {
                FormatterCreator.$$$reportNull$$$0(47);
            }
            return (Formatter)mapper.fun(formatter, (Object)pattern);
        }));
        if (compositeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(27);
        }
        return compositeFormatter;
    }

    private static void appendTime(@NotNull Builders builders) {
        if (builders == null) {
            FormatterCreator.$$$reportNull$$$0(28);
        }
        builders.sb.append("HH:mm:ss");
        builders.fb.parseLenient().optionalStart().appendValue(ChronoField.HOUR_OF_DAY, 2).optionalEnd().optionalStart().appendLiteral(":").optionalEnd().optionalStart().appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalEnd().optionalStart().appendLiteral(":").optionalEnd().optionalStart().appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().parseStrict();
    }

    @NotNull
    private static List<DateTimeFormatter> appendTimeZone(@NotNull Builders builders) {
        if (builders == null) {
            FormatterCreator.$$$reportNull$$$0(29);
        }
        List<DateTimeFormatter> list = FormatterCreator.withZoneOffsets(builders, builder -> builder.appendOffset("+HH:MM:ss", "+00:00"), builder -> builder.appendOffset("+HH:mm", "+00:00"), builder -> builder.appendZoneOrOffsetId());
        if (list == null) {
            FormatterCreator.$$$reportNull$$$0(30);
        }
        return list;
    }

    @NotNull
    private static List<DateTimeFormatter> withZoneOffsets(@NotNull Builders builders, Consumer<DateTimeFormatterBuilder> ... consumers) {
        if (builders == null) {
            FormatterCreator.$$$reportNull$$$0(31);
        }
        if (consumers == null) {
            FormatterCreator.$$$reportNull$$$0(32);
        }
        List list = ContainerUtil.map((Object[])consumers, c -> {
            if (builders == null) {
                FormatterCreator.$$$reportNull$$$0(46);
            }
            DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().append(FormatterCreator.toFormatter(builders.fb)).optionalStart().appendPattern("[ ]");
            c.consume((Object)builder);
            return FormatterCreator.toFormatter(builder.optionalEnd());
        });
        if (list == null) {
            FormatterCreator.$$$reportNull$$$0(33);
        }
        return list;
    }

    private static void appendDate(@NotNull Builders builders) {
        if (builders == null) {
            FormatterCreator.$$$reportNull$$$0(34);
        }
        builders.sb.append(DATE_PATTERN);
        builders.fb.parseLenient().appendValue(ChronoField.YEAR_OF_ERA, 4, 7, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).parseStrict();
    }

    private static void appendFraction(@NotNull Builders builders, int scale) {
        if (builders == null) {
            FormatterCreator.$$$reportNull$$$0(35);
        }
        builders.sb.append(scale > 0 ? "." : "");
        for (int i2 = 0; i2 < scale; ++i2) {
            builders.sb.append('f');
        }
        if (scale > 0) {
            builders.fb.parseLenient().appendFraction(ChronoField.NANO_OF_SECOND, scale, scale, true).parseStrict();
        }
    }

    @NotNull
    private static <T, V extends TemporalAccessor> EraDateAndTimeFormatter eraFormatter(@NotNull String regular, @NotNull DateTimeFormatter regularFormatter, @NotNull DateAndTimeFormatterDelegate<T, V> delegate, @NotNull BoundaryValueResolver resolver) {
        if (regular == null) {
            FormatterCreator.$$$reportNull$$$0(36);
        }
        if (regularFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(37);
        }
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(38);
        }
        if (resolver == null) {
            FormatterCreator.$$$reportNull$$$0(39);
        }
        DateTimeFormatter era = FormatterCreator.toFormatter(new DateTimeFormatterBuilder().append(regularFormatter).appendPattern(ERA_PATTERN));
        EraDateAndTimeFormatter eraDateAndTimeFormatter = new EraDateAndTimeFormatter(new DateAndTimeFormatter<T, V>(regular, regularFormatter, delegate, resolver), new DateAndTimeFormatter<T, V>(regular, era, delegate, resolver));
        if (eraDateAndTimeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(40);
        }
        return eraDateAndTimeFormatter;
    }

    @NotNull
    private static DateTimeFormatter toFormatter(@NotNull DateTimeFormatterBuilder builder) {
        if (builder == null) {
            FormatterCreator.$$$reportNull$$$0(41);
        }
        DateTimeFormatter dateTimeFormatter = builder.toFormatter(Locale.US);
        if (dateTimeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(42);
        }
        return dateTimeFormatter;
    }

    @NotNull
    private static Builders createBuildersForTimestamp(int scale) {
        Builders builders = new Builders();
        FormatterCreator.appendDate(builders);
        builders.sb.append(' ');
        builders.fb.appendPattern("[ ]");
        FormatterCreator.appendTime(builders);
        FormatterCreator.appendFraction(builders, scale);
        Builders builders2 = builders;
        if (builders2 == null) {
            FormatterCreator.$$$reportNull$$$0(43);
        }
        return builders2;
    }

    @NotNull
    private static NumberFormatter configureDecimalFormat(@NotNull DecimalFormat format) {
        if (format == null) {
            FormatterCreator.$$$reportNull$$$0(44);
        }
        format.setGroupingUsed(false);
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        symbols.setNaN("NaN");
        format.setDecimalFormatSymbols(symbols);
        NumberFormatter numberFormatter = new NumberFormatter(format);
        if (numberFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(45);
        }
        return numberFormatter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/FormatterCreator";
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 20: 
            case 23: 
            case 38: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 8: 
            case 10: 
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 14: 
            case 39: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 26: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 28: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builders";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumers";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regular";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regularFormatter";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "newDecimalFormat";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newFloatFormat";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "newShortZonedTimeFormat";
                break;
            }
            case 3: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "newZonedTimeFormat";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "newTimeFormat";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/FormatterCreator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "newTimestampFormat";
                break;
            }
            case 9: 
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "newZonedTimestampFormat";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "newEraTimestampFormat";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "newShortEraZonedTimestampFormat";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "newEraDateFormatter";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "newDateFormatter";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "newShortZonedTimestampFormat";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "appendTimeZone";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "withZoneOffsets";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "eraFormatter";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "toFormatter";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildersForTimestamp";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "configureDecimalFormat";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "newTimeFormat";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "newZonedTimestampFormat";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "newEraTimestampFormat";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "newEraDateFormatter";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "newZonedTimeFormat";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "supportsEra";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "newShortZonedTimestampFormat";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "appendTime";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "appendTimeZone";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "withZoneOffsets";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "appendDate";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "appendFraction";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "eraFormatter";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "toFormatter";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "configureDecimalFormat";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$withZoneOffsets$7";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$newShortZonedTimestampFormat$3";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$newZonedTimeFormat$2";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "lambda$newZonedTimestampFormat$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Builders {
        private final StringBuilder sb = new StringBuilder();
        private final DateTimeFormatterBuilder fb = new DateTimeFormatterBuilder();

        private Builders() {
        }
    }
}

