/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.LongIdName;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.core.RowLayout;
import org.jetbrains.dekaf.sql.Scriptum;
import org.jetbrains.dekaf.sql.SqlQuery;

public final class OraIntroQueries {
    static OraIntroQueries QUERIES = new OraIntroQueries();
    @NotNull
    private final Scriptum myScriptum = Scriptum.of(OraIntroQueries.class);
    final SqlQuery<Timestamp> askForTimeNow = new SqlQuery("select sysdate from dual", Layouts.rowOf((RowLayout)Layouts.oneOf(Timestamp.class)));
    final SqlQuery<OneSessionInfo> retrieveSessionInfo = this.myScriptum.query("RetrieveSessionInfo", Layouts.rowOf((RowLayout)Layouts.structOf(OneSessionInfo.class)));
    final SqlQuery<Boolean> checkBaseDictionariesAccess = this.myScriptum.query("CheckBaseDictionariesAccess", Layouts.existence());
    final SqlQuery<List<LongIdName>> retrieveAllSchemas = this.myScriptum.query("RetrieveAllSchemas", Layouts.listOf((RowLayout)Layouts.structOf(LongIdName.class)));
    final SqlQuery<OneSchemaInfo> retrieveSchemaInfo = this.myScriptum.query("RetrieveSchemaInfo", Layouts.rowOf((RowLayout)Layouts.structOf(OneSchemaInfo.class)));
    final SqlQuery<OneSchemaInfo> retrievePublicSchemaInfo = this.myScriptum.query("RetrievePublicSchemaInfo", Layouts.rowOf((RowLayout)Layouts.structOf(OneSchemaInfo.class)));
    final SqlQuery<String[]> retrieveAllMajorNamesFast = this.myScriptum.query("RetrieveAllMajorNamesFast", Layouts.columnOf(String.class));
    final SqlQuery<String[]> retrieveAllMajorNamesSlow = this.myScriptum.query("RetrieveAllMajorNamesSlow", Layouts.columnOf(String.class));
    final SqlQuery<long[]> retrieveAllObjectIdentifiersFast = this.myScriptum.query("RetrieveAllObjectIdentifiersFast", Layouts.columnOfLongs((int)4000));
    final SqlQuery<long[]> retrieveAllObjectIdentifiersSlow = this.myScriptum.query("RetrieveAllObjectIdentifiersSlow", Layouts.columnOfLongs((int)4000));
    final SqlQuery<List<OneSynonym>> retrieveAllSynonyms = this.myScriptum.query("RetrieveAllSynonyms", Layouts.listOf((RowLayout)Layouts.structOf(OneSynonym.class)));
    final SqlQuery<List<OneSynonym>> retrieveFragmentSynonyms = this.myScriptum.query("RetrieveFragmentSynonyms", Layouts.listOf((RowLayout)Layouts.structOf(OneSynonym.class)));
    final SqlQuery<String[]> listFragmentRegularIds = this.myScriptum.query("ListFragmentRegularIds", Layouts.columnOf(String.class));
    final SqlQuery<String[]> listFragmentTypeIds = this.myScriptum.query("ListFragmentTypeIds", Layouts.columnOf(String.class));
    final SqlQuery<List<OneSequence>> retrieveSequences = this.myScriptum.query("RetrieveSequences", Layouts.listOf((RowLayout)Layouts.structOf(OneSequence.class)));
    final SqlQuery<List<OneObjectType>> retrieveObjectTypes = this.myScriptum.query("RetrieveObjectTypes", Layouts.listOf((RowLayout)Layouts.structOf(OneObjectType.class)));
    final SqlQuery<List<OneCollectionType>> retrieveCollectionTypes = this.myScriptum.query("RetrieveCollectionTypes", Layouts.listOf((RowLayout)Layouts.structOf(OneCollectionType.class)));
    final SqlQuery<List<OneObjectTypeAttribute>> retrieveObjectTypeAttributes = this.myScriptum.query("RetrieveObjectTypeAttributes", Layouts.listOf((RowLayout)Layouts.structOf(OneObjectTypeAttribute.class)));
    final SqlQuery<List<OneCluster>> retrieveClusters = this.myScriptum.query("RetrieveClusters", Layouts.listOf((RowLayout)Layouts.structOf(OneCluster.class)));
    final SqlQuery<List<OneCluster>> retrieveClustersWhenNoPermissions = this.myScriptum.query("RetrieveClustersWhenNoPermissions", Layouts.listOf((RowLayout)Layouts.structOf(OneCluster.class)));
    final SqlQuery<List<OneTable>> retrieveTables = this.myScriptum.query("RetrieveTables", Layouts.listOf((RowLayout)Layouts.structOf(OneTable.class)));
    final SqlQuery<List<OneMatLog>> retrieveMatLogs = this.myScriptum.query("RetrieveMatLogs", Layouts.listOf((RowLayout)Layouts.structOf(OneMatLog.class)));
    final SqlQuery<List<OneMatView>> retrieveMatViews = this.myScriptum.query("RetrieveMatViews", Layouts.listOf((RowLayout)Layouts.structOf(OneMatView.class)));
    final SqlQuery<List<OneView>> retrieveViews = this.myScriptum.query("RetrieveViews", Layouts.listOf((RowLayout)Layouts.structOf(OneView.class)));
    final SqlQuery<List<OneColumn>> retrieveColumns = this.myScriptum.query("RetrieveColumns", Layouts.listOf((RowLayout)Layouts.structOf(OneColumn.class)));
    final SqlQuery<List<OneColumnDefault>> retrieveColumnDefaults = this.myScriptum.query("RetrieveColumnDefaults", Layouts.listOf((RowLayout)Layouts.structOf(OneColumnDefault.class)));
    final SqlQuery<List<OneClusterIndex>> retrieveClusterIndicesFast = this.myScriptum.query("RetrieveClusterIndicesFast", Layouts.listOf((RowLayout)Layouts.structOf(OneClusterIndex.class)));
    final SqlQuery<List<OneClusterIndex>> retrieveClusterIndicesUser = this.myScriptum.query("RetrieveClusterIndicesUser", Layouts.listOf((RowLayout)Layouts.structOf(OneClusterIndex.class)));
    final SqlQuery<List<OneTableClusterColumn>> retrieveTableClusterColumnsAdmin = this.myScriptum.query("RetrieveTableClusterColumnsAdmin", Layouts.listOf((RowLayout)Layouts.structOf(OneTableClusterColumn.class)));
    final SqlQuery<List<OneTableClusterColumn>> retrieveTableClusterColumnsUser = this.myScriptum.query("RetrieveTableClusterColumnsUser", Layouts.listOf((RowLayout)Layouts.structOf(OneTableClusterColumn.class)));
    final SqlQuery<List<OneIndex>> retrieveIndices = this.myScriptum.query("RetrieveIndices", Layouts.listOf((RowLayout)Layouts.structOf(OneIndex.class)));
    final SqlQuery<List<OneIndexItem>> retrieveIndicesColumns = this.myScriptum.query("RetrieveIndicesColumns", Layouts.listOf((RowLayout)Layouts.structOf(OneIndexItem.class)));
    final SqlQuery<List<OneIndexItem>> retrieveIndicesExpressions = this.myScriptum.query("RetrieveIndicesExpressions", Layouts.listOf((RowLayout)Layouts.structOf(OneIndexItem.class)));
    final SqlQuery<List<OneKey>> retrieveKeys = this.myScriptum.query("RetrieveKeys", Layouts.listOf((RowLayout)Layouts.structOf(OneKey.class)));
    final SqlQuery<List<OneForeignKey>> retrieveForeignKeysFast = this.myScriptum.query("RetrieveForeignKeysFast", Layouts.listOf((RowLayout)Layouts.structOf(OneForeignKey.class)));
    final SqlQuery<List<OneForeignKey>> retrieveForeignKeysSlow = this.myScriptum.query("RetrieveForeignKeysSlow", Layouts.listOf((RowLayout)Layouts.structOf(OneForeignKey.class)));
    final SqlQuery<List<OneCheck>> retrieveChecks = this.myScriptum.query("RetrieveChecks", Layouts.listOf((RowLayout)Layouts.structOf(OneCheck.class)));
    final SqlQuery<List<OneConstraintColumn>> retrieveConstraintColumns = this.myScriptum.query("RetrieveConstraintColumns", Layouts.listOf((RowLayout)Layouts.structOf(OneConstraintColumn.class)));
    final SqlQuery<List<OneTrigger>> retrieveTriggers = this.myScriptum.query("RetrieveTriggers", Layouts.listOf((RowLayout)Layouts.structOf(OneTrigger.class)));
    final SqlQuery<List<String[]>> retrieveTriggerUpdateColumns = this.myScriptum.query("RetrieveTriggerUpdateColumns", Layouts.listOf((RowLayout)Layouts.arrayOf((int)3, String.class)));
    final SqlQuery<List<OnePackage>> retrievePackages = this.myScriptum.query("RetrievePackages", Layouts.listOf((RowLayout)Layouts.structOf(OnePackage.class)));
    final SqlQuery<List<OneInnerRoutine>> retrieveInnerRoutines = this.myScriptum.query("RetrieveInnerRoutines", Layouts.listOf((RowLayout)Layouts.structOf(OneInnerRoutine.class)));
    final SqlQuery<List<OneInnerRoutineArgument>> retrieveInnerRoutineArguments = this.myScriptum.query("RetrieveInnerRoutineArguments", Layouts.listOf((RowLayout)Layouts.structOf(OneInnerRoutineArgument.class)));
    final SqlQuery<List<OneSingleRoutine>> retrieveSingleRoutines = this.myScriptum.query("RetrieveSingleRoutines", Layouts.listOf((RowLayout)Layouts.structOf(OneSingleRoutine.class)));
    final SqlQuery<List<OneSingleRoutineArgument>> retrieveSingleRoutineArguments = this.myScriptum.query("RetrieveSingleRoutineArguments", Layouts.listOf((RowLayout)Layouts.structOf(OneSingleRoutineArgument.class)));
    final SqlQuery<Long> calculateCommentsHash = this.myScriptum.query("CalculateCommentsHash", Layouts.singleOf(Long.class));
    final SqlQuery<List<OneComment>> retrieveComments = this.myScriptum.query("RetrieveComments", Layouts.listOf((RowLayout)Layouts.structOf(OneComment.class)));
    final SqlQuery<List<OneDependency>> retrieveDependenciesFast = this.myScriptum.query("RetrieveDependenciesFast", Layouts.listOf((RowLayout)Layouts.structOf(OneDependency.class)));
    final SqlQuery<List<OneDependency>> retrieveDependenciesSlow = this.myScriptum.query("RetrieveDependenciesSlow", Layouts.listOf((RowLayout)Layouts.structOf(OneDependency.class)));
    final SqlQuery<List<OneViewSource>> retrieveViewSources = this.myScriptum.query("RetrieveViewSources", Layouts.listOf((RowLayout)Layouts.structOf(OneViewSource.class)));
    final SqlQuery<List<OneTriggerSource>> retrieveTriggerSources = this.myScriptum.query("RetrieveTriggerSources", Layouts.listOf((RowLayout)Layouts.structOf(OneTriggerSource.class)));
    final SqlQuery<List<OneSrcLine>> retrieveSources = this.myScriptum.query("RetrieveSources", Layouts.listOf((RowLayout)Layouts.structOf(OneSrcLine.class)));
    final SqlQuery<List<OneObfuscatedSrc>> listObfuscatedSources = this.myScriptum.query("ListObfuscatedSources", Layouts.listOf((RowLayout)Layouts.structOf(OneObfuscatedSrc.class)));
    final SqlQuery<long[]> listInvalidObjectsFast = this.myScriptum.query("ListInvalidObjectsFast", Layouts.columnOfLongs((int)1000));
    final SqlQuery<long[]> listInvalidObjectsSlow = this.myScriptum.query("ListInvalidObjectsSlow", Layouts.columnOfLongs((int)1000));
    final SqlQuery<List<OneError>> retrieveErrors = this.myScriptum.query("RetrieveErrors", Layouts.listOf((RowLayout)Layouts.structOf(OneError.class)));
    final SqlQuery<List<OneNativeDefinition>> retrieveNativeDefinitions = this.myScriptum.query("RetrieveNativeDefinitions", Layouts.listOf((RowLayout)Layouts.structOf(OneNativeDefinition.class)));

    static final class OneNativeDefinition {
        long object_id;
        String text;

        OneNativeDefinition() {
        }
    }

    static final class OneError {
        String name;
        char type_code;
        boolean is_body;
        int line;
        int position;
        String message;

        OneError() {
        }
    }

    static final class OneObfuscatedSrc {
        String type;
        String name;

        OneObfuscatedSrc() {
        }
    }

    static final class OneSrcLine {
        String type;
        String name;
        String text;

        OneSrcLine() {
        }
    }

    static final class OneTriggerSource {
        String table_name;
        String trigger_name;
        String trigger_body;

        OneTriggerSource() {
        }
    }

    static final class OneViewSource {
        String view_name;
        String text;

        OneViewSource() {
        }
    }

    static final class OneDependency {
        long object_id;
        long referenced_id;

        OneDependency() {
        }
    }

    static final class OneComment {
        String table_name;
        String column_name;
        String comments;

        OneComment() {
        }
    }

    static final class OneSingleRoutineArgument {
        String routine_name;
        String arg_name;
        short position;
        char arg_direction;
        String data_type_schema_name;
        String data_type;

        OneSingleRoutineArgument() {
        }
    }

    static final class OneSingleRoutine {
        String name;
        char kind;
        boolean is_invalid;
        long object_id;
        boolean is_deterministic;
        Date created_timestamp;
        Date modified_timestamp;

        OneSingleRoutine() {
        }
    }

    static final class OneInnerRoutineArgument {
        String package_name;
        String routine_name;
        String arg_name;
        short position;
        char arg_direction;
        String data_type_schema_name;
        String data_type;

        OneInnerRoutineArgument() {
        }
    }

    static final class OneInnerRoutine {
        char module_kind;
        String module_name;
        String routine_name;
        boolean is_deterministic;

        OneInnerRoutine() {
        }
    }

    static final class OnePackage {
        long object_id;
        String package_name;
        boolean is_body;
        boolean is_invalid;
        Date created_timestamp;
        Date modified_timestamp;

        OnePackage() {
        }
    }

    static final class OneTrigger {
        String table_name;
        String trigger_name;
        long trigger_id;
        short turn;
        String events;
        boolean has_on_update_columns;
        String referencing_names;
        String condition;
        String action_type;
        Date created_timestamp;
        Date modified_timestamp;

        OneTrigger() {
        }
    }

    static final class OneConstraintColumn {
        String table_name;
        String constraint_name;
        short column_position;
        String column_name;

        OneConstraintColumn() {
        }
    }

    static final class OneCheck {
        String table_name;
        String constraint_name;
        boolean is_surrogate_name;
        String predicate;
        boolean is_deferrable;
        boolean is_initially_deferred;
        Date modified_timestamp;

        OneCheck() {
        }
    }

    static final class OneForeignKey {
        long table_id;
        String table_name;
        String constraint_name;
        boolean is_surrogate_name;
        long ref_schema_id;
        String ref_schema_name;
        String ref_table_name;
        String ref_key_name;
        char cascade_rule;
        boolean is_deferrable;
        boolean is_initially_deferred;
        Date modified_timestamp;

        OneForeignKey() {
        }
    }

    static final class OneKey {
        String table_name;
        String constraint_name;
        boolean is_surrogate_name;
        boolean is_pk;
        boolean is_deferrable;
        boolean is_initially_deferred;
        String index_schema_name;
        String index_name;
        Date modified_timestamp;

        OneKey() {
        }
    }

    static final class OneIndexItem {
        String table_name;
        String index_schema_name;
        String index_name;
        short column_position;
        char direction;
        String item;

        OneIndexItem() {
        }
    }

    static final class OneIndex {
        String table_name;
        String index_name;
        boolean uniqueness;
        boolean clustering;
        boolean function_based;
        boolean bitmap;
        boolean surrogate;
        long object_id;
        String tablespace_name;
        Date created_timestamp;
        Date modified_timestamp;

        OneIndex() {
        }
    }

    static final class OneTableClusterColumn {
        String table_name;
        String column_name;

        OneTableClusterColumn() {
        }
    }

    static final class OneClusterIndex {
        String cluster_name;
        String index_name;
        long index_id;
        String tablespace_name;
        Date created_timestamp;
        Date modified_timestamp;

        OneClusterIndex() {
        }
    }

    static final class OneColumnDefault {
        String table_name;
        String column_name;
        String default_expression;

        OneColumnDefault() {
        }
    }

    static final class OneColumn {
        char major_kind;
        long major_id;
        short column_position;
        String column_name;
        String data_type_schema_name;
        String data_type;
        int data_size;
        int data_scale;
        char data_size_units;
        boolean mandatory;
        boolean identity_column;
        boolean default_on_null;
        boolean has_default_expression;

        OneColumn() {
        }
    }

    static final class OneView {
        String view_name;
        long object_id;
        boolean modifiable;
        boolean is_invalid;
        Date created_timestamp;
        Date modified_timestamp;

        OneView() {
        }
    }

    static final class OneMatView {
        String view_name;
        long object_id;
        boolean prebuilt;
        boolean modifiable;
        char refresh_method;
        char refresh_mode;
        boolean is_invalid;
        Date created_timestamp;
        Date modified_timestamp;

        OneMatView() {
        }
    }

    static final class OneMatLog {
        String table_name;
        String log_name;
        boolean with_rowid;
        boolean with_object_id;
        boolean with_primary_key;
        boolean with_sequence;
        boolean with_new_values;

        OneMatLog() {
        }
    }

    static final class OneTable {
        String table_name;
        long object_id;
        char organization_kind;
        boolean has_mat_log;
        boolean is_mat_log;
        boolean is_mat_view;
        boolean is_temp;
        boolean is_temp_preserved;
        boolean surrogate;
        String master_table_name;
        String row_type_schema_name;
        String row_type_name;
        String cluster_name;
        Date created_timestamp;
        Date modified_timestamp;

        OneTable() {
        }
    }

    static final class OneCluster {
        long id;
        char type_code;
        boolean single_table;
        int block_size;
        int hash_cardinality;
        String hash_expression;
        String tablespace_name;
        String decompiled_text;

        OneCluster() {
        }
    }

    static final class OneObjectTypeAttribute {
        String type_name;
        short position;
        String attr_name;
        String data_type_schema;
        String data_type;
        int data_size;
        int data_scale;
        char data_size_units;

        OneObjectTypeAttribute() {
        }
    }

    static final class OneCollectionType {
        long object_id;
        String type_name;
        char collection_kind;
        String data_type_schema_name;
        String data_type;
        int data_size;
        int data_scale;
        char data_size_units;
        int upper_bound;
        Date created_timestamp;
        Date modified_timestamp;

        OneCollectionType() {
        }
    }

    static final class OneObjectType {
        String type_name;
        String supertype_schema_name;
        String supertype_name;
        boolean is_incomplete;
        boolean is_final;
        boolean is_instantiable;
        long object_id;
        Date created_timestamp;
        Date modified_timestamp;
        long body_object_id;
        Date body_created_timestamp;
        Date body_modified_timestamp;

        OneObjectType() {
        }
    }

    static final class OneSequence {
        String sequence_name;
        BigDecimal min_value;
        BigDecimal max_value;
        long increment_by;
        boolean cycle_flag;
        boolean order_flag;
        Integer cache_size;
        BigDecimal last_number;
        long object_id;
        boolean generated;
        Date created_timestamp;
        Date modified_timestamp;

        OneSequence() {
        }
    }

    static final class OneSynonym {
        String synonym_schema_name;
        long synonym_id;
        String synonym_name;
        Date created_timestamp;
        Date modified_timestamp;
        String origin_db_link;
        String origin_schema_name;
        String origin_object_name;

        OneSynonym() {
        }
    }

    static final class OneSchemaInfo {
        long user_id;
        Timestamp created_timestamp;
        Timestamp modified_timestamp;

        OneSchemaInfo() {
        }
    }

    static final class OneSessionInfo {
        String current_schema;
        String current_user;
        String database_name;

        OneSessionInfo() {
        }
    }
}

