/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.google.common.collect.ImmutableList;
import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.introspection.BaseMultiDatabaseIntrospector;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.LongIdName;
import com.intellij.database.introspection.SrcText;
import com.intellij.database.introspection.SybaseIntroQueries;
import com.intellij.database.introspection.SybaseIntrospector;
import com.intellij.database.introspection.SybaseIntrospector$SybaseSchemaRetriever$retrieveSources$;
import com.intellij.database.introspection.SybaseIntrospectorKt;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.sybase.SybaseDatabase;
import com.intellij.database.model.sybase.SybaseModArgument;
import com.intellij.database.model.sybase.SybaseModCheck;
import com.intellij.database.model.sybase.SybaseModDatabase;
import com.intellij.database.model.sybase.SybaseModForeignKey;
import com.intellij.database.model.sybase.SybaseModFunction;
import com.intellij.database.model.sybase.SybaseModIndex;
import com.intellij.database.model.sybase.SybaseModKey;
import com.intellij.database.model.sybase.SybaseModLikeColumn;
import com.intellij.database.model.sybase.SybaseModLikeTable;
import com.intellij.database.model.sybase.SybaseModMajorObject;
import com.intellij.database.model.sybase.SybaseModModel;
import com.intellij.database.model.sybase.SybaseModProcedure;
import com.intellij.database.model.sybase.SybaseModProcedureGroup;
import com.intellij.database.model.sybase.SybaseModRoot;
import com.intellij.database.model.sybase.SybaseModRoutine;
import com.intellij.database.model.sybase.SybaseModSchema;
import com.intellij.database.model.sybase.SybaseModTable;
import com.intellij.database.model.sybase.SybaseModTableColumn;
import com.intellij.database.model.sybase.SybaseModTrigger;
import com.intellij.database.model.sybase.SybaseRoot;
import com.intellij.database.model.sybase.SybaseSchema;
import com.intellij.database.queryRewriting.QueryRewriters;
import com.intellij.database.scripting.CompositeText;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sybase;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.sql.SqlQuery;
import org.jetbrains.dekaf.util.StringOperator;
import org.jetbrains.dekaf.util.Strings;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0001:\u0003\u001c\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\tJF\u0010\f\u001a00\rR,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0014J\u001c\u0010\u0011\u001a\u00060\u0012R\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0007H\u0014J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0007H\u0014J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0016\u001a\u00020\u000fH\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u000fH\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/introspection/SybaseIntrospector;", "Lcom/intellij/database/introspection/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/model/sybase/SybaseModModel;", "Lcom/intellij/database/model/sybase/SybaseRoot;", "Lcom/intellij/database/model/sybase/SybaseModRoot;", "Lcom/intellij/database/model/sybase/SybaseDatabase;", "Lcom/intellij/database/model/sybase/SybaseModDatabase;", "Lcom/intellij/database/model/sybase/SybaseSchema;", "Lcom/intellij/database/model/sybase/SybaseModSchema;", "()V", "myQueries", "Lcom/intellij/database/introspection/SybaseIntroQueries;", "createDatabaseRetriever", "Lcom/intellij/database/introspection/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/introspection/SybaseIntrospector$SybaseSchemaRetriever;", "schema", "isPossibleToIntrospectSchemaIncrementally", "", "tran", "listDatabases", "", "Lcom/intellij/database/introspection/LongIdName;", "retrieveSessionBriefInfo", "", "SybaseDatabaseRetriever", "SybaseSchemaRetriever", "VERSION", "database-introspection"})
public final class SybaseIntrospector
extends BaseMultiDatabaseIntrospector<SybaseModModel, SybaseRoot, SybaseModRoot, SybaseDatabase, SybaseModDatabase, SybaseSchema, SybaseModSchema> {
    private final SybaseIntroQueries myQueries;

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.BaseDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull SybaseDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        return new SybaseDatabaseRetriever(transaction, database);
    }

    @NotNull
    protected SybaseSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull SybaseSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return new SybaseSchemaRetriever(transaction, schema);
    }

    @Override
    protected void retrieveSessionBriefInfo(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        super.retrieveSessionBriefInfo(tran);
        ConnectionInfo info = this.getDbConnectionInfo();
        if (info.databaseName != null) {
            SybaseIntrospector this_$iv = this;
            this_$iv.getModel().modify(BaseMultiDatabaseIntrospector.access$getModRootClass$p(this_$iv), new ModelModifier<MR>(info){
                final /* synthetic */ ConnectionInfo $info$inlined;
                {
                    this.$info$inlined = connectionInfo;
                }

                public final void perform(MR root2) {
                    MR MR = root2;
                    Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                    SybaseModRoot root3 = (SybaseModRoot)MR;
                    NamingIdentifyingFamily namingIdentifyingFamily = root3.getDatabases();
                    String string = this.$info$inlined.databaseName;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    SybaseModDatabase database = (SybaseModDatabase)namingIdentifyingFamily.createOrGet(string);
                    database.setCurrent(true);
                    if (this.$info$inlined.schemaName != null) {
                        NamingIdentifyingFamily namingIdentifyingFamily2 = database.getSchemas();
                        String string2 = this.$info$inlined.schemaName;
                        if (string2 == null) {
                            Intrinsics.throwNpe();
                        }
                        SybaseModSchema schema = (SybaseModSchema)namingIdentifyingFamily2.createOrGet(string2);
                        schema.setCurrent(true);
                    }
                }
            });
        }
    }

    @Override
    @NotNull
    protected List<LongIdName> listDatabases(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Object object = tran.query(this.myQueries.listDatabases).run();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"tran.query(myQueries.listDatabases).run()");
        return (List)object;
    }

    @Override
    protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull SybaseSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return false;
    }

    public SybaseIntrospector() {
        Rdbms rdbms = Sybase.RDBMS;
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"Sybase.RDBMS");
        super(rdbms, SybaseModModel.class, SybaseModRoot.class, SybaseModDatabase.class, SybaseModSchema.class);
        SybaseIntroQueries sybaseIntroQueries = SybaseIntroQueries.QUERIES;
        Intrinsics.checkExpressionValueIsNotNull((Object)sybaseIntroQueries, (String)"SybaseIntroQueries.QUERIES");
        this.myQueries = sybaseIntroQueries;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u0000200\u0001R,\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0002B\u0017\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/introspection/SybaseIntrospector$SybaseDatabaseRetriever;", "Lcom/intellij/database/introspection/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/introspection/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/model/sybase/SybaseModModel;", "Lcom/intellij/database/model/sybase/SybaseRoot;", "Lcom/intellij/database/model/sybase/SybaseModRoot;", "Lcom/intellij/database/model/sybase/SybaseDatabase;", "Lcom/intellij/database/model/sybase/SybaseModDatabase;", "Lcom/intellij/database/model/sybase/SybaseSchema;", "Lcom/intellij/database/model/sybase/SybaseModSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "(Lcom/intellij/database/introspection/SybaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/sybase/SybaseDatabase;)V", "beforeSchemasRetrieval", "", "listSchemas", "", "Lcom/intellij/database/introspection/LongIdName;", "database-introspection"})
    private final class SybaseDatabaseRetriever
    extends BaseMultiDatabaseIntrospector.BaseDatabaseRetriever {
        @Override
        protected void beforeSchemasRetrieval() {
            this.setQueryParameter("CAT", SybaseIntrospectorKt.access$catalogPrefix((SybaseDatabase)this.getDatabase()));
        }

        @Override
        @NotNull
        protected List<LongIdName> listSchemas() {
            SqlQuery<List<LongIdName>> sqlQuery = ((SybaseIntrospector)SybaseIntrospector.this).myQueries.listSchemas;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.listSchemas");
            return this.performQuery(sqlQuery);
        }

        public SybaseDatabaseRetriever(@NotNull DBTransaction transaction, SybaseDatabase database) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            super((BaseMultiDatabaseIntrospector)SybaseIntrospector.this, transaction, (BasicDatabase)database);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0084\u0004\u0018\u0000200\u0001R,\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0002B\u0017\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\rJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0015H\u0014J\b\u0010\u001d\u001a\u00020\u0015H\u0014J\b\u0010\u001e\u001a\u00020\u0015H\u0014J\b\u0010\u001f\u001a\u00020\u0015H\u0014J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020\u0015H\u0002J\b\u0010+\u001a\u00020\u0015H\u0002J\b\u0010,\u001a\u00020\u0015H\u0002J\b\u0010-\u001a\u00020\u0015H\u0002J\b\u0010.\u001a\u00020\u0015H\u0002J\b\u0010/\u001a\u00020\u0015H\u0014J\b\u00100\u001a\u00020\u0015H\u0014J\b\u00101\u001a\u00020\u0015H\u0002J\b\u00102\u001a\u00020\u0015H\u0002J\b\u00103\u001a\u00020\u0015H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/database/introspection/SybaseIntrospector$SybaseSchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "Lcom/intellij/database/model/sybase/SybaseModModel;", "Lcom/intellij/database/model/sybase/SybaseRoot;", "Lcom/intellij/database/model/sybase/SybaseModRoot;", "Lcom/intellij/database/model/sybase/SybaseDatabase;", "Lcom/intellij/database/model/sybase/SybaseModDatabase;", "Lcom/intellij/database/model/sybase/SybaseSchema;", "Lcom/intellij/database/model/sybase/SybaseModSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/introspection/SybaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/sybase/SybaseSchema;)V", "rewriter", "Lorg/jetbrains/dekaf/util/StringOperator;", "schemaId", "", "wasProcedures", "", "addRoutineArgument", "", "routine", "Lcom/intellij/database/model/basic/BasicModRoutine;", "ca", "Lcom/intellij/database/introspection/SybaseIntroQueries$OneColumnOrArgument;", "dt", "Lcom/intellij/database/model/DataType;", "analyzeBriefInfo", "analyzeCurrentContent", "clearSchema", "finishSchema", "peekColumnPositions", "", "keys", "", "peekIndexColumns", "index", "Lcom/intellij/database/model/sybase/SybaseModIndex;", "progress", "what", "", "retrieveCheckConstraints", "retrieveColumnsAndArguments", "retrieveDefaults", "retrieveForeignKeys", "retrieveIndicesAndKeys", "retrieveMainContent", "retrieveMajorNames", "retrieveProcedures", "retrieveSources", "retrieveTriggers", "database-introspection"})
    protected final class SybaseSchemaRetriever
    extends BaseIntrospector.AbstractSchemaRetriever {
        private final int schemaId;
        private final StringOperator rewriter;
        private boolean wasProcedures;

        @Override
        protected void analyzeBriefInfo() {
            this.setIntrospectionBeginTimestamp$database_introspection((Timestamp)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.now).run());
        }

        @Override
        protected void clearSchema() {
        }

        @Override
        protected void analyzeCurrentContent() {
            this.progress("determining dropped objects");
        }

        @Override
        protected void retrieveMajorNames() {
            this.progress("listing major objects");
            List ms = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveMajorNames.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            SybaseSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, ms){
                final /* synthetic */ SybaseSchemaRetriever this$0;
                final /* synthetic */ List $ms$inlined;
                {
                    this.this$0 = sybaseSchemaRetriever;
                    this.$ms$inlined = list;
                }

                public final void perform(MS schema) {
                    ModNamingIdentifyingFamily it;
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    Object[] objectArray = new ModNamingIdentifyingFamily[4];
                    NamingIdentifyingFamily namingIdentifyingFamily = schema2.getTables();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.tables");
                    objectArray[0] = namingIdentifyingFamily;
                    NamingIdentifyingFamily namingIdentifyingFamily2 = schema2.getViews();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"schema.views");
                    objectArray[1] = namingIdentifyingFamily2;
                    NamingIdentifyingFamily namingIdentifyingFamily3 = schema2.getFunctions();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily3, (String)"schema.functions");
                    objectArray[2] = namingIdentifyingFamily3;
                    NamingIdentifyingFamily namingIdentifyingFamily4 = schema2.getProcedureGroups();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily4, (String)"schema.procedureGroups");
                    objectArray[3] = namingIdentifyingFamily4;
                    List families = CollectionsKt.listOf((Object[])objectArray);
                    Iterable $receiver$iv = families;
                    for (Object element$iv : $receiver$iv) {
                        it = (ModNamingIdentifyingFamily)element$iv;
                        it.markChildrenAsSyncPending();
                    }
                    block7: for (SybaseIntroQueries.OneMajorName m : this.$ms$inlined) {
                        NamingIdentifyingFamily family;
                        switch (m.type) {
                            case 'S': 
                            case 'U': {
                                Intrinsics.checkExpressionValueIsNotNull((Object)schema2.getTables(), (String)"schema.tables");
                                break;
                            }
                            case 'V': {
                                Intrinsics.checkExpressionValueIsNotNull((Object)schema2.getViews(), (String)"schema.views");
                                break;
                            }
                            case 'F': {
                                Intrinsics.checkExpressionValueIsNotNull((Object)schema2.getFunctions(), (String)"schema.functions");
                                break;
                            }
                            case 'P': {
                                Intrinsics.checkExpressionValueIsNotNull((Object)schema2.getProcedureGroups(), (String)"schema.procedureGroups");
                                break;
                            }
                            default: {
                                continue block7;
                            }
                        }
                        SybaseSchemaRetriever.access$setWasProcedures$p(this.this$0, SybaseSchemaRetriever.access$getWasProcedures$p(this.this$0) | m.type == 'P');
                        SybaseModMajorObject obj = (SybaseModMajorObject)family.renew(m.id, m.name);
                        obj.setStateNumber(m.state_nr);
                    }
                    $receiver$iv = families;
                    for (Object element$iv : $receiver$iv) {
                        it = (ModNamingIdentifyingFamily)element$iv;
                        SybaseIntrospectorKt.access$finish(it);
                    }
                }
            });
        }

        @Override
        protected void retrieveMainContent() {
            this.retrieveProcedures();
            this.retrieveColumnsAndArguments();
            this.retrieveDefaults();
            this.retrieveIndicesAndKeys();
            this.retrieveForeignKeys();
            this.retrieveCheckConstraints();
            this.retrieveTriggers();
            this.retrieveSources();
            this.finishSchema();
        }

        private final void retrieveProcedures() {
            if (!this.wasProcedures) {
                return;
            }
            this.progress("retrieving procedure overloads");
            List ps = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveProcedures.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            SybaseSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(ps){
                final /* synthetic */ List $ps$inlined;
                {
                    this.$ps$inlined = list;
                }

                public final void perform(MS schema) {
                    SybaseModProcedureGroup it;
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    Iterable $receiver$iv = schema2.getProcedureGroups();
                    for (Object element$iv : $receiver$iv) {
                        it = (SybaseModProcedureGroup)element$iv;
                        it.getProcedures().markChildrenAsSyncPending();
                    }
                    for (SybaseIntroQueries.OneProcedure p : this.$ps$inlined) {
                        SybaseModProcedureGroup group2;
                        if ((SybaseModProcedureGroup)schema2.getProcedureGroups().getByObjectId((long)p.id) == null) {
                            continue;
                        }
                        group2.getProcedures().createOrGetAt(p.procedure_position);
                    }
                    $receiver$iv = schema2.getProcedureGroups();
                    for (Object element$iv : $receiver$iv) {
                        it = (SybaseModProcedureGroup)element$iv;
                        SybaseIntrospectorKt.access$finish((ModFamily)((Object)it.getProcedures()));
                    }
                }
            });
        }

        private final void retrieveColumnsAndArguments() {
            this.progress("retrieving columns and arguments");
            List cas = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveColumnsAndArguments.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            SybaseSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, cas){
                final /* synthetic */ SybaseSchemaRetriever this$0;
                final /* synthetic */ List $cas$inlined;
                {
                    this.this$0 = sybaseSchemaRetriever;
                    this.$cas$inlined = list;
                }

                public final void perform(MS schema) {
                    BasicScriptable it;
                    BasicScriptable it2;
                    Iterator<T> $receiver$iv$iv;
                    Iterable $receiver$iv;
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    Iterable iterable = $receiver$iv = (Iterable)schema2.getProcedureGroups();
                    Collection destination$iv$iv = new ArrayList<E>();
                    Iterator<Object> iterator = $receiver$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        T element$iv$iv = iterator.next();
                        it2 = (SybaseModProcedureGroup)element$iv$iv;
                        Iterable list$iv$iv = it2.getProcedures();
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    Iterable procedures = (List)destination$iv$iv;
                    Iterable iterable2 = schema2.getTables();
                    NamingIdentifyingFamily namingIdentifyingFamily = schema2.getViews();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.views");
                    $receiver$iv = CollectionsKt.plus((Iterable)iterable2, (Iterable)namingIdentifyingFamily);
                    for (T element$iv : $receiver$iv) {
                        it = (SybaseModLikeTable)element$iv;
                        it.getColumns().markChildrenAsSyncPending();
                    }
                    $receiver$iv = CollectionsKt.plus((Iterable)schema2.getFunctions(), (Iterable)procedures);
                    for (T element$iv : $receiver$iv) {
                        it = (SybaseModRoutine)element$iv;
                        it.getArguments().markChildrenAsSyncPending();
                    }
                    SybaseModMajorObject obj = null;
                    int objId = Integer.MIN_VALUE;
                    for (SybaseIntroQueries.OneColumnOrArgument ca : this.$cas$inlined) {
                        SybaseModProcedure procedure;
                        if (obj == null || objId != ca.id) {
                            obj = SybaseIntrospectorKt.access$findObjectById(schema2, ca.id);
                            objId = ca.id;
                            if (obj == null) continue;
                        }
                        DataType dt = SybaseIntrospectorKt.access$makeDataType(ca.type_name, ca.length, ca.prec, ca.scale, ca.variable);
                        if (obj instanceof SybaseModLikeTable) {
                            short that$iv;
                            short $receiver$iv2;
                            SybaseModLikeColumn column2 = (SybaseModLikeColumn)((SybaseModLikeTable)obj).getColumns().createOrGet(ca.name);
                            column2.setPosition(ca.colid);
                            column2.setDataType(dt);
                            short $i$a$1$flatMap = ca.bits1;
                            int list$iv$iv = 8;
                            SybaseModLikeColumn sybaseModLikeColumn = column2;
                            short $receiver$iv$iv2 = $receiver$iv2;
                            int n = Short.toUnsignedInt($receiver$iv$iv2);
                            $receiver$iv$iv2 = that$iv;
                            int n2 = n;
                            int n3 = Short.toUnsignedInt($receiver$iv$iv2);
                            short s = (short)(n2 & n3);
                            sybaseModLikeColumn.setNotNull(s == 0);
                            $receiver$iv2 = ca.bits2;
                            that$iv = 16;
                            sybaseModLikeColumn = column2;
                            $receiver$iv$iv2 = $receiver$iv2;
                            int n4 = Short.toUnsignedInt($receiver$iv$iv2);
                            $receiver$iv$iv2 = that$iv;
                            n2 = n4;
                            n3 = Short.toUnsignedInt($receiver$iv$iv2);
                            s = (short)(n2 & n3);
                            sybaseModLikeColumn.setComputed(s != 0);
                            if (column2 instanceof SybaseModTableColumn) {
                                $receiver$iv2 = ca.bits1;
                                that$iv = 128;
                                sybaseModLikeColumn = (SybaseModTableColumn)column2;
                                $receiver$iv$iv2 = $receiver$iv2;
                                n2 = Short.toUnsignedInt($receiver$iv$iv2);
                                s = (short)(n2 & (n3 = Short.toUnsignedInt($receiver$iv$iv2 = that$iv)));
                                sybaseModLikeColumn.setSequenceIdentity(s != 0 ? SybaseIntrospectorKt.access$getOurSybaseIdentity$p() : null);
                            }
                        }
                        if (obj instanceof BasicModRoutine) {
                            BasicModRoutine basicModRoutine = (BasicModRoutine)((Object)obj);
                            SybaseIntroQueries.OneColumnOrArgument oneColumnOrArgument = ca;
                            Intrinsics.checkExpressionValueIsNotNull((Object)oneColumnOrArgument, (String)"ca");
                            SybaseSchemaRetriever.access$addRoutineArgument(this.this$0, basicModRoutine, oneColumnOrArgument, dt);
                        }
                        if (!(obj instanceof SybaseModProcedureGroup)) continue;
                        SybaseModProcedure sybaseModProcedure = procedure = (SybaseModProcedure)((SybaseModProcedureGroup)obj).getProcedures().createOrGetAt(ca.procedure_position);
                        Intrinsics.checkExpressionValueIsNotNull((Object)sybaseModProcedure, (String)"procedure");
                        BasicModRoutine basicModRoutine = sybaseModProcedure;
                        SybaseIntroQueries.OneColumnOrArgument oneColumnOrArgument = ca;
                        Intrinsics.checkExpressionValueIsNotNull((Object)oneColumnOrArgument, (String)"ca");
                        SybaseSchemaRetriever.access$addRoutineArgument(this.this$0, basicModRoutine, oneColumnOrArgument, dt);
                    }
                    Iterable iterable3 = schema2.getTables();
                    NamingIdentifyingFamily namingIdentifyingFamily2 = schema2.getViews();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"schema.views");
                    Iterable $receiver$iv3 = CollectionsKt.plus((Iterable)iterable3, (Iterable)namingIdentifyingFamily2);
                    for (Object element$iv : $receiver$iv3) {
                        it2 = (SybaseModLikeTable)element$iv;
                        SybaseIntrospectorKt.access$finish((ModFamily)((Object)it2.getColumns()));
                    }
                    $receiver$iv3 = CollectionsKt.plus((Iterable)schema2.getFunctions(), (Iterable)procedures);
                    for (Object element$iv : $receiver$iv3) {
                        it2 = (SybaseModRoutine)element$iv;
                        SybaseIntrospectorKt.access$finish((ModFamily)((Object)it2.getArguments()));
                    }
                    $receiver$iv3 = schema2.getProcedureGroups();
                    for (Object element$iv : $receiver$iv3) {
                        it2 = (SybaseModProcedureGroup)element$iv;
                        it2.getProcedures().sort();
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void addRoutineArgument(BasicModRoutine routine, SybaseIntroQueries.OneColumnOrArgument ca, DataType dt) {
            BasicModArgument basicModArgument;
            boolean result2;
            int n;
            void $receiver$iv;
            short s = ca.bits2;
            short that$iv = 2;
            short $receiver$iv$iv = $receiver$iv;
            int n2 = Short.toUnsignedInt($receiver$iv$iv);
            boolean out = (short)(n2 & (n = Short.toUnsignedInt($receiver$iv$iv = that$iv))) != 0;
            boolean bl = result2 = out && Strings.eq((String)ca.name, (String)"Return Type", (boolean)false);
            if (result2) {
                basicModArgument = routine.createOrGetReturnArgument();
            } else {
                SybaseModArgument sybaseModArgument;
                BasicModRoutine basicModRoutine = routine;
                if (basicModRoutine instanceof SybaseModFunction) {
                    ModFamily modFamily = (ModFamily)((Object)((SybaseModFunction)routine).getArguments());
                    String string = ca.name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ca.name");
                    sybaseModArgument = SybaseIntrospectorKt.access$createOrGetByName(modFamily, string);
                } else if (basicModRoutine instanceof SybaseModProcedure) {
                    ModFamily modFamily = (ModFamily)((Object)((SybaseModProcedure)routine).getArguments());
                    String string = ca.name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ca.name");
                    sybaseModArgument = SybaseIntrospectorKt.access$createOrGetByName(modFamily, string);
                } else {
                    return;
                }
                basicModArgument = sybaseModArgument;
            }
            BasicModArgument argument = basicModArgument;
            argument.setPosition(ca.colid);
            argument.setDataType(dt);
            if (!result2) {
                argument.setArgumentDirection(out ? DasArgument.Direction.OUT : DasArgument.Direction.IN);
            }
        }

        private final void retrieveIndicesAndKeys() {
            if (((SybaseSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            this.progress("retrieving indices");
            List inds = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveIndices.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            SybaseSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, inds){
                final /* synthetic */ SybaseSchemaRetriever this$0;
                final /* synthetic */ List $inds$inlined;
                {
                    this.this$0 = sybaseSchemaRetriever;
                    this.$inds$inlined = list;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    SybaseModTable table = null;
                    int tableId = Integer.MIN_VALUE;
                    Iterable $receiver$iv = schema2.getTables();
                    for (Object element$iv : $receiver$iv) {
                        SybaseModTable it = (SybaseModTable)element$iv;
                        it.getIndices().markChildrenAsSyncPending();
                        it.getKeys().markChildrenAsSyncPending();
                    }
                    for (SybaseIntroQueries.OneIndex ind : this.$inds$inlined) {
                        void that$iv;
                        void $receiver$iv2;
                        int that$iv2;
                        int $receiver$iv3;
                        if (table == null || tableId != ind.id) {
                            if ((SybaseModTable)schema2.getTables().getByObjectId((long)ind.id) == null) {
                                continue;
                            }
                            tableId = ind.id;
                        }
                        SybaseModIndex index = (SybaseModIndex)table.getIndices().createOrGet(ind.name);
                        index.setPosition(ind.position);
                        short it = ind.bits2;
                        int $i$a$1$forEach = 8;
                        BasicModColumniation basicModColumniation = index;
                        int $receiver$iv$iv = $receiver$iv3;
                        int n = Short.toUnsignedInt((short)$receiver$iv$iv);
                        $receiver$iv$iv = that$iv2;
                        int n2 = n;
                        int n3 = Short.toUnsignedInt((short)$receiver$iv$iv);
                        short s = (short)(n2 & n3);
                        basicModColumniation.setNameSurrogate(s != 0);
                        $receiver$iv3 = ind.bits1;
                        that$iv2 = 16;
                        basicModColumniation = index;
                        $receiver$iv$iv = $receiver$iv3;
                        int n4 = Short.toUnsignedInt((short)$receiver$iv$iv);
                        $receiver$iv$iv = that$iv2;
                        n2 = n4;
                        n3 = Short.toUnsignedInt((short)$receiver$iv$iv);
                        s = (short)(n2 & n3);
                        basicModColumniation.setClustering(s != 0);
                        $receiver$iv3 = ind.bits1;
                        that$iv2 = 2;
                        basicModColumniation = index;
                        $receiver$iv$iv = $receiver$iv3;
                        int n5 = Short.toUnsignedInt((short)$receiver$iv$iv);
                        $receiver$iv$iv = that$iv2;
                        n2 = n5;
                        n3 = Short.toUnsignedInt((short)$receiver$iv$iv);
                        s = (short)(n2 & n3);
                        basicModColumniation.setUnique(s != 0);
                        if (ind.keys1 != null) {
                            byte[] keys;
                            Object object = ind.keys1;
                            if (object == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
                            }
                            byte[] keys1 = (byte[])object;
                            if (ind.keys2 == null) {
                                keys = keys1;
                            } else {
                                Object object2 = ind.keys2;
                                if (object2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
                                }
                                byte[] keys2 = (byte[])object2;
                                keys = new byte[keys1.length + keys2.length];
                                System.arraycopy(keys1, 0, keys, 0, keys1.length);
                                System.arraycopy(keys2, 0, keys, keys1.length, keys2.length);
                            }
                            SybaseModIndex sybaseModIndex = index;
                            Intrinsics.checkExpressionValueIsNotNull((Object)sybaseModIndex, (String)"index");
                            SybaseSchemaRetriever.access$peekIndexColumns(this.this$0, sybaseModIndex, keys);
                        }
                        short keys = ind.bits2;
                        that$iv2 = 2;
                        $receiver$iv$iv = $receiver$iv;
                        n2 = Short.toUnsignedInt((short)$receiver$iv$iv);
                        if ((short)(n2 & (n3 = Short.toUnsignedInt((short)($receiver$iv$iv = that$iv2)))) == 0) continue;
                        SybaseModKey key2 = (SybaseModKey)table.getKeys().createOrGet(ind.name);
                        key2.setNameSurrogate(index.isNameSurrogate());
                        key2.setUnderlyingIndexName(ind.name);
                        key2.setUnderlyingIndexPosition(ind.position);
                        that$iv2 = ind.bits1;
                        $receiver$iv$iv = 2048;
                        basicModColumniation = key2;
                        void $receiver$iv$iv2 = $receiver$iv2;
                        int n6 = Short.toUnsignedInt((short)$receiver$iv$iv2);
                        $receiver$iv$iv2 = that$iv;
                        n3 = n6;
                        int n7 = Short.toUnsignedInt((short)$receiver$iv$iv2);
                        s = (short)(n3 & n7);
                        basicModColumniation.setPrimary(s != 0);
                        key2.setColNames(index.getColNames());
                    }
                    $receiver$iv = schema2.getTables();
                    for (Object element$iv : $receiver$iv) {
                        SybaseModTable it = (SybaseModTable)element$iv;
                        SybaseIntrospectorKt.access$finish((ModFamily)((Object)it.getIndices()));
                        SybaseIntrospectorKt.access$finish((ModFamily)((Object)it.getKeys()));
                    }
                }
            });
        }

        private final void peekIndexColumns(SybaseModIndex index, byte[] keys) {
            short[] positions = this.peekColumnPositions(keys);
            ImmutableList.Builder names = ImmutableList.builder();
            for (short position : positions) {
                Object v0;
                block2: {
                    if (position == 0) break;
                    Iterable $receiver$iv = index.getTable().getColumns();
                    for (Object element$iv : $receiver$iv) {
                        SybaseModTableColumn column2 = (SybaseModTableColumn)element$iv;
                        if (!(column2.getPosition() == position)) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                SybaseModTableColumn column3 = v0;
                if (column3 == null) continue;
                names.add((Object)column3.getName());
            }
            index.setColNames((List)names.build());
        }

        /*
         * WARNING - void declaration
         */
        private final short[] peekColumnPositions(byte[] keys) {
            int n = (keys.length + 7) / 16;
            short[] positions = new short[n];
            int n2 = 0;
            int n3 = n - 1;
            if (n2 <= n3) {
                while (true) {
                    short position;
                    void i2;
                    int offset = i2 << 4 | 4;
                    positions[i2] = position = SybaseIntrospectorKt.peek16(keys, offset);
                    if (position == 0 || i2 == n3) break;
                    ++i2;
                }
            }
            return positions;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveForeignKeys() {
            void wides;
            if (((SybaseSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            this.progress("retrieving foreign keys");
            List fks = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveForeignKeys.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            SybaseSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(fks, (Ref.BooleanRef)wides){
                final /* synthetic */ List $fks$inlined;
                final /* synthetic */ Ref.BooleanRef $wides$inlined;
                {
                    this.$fks$inlined = list;
                    this.$wides$inlined = booleanRef;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    Iterable $receiver$iv = schema2.getTables();
                    for (T element$iv : $receiver$iv) {
                        SybaseModTable it = (SybaseModTable)element$iv;
                        it.getForeignKeys().markChildrenAsSyncPending();
                    }
                    for (SybaseIntroQueries.OneForeignKey fk : this.$fks$inlined) {
                        short n;
                        SybaseModTable table;
                        if ((SybaseModTable)schema2.getTables().getByObjectId(fk.source_table_id) == null) {
                            continue;
                        }
                        SybaseModForeignKey foreignKey = (SybaseModForeignKey)table.getForeignKeys().renew(fk.source_constraint_id, fk.source_constraint_name);
                        foreignKey.setNameSurrogate(SybaseIntrospectorKt.access$detectSurrogateName(fk.source_constraint_name, fk.source_constraint_id));
                        SybaseModTable targetTable = (SybaseModTable)schema2.getTables().getByObjectId(fk.target_table_id);
                        if (targetTable != null) {
                            Object v1;
                            block13: {
                                foreignKey.setRefTableName(targetTable.getRealName());
                                Iterable $receiver$iv2 = targetTable.getKeys();
                                for (T element$iv : $receiver$iv2) {
                                    SybaseModKey k = (SybaseModKey)element$iv;
                                    if (!(k.getUnderlyingIndexPosition() == fk.target_index_position)) continue;
                                    v1 = element$iv;
                                    break block13;
                                }
                                v1 = null;
                            }
                            SybaseModKey targetKey = v1;
                            if (targetKey != null) {
                                foreignKey.setRefKeyName(targetKey.getRealName());
                                foreignKey.setRefColNames(targetKey.getColNames());
                            } else {
                                SybaseModIndex targetIndex = (SybaseModIndex)targetTable.getIndices().getByNaturalPosition(fk.target_index_position);
                                if (targetIndex != null) {
                                    foreignKey.setRefColNames(targetIndex.getColNames());
                                }
                            }
                        }
                        if ((n = fk.involved_columns_count) <= 4) {
                            short[] columnPositions = new short[n];
                            if (n >= 1) {
                                columnPositions[0] = fk.column_position_1;
                            }
                            if (n >= 2) {
                                columnPositions[1] = fk.column_position_2;
                            }
                            if (n >= 3) {
                                columnPositions[2] = fk.column_position_3;
                            }
                            if (n >= 4) {
                                columnPositions[3] = fk.column_position_4;
                            }
                            SybaseModForeignKey sybaseModForeignKey = foreignKey;
                            Intrinsics.checkExpressionValueIsNotNull((Object)sybaseModForeignKey, (String)"foreignKey");
                            SybaseIntrospectorKt.access$assignForeignKeyColumns(sybaseModForeignKey, columnPositions);
                            continue;
                        }
                        this.$wides$inlined.element = true;
                    }
                }
            });
            if (wides.element) {
                List wfks = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveForeignKeysWideColumnLists.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
                SybaseSchemaRetriever this_$iv2 = this;
                BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv2).modify((BasicElement)this_$iv2.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv2).this$0), new ModelModifier<MS>(wfks){
                    final /* synthetic */ List $wfks$inlined;
                    {
                        this.$wfks$inlined = list;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void perform(MS schema) {
                        MS MS = schema;
                        Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                        SybaseModSchema schema2 = (SybaseModSchema)MS;
                        for (int[] wfk : this.$wfks$inlined) {
                            SybaseModForeignKey foreignKey;
                            int n;
                            int constraintId = wfk[0];
                            if (SybaseIntrospectorKt.access$findForeignKeyById(schema2, constraintId) == null) {
                                continue;
                            }
                            for (n = 0; n < 16 && wfk[n + 1] > 0; ++n) {
                            }
                            short[] columnPositions = new short[n];
                            int n2 = 0;
                            int n3 = n;
                            while (n2 < n3) {
                                void i2;
                                columnPositions[i2] = (short)wfk[i2 + true];
                                ++i2;
                            }
                            SybaseIntrospectorKt.access$assignForeignKeyColumns(foreignKey, columnPositions);
                        }
                    }
                });
            }
            this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(){

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    Iterable $receiver$iv = schema2.getTables();
                    for (T element$iv : $receiver$iv) {
                        SybaseModTable it = (SybaseModTable)element$iv;
                        SybaseIntrospectorKt.access$finish((ModFamily)((Object)it.getForeignKeys()));
                    }
                }
            });
        }

        private final void retrieveCheckConstraints() {
            if (((SybaseSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            this.progress("retrieving check constraints");
            List cs = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveChecks.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            SybaseSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(cs){
                final /* synthetic */ List $cs$inlined;
                {
                    this.$cs$inlined = list;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void perform(MS schema) {
                    SybaseModTable it;
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    Iterable $receiver$iv = schema2.getTables();
                    for (Object element$iv : $receiver$iv) {
                        it = (SybaseModTable)element$iv;
                        it.getChecks().markChildrenAsSyncPending();
                    }
                    for (SybaseIntroQueries.OneCheck c : this.$cs$inlined) {
                        BasicElement basicElement;
                        SybaseModTable table;
                        if ((SybaseModTable)schema2.getTables().getByObjectId(c.table_id) == null) {
                            continue;
                        }
                        SybaseModCheck check = (SybaseModCheck)table.getChecks().renew(c.constraint_id, c.constraint_name);
                        check.setNameSurrogate(SybaseIntrospectorKt.access$detectSurrogateName(c.constraint_name, c.constraint_id));
                        if (c.definition != null) {
                            String s;
                            int len;
                            void $receiver$iv2;
                            String string;
                            int p = StringsKt.indexOf$default((CharSequence)c.definition, (String)"CHECK", (int)0, (boolean)false, (int)6, null);
                            p = p >= 0 ? p + 5 : 0;
                            String string2 = string = c.definition;
                            if (string2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string3 = string2.substring(p);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                            string = string3;
                            CharSequence $receiver$iv$iv = (CharSequence)$receiver$iv2;
                            int startIndex$iv$iv = 0;
                            int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                            boolean startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                boolean match$iv$iv;
                                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                char it2 = $receiver$iv$iv.charAt(index$iv$iv);
                                boolean bl = match$iv$iv = it2 <= ' ';
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            if ((len = (s = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length()) >= 3 && s.charAt(0) == '(' && s.charAt(len - 1) == ')') {
                                void $receiver$iv3;
                                $receiver$iv$iv = s;
                                startIndex$iv$iv = 1;
                                endIndex$iv$iv = len - 1;
                                CharSequence charSequence = $receiver$iv$iv;
                                if (charSequence == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                String string4 = ((String)charSequence).substring(startIndex$iv$iv, endIndex$iv$iv);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                $receiver$iv$iv = string4;
                                CharSequence $receiver$iv$iv2 = (CharSequence)$receiver$iv3;
                                int startIndex$iv$iv2 = 0;
                                int endIndex$iv$iv2 = $receiver$iv$iv2.length() - 1;
                                boolean startFound$iv$iv2 = false;
                                while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                                    boolean match$iv$iv;
                                    int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                                    char it3 = $receiver$iv$iv2.charAt(index$iv$iv);
                                    boolean bl = match$iv$iv = it3 <= ' ';
                                    if (!startFound$iv$iv2) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv2 = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv2;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv2;
                                }
                                s = ((Object)$receiver$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
                            }
                            check.setPredicate(s);
                        } else {
                            check.setPredicate(null);
                        }
                        if (c.column_position > 0) {
                            Object v7;
                            block18: {
                                Iterable $receiver$iv4 = check.getTable().getColumns();
                                for (T element$iv : $receiver$iv4) {
                                    SybaseModTableColumn col = (SybaseModTableColumn)element$iv;
                                    if (!(col.getPosition() == c.column_position)) continue;
                                    v7 = element$iv;
                                    break block18;
                                }
                                v7 = null;
                            }
                            basicElement = v7;
                        } else {
                            basicElement = null;
                        }
                        BasicElement column2 = basicElement;
                        check.setColNames(column2 != null ? Collections.singletonList(column2.getName()) : CollectionsKt.emptyList());
                    }
                    $receiver$iv = schema2.getTables();
                    for (Object element$iv : $receiver$iv) {
                        it = (SybaseModTable)element$iv;
                        SybaseIntrospectorKt.access$finish((ModFamily)((Object)it.getChecks()));
                    }
                }
            });
        }

        private final void retrieveDefaults() {
            this.progress("retrieving defaults");
            List ds = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveDefaults.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            if (ds.isEmpty()) {
                return;
            }
            SybaseSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(ds){
                final /* synthetic */ List $ds$inlined;
                {
                    this.$ds$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    SybaseModTable obj = null;
                    int objectId = Integer.MIN_VALUE;
                    for (SybaseIntroQueries.OneDefault d : this.$ds$inlined) {
                        SybaseModTableColumn column2;
                        Object v8;
                        String def2;
                        block17: {
                            boolean match$iv$iv;
                            char it;
                            int index$iv$iv;
                            if (obj == null || objectId != d.id) {
                                obj = (SybaseModTable)schema2.getTables().getByObjectId(d.id);
                                objectId = d.id;
                                if (obj == null) continue;
                            }
                            String $receiver$iv = d.text;
                            CharSequence $receiver$iv$iv22 = $receiver$iv;
                            int startIndex$iv$iv = 0;
                            int endIndex$iv$iv = $receiver$iv$iv22.length() - 1;
                            boolean startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                it = $receiver$iv$iv22.charAt(index$iv$iv);
                                boolean bl = match$iv$iv = it <= ' ';
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            if (StringsKt.startsWith$default((String)(def2 = ((Object)$receiver$iv$iv22.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (String)"DEFAULT", (boolean)false, (int)2, null)) {
                                $receiver$iv = def2;
                                int $receiver$iv$iv22 = 8;
                                String string = $receiver$iv;
                                if (string == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                String string2 = string.substring($receiver$iv$iv22);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                                $receiver$iv = string2;
                                $receiver$iv$iv22 = $receiver$iv;
                                startIndex$iv$iv = 0;
                                endIndex$iv$iv = $receiver$iv$iv22.length() - 1;
                                startFound$iv$iv = false;
                                while (startIndex$iv$iv <= endIndex$iv$iv) {
                                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                    it = $receiver$iv$iv22.charAt(index$iv$iv);
                                    boolean bl = match$iv$iv = it <= ' ';
                                    if (!startFound$iv$iv) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv;
                                }
                                def2 = ((Object)$receiver$iv$iv22.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                            } else if (StringsKt.startsWith$default((String)def2, (String)"AS", (boolean)false, (int)2, null)) {
                                $receiver$iv = def2;
                                int $receiver$iv$iv = 3;
                                String string = $receiver$iv;
                                if (string == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                String string3 = string.substring($receiver$iv$iv);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                                $receiver$iv = string3;
                                $receiver$iv$iv22 = $receiver$iv;
                                startIndex$iv$iv = 0;
                                endIndex$iv$iv = $receiver$iv$iv22.length() - 1;
                                startFound$iv$iv = false;
                                while (startIndex$iv$iv <= endIndex$iv$iv) {
                                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                    it = $receiver$iv$iv22.charAt(index$iv$iv);
                                    boolean bl = match$iv$iv = it <= ' ';
                                    if (!startFound$iv$iv) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv;
                                }
                                def2 = ((Object)$receiver$iv$iv22.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                            }
                            PositioningNamingFamily columns2 = obj.getColumns();
                            Iterable $receiver$iv2 = columns2;
                            for (T element$iv : $receiver$iv2) {
                                SybaseModTableColumn col = (SybaseModTableColumn)element$iv;
                                if (!(col.getPosition() == d.position)) continue;
                                v8 = element$iv;
                                break block17;
                            }
                            v8 = null;
                        }
                        if ((column2 = (SybaseModTableColumn)v8) == null) continue;
                        column2.setDefaultExpression(def2);
                    }
                }
            });
        }

        private final void retrieveTriggers() {
            if (((SybaseSchema)this.getSchema()).getTables().isEmpty() && ((SybaseSchema)this.getSchema()).getViews().isEmpty()) {
                return;
            }
            this.progress("retrieving triggers");
            List ts2 = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveTriggers.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.schemaId, this.schemaId}).run();
            SybaseSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(ts2){
                final /* synthetic */ List $ts$inlined;
                {
                    this.$ts$inlined = list;
                }

                public final void perform(MS schema) {
                    SybaseModLikeTable it;
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    Iterable iterable = schema2.getTables();
                    NamingIdentifyingFamily namingIdentifyingFamily = schema2.getViews();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.views");
                    Iterable $receiver$iv = CollectionsKt.plus((Iterable)iterable, (Iterable)namingIdentifyingFamily);
                    for (Object element$iv : $receiver$iv) {
                        it = (SybaseModLikeTable)element$iv;
                        it.getTriggers().markChildrenAsSyncPending();
                    }
                    for (SybaseIntroQueries.OneTrigger t : this.$ts$inlined) {
                        SybaseModLikeTable table;
                        SybaseModTable sybaseModTable = (SybaseModTable)schema2.getTables().getByObjectId(t.table_id);
                        if ((sybaseModTable != null ? (SybaseModLikeTable)sybaseModTable : (SybaseModLikeTable)schema2.getViews().getByObjectId(t.table_id)) == null) {
                            continue;
                        }
                        table = table;
                        SybaseModTrigger trigger = (SybaseModTrigger)table.getTriggers().renew(t.trig_id, t.trig_name);
                        TrigEvent event = TrigEvent.of((char)t.event_code);
                        SybaseIntrospectorKt.access$addEvent(trigger, event);
                        trigger.setTurn(t.turn_code == 'I' ? TrigTurn.INSTEAD_OF : TrigTurn.ALSO);
                    }
                    Iterable iterable2 = schema2.getTables();
                    NamingIdentifyingFamily namingIdentifyingFamily2 = schema2.getViews();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"schema.views");
                    $receiver$iv = CollectionsKt.plus((Iterable)iterable2, (Iterable)namingIdentifyingFamily2);
                    for (Object element$iv : $receiver$iv) {
                        it = (SybaseModLikeTable)element$iv;
                        SybaseIntrospectorKt.access$finish((ModFamily)((Object)it.getTriggers()));
                    }
                }
            });
        }

        private final void retrieveSources() {
            if (Intrinsics.areEqual((Object)((Object)SybaseIntrospector.this.getOptions().getSources()), (Object)((Object)DBIntrospectionOptions.SourceLoading.NO_SOURCES))) {
                return;
            }
            if (((SybaseSchema)this.getSchema()).getTables().isEmpty() && ((SybaseSchema)this.getSchema()).getViews().isEmpty() && ((SybaseSchema)this.getSchema()).getProcedureGroups().isEmpty() && ((SybaseSchema)this.getSchema()).getFunctions().isEmpty()) {
                return;
            }
            List ss = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveSources.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.schemaId, this.schemaId}).run();
            if (ss.isEmpty()) {
                return;
            }
            Iterable ts2 = BaseIntrospectionFunctions.group(ss, retrieveSources.ts.1.INSTANCE, retrieveSources.ts.2.INSTANCE, retrieveSources.ts.3.INSTANCE);
            SybaseIntrospector this_$iv = SybaseIntrospector.this;
            this_$iv.getModel().writeSources(new Runnable(this, ts2){
                final /* synthetic */ SybaseSchemaRetriever this$0;
                final /* synthetic */ Iterable $ts$inlined;
                {
                    this.this$0 = sybaseSchemaRetriever;
                    this.$ts$inlined = iterable;
                }

                public final void run() {
                    SybaseSchemaRetriever this_$iv = this.this$0;
                    BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), (ModelModifier)new ModelModifier<MS>(this){
                        final /* synthetic */ SybaseSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void perform(MS schema) {
                            MS MS = schema;
                            Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                            SybaseModSchema schema2 = (SybaseModSchema)MS;
                            for (SrcText t : this.this$0.$ts$inlined) {
                                BasicNode basicNode;
                                BasicNode basicNode2;
                                BasicModSourceAware o = t.getMinor_kind() == 'G' ? (BasicModSourceAware)((basicNode2 = SybaseIntrospectorKt.access$findTableOrView(schema2, t.getMajor_kind(), t.getMajor_id())) != null && (basicNode2 = basicNode2.getTriggers()) != null ? (SybaseModTrigger)basicNode2.getByObjectId(t.getMinor_id()) : null) : (t.getMajor_kind() == 'V' ? (BasicModSourceAware)schema2.getViews().getByObjectId(t.getMajor_id()) : (t.getMajor_kind() == 'F' ? (BasicModSourceAware)schema2.getFunctions().getByObjectId(t.getMajor_id()) : (t.getMajor_kind() == 'P' ? (BasicModSourceAware)((basicNode = (SybaseModProcedureGroup)schema2.getProcedureGroups().getByObjectId(t.getMajor_id())) != null && (basicNode = basicNode.getProcedures()) != null ? (SybaseModProcedure)basicNode.getByNaturalPosition((short)t.getMinor_id()) : null) : null)));
                                if (o == null) {
                                    continue;
                                }
                                String string = t.getText();
                                o.setSourceText(string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.ORIGINAL_TEXT) : null);
                            }
                        }
                    });
                }
            });
        }

        @Override
        protected void finishSchema() {
            super.finishSchema();
            SybaseSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ SybaseSchemaRetriever this$0;
                {
                    this.this$0 = sybaseSchemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    schema2.setIntrospectionTimestamp(this.this$0.getIntrospectionBeginTimestamp$database_introspection());
                }
            });
        }

        private final void progress(String what) {
            String mode = this.getMode$database_introspection().increment ? "incrementally" : "completely";
            String string = String.format("Introspecting schema %s (%s)", ((SybaseSchema)this.getSchema()).getName(), mode);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"format(\"Introspecting sc\u2026(%s)\", schema.name, mode)");
            SybaseIntrospector.this.updateStatus(string, what);
        }

        public SybaseSchemaRetriever(@NotNull DBTransaction transaction, SybaseSchema schema) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((BaseIntrospector)SybaseIntrospector.this, transaction, (BasicSchema)schema);
            this.schemaId = (int)schema.getObjectId();
            SybaseDatabase db = schema.getDatabase();
            if (db == null || db.isCurrent()) {
                string = "dbo";
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                char c = '[';
                String string2 = db.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"db.name");
                String string3 = string2;
                StringBuilder stringBuilder2 = stringBuilder;
                String string4 = String.valueOf(c) + string3;
                string = stringBuilder2.append(string4).append("].dbo").toString();
            }
            String catalogPrefix = string;
            StringOperator stringOperator = QueryRewriters.substitute("#CAT", catalogPrefix);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringOperator, (String)"substitute(\"#CAT\", catalogPrefix)");
            this.rewriter = stringOperator;
        }

        public static final /* synthetic */ boolean access$getWasProcedures$p(SybaseSchemaRetriever $this) {
            return $this.wasProcedures;
        }

        public static final /* synthetic */ void access$setWasProcedures$p(SybaseSchemaRetriever $this, boolean bl) {
            $this.wasProcedures = bl;
        }

        public static final /* synthetic */ void access$addRoutineArgument(SybaseSchemaRetriever $this, @NotNull BasicModRoutine routine, @NotNull SybaseIntroQueries.OneColumnOrArgument ca, @NotNull DataType dt) {
            $this.addRoutineArgument(routine, ca, dt);
        }

        public static final /* synthetic */ void access$peekIndexColumns(SybaseSchemaRetriever $this, @NotNull SybaseModIndex index, @NotNull byte[] keys) {
            $this.peekIndexColumns(index, keys);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/introspection/SybaseIntrospector$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "database-introspection"})
    public static final class VERSION
    extends PerObjectVersion {
        public static final VERSION INSTANCE;

        private VERSION() {
        }

        static {
            VERSION vERSION;
            INSTANCE = vERSION = new VERSION();
        }
    }
}

