/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.families.Family;
import com.intellij.database.scripting.AbortException;
import com.intellij.database.scripting.AbstractCodeGenerator$WhenMappings;
import com.intellij.database.scripting.AbstractCodeGeneratorKt$sam$Condition$e0aa8746;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.NamingService;
import com.intellij.database.scripting.NamingServices;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingHelper;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingOrder;
import com.intellij.database.scripting.SimpleCompositeText;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u00104\u001a\u0002002\u0006\u00105\u001a\u00020\u0011H\u0014J,\u00106\u001a\u0002072\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u00108\u001a\u0002002\f\u00109\u001a\b\u0012\u0004\u0012\u0002070:H\u0004J\u0010\u0010;\u001a\u0002072\u0006\u00105\u001a\u00020\u0011H\u0014J\b\u0010<\u001a\u000207H\u0016J\u0010\u0010=\u001a\u0002072\u0006\u00105\u001a\u00020\u0011H$J\b\u0010>\u001a\u000207H\u0014J\b\u0010?\u001a\u000207H\u0014J\b\u0010@\u001a\u000207H\u0002J\u0010\u0010@\u001a\u0002072\u0006\u0010A\u001a\u00020BH\u0004J\u0010\u0010C\u001a\u0002072\u0006\u00105\u001a\u00020\u0011H\u0004J\u0010\u0010D\u001a\u0002072\u0006\u00105\u001a\u00020\u0011H\u0004J$\u0010E\u001a\u0002072\u0006\u00105\u001a\u00020\u00112\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002000GH\u0014J)\u0010E\u001a\u0002072\u0006\u00105\u001a\u00020\u00112\u0012\u0010H\u001a\n\u0012\u0006\b\u0001\u0012\u00020J0I\"\u00020JH\u0014\u00a2\u0006\u0002\u0010KJ\u0010\u0010L\u001a\u00020(2\u0006\u0010M\u001a\u00020NH\u0014J\u0014\u0010O\u001a\u0002072\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00110+J\u0012\u0010Q\u001a\u0002002\b\u0010R\u001a\u0004\u0018\u00010(H\u0014J\f\u0010S\u001a\u00020(*\u00020\u0011H\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@BX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R \u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110$X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0019\u0010'\u001a\u00020(*\u00020(8\u00c4\u0002X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u001f\u0010'\u001a\u00020(*\b\u0012\u0004\u0012\u00020(0+8\u00c4\u0002X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010,R\u0018\u0010-\u001a\u00020(*\u00020(8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010*R\u0018\u0010/\u001a\u000200*\u0002018DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u0006T"}, d2={"Lcom/intellij/database/scripting/AbstractCodeGenerator;", "", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptCategory;)V", "builder", "Lcom/intellij/database/scripting/CodeTextBuilder;", "getBuilder", "()Lcom/intellij/database/scripting/CodeTextBuilder;", "getCategory", "()Lcom/intellij/database/scripting/ScriptCategory;", "getContext", "()Lcom/intellij/database/scripting/ScriptingContext;", "deck", "Ljava/util/Deque;", "Lcom/intellij/database/model/basic/BasicElement;", "getDeck", "()Ljava/util/Deque;", "helper", "Lcom/intellij/database/scripting/ScriptingHelper;", "getHelper", "()Lcom/intellij/database/scripting/ScriptingHelper;", "<set-?>", "Lcom/intellij/database/scripting/ScriptLocus;", "locus", "getLocus", "()Lcom/intellij/database/scripting/ScriptLocus;", "setLocus", "(Lcom/intellij/database/scripting/ScriptLocus;)V", "naming", "Lcom/intellij/database/scripting/NamingService;", "getNaming", "()Lcom/intellij/database/scripting/NamingService;", "postponed", "Lcom/intellij/util/containers/MultiMap;", "getPostponed", "()Lcom/intellij/util/containers/MultiMap;", "scr", "", "getScr", "(Ljava/lang/String;)Ljava/lang/String;", "", "(Ljava/lang/Iterable;)Ljava/lang/String;", "sqlString", "getSqlString", "useName", "", "Lcom/intellij/database/model/basic/BasicNamedElement;", "getUseName", "(Lcom/intellij/database/model/basic/BasicNamedElement;)Z", "canQualify", "element", "coding", "", "indent", "block", "Lkotlin/Function0;", "finishElement", "generate", "generateElement", "generateFooting", "generateHeading", "postStatement", "statement", "Lcom/intellij/database/scripting/CompositeText;", "process", "processElement", "processInnerElements", "condition", "Lkotlin/Function1;", "kinds", "", "Lcom/intellij/database/model/ObjectKind;", "(Lcom/intellij/database/model/basic/BasicElement;[Lcom/intellij/database/model/ObjectKind;)V", "script", "d", "Lcom/intellij/database/model/DataType;", "setElementsToGenerate", "elements", "useSchemaName", "schemaName", "currentScopeName", "database-scripting"})
public abstract class AbstractCodeGenerator {
    @NotNull
    private final NamingService naming;
    @NotNull
    private final ScriptingHelper helper;
    @NotNull
    private final Deque<BasicElement> deck;
    @NotNull
    private final MultiMap<BasicElement, BasicElement> postponed;
    @NotNull
    private final CodeTextBuilder builder;
    @NotNull
    private ScriptLocus locus;
    @NotNull
    private final ScriptingContext context;
    @NotNull
    private final ScriptCategory category;

    @NotNull
    protected final NamingService getNaming() {
        return this.naming;
    }

    @NotNull
    protected final ScriptingHelper getHelper() {
        return this.helper;
    }

    @NotNull
    protected final Deque<BasicElement> getDeck() {
        return this.deck;
    }

    @NotNull
    protected final MultiMap<BasicElement, BasicElement> getPostponed() {
        return this.postponed;
    }

    @NotNull
    protected final CodeTextBuilder getBuilder() {
        return this.builder;
    }

    @NotNull
    protected final ScriptLocus getLocus() {
        return this.locus;
    }

    private final void setLocus(ScriptLocus scriptLocus) {
        this.locus = scriptLocus;
    }

    public final void setElementsToGenerate(@NotNull Iterable<? extends BasicElement> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        for (BasicElement basicElement : elements) {
            this.deck.offer(basicElement);
        }
    }

    public void generate() {
        this.generateHeading();
        while ((Intrinsics.areEqual((Object)((Object)this.category.getOrder()), (Object)((Object)ScriptingOrder.REVERS_ORDER)) ? this.deck.pollLast() : this.deck.poll()) != null) {
            BasicElement element;
            element = element;
            if (element.isAutoCreated()) continue;
            this.process(element);
        }
        this.generateFooting();
    }

    protected void generateHeading() {
    }

    protected void generateFooting() {
    }

    protected final void process(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (!this.context.getGenerated().contains(element)) {
            if (Intrinsics.areEqual((Object)((Object)this.category.getOrder()), (Object)((Object)ScriptingOrder.NORMAL_ORDER))) {
                Iterable<? extends BasicElement> predecessors = element.getPredecessors();
                boolean postpone = false;
                for (BasicElement basicElement : predecessors) {
                    if (this.context.getGenerated().contains(basicElement) || !this.deck.contains(basicElement)) continue;
                    this.postponed.putValue((Object)basicElement, (Object)element);
                    postpone = true;
                }
                if (postpone) {
                    return;
                }
            }
            this.processElement(element);
            if (!this.context.getGenerated().contains(element)) {
                return;
            }
        }
        if (Intrinsics.areEqual((Object)((Object)this.locus), (Object)((Object)ScriptLocus.IN_SCHEMA)) || Intrinsics.areEqual((Object)((Object)this.locus), (Object)((Object)ScriptLocus.OUTSIDE))) {
            Collection collection = this.postponed.get((Object)element);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"postponed[element]");
            Iterable pendingElements = collection;
            for (BasicElement pendingElement : pendingElements) {
                this.process(pendingElement);
            }
        }
    }

    protected final void processElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        try {
            this.generateElement(element);
            this.finishElement(element);
        }
        catch (AbortException abortException) {
            // empty catch block
        }
    }

    protected void finishElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.context.getGenerated().add(element);
    }

    protected abstract void generateElement(@NotNull BasicElement var1);

    protected void processInnerElements(@NotNull BasicElement element, ObjectKind ... kinds) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)kinds, (String)"kinds");
        ArrayList innerElements = new ArrayList();
        for (ObjectKind kind : kinds) {
            Family<? extends BasicElement> f = element.familyOf(kind);
            if (f == null) continue;
            CollectionsKt.addAll((Collection)innerElements, (Iterable)f);
        }
        int n = innerElements.size();
        if (n == 0) {
            return;
        }
        if (n >= 2 && Intrinsics.areEqual((Object)((Object)this.category.getOrder()), (Object)((Object)ScriptingOrder.REVERS_ORDER))) {
            Collections.reverse(innerElements);
        }
        Iterator iterator = innerElements.iterator();
        while (iterator.hasNext()) {
            BasicElement innerElement;
            BasicElement basicElement = innerElement = (BasicElement)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"innerElement");
            this.process(basicElement);
        }
    }

    protected void processInnerElements(@NotNull BasicElement element, @NotNull Function1<? super BasicElement, Boolean> condition) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
        Function1<? super BasicElement, Boolean> function1 = condition;
        List innerElements = ModelFun.iterateChildren(element).filter((Condition)new AbstractCodeGeneratorKt$sam$Condition$e0aa8746(function1)).toList();
        int n = innerElements.size();
        if (n == 0) {
            return;
        }
        if (n >= 2 && Intrinsics.areEqual((Object)((Object)this.category.getOrder()), (Object)((Object)ScriptingOrder.REVERS_ORDER))) {
            innerElements = CollectionsKt.toList((Iterable)CollectionsKt.reversed((Iterable)innerElements));
        }
        Iterator iterator = innerElements.iterator();
        while (iterator.hasNext()) {
            BasicElement innerElement;
            BasicElement basicElement = innerElement = (BasicElement)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"innerElement");
            this.process(basicElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void coding(@Nullable ScriptLocus locus, boolean indent, @NotNull Function0<Unit> block) {
        boolean complete;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        ScriptLocus oldContext = this.locus;
        ScriptLocus scriptLocus = locus;
        if (scriptLocus == null) {
            scriptLocus = Intrinsics.areEqual((Object)((Object)oldContext), (Object)((Object)ScriptLocus.OUTSIDE)) ? ScriptLocus.IN_STATEMENT : oldContext;
        }
        ScriptLocus newContext = scriptLocus;
        CodeTextBuilder.IndentationState savedIndentation = this.builder.getCurrentIndentationState();
        try {
            this.locus = newContext;
            if (indent) {
                CodeTextBuilder.indent$default(this.builder, null, 1, null);
            }
            block.invoke();
            this.builder.returnToIndentation(savedIndentation);
            this.locus = oldContext;
        }
        catch (Throwable throwable) {
            boolean complete2;
            this.builder.returnToIndentation(savedIndentation);
            this.locus = oldContext;
            boolean bl = complete2 = Intrinsics.areEqual((Object)((Object)oldContext), (Object)((Object)ScriptLocus.OUTSIDE)) && Intrinsics.areEqual((Object)((Object)newContext), (Object)((Object)ScriptLocus.OUTSIDE)) ^ true && this.builder.isNotEmpty();
            if (complete2) {
                this.postStatement();
            }
            throw throwable;
        }
        boolean bl = complete = Intrinsics.areEqual((Object)((Object)oldContext), (Object)((Object)ScriptLocus.OUTSIDE)) && Intrinsics.areEqual((Object)((Object)newContext), (Object)((Object)ScriptLocus.OUTSIDE)) ^ true && this.builder.isNotEmpty();
        if (complete) {
            this.postStatement();
        }
    }

    public static /* bridge */ /* synthetic */ void coding$default(AbstractCodeGenerator abstractCodeGenerator, ScriptLocus scriptLocus, boolean bl, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: coding");
        }
        if ((n & 1) != 0) {
            scriptLocus = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        abstractCodeGenerator.coding(scriptLocus, bl, (Function0<Unit>)function0);
    }

    private final void postStatement() {
        if (this.builder.isNotEmpty()) {
            this.postStatement(new SimpleCompositeText(this.builder));
        }
        this.builder.clearAll();
    }

    protected final void postStatement(@NotNull CompositeText statement) {
        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
        this.context.getScript().add(statement);
    }

    @NotNull
    protected final String getScr(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return this.naming.nameToScript($receiver);
    }

    @NotNull
    protected final String getScr(@NotNull Iterable<String> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return CollectionsKt.joinToString$default($receiver, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>(this){
            final /* synthetic */ AbstractCodeGenerator this$0;

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String $receiver$iv = it;
                AbstractCodeGenerator this_$iv = this.this$0;
                return AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
            }
            {
                this.this$0 = abstractCodeGenerator;
                super(1);
            }
        }), (int)31, null);
    }

    protected final boolean getUseName(@NotNull BasicNamedElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver.getName(), (Object)ModelConsts.NO_NAME) ^ true && (!$receiver.isNameSurrogate() || this.context.getOptions().get(ScriptingOptionStatic.CONSIDER_SURROGATE_NAMES) != false);
    }

    protected boolean canQualify(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String currentScopeName(@NotNull BasicElement $receiver) {
        String string;
        String name;
        block13: {
            String string2;
            block12: {
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                string2 = $receiver.getRealName();
                if (string2 == null) break block12;
                String string3 = string2;
                AbstractCodeGenerator this_$iv = this;
                string2 = this_$iv.naming.nameToScript((String)$receiver$iv);
                if (string2 != null) break block13;
            }
            string2 = name = "???";
        }
        if (!this.canQualify($receiver)) {
            return name;
        }
        BasicElement basicElement = $receiver;
        if (basicElement instanceof BasicSchemaObject) {
            String string4;
            String schemaName = ((BasicSchemaObject)$receiver).getSchemaName();
            if (schemaName != null && this.useSchemaName(schemaName)) {
                void $receiver$iv2;
                void this_$iv;
                String string5 = schemaName;
                AbstractCodeGenerator abstractCodeGenerator = this;
                StringBuilder stringBuilder = new StringBuilder();
                String string6 = ((AbstractCodeGenerator)this_$iv).naming.nameToScript((String)$receiver$iv2);
                string4 = stringBuilder.append(string6).append(".").toString();
            } else {
                string4 = "";
            }
            String prefix = string4;
            string = prefix + name;
        } else if (basicElement instanceof BasicMinorObject) {
            String string7;
            String schemaName;
            BasicMajorObject majorObject;
            BasicMajorObject basicMajorObject = majorObject = ((BasicMinorObject)$receiver).getMajorObject();
            String string8 = schemaName = basicMajorObject != null ? basicMajorObject.getSchemaName() : null;
            if (schemaName != null && this.useSchemaName(schemaName)) {
                void $receiver$iv;
                void this_$iv;
                String $i$f$getScr = schemaName;
                AbstractCodeGenerator $receiver$iv2 = this;
                StringBuilder stringBuilder = new StringBuilder();
                String string9 = ((AbstractCodeGenerator)this_$iv).naming.nameToScript((String)$receiver$iv);
                string7 = stringBuilder.append(string9).append(".").toString();
            } else {
                string7 = "";
            }
            String prefix = string7;
            string = prefix + name;
        } else {
            string = name;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean useSchemaName(@Nullable String schemaName) {
        boolean bl;
        if (schemaName == null) return false;
        switch (AbstractCodeGenerator$WhenMappings.$EnumSwitchMapping$0[this.context.getOptions().get(ScriptingOptionStatic.CONSIDER_SCHEMA_NAME).ordinal()]) {
            case 1: {
                BasicSchema basicSchema = this.context.getCurrentSchema();
                bl = Intrinsics.areEqual((Object)schemaName, (Object)(basicSchema != null ? basicSchema.getRealName() : null)) ^ true;
                break;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (!bl) return false;
        return true;
    }

    @NotNull
    protected String script(@NotNull DataType d) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        return this.helper.script(d, this.context.getOptions());
    }

    @NotNull
    protected final String getSqlString(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return "'" + StringsKt.replace$default((String)$receiver, (String)"'", (String)"''", (boolean)false, (int)4, null) + "'";
    }

    @NotNull
    protected final ScriptingContext getContext() {
        return this.context;
    }

    @NotNull
    protected final ScriptCategory getCategory() {
        return this.category;
    }

    public AbstractCodeGenerator(@NotNull ScriptingContext context, @NotNull ScriptCategory category) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        this.context = context;
        this.category = category;
        this.deck = new ArrayDeque();
        this.postponed = new MultiMap();
        this.builder = new CodeTextBuilder(0, 1, null);
        this.naming = NamingServices.INSTANCE.getNamingService(this.context.getModel(), this.context.getCurrentDatabase());
        this.helper = ScriptingHelper.Companion.get(this.context.getRdbms());
        this.locus = ScriptLocus.OUTSIDE;
    }
}

