/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMatView;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingContext;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/scripting/BaseRefreshMatViewGenerator;", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptCategory;)V", "generateElement", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateRefreshAllMatViews", "schema", "Lcom/intellij/database/model/basic/BasicSchema;", "generateRefreshMatView", "view", "Lcom/intellij/database/model/basic/BasicMatView;", "database-scripting"})
public class BaseRefreshMatViewGenerator
extends AbstractCodeGenerator {
    @Override
    protected void generateElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof BasicSchema) {
            this.generateRefreshAllMatViews((BasicSchema)element);
        } else if (basicElement instanceof BasicMatView) {
            this.generateRefreshMatView((BasicMatView)element);
        }
    }

    protected void generateRefreshAllMatViews(@NotNull BasicSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Family<? extends BasicElement> family = schema.familyOf(ObjectKind.MAT_VIEW);
        if (family == null) {
            return;
        }
        Family<? extends BasicElement> views = family;
        Iterator iterator = views.iterator();
        while (iterator.hasNext()) {
            BasicElement view;
            BasicElement basicElement = view = (BasicElement)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"view");
            this.processElement(basicElement);
        }
    }

    protected void generateRefreshMatView(@NotNull BasicMatView view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view){
            final /* synthetic */ BaseRefreshMatViewGenerator this$0;
            final /* synthetic */ BasicMatView $view;

            public final void invoke() {
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "-- refresh " + this.$view.getName(), null, false, 6, null);
            }
            {
                this.this$0 = baseRefreshMatViewGenerator;
                this.$view = basicMatView;
                super(0);
            }
        }, 3, null);
    }

    public BaseRefreshMatViewGenerator(@NotNull ScriptingContext context, @NotNull ScriptCategory category) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        super(context, category);
    }
}

