/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.scripting.CustomScriptingOptions;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingSettingsState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

@State(name="SQLScriptSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J#\u0010\u0016\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\nH\u0086\u0002J\b\u0010\u0018\u001a\u00020\tH\u0016R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/scripting/ScriptGeneratorSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/database/scripting/ScriptingSettingsState;", "()V", "isEmpty", "", "()Z", "matrix", "Ljava/util/concurrent/ConcurrentSkipListMap;", "", "Lcom/intellij/database/scripting/CustomScriptingOptions;", "get", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "getState", "keyOf", "loadState", "", "state", "noStateLoaded", "set", "options", "toString", "Companion", "database-impl"})
public final class ScriptGeneratorSettings
implements PersistentStateComponent<ScriptingSettingsState> {
    private final ConcurrentSkipListMap<String, CustomScriptingOptions> matrix = new ConcurrentSkipListMap(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
    private static final Logger log;
    public static final Companion Companion;

    private final String keyOf(Rdbms rdbms, ScriptCategory category) {
        return rdbms.code + '.' + category.getCode();
    }

    public final void set(@NotNull Rdbms rdbms, @NotNull ScriptCategory category, @Nullable CustomScriptingOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)rdbms, (String)"rdbms");
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        String key2 = this.keyOf(rdbms, category);
        if (options != null) {
            Map map2 = this.matrix;
            CustomScriptingOptions customScriptingOptions = options;
            map2.put(key2, customScriptingOptions);
        } else {
            this.matrix.remove(key2);
        }
    }

    @Nullable
    public final CustomScriptingOptions get(@NotNull Rdbms rdbms, @NotNull ScriptCategory category) {
        Intrinsics.checkParameterIsNotNull((Object)rdbms, (String)"rdbms");
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        String key2 = this.keyOf(rdbms, category);
        return this.matrix.get(key2);
    }

    public final boolean isEmpty() {
        return this.matrix.isEmpty();
    }

    @Nullable
    public ScriptingSettingsState getState() {
        if (this.matrix.isEmpty()) {
            return null;
        }
        ScriptingSettingsState state = new ScriptingSettingsState();
        Map map2 = this.matrix;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            String k = (String)entry2.getKey();
            entry2 = entry;
            CustomScriptingOptions o = (CustomScriptingOptions)entry2.getValue();
            String string = o.export();
            state.getMatrix().put(k, string);
        }
        return state;
    }

    public void loadState(@NotNull ScriptingSettingsState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        this.matrix.clear();
        if (state.getMatrix().isEmpty()) {
            return;
        }
        Map map2 = state.getMatrix();
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            String k = (String)entry2.getKey();
            entry2 = entry;
            String s = (String)entry2.getValue();
            Logger $receiver$iv = ScriptGeneratorSettings.Companion.getLog();
            try {
                String string;
                String string2 = s;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"s");
                CustomScriptingOptions o = new CustomScriptingOptions(string2);
                Map map3 = this.matrix;
                Intrinsics.checkExpressionValueIsNotNull((Object)k, (String)"k");
                CustomScriptingOptions customScriptingOptions = o;
                map3.put(string, customScriptingOptions);
            }
            catch (ProcessCanceledException e$iv) {
            }
            catch (Throwable e$iv) {
                $receiver$iv.error(e$iv);
            }
        }
    }

    public void noStateLoaded() {
        this.matrix.clear();
    }

    @NotNull
    public String toString() {
        StringBuilder b = new StringBuilder();
        Map map2 = this.matrix;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            String k = (String)entry2.getKey();
            entry2 = entry;
            CustomScriptingOptions v = (CustomScriptingOptions)entry2.getValue();
            b.append(k).append(" -> ").append(v.export()).append('\n');
        }
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    static {
        Companion = new Companion(null);
        log = Logger.getInstance(ScriptGeneratorSettings.class);
    }

    private static final Logger getLog() {
        return ScriptGeneratorSettings.Companion.getLog();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/ScriptGeneratorSettings$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "log$annotations", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "database-impl"})
    private static final class Companion {
        @JvmStatic
        private static /* synthetic */ void log$annotations() {
        }

        private final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

