/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.exasol;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.exasol.ExasolConnection;
import com.intellij.database.model.exasol.ExasolForeignKey;
import com.intellij.database.model.exasol.ExasolKey;
import com.intellij.database.model.exasol.ExasolRole;
import com.intellij.database.model.exasol.ExasolRoutine;
import com.intellij.database.model.exasol.ExasolSchema;
import com.intellij.database.model.exasol.ExasolScript;
import com.intellij.database.model.exasol.ExasolTable;
import com.intellij.database.model.exasol.ExasolTableColumn;
import com.intellij.database.model.exasol.ExasolUser;
import com.intellij.database.model.exasol.ExasolView;
import com.intellij.database.model.exasol.ExasolVirtualSchema;
import com.intellij.database.model.properties.ExasolScriptType;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseDropGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingContext;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 .2\u00020\u0001:\u0001.B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020-H\u0002\u00a8\u0006/"}, d2={"Lcom/intellij/database/scripting/exasol/ExasolDropGenerator;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptCategory;)V", "generateConnection", "", "connection", "Lcom/intellij/database/model/exasol/ExasolConnection;", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateRole", "role", "Lcom/intellij/database/model/exasol/ExasolRole;", "generateRoutine", "routine", "Lcom/intellij/database/model/exasol/ExasolRoutine;", "generateSchema", "schema", "Lcom/intellij/database/model/exasol/ExasolSchema;", "generateScript", "script", "Lcom/intellij/database/model/exasol/ExasolScript;", "generateTable", "table", "Lcom/intellij/database/model/exasol/ExasolTable;", "generateTableColumn", "column", "Lcom/intellij/database/model/exasol/ExasolTableColumn;", "generateTableForeignKey", "fk", "Lcom/intellij/database/model/exasol/ExasolForeignKey;", "generateTableKey", "key", "Lcom/intellij/database/model/exasol/ExasolKey;", "generateUser", "user", "Lcom/intellij/database/model/exasol/ExasolUser;", "generateView", "view", "Lcom/intellij/database/model/exasol/ExasolView;", "generateVirtualSchema", "Lcom/intellij/database/model/exasol/ExasolVirtualSchema;", "Companion", "database-scripting"})
public final class ExasolDropGenerator
extends BaseDropGenerator {
    private static final Set<ObjectKind> SUPPORTED;
    public static final Companion Companion;

    @Override
    protected void generateElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof ExasolVirtualSchema) {
            this.generateVirtualSchema((ExasolVirtualSchema)element);
        } else if (basicElement instanceof ExasolSchema) {
            this.generateSchema((ExasolSchema)element);
        } else if (basicElement instanceof ExasolTable) {
            this.generateTable((ExasolTable)element);
        } else if (basicElement instanceof ExasolView) {
            this.generateView((ExasolView)element);
        } else if (basicElement instanceof ExasolRoutine) {
            this.generateRoutine((ExasolRoutine)element);
        } else if (basicElement instanceof ExasolScript) {
            this.generateScript((ExasolScript)element);
        } else if (basicElement instanceof ExasolUser) {
            this.generateUser((ExasolUser)element);
        } else if (basicElement instanceof ExasolRole) {
            this.generateRole((ExasolRole)element);
        } else if (basicElement instanceof ExasolConnection) {
            this.generateConnection((ExasolConnection)element);
        } else if (basicElement instanceof ExasolTableColumn) {
            this.generateTableColumn((ExasolTableColumn)element);
        } else if (basicElement instanceof ExasolKey) {
            this.generateTableKey((ExasolKey)element);
        } else if (basicElement instanceof ExasolForeignKey) {
            this.generateTableForeignKey((ExasolForeignKey)element);
        } else {
            this.unknownHowToDrop(element);
        }
    }

    private final void generateTableForeignKey(ExasolForeignKey fk) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, fk){
            final /* synthetic */ ExasolDropGenerator this$0;
            final /* synthetic */ ExasolForeignKey $fk;

            public final void invoke() {
                Object object;
                ExasolDropGenerator.access$getBuilder$p(this.this$0).phrase("alter table", (object = this.$fk.getTable()) != null && (object = ExasolDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???", "drop constraint", ExasolDropGenerator.access$getScr$p(this.this$0, this.$fk.getName()));
            }
            {
                this.this$0 = exasolDropGenerator;
                this.$fk = exasolForeignKey;
                super(0);
            }
        }, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateTableKey(ExasolKey key2) {
        String string;
        if (key2.isPrimary()) {
            string = "primary key";
        } else {
            void $receiver$iv;
            void this_$iv;
            String string2 = key2.getName();
            ExasolDropGenerator exasolDropGenerator = this;
            StringBuilder stringBuilder = new StringBuilder().append("constraint ");
            String string3 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
            string = stringBuilder.append(string3).toString();
        }
        String target2 = string;
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, key2, target2){
            final /* synthetic */ ExasolDropGenerator this$0;
            final /* synthetic */ ExasolKey $key;
            final /* synthetic */ String $target;

            public final void invoke() {
                Object object;
                ExasolDropGenerator.access$getBuilder$p(this.this$0).phrase("alter table", (object = this.$key.getTable()) != null && (object = ExasolDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???", "drop", this.$target);
            }
            {
                this.this$0 = exasolDropGenerator;
                this.$key = exasolKey;
                this.$target = string;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTableColumn(ExasolTableColumn column2) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, column2){
            final /* synthetic */ ExasolDropGenerator this$0;
            final /* synthetic */ ExasolTableColumn $column;

            public final void invoke() {
                Object object;
                ExasolDropGenerator.access$getBuilder$p(this.this$0).phrase("alter table", (object = this.$column.getTable()) != null && (object = ExasolDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???", "drop column", ExasolDropGenerator.access$ifExists(this.this$0), ExasolDropGenerator.access$getScr$p(this.this$0, this.$column.getName()), ExasolDropGenerator.access$cascadeConstraints(this.this$0));
            }
            {
                this.this$0 = exasolDropGenerator;
                this.$column = exasolTableColumn;
                super(0);
            }
        }, 3, null);
    }

    private final void generateConnection(ExasolConnection connection) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, connection){
            final /* synthetic */ ExasolDropGenerator this$0;
            final /* synthetic */ ExasolConnection $connection;

            public final void invoke() {
                ExasolDropGenerator.access$getBuilder$p(this.this$0).phrase("drop connection", ExasolDropGenerator.access$ifExists(this.this$0), ExasolDropGenerator.access$currentScopeName(this.this$0, this.$connection));
            }
            {
                this.this$0 = exasolDropGenerator;
                this.$connection = exasolConnection;
                super(0);
            }
        }, 3, null);
    }

    private final void generateUser(ExasolUser user) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, user){
            final /* synthetic */ ExasolDropGenerator this$0;
            final /* synthetic */ ExasolUser $user;

            public final void invoke() {
                ExasolDropGenerator.access$getBuilder$p(this.this$0).phrase("drop user", ExasolDropGenerator.access$ifExists(this.this$0), ExasolDropGenerator.access$currentScopeName(this.this$0, this.$user), ExasolDropGenerator.access$cascade(this.this$0));
            }
            {
                this.this$0 = exasolDropGenerator;
                this.$user = exasolUser;
                super(0);
            }
        }, 3, null);
    }

    private final void generateRole(ExasolRole role) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, role){
            final /* synthetic */ ExasolDropGenerator this$0;
            final /* synthetic */ ExasolRole $role;

            public final void invoke() {
                ExasolDropGenerator.access$getBuilder$p(this.this$0).phrase("drop role", ExasolDropGenerator.access$ifExists(this.this$0), ExasolDropGenerator.access$currentScopeName(this.this$0, this.$role), ExasolDropGenerator.access$cascade(this.this$0));
            }
            {
                this.this$0 = exasolDropGenerator;
                this.$role = exasolRole;
                super(0);
            }
        }, 3, null);
    }

    private final void generateScript(ExasolScript script) {
        String adapter = Intrinsics.areEqual((Object)((Object)script.getScriptType()), (Object)((Object)ExasolScriptType.ADAPTER)) ? "adapter" : null;
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, adapter, script){
            final /* synthetic */ ExasolDropGenerator this$0;
            final /* synthetic */ String $adapter;
            final /* synthetic */ ExasolScript $script;

            public final void invoke() {
                ExasolDropGenerator.access$getBuilder$p(this.this$0).phrase("drop", this.$adapter, "script", ExasolDropGenerator.access$ifExists(this.this$0), ExasolDropGenerator.access$currentScopeName(this.this$0, this.$script));
            }
            {
                this.this$0 = exasolDropGenerator;
                this.$adapter = string;
                this.$script = exasolScript;
                super(0);
            }
        }, 3, null);
    }

    private final void generateRoutine(ExasolRoutine routine) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, routine){
            final /* synthetic */ ExasolDropGenerator this$0;
            final /* synthetic */ ExasolRoutine $routine;

            public final void invoke() {
                ExasolDropGenerator.access$getBuilder$p(this.this$0).phrase("drop function", ExasolDropGenerator.access$ifExists(this.this$0), ExasolDropGenerator.access$currentScopeName(this.this$0, this.$routine));
            }
            {
                this.this$0 = exasolDropGenerator;
                this.$routine = exasolRoutine;
                super(0);
            }
        }, 3, null);
    }

    private final void generateView(ExasolView view) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view){
            final /* synthetic */ ExasolDropGenerator this$0;
            final /* synthetic */ ExasolView $view;

            public final void invoke() {
                ExasolDropGenerator.access$getBuilder$p(this.this$0).phrase("drop view", ExasolDropGenerator.access$ifExists(this.this$0), ExasolDropGenerator.access$currentScopeName(this.this$0, this.$view), ExasolDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = exasolDropGenerator;
                this.$view = exasolView;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTable(ExasolTable table) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, table){
            final /* synthetic */ ExasolDropGenerator this$0;
            final /* synthetic */ ExasolTable $table;

            public final void invoke() {
                ExasolDropGenerator.access$getBuilder$p(this.this$0).phrase("drop table", ExasolDropGenerator.access$ifExists(this.this$0), ExasolDropGenerator.access$currentScopeName(this.this$0, this.$table), ExasolDropGenerator.access$cascadeConstraints(this.this$0));
            }
            {
                this.this$0 = exasolDropGenerator;
                this.$table = exasolTable;
                super(0);
            }
        }, 3, null);
    }

    private final void generateSchema(ExasolSchema schema) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, schema){
            final /* synthetic */ ExasolDropGenerator this$0;
            final /* synthetic */ ExasolSchema $schema;

            public final void invoke() {
                ExasolDropGenerator.access$getBuilder$p(this.this$0).phrase("drop schema", ExasolDropGenerator.access$ifExists(this.this$0), ExasolDropGenerator.access$currentScopeName(this.this$0, this.$schema), ExasolDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = exasolDropGenerator;
                this.$schema = exasolSchema;
                super(0);
            }
        }, 3, null);
    }

    private final void generateVirtualSchema(ExasolVirtualSchema schema) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, schema){
            final /* synthetic */ ExasolDropGenerator this$0;
            final /* synthetic */ ExasolVirtualSchema $schema;

            public final void invoke() {
                ExasolDropGenerator.access$getBuilder$p(this.this$0).phrase("drop virtual schema", ExasolDropGenerator.access$ifExists(this.this$0), ExasolDropGenerator.access$currentScopeName(this.this$0, this.$schema), ExasolDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = exasolDropGenerator;
                this.$schema = exasolVirtualSchema;
                super(0);
            }
        }, 3, null);
    }

    public ExasolDropGenerator(@NotNull ScriptingContext context, @NotNull ScriptCategory category) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        super(context, category);
    }

    static {
        Companion = new Companion(null);
        SUPPORTED = SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.SCHEMA, ObjectKind.EXTERNAL_SCHEMA, ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.ROUTINE, ObjectKind.SCRIPT, ObjectKind.USER, ObjectKind.ROLE, ObjectKind.CONNECTION, ObjectKind.COLUMN, ObjectKind.KEY, ObjectKind.FOREIGN_KEY});
    }

    @NotNull
    public static final /* synthetic */ CodeTextBuilder access$getBuilder$p(ExasolDropGenerator $this) {
        return $this.getBuilder();
    }

    @NotNull
    public static final /* synthetic */ String access$currentScopeName(ExasolDropGenerator $this, @NotNull BasicElement $receiver) {
        return $this.currentScopeName($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$getScr$p(ExasolDropGenerator $this, @NotNull String $receiver) {
        return $this.getScr($receiver);
    }

    @Nullable
    public static final /* synthetic */ String access$ifExists(ExasolDropGenerator $this) {
        return $this.ifExists();
    }

    @Nullable
    public static final /* synthetic */ String access$cascadeConstraints(ExasolDropGenerator $this) {
        return $this.cascadeConstraints();
    }

    @Nullable
    public static final /* synthetic */ String access$cascade(ExasolDropGenerator $this) {
        return $this.cascade();
    }

    @Nullable
    public static final /* synthetic */ String access$restrictCascade(ExasolDropGenerator $this) {
        return $this.restrictCascade();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rR\"\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/scripting/exasol/ExasolDropGenerator$Companion;", "", "()V", "SUPPORTED", "", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "getSUPPORTED", "()Ljava/util/Set;", "canDrop", "", "kind", "context", "", "database-scripting"})
    public static final class Companion {
        private final Set<ObjectKind> getSUPPORTED() {
            return SUPPORTED;
        }

        public final boolean canDrop(@NotNull ObjectKind kind, @NotNull Iterable<? extends ObjectKind> context) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(context, (String)"context");
            ObjectKind objectKind = kind;
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLUMN)) {
                ObjectKind objectKind2 = (ObjectKind)CollectionsKt.firstOrNull(context);
                if (objectKind2 == null) {
                    objectKind2 = ObjectKind.TABLE;
                }
                bl = Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.TABLE);
            } else {
                bl = this.getSUPPORTED().contains(kind);
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

