/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.generic;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseDropGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingContext;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/scripting/generic/GenericDropGenerator;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptCategory;)V", "generateConstraint", "", "constraint", "Lcom/intellij/database/model/basic/BasicConstraint;", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateTable", "table", "Lcom/intellij/database/model/basic/BasicTable;", "generateTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "Companion", "database-scripting"})
public final class GenericDropGenerator
extends BaseDropGenerator {
    private static final Set<ObjectKind> SUPPORTED;
    public static final Companion Companion;

    @Override
    protected void generateElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof BasicTable) {
            this.generateTable((BasicTable)element);
        } else if (basicElement instanceof BasicConstraint) {
            this.generateConstraint((BasicConstraint)element);
        } else if (basicElement instanceof BasicTrigger) {
            this.generateTrigger((BasicTrigger)element);
        } else if (basicElement instanceof BasicMajorObject) {
            this.generateUnspecifiedMajorObject((BasicMajorObject)element);
        } else {
            this.unknownHowToDrop(element);
        }
    }

    private final void generateTable(BasicTable table) {
        this.generateUnspecifiedMajorObject(table);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateConstraint(BasicConstraint constraint) {
        void $receiver$iv;
        BasicLikeTable basicLikeTable = constraint.getLikeTable();
        if (basicLikeTable == null) {
            return;
        }
        BasicLikeTable table = basicLikeTable;
        String tableName = this.currentScopeName(table);
        String string = constraint.getName();
        GenericDropGenerator this_$iv = this;
        String constraintName = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, tableName, constraintName){
            final /* synthetic */ GenericDropGenerator this$0;
            final /* synthetic */ String $tableName;
            final /* synthetic */ String $constraintName;

            public final void invoke() {
                GenericDropGenerator.access$getBuilder$p(this.this$0).phrase("alter table", this.$tableName, "drop constraint", this.$constraintName);
            }
            {
                this.this$0 = genericDropGenerator;
                this.$tableName = string;
                this.$constraintName = string2;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTrigger(BasicTrigger trigger) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, trigger){
            final /* synthetic */ GenericDropGenerator this$0;
            final /* synthetic */ BasicTrigger $trigger;

            public final void invoke() {
                GenericDropGenerator.access$getBuilder$p(this.this$0).phrase("drop trigger", GenericDropGenerator.access$currentScopeName(this.this$0, this.$trigger));
            }
            {
                this.this$0 = genericDropGenerator;
                this.$trigger = basicTrigger;
                super(0);
            }
        }, 3, null);
    }

    public GenericDropGenerator(@NotNull ScriptingContext context, @NotNull ScriptCategory category) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        super(context, category);
    }

    static {
        Companion = new Companion(null);
        SUPPORTED = SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.MAT_VIEW, ObjectKind.CHECK, ObjectKind.TRIGGER, ObjectKind.SEQUENCE, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.OBJECT_TYPE, ObjectKind.ROUTINE});
    }

    @NotNull
    public static final /* synthetic */ CodeTextBuilder access$getBuilder$p(GenericDropGenerator $this) {
        return $this.getBuilder();
    }

    @NotNull
    public static final /* synthetic */ String access$currentScopeName(GenericDropGenerator $this, @NotNull BasicElement $receiver) {
        return $this.currentScopeName($receiver);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rR\"\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/scripting/generic/GenericDropGenerator$Companion;", "", "()V", "SUPPORTED", "", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "getSUPPORTED", "()Ljava/util/Set;", "canDrop", "", "kind", "context", "", "database-scripting"})
    public static final class Companion {
        private final Set<ObjectKind> getSUPPORTED() {
            return SUPPORTED;
        }

        public final boolean canDrop(@NotNull ObjectKind kind, @NotNull Iterable<? extends ObjectKind> context) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(context, (String)"context");
            return this.getSUPPORTED().contains(kind);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

