/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.mysql;

import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.mysql.MysqlEvent;
import com.intellij.database.model.mysql.MysqlForeignKey;
import com.intellij.database.model.mysql.MysqlIndex;
import com.intellij.database.model.mysql.MysqlKey;
import com.intellij.database.model.mysql.MysqlRoutine;
import com.intellij.database.model.mysql.MysqlSchema;
import com.intellij.database.model.mysql.MysqlTable;
import com.intellij.database.model.mysql.MysqlTableColumn;
import com.intellij.database.model.mysql.MysqlTrigger;
import com.intellij.database.model.mysql.MysqlView;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseDropGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingContext;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(H\u0002\u00a8\u0006*"}, d2={"Lcom/intellij/database/scripting/mysql/MysqlDropGenerator;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptCategory;)V", "generateElement", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateEvent", "event", "Lcom/intellij/database/model/mysql/MysqlEvent;", "generateIndex", "index", "Lcom/intellij/database/model/mysql/MysqlIndex;", "generateRoutine", "routine", "Lcom/intellij/database/model/mysql/MysqlRoutine;", "generateSchema", "schema", "Lcom/intellij/database/model/mysql/MysqlSchema;", "generateTable", "table", "Lcom/intellij/database/model/mysql/MysqlTable;", "generateTableColumn", "column", "Lcom/intellij/database/model/mysql/MysqlTableColumn;", "generateTableForeignKey", "fk", "Lcom/intellij/database/model/mysql/MysqlForeignKey;", "generateTableKey", "key", "Lcom/intellij/database/model/mysql/MysqlKey;", "generateTrigger", "trigger", "Lcom/intellij/database/model/mysql/MysqlTrigger;", "generateView", "view", "Lcom/intellij/database/model/mysql/MysqlView;", "Companion", "database-scripting"})
public final class MysqlDropGenerator
extends BaseDropGenerator {
    private static final Set<ObjectKind> SUPPORTED;
    public static final Companion Companion;

    @Override
    protected void generateElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof MysqlIndex) {
            this.generateIndex((MysqlIndex)element);
        } else if (basicElement instanceof MysqlSchema) {
            this.generateSchema((MysqlSchema)element);
        } else if (basicElement instanceof MysqlTable) {
            this.generateTable((MysqlTable)element);
        } else if (basicElement instanceof MysqlTrigger) {
            this.generateTrigger((MysqlTrigger)element);
        } else if (basicElement instanceof MysqlEvent) {
            this.generateEvent((MysqlEvent)element);
        } else if (basicElement instanceof MysqlView) {
            this.generateView((MysqlView)element);
        } else if (basicElement instanceof MysqlRoutine) {
            this.generateRoutine((MysqlRoutine)element);
        } else if (basicElement instanceof MysqlTableColumn) {
            this.generateTableColumn((MysqlTableColumn)element);
        } else if (basicElement instanceof MysqlKey) {
            this.generateTableKey((MysqlKey)element);
        } else if (basicElement instanceof MysqlForeignKey) {
            this.generateTableForeignKey((MysqlForeignKey)element);
        } else {
            this.unknownHowToDrop(element);
        }
    }

    private final void generateTableForeignKey(MysqlForeignKey fk) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, fk){
            final /* synthetic */ MysqlDropGenerator this$0;
            final /* synthetic */ MysqlForeignKey $fk;

            public final void invoke() {
                Object object;
                MysqlDropGenerator.access$getBuilder$p(this.this$0).phrase("alter table", (object = this.$fk.getTable()) != null && (object = MysqlDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???", "drop foreign key", MysqlDropGenerator.access$getScr$p(this.this$0, this.$fk.getName()));
            }
            {
                this.this$0 = mysqlDropGenerator;
                this.$fk = mysqlForeignKey;
                super(0);
            }
        }, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateTableKey(MysqlKey key2) {
        String string;
        if (key2.isPrimary()) {
            string = "primary key";
        } else {
            void $receiver$iv;
            void this_$iv;
            String string2 = key2.getName();
            MysqlDropGenerator mysqlDropGenerator = this;
            StringBuilder stringBuilder = new StringBuilder().append("key ");
            String string3 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
            string = stringBuilder.append(string3).toString();
        }
        String target2 = string;
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, key2, target2){
            final /* synthetic */ MysqlDropGenerator this$0;
            final /* synthetic */ MysqlKey $key;
            final /* synthetic */ String $target;

            public final void invoke() {
                Object object;
                MysqlDropGenerator.access$getBuilder$p(this.this$0).phrase("alter table", (object = this.$key.getTable()) != null && (object = MysqlDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???", "drop", this.$target);
            }
            {
                this.this$0 = mysqlDropGenerator;
                this.$key = mysqlKey;
                this.$target = string;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTableColumn(MysqlTableColumn column2) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, column2){
            final /* synthetic */ MysqlDropGenerator this$0;
            final /* synthetic */ MysqlTableColumn $column;

            public final void invoke() {
                Object object;
                MysqlDropGenerator.access$getBuilder$p(this.this$0).phrase("alter table", (object = this.$column.getTable()) != null && (object = MysqlDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???", "drop column", MysqlDropGenerator.access$getScr$p(this.this$0, this.$column.getName()));
            }
            {
                this.this$0 = mysqlDropGenerator;
                this.$column = mysqlTableColumn;
                super(0);
            }
        }, 3, null);
    }

    private final void generateRoutine(MysqlRoutine routine) {
        String r = Intrinsics.areEqual((Object)routine.getRoutineKind(), (Object)DasRoutine.Kind.PROCEDURE) ? "procedure" : "function";
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, r, routine){
            final /* synthetic */ MysqlDropGenerator this$0;
            final /* synthetic */ String $r;
            final /* synthetic */ MysqlRoutine $routine;

            public final void invoke() {
                MysqlDropGenerator.access$getBuilder$p(this.this$0).phrase("drop", this.$r, MysqlDropGenerator.access$ifExists(this.this$0), MysqlDropGenerator.access$currentScopeName(this.this$0, this.$routine));
            }
            {
                this.this$0 = mysqlDropGenerator;
                this.$r = string;
                this.$routine = mysqlRoutine;
                super(0);
            }
        }, 3, null);
    }

    private final void generateView(MysqlView view) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view){
            final /* synthetic */ MysqlDropGenerator this$0;
            final /* synthetic */ MysqlView $view;

            public final void invoke() {
                MysqlDropGenerator.access$getBuilder$p(this.this$0).phrase("drop view", MysqlDropGenerator.access$ifExists(this.this$0), MysqlDropGenerator.access$currentScopeName(this.this$0, this.$view), MysqlDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = mysqlDropGenerator;
                this.$view = mysqlView;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTable(MysqlTable table) {
        String temp = table.isTemporary() ? "temporary" : null;
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, temp, table){
            final /* synthetic */ MysqlDropGenerator this$0;
            final /* synthetic */ String $temp;
            final /* synthetic */ MysqlTable $table;

            public final void invoke() {
                MysqlDropGenerator.access$getBuilder$p(this.this$0).phrase("drop", this.$temp, "table", MysqlDropGenerator.access$ifExists(this.this$0), MysqlDropGenerator.access$currentScopeName(this.this$0, this.$table), MysqlDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = mysqlDropGenerator;
                this.$temp = string;
                this.$table = mysqlTable;
                super(0);
            }
        }, 3, null);
    }

    private final void generateEvent(MysqlEvent event) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, event){
            final /* synthetic */ MysqlDropGenerator this$0;
            final /* synthetic */ MysqlEvent $event;

            public final void invoke() {
                MysqlDropGenerator.access$getBuilder$p(this.this$0).phrase("drop event", MysqlDropGenerator.access$ifExists(this.this$0), MysqlDropGenerator.access$currentScopeName(this.this$0, this.$event));
            }
            {
                this.this$0 = mysqlDropGenerator;
                this.$event = mysqlEvent;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTrigger(MysqlTrigger trigger) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, trigger){
            final /* synthetic */ MysqlDropGenerator this$0;
            final /* synthetic */ MysqlTrigger $trigger;

            public final void invoke() {
                MysqlDropGenerator.access$getBuilder$p(this.this$0).phrase("drop trigger", MysqlDropGenerator.access$ifExists(this.this$0), MysqlDropGenerator.access$currentScopeName(this.this$0, this.$trigger));
            }
            {
                this.this$0 = mysqlDropGenerator;
                this.$trigger = mysqlTrigger;
                super(0);
            }
        }, 3, null);
    }

    private final void generateSchema(MysqlSchema schema) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, schema){
            final /* synthetic */ MysqlDropGenerator this$0;
            final /* synthetic */ MysqlSchema $schema;

            public final void invoke() {
                MysqlDropGenerator.access$getBuilder$p(this.this$0).phrase("drop schema", MysqlDropGenerator.access$ifExists(this.this$0), MysqlDropGenerator.access$currentScopeName(this.this$0, this.$schema));
            }
            {
                this.this$0 = mysqlDropGenerator;
                this.$schema = mysqlSchema;
                super(0);
            }
        }, 3, null);
    }

    private final void generateIndex(MysqlIndex index) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, index){
            final /* synthetic */ MysqlDropGenerator this$0;
            final /* synthetic */ MysqlIndex $index;

            public final void invoke() {
                Object object;
                MysqlDropGenerator.access$getBuilder$p(this.this$0).phrase("drop index", MysqlDropGenerator.access$currentScopeName(this.this$0, this.$index), "on", (object = this.$index.getTable()) != null && (object = MysqlDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???");
            }
            {
                this.this$0 = mysqlDropGenerator;
                this.$index = mysqlIndex;
                super(0);
            }
        }, 3, null);
    }

    public MysqlDropGenerator(@NotNull ScriptingContext context, @NotNull ScriptCategory category) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        super(context, category);
    }

    static {
        Companion = new Companion(null);
        SUPPORTED = SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.INDEX, ObjectKind.SCHEMA, ObjectKind.TABLE, ObjectKind.SCHEDULED_EVENT, ObjectKind.TRIGGER, ObjectKind.VIEW, ObjectKind.ROUTINE, ObjectKind.KEY, ObjectKind.FOREIGN_KEY});
    }

    @NotNull
    public static final /* synthetic */ CodeTextBuilder access$getBuilder$p(MysqlDropGenerator $this) {
        return $this.getBuilder();
    }

    @NotNull
    public static final /* synthetic */ String access$currentScopeName(MysqlDropGenerator $this, @NotNull BasicElement $receiver) {
        return $this.currentScopeName($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$getScr$p(MysqlDropGenerator $this, @NotNull String $receiver) {
        return $this.getScr($receiver);
    }

    @Nullable
    public static final /* synthetic */ String access$ifExists(MysqlDropGenerator $this) {
        return $this.ifExists();
    }

    @Nullable
    public static final /* synthetic */ String access$restrictCascade(MysqlDropGenerator $this) {
        return $this.restrictCascade();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rR\"\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/scripting/mysql/MysqlDropGenerator$Companion;", "", "()V", "SUPPORTED", "", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "getSUPPORTED", "()Ljava/util/Set;", "canDrop", "", "kind", "context", "", "database-scripting"})
    public static final class Companion {
        private final Set<ObjectKind> getSUPPORTED() {
            return SUPPORTED;
        }

        public final boolean canDrop(@NotNull ObjectKind kind, @NotNull Iterable<? extends ObjectKind> context) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(context, (String)"context");
            ObjectKind objectKind = kind;
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLUMN)) {
                ObjectKind objectKind2 = (ObjectKind)CollectionsKt.firstOrNull(context);
                if (objectKind2 == null) {
                    objectKind2 = ObjectKind.TABLE;
                }
                bl = Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.TABLE);
            } else {
                bl = this.getSUPPORTED().contains(kind);
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

