/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.oracle;

import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicUserDefinedType;
import com.intellij.database.model.oracle.OraCluster;
import com.intellij.database.model.oracle.OraConstraint;
import com.intellij.database.model.oracle.OraDataFile;
import com.intellij.database.model.oracle.OraInfraIndex;
import com.intellij.database.model.oracle.OraKey;
import com.intellij.database.model.oracle.OraMatLog;
import com.intellij.database.model.oracle.OraMatView;
import com.intellij.database.model.oracle.OraObjectTypeBody;
import com.intellij.database.model.oracle.OraPackage;
import com.intellij.database.model.oracle.OraPackageBody;
import com.intellij.database.model.oracle.OraSequence;
import com.intellij.database.model.oracle.OraSingleRoutine;
import com.intellij.database.model.oracle.OraSynonym;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.oracle.OraTableColumn;
import com.intellij.database.model.oracle.OraTablespace;
import com.intellij.database.model.oracle.OraTrigger;
import com.intellij.database.model.oracle.OraView;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseDropGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingContext;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\b\u0000\u0018\u0000 D2\u00020\u0001:\u0001DB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\b2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\b2\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020\b2\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020\b2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020\b2\u0006\u0010;\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020\b2\u0006\u0010@\u001a\u00020AH\u0002J\n\u0010B\u001a\u0004\u0018\u00010CH\u0002\u00a8\u0006E"}, d2={"Lcom/intellij/database/scripting/oracle/OraDropGenerator;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptCategory;)V", "generateCluster", "", "cluster", "Lcom/intellij/database/model/oracle/OraCluster;", "generateConstraint", "constraint", "Lcom/intellij/database/model/oracle/OraConstraint;", "generateDataFile", "df", "Lcom/intellij/database/model/oracle/OraDataFile;", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateIndex", "index", "Lcom/intellij/database/model/oracle/OraInfraIndex;", "generateMatLog", "ml", "Lcom/intellij/database/model/oracle/OraMatLog;", "generateMatView", "mv", "Lcom/intellij/database/model/oracle/OraMatView;", "generatePackage", "pkg", "Lcom/intellij/database/model/oracle/OraPackage;", "generatePackageBody", "Lcom/intellij/database/model/oracle/OraPackageBody;", "generateRoutine", "r", "Lcom/intellij/database/model/oracle/OraSingleRoutine;", "generateSequence", "seq", "Lcom/intellij/database/model/oracle/OraSequence;", "generateSynonym", "syn", "Lcom/intellij/database/model/oracle/OraSynonym;", "generateTable", "table", "Lcom/intellij/database/model/oracle/OraTable;", "generateTableColumn", "column", "Lcom/intellij/database/model/oracle/OraTableColumn;", "generateTableKey", "key", "Lcom/intellij/database/model/oracle/OraKey;", "generateTablespace", "tsp", "Lcom/intellij/database/model/oracle/OraTablespace;", "generateTrigger", "trigger", "Lcom/intellij/database/model/oracle/OraTrigger;", "generateType", "type", "Lcom/intellij/database/model/basic/BasicUserDefinedType;", "generateTypeBody", "Lcom/intellij/database/model/oracle/OraObjectTypeBody;", "generateTypeView", "view", "Lcom/intellij/database/model/oracle/OraView;", "incTablesCascadeConstraints", "", "Companion", "database-scripting"})
public final class OraDropGenerator
extends BaseDropGenerator {
    private static final Set<ObjectKind> SUPPORTED;
    public static final Companion Companion;

    @Override
    protected void generateElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof OraCluster) {
            this.generateCluster((OraCluster)element);
        } else if (basicElement instanceof OraSingleRoutine) {
            this.generateRoutine((OraSingleRoutine)element);
        } else if (basicElement instanceof OraInfraIndex) {
            this.generateIndex((OraInfraIndex)element);
        } else if (basicElement instanceof OraMatLog) {
            this.generateMatLog((OraMatLog)element);
        } else if (basicElement instanceof OraMatView) {
            this.generateMatView((OraMatView)element);
        } else if (basicElement instanceof OraPackage) {
            this.generatePackage((OraPackage)element);
        } else if (basicElement instanceof OraPackageBody) {
            this.generatePackageBody((OraPackageBody)element);
        } else if (basicElement instanceof OraSequence) {
            this.generateSequence((OraSequence)element);
        } else if (basicElement instanceof OraSynonym) {
            this.generateSynonym((OraSynonym)element);
        } else if (basicElement instanceof OraTablespace) {
            this.generateTablespace((OraTablespace)element);
        } else if (basicElement instanceof OraTable) {
            this.generateTable((OraTable)element);
        } else if (basicElement instanceof OraTrigger) {
            this.generateTrigger((OraTrigger)element);
        } else if (basicElement instanceof BasicUserDefinedType) {
            this.generateType((BasicUserDefinedType)element);
        } else if (basicElement instanceof OraObjectTypeBody) {
            this.generateTypeBody((OraObjectTypeBody)element);
        } else if (basicElement instanceof OraView) {
            this.generateTypeView((OraView)element);
        } else if (basicElement instanceof OraTableColumn) {
            this.generateTableColumn((OraTableColumn)element);
        } else if (basicElement instanceof OraKey) {
            this.generateTableKey((OraKey)element);
        } else if (basicElement instanceof OraConstraint) {
            this.generateConstraint((OraConstraint)element);
        } else if (basicElement instanceof OraDataFile) {
            this.generateDataFile((OraDataFile)element);
        } else {
            this.unknownHowToDrop(element);
        }
    }

    private final void generateDataFile(OraDataFile df) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, df){
            final /* synthetic */ OraDropGenerator this$0;
            final /* synthetic */ OraDataFile $df;

            public final void invoke() {
                Object object;
                OraDropGenerator.access$getBuilder$p(this.this$0).phrase("alter tablespace", (object = this.$df.getTablespace()) != null && (object = OraDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???", "drop datafile", OraDropGenerator.access$getSqlString$p(this.this$0, this.$df.getName()));
            }
            {
                this.this$0 = oraDropGenerator;
                this.$df = oraDataFile;
                super(0);
            }
        }, 3, null);
    }

    private final void generateConstraint(OraConstraint constraint) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, constraint){
            final /* synthetic */ OraDropGenerator this$0;
            final /* synthetic */ OraConstraint $constraint;

            public final void invoke() {
                Object object;
                OraDropGenerator.access$getBuilder$p(this.this$0).phrase("alter table", (object = this.$constraint.getLikeTable()) != null && (object = OraDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???", "drop constraint", OraDropGenerator.access$getScr$p(this.this$0, this.$constraint.getName()), OraDropGenerator.access$cascade(this.this$0));
            }
            {
                this.this$0 = oraDropGenerator;
                this.$constraint = oraConstraint;
                super(0);
            }
        }, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateTableKey(OraKey key2) {
        String string;
        if (key2.isPrimary()) {
            string = "primary key";
        } else if (key2.getRealName() == null) {
            string = "unique(" + CollectionsKt.joinToString$default((Iterable)key2.getColNames(), (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>(this){
                final /* synthetic */ OraDropGenerator this$0;

                @NotNull
                public final String invoke(String it) {
                    return OraDropGenerator.access$getScr$p(this.this$0, it);
                }
                {
                    this.this$0 = oraDropGenerator;
                    super(1);
                }
            }), (int)30, null) + ')';
        } else {
            void $receiver$iv;
            void this_$iv;
            String string2 = key2.getName();
            OraDropGenerator oraDropGenerator = this;
            StringBuilder stringBuilder = new StringBuilder().append("constraint ");
            String string3 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
            string = stringBuilder.append(string3).toString();
        }
        String target2 = string;
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, key2, target2){
            final /* synthetic */ OraDropGenerator this$0;
            final /* synthetic */ OraKey $key;
            final /* synthetic */ String $target;

            public final void invoke() {
                Object object;
                OraDropGenerator.access$getBuilder$p(this.this$0).phrase("alter table", (object = this.$key.getTable()) != null && (object = OraDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???", "drop", this.$target, OraDropGenerator.access$cascade(this.this$0));
            }
            {
                this.this$0 = oraDropGenerator;
                this.$key = oraKey;
                this.$target = string;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTableColumn(OraTableColumn column2) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, column2){
            final /* synthetic */ OraDropGenerator this$0;
            final /* synthetic */ OraTableColumn $column;

            public final void invoke() {
                Object object;
                OraDropGenerator.access$getBuilder$p(this.this$0).phrase("alter table", (object = this.$column.getTable()) != null && (object = OraDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???", "drop column", OraDropGenerator.access$getScr$p(this.this$0, this.$column.getName()), OraDropGenerator.access$cascadeConstraints(this.this$0));
            }
            {
                this.this$0 = oraDropGenerator;
                this.$column = oraTableColumn;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTypeView(OraView view) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view){
            final /* synthetic */ OraDropGenerator this$0;
            final /* synthetic */ OraView $view;

            public final void invoke() {
                OraDropGenerator.access$getBuilder$p(this.this$0).phrase("drop view", OraDropGenerator.access$currentScopeName(this.this$0, this.$view), OraDropGenerator.access$cascadeConstraints(this.this$0));
            }
            {
                this.this$0 = oraDropGenerator;
                this.$view = oraView;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTypeBody(OraObjectTypeBody type) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, type){
            final /* synthetic */ OraDropGenerator this$0;
            final /* synthetic */ OraObjectTypeBody $type;

            public final void invoke() {
                OraDropGenerator.access$getBuilder$p(this.this$0).phrase("drop type body", OraDropGenerator.access$currentScopeName(this.this$0, this.$type));
            }
            {
                this.this$0 = oraDropGenerator;
                this.$type = oraObjectTypeBody;
                super(0);
            }
        }, 3, null);
    }

    private final void generateType(BasicUserDefinedType type) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, type){
            final /* synthetic */ OraDropGenerator this$0;
            final /* synthetic */ BasicUserDefinedType $type;

            public final void invoke() {
                OraDropGenerator.access$getBuilder$p(this.this$0).phrase("drop type", OraDropGenerator.access$currentScopeName(this.this$0, this.$type));
            }
            {
                this.this$0 = oraDropGenerator;
                this.$type = basicUserDefinedType;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTrigger(OraTrigger trigger) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, trigger){
            final /* synthetic */ OraDropGenerator this$0;
            final /* synthetic */ OraTrigger $trigger;

            public final void invoke() {
                OraDropGenerator.access$getBuilder$p(this.this$0).phrase("drop trigger", OraDropGenerator.access$currentScopeName(this.this$0, this.$trigger));
            }
            {
                this.this$0 = oraDropGenerator;
                this.$trigger = oraTrigger;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTable(OraTable table) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, table){
            final /* synthetic */ OraDropGenerator this$0;
            final /* synthetic */ OraTable $table;

            public final void invoke() {
                OraDropGenerator.access$getBuilder$p(this.this$0).phrase("drop table", OraDropGenerator.access$currentScopeName(this.this$0, this.$table), OraDropGenerator.access$cascadeConstraints(this.this$0));
            }
            {
                this.this$0 = oraDropGenerator;
                this.$table = oraTable;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTablespace(OraTablespace tsp) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, tsp){
            final /* synthetic */ OraDropGenerator this$0;
            final /* synthetic */ OraTablespace $tsp;

            public final void invoke() {
                OraDropGenerator.access$getBuilder$p(this.this$0).phrase("drop tablespace", OraDropGenerator.access$currentScopeName(this.this$0, this.$tsp), OraDropGenerator.access$cascadeConstraints(this.this$0));
            }
            {
                this.this$0 = oraDropGenerator;
                this.$tsp = oraTablespace;
                super(0);
            }
        }, 3, null);
    }

    private final void generateSynonym(OraSynonym syn) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, syn){
            final /* synthetic */ OraDropGenerator this$0;
            final /* synthetic */ OraSynonym $syn;

            public final void invoke() {
                OraDropGenerator.access$getBuilder$p(this.this$0).phrase("drop synonym", OraDropGenerator.access$currentScopeName(this.this$0, this.$syn));
            }
            {
                this.this$0 = oraDropGenerator;
                this.$syn = oraSynonym;
                super(0);
            }
        }, 3, null);
    }

    private final void generateSequence(OraSequence seq) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, seq){
            final /* synthetic */ OraDropGenerator this$0;
            final /* synthetic */ OraSequence $seq;

            public final void invoke() {
                OraDropGenerator.access$getBuilder$p(this.this$0).phrase("drop sequence", OraDropGenerator.access$currentScopeName(this.this$0, this.$seq));
            }
            {
                this.this$0 = oraDropGenerator;
                this.$seq = oraSequence;
                super(0);
            }
        }, 3, null);
    }

    private final void generatePackageBody(OraPackageBody pkg) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, pkg){
            final /* synthetic */ OraDropGenerator this$0;
            final /* synthetic */ OraPackageBody $pkg;

            public final void invoke() {
                OraDropGenerator.access$getBuilder$p(this.this$0).phrase("drop package body", OraDropGenerator.access$currentScopeName(this.this$0, this.$pkg));
            }
            {
                this.this$0 = oraDropGenerator;
                this.$pkg = oraPackageBody;
                super(0);
            }
        }, 3, null);
    }

    private final void generatePackage(OraPackage pkg) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, pkg){
            final /* synthetic */ OraDropGenerator this$0;
            final /* synthetic */ OraPackage $pkg;

            public final void invoke() {
                OraDropGenerator.access$getBuilder$p(this.this$0).phrase("drop package", OraDropGenerator.access$currentScopeName(this.this$0, this.$pkg));
            }
            {
                this.this$0 = oraDropGenerator;
                this.$pkg = oraPackage;
                super(0);
            }
        }, 3, null);
    }

    private final void generateMatView(OraMatView mv) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, mv){
            final /* synthetic */ OraDropGenerator this$0;
            final /* synthetic */ OraMatView $mv;

            public final void invoke() {
                OraDropGenerator.access$getBuilder$p(this.this$0).phrase("drop materialized view", OraDropGenerator.access$currentScopeName(this.this$0, this.$mv));
            }
            {
                this.this$0 = oraDropGenerator;
                this.$mv = oraMatView;
                super(0);
            }
        }, 3, null);
    }

    private final void generateMatLog(OraMatLog ml) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, ml){
            final /* synthetic */ OraDropGenerator this$0;
            final /* synthetic */ OraMatLog $ml;

            public final void invoke() {
                Object object;
                OraDropGenerator.access$getBuilder$p(this.this$0).phrase("drop materialized view log on", (object = this.$ml.getTable()) != null && (object = OraDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???");
            }
            {
                this.this$0 = oraDropGenerator;
                this.$ml = oraMatLog;
                super(0);
            }
        }, 3, null);
    }

    private final void generateIndex(OraInfraIndex index) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, index){
            final /* synthetic */ OraDropGenerator this$0;
            final /* synthetic */ OraInfraIndex $index;

            public final void invoke() {
                OraDropGenerator.access$getBuilder$p(this.this$0).phrase("drop index", OraDropGenerator.access$currentScopeName(this.this$0, this.$index));
            }
            {
                this.this$0 = oraDropGenerator;
                this.$index = oraInfraIndex;
                super(0);
            }
        }, 3, null);
    }

    private final void generateRoutine(OraSingleRoutine r) {
        String rt = Intrinsics.areEqual((Object)r.getRoutineKind(), (Object)DasRoutine.Kind.FUNCTION) ? "function" : "procedure";
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, rt, r){
            final /* synthetic */ OraDropGenerator this$0;
            final /* synthetic */ String $rt;
            final /* synthetic */ OraSingleRoutine $r;

            public final void invoke() {
                OraDropGenerator.access$getBuilder$p(this.this$0).phrase("drop", this.$rt, OraDropGenerator.access$currentScopeName(this.this$0, this.$r));
            }
            {
                this.this$0 = oraDropGenerator;
                this.$rt = string;
                this.$r = oraSingleRoutine;
                super(0);
            }
        }, 3, null);
    }

    private final void generateCluster(OraCluster cluster) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, cluster){
            final /* synthetic */ OraDropGenerator this$0;
            final /* synthetic */ OraCluster $cluster;

            public final void invoke() {
                OraDropGenerator.access$getBuilder$p(this.this$0).phrase("drop cluster", OraDropGenerator.access$currentScopeName(this.this$0, this.$cluster), OraDropGenerator.access$incTablesCascadeConstraints(this.this$0));
            }
            {
                this.this$0 = oraDropGenerator;
                this.$cluster = oraCluster;
                super(0);
            }
        }, 3, null);
    }

    private final CharSequence incTablesCascadeConstraints() {
        String string;
        String string2 = this.cascade();
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            string = "including tables cascade constraints";
        } else {
            string = null;
        }
        return string;
    }

    public OraDropGenerator(@NotNull ScriptingContext context, @NotNull ScriptCategory category) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        super(context, category);
    }

    static {
        Companion = new Companion(null);
        SUPPORTED = SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.CLUSTER, ObjectKind.INDEX, ObjectKind.MAT_VIEW, ObjectKind.MAT_LOG, ObjectKind.PACKAGE, ObjectKind.BODY, ObjectKind.SYNONYM, ObjectKind.SEQUENCE, ObjectKind.TABLESPACE, ObjectKind.TABLE, ObjectKind.TRIGGER, ObjectKind.TABLE_TYPE, ObjectKind.OBJECT_TYPE, ObjectKind.COLLECTION_TYPE, ObjectKind.VIEW, ObjectKind.KEY, ObjectKind.CHECK, ObjectKind.FOREIGN_KEY, ObjectKind.DATA_FILE});
    }

    @NotNull
    public static final /* synthetic */ CodeTextBuilder access$getBuilder$p(OraDropGenerator $this) {
        return $this.getBuilder();
    }

    @NotNull
    public static final /* synthetic */ String access$currentScopeName(OraDropGenerator $this, @NotNull BasicElement $receiver) {
        return $this.currentScopeName($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$getSqlString$p(OraDropGenerator $this, @NotNull String $receiver) {
        return $this.getSqlString($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$getScr$p(OraDropGenerator $this, @NotNull String $receiver) {
        return $this.getScr($receiver);
    }

    @Nullable
    public static final /* synthetic */ String access$cascade(OraDropGenerator $this) {
        return $this.cascade();
    }

    @Nullable
    public static final /* synthetic */ String access$cascadeConstraints(OraDropGenerator $this) {
        return $this.cascadeConstraints();
    }

    @Nullable
    public static final /* synthetic */ CharSequence access$incTablesCascadeConstraints(OraDropGenerator $this) {
        return $this.incTablesCascadeConstraints();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rR\"\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/scripting/oracle/OraDropGenerator$Companion;", "", "()V", "SUPPORTED", "", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "getSUPPORTED", "()Ljava/util/Set;", "canDrop", "", "kind", "context", "", "database-scripting"})
    public static final class Companion {
        private final Set<ObjectKind> getSUPPORTED() {
            return SUPPORTED;
        }

        public final boolean canDrop(@NotNull ObjectKind kind, @NotNull Iterable<? extends ObjectKind> context) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(context, (String)"context");
            ObjectKind objectKind = kind;
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE)) {
                ObjectKind objectKind2 = (ObjectKind)CollectionsKt.firstOrNull(context);
                if (objectKind2 == null) {
                    objectKind2 = ObjectKind.SCHEMA;
                }
                bl = Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.SCHEMA);
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLUMN)) {
                ObjectKind objectKind3 = (ObjectKind)CollectionsKt.firstOrNull(context);
                if (objectKind3 == null) {
                    objectKind3 = ObjectKind.TABLE;
                }
                bl = Intrinsics.areEqual((Object)objectKind3, (Object)ObjectKind.TABLE);
            } else {
                bl = this.getSUPPORTED().contains(kind);
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

