/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.oracle;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.oracle.OraArgument;
import com.intellij.database.model.oracle.OraPackage;
import com.intellij.database.model.oracle.OraPackageRoutine;
import com.intellij.database.model.oracle.OraRoutine;
import com.intellij.database.model.oracle.OraSingleRoutine;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseExecuteGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.oracle.OraExecuteGenerator;
import com.intellij.database.scripting.oracle.OraExecuteGenerator$WhenMappings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/scripting/oracle/OraExecuteGenerator;", "Lcom/intellij/database/scripting/BaseExecuteGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptCategory;)V", "generateElement", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generatePackage", "pack", "Lcom/intellij/database/model/oracle/OraPackage;", "generateRoutine", "routine", "Lcom/intellij/database/model/oracle/OraRoutine;", "guessDefaultValue", "", "dt", "Lcom/intellij/database/model/DataType;", "database-scripting"})
public final class OraExecuteGenerator
extends BaseExecuteGenerator {
    @Override
    protected void generateElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof OraPackage) {
            this.generatePackage((OraPackage)element);
        } else if (basicElement instanceof OraRoutine) {
            this.generateRoutine((OraRoutine)element);
        }
    }

    private final void generatePackage(OraPackage pack) {
        Iterator iterator = pack.getRoutines().iterator();
        while (iterator.hasNext()) {
            OraPackageRoutine routine;
            OraPackageRoutine oraPackageRoutine = routine = (OraPackageRoutine)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraPackageRoutine, (String)"routine");
            this.process(oraPackageRoutine);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateRoutine(OraRoutine routine) {
        void ret;
        void hasOut;
        Ref.BooleanRef $receiver$iv;
        String string;
        OraRoutine oraRoutine = routine;
        if (oraRoutine instanceof OraSingleRoutine) {
            string = this.currentScopeName(routine);
        } else if (oraRoutine instanceof OraPackageRoutine) {
            void this_$iv;
            StringBuilder stringBuilder = new StringBuilder();
            OraPackage oraPackage = ((OraPackageRoutine)routine).getPackage();
            if (oraPackage == null) {
                Intrinsics.throwNpe();
            }
            String string2 = ((OraPackageRoutine)routine).getName();
            OraExecuteGenerator oraExecuteGenerator = this;
            StringBuilder stringBuilder2 = stringBuilder.append(this.currentScopeName(oraPackage)).append('.');
            String string3 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
            string = stringBuilder2.append(string3).toString();
        } else {
            return;
        }
        String callName = string;
        List arguments = CollectionsKt.toList((Iterable)routine.getArguments());
        int n = arguments.size();
        $receiver$iv = new Ref.BooleanRef();
        $receiver$iv.element = false;
        Ref.ObjectRef $i$f$getScr = new Ref.ObjectRef();
        $i$f$getScr.element = null;
        for (OraArgument argument : arguments) {
            DasArgument.Direction d = argument.getArgumentDirection();
            switch (OraExecuteGenerator$WhenMappings.$EnumSwitchMapping$0[d.ordinal()]) {
                case 1: {
                    hasOut.element = true;
                    break;
                }
                case 2: {
                    hasOut.element = true;
                    break;
                }
                case 3: {
                    ret.element = argument;
                }
            }
        }
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, (Ref.BooleanRef)hasOut, (Ref.ObjectRef)ret, arguments, n, callName){
            final /* synthetic */ OraExecuteGenerator this$0;
            final /* synthetic */ Ref.BooleanRef $hasOut;
            final /* synthetic */ Ref.ObjectRef $ret;
            final /* synthetic */ List $arguments;
            final /* synthetic */ int $n;
            final /* synthetic */ String $callName;

            public final void invoke() {
                if (this.$hasOut.element || (OraArgument)this.$ret.element != null) {
                    OraExecuteGenerator.access$getBuilder$p(this.this$0).phrase("declare");
                    OraExecuteGenerator.access$coding(this.this$0, ScriptLocus.IN_STATEMENT, true, (Function0)new Function0<Unit>(this){
                        final /* synthetic */ generateRoutine.1 this$0;

                        public final void invoke() {
                            for (OraArgument a : this.this$0.$arguments) {
                                DasArgument.Direction dir = a.getArgumentDirection();
                                DataType dt = a.getDataType();
                                OraExecuteGenerator oraExecuteGenerator = this.this$0.this$0;
                                DataType dataType = dt;
                                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"dt");
                                String specification = OraExecuteGenerator.access$script(oraExecuteGenerator, dataType);
                                if (Intrinsics.areEqual((Object)dir, (Object)DasArgument.Direction.INOUT)) {
                                    String defaultValue = OraExecuteGenerator.access$guessDefaultValue(this.this$0.this$0, dt);
                                    CodeTextBuilder.append$default(OraExecuteGenerator.access$getBuilder$p(this.this$0.this$0), "" + OraExecuteGenerator.access$getScr$p(this.this$0.this$0, a.getName()) + ' ' + specification + " := " + defaultValue + ';', null, false, 6, null);
                                }
                                if (Intrinsics.areEqual((Object)dir, (Object)DasArgument.Direction.OUT)) {
                                    CodeTextBuilder.append$default(OraExecuteGenerator.access$getBuilder$p(this.this$0.this$0), "" + OraExecuteGenerator.access$getScr$p(this.this$0.this$0, a.getName()) + ' ' + specification + ';', null, false, 6, null);
                                }
                                if (!Intrinsics.areEqual((Object)dir, (Object)DasArgument.Direction.RETURN)) continue;
                                CodeTextBuilder.append$default(OraExecuteGenerator.access$getBuilder$p(this.this$0.this$0), "Result " + specification + ';', null, false, 6, null);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                }
                OraExecuteGenerator.access$getBuilder$p(this.this$0).phrase("begin");
                OraExecuteGenerator.access$coding(this.this$0, ScriptLocus.IN_STATEMENT, true, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ generateRoutine.1 this$0;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        ArrayList<String> passing = new ArrayList<String>(this.this$0.$n);
                        for (OraArgument a : this.this$0.$arguments) {
                            switch (OraExecuteGenerator$WhenMappings.$EnumSwitchMapping$1[a.getArgumentDirection().ordinal()]) {
                                case 1: {
                                    StringBuilder stringBuilder = new StringBuilder().append("").append(OraExecuteGenerator.access$getScr$p(this.this$0.this$0, a.getName())).append(" => ");
                                    OraExecuteGenerator oraExecuteGenerator = this.this$0.this$0;
                                    DataType dataType = a.getDataType();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"a.dataType");
                                    passing.add(stringBuilder.append(OraExecuteGenerator.access$guessDefaultValue(oraExecuteGenerator, dataType)).toString());
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    passing.add("" + OraExecuteGenerator.access$getScr$p(this.this$0.this$0, a.getName()) + " => " + OraExecuteGenerator.access$getScr$p(this.this$0.this$0, a.getName()));
                                }
                            }
                        }
                        String retClause = (OraArgument)this.this$0.$ret.element != null ? "result :=" : null;
                        Iterable $receiver$iv = passing;
                        int sum$iv = 0;
                        for (T element$iv : $receiver$iv) {
                            void it;
                            String string = (String)element$iv;
                            int n = sum$iv;
                            int n2 = it.length();
                            sum$iv = n + n2;
                        }
                        int x = sum$iv;
                        if (x == 0) {
                            OraExecuteGenerator.access$getBuilder$p(this.this$0.this$0).phrase(retClause, this.this$0.$callName + ';');
                        } else if (x <= 60) {
                            String passingText = CollectionsKt.joinToString$default((Iterable)passing, null, null, null, (int)0, null, null, (int)63, null);
                            OraExecuteGenerator.access$getBuilder$p(this.this$0.this$0).phrase(retClause, "" + this.this$0.$callName + '(' + passingText + ");");
                        } else {
                            OraExecuteGenerator.access$getBuilder$p(this.this$0.this$0).phrase(retClause, this.this$0.$callName + '(');
                            CodeTextBuilder this_$iv = OraExecuteGenerator.access$getBuilder$p(this.this$0.this$0);
                            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                            try {
                                for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)passing)) {
                                    int i2 = indexedValue.component1();
                                    String p = (String)indexedValue.component2();
                                    CodeTextBuilder.append$default(OraExecuteGenerator.access$getBuilder$p(this.this$0.this$0), i2 + 1 < passing.size() ? p + ',' : p, null, false, 6, null);
                                }
                            }
                            finally {
                                this_$iv.unindent();
                            }
                            CodeTextBuilder.append$default(OraExecuteGenerator.access$getBuilder$p(this.this$0.this$0), ");", null, false, 6, null);
                        }
                        for (OraArgument a : this.this$0.$arguments) {
                            if (!a.getArgumentDirection().isOut()) continue;
                            CodeTextBuilder.append$default(OraExecuteGenerator.access$getBuilder$p(this.this$0.this$0), "dbms_output.put_line('" + a.getName() + " = '||" + OraExecuteGenerator.access$getScr$p(this.this$0.this$0, a.getName()) + ");", null, false, 6, null);
                        }
                        if ((OraArgument)this.this$0.$ret.element != null) {
                            CodeTextBuilder.append$default(OraExecuteGenerator.access$getBuilder$p(this.this$0.this$0), "dbms_output.put_line('Result = '||Result);", null, false, 6, null);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
                OraExecuteGenerator.access$getBuilder$p(this.this$0).phrase("end;");
            }
            {
                this.this$0 = oraExecuteGenerator;
                this.$hasOut = booleanRef;
                this.$ret = objectRef;
                this.$arguments = list;
                this.$n = n;
                this.$callName = string;
                super(0);
            }
        }, 3, null);
    }

    private final String guessDefaultValue(DataType dt) {
        String typeName = dt.typeName;
        return StringsKt.startsWith((String)typeName, (String)"binary_integer", (boolean)true) ? "0" : (StringsKt.startsWith((String)typeName, (String)"number", (boolean)true) ? (dt.scale > 0 ? "0.0" : "0") : (StringsKt.startsWith((String)typeName, (String)"float", (boolean)true) ? "0.0" : (StringsKt.startsWith((String)typeName, (String)"char", (boolean)true) ? "''" : (StringsKt.startsWith((String)typeName, (String)"varchar", (boolean)true) ? "''" : (StringsKt.startsWith((String)typeName, (String)"nchar", (boolean)true) ? "''" : (StringsKt.startsWith((String)typeName, (String)"nvarchar", (boolean)true) ? "''" : (StringsKt.startsWith((String)typeName, (String)"date", (boolean)true) ? "sysdate" : "null")))))));
    }

    public OraExecuteGenerator(@NotNull ScriptingContext context, @NotNull ScriptCategory category) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        super(context, category);
    }

    @NotNull
    public static final /* synthetic */ CodeTextBuilder access$getBuilder$p(OraExecuteGenerator $this) {
        return $this.getBuilder();
    }

    public static final /* synthetic */ void access$coding(OraExecuteGenerator $this, @Nullable ScriptLocus locus, boolean indent, @NotNull Function0 block) {
        $this.coding(locus, indent, (Function0<Unit>)block);
    }

    @NotNull
    public static final /* synthetic */ String access$script(OraExecuteGenerator $this, @NotNull DataType d) {
        return $this.script(d);
    }

    @NotNull
    public static final /* synthetic */ String access$guessDefaultValue(OraExecuteGenerator $this, @NotNull DataType dt) {
        return $this.guessDefaultValue(dt);
    }

    @NotNull
    public static final /* synthetic */ String access$getScr$p(OraExecuteGenerator $this, @NotNull String $receiver) {
        return $this.getScr($receiver);
    }
}

