/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.postgres;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.postgresbase.PostgresBaseArgument;
import com.intellij.database.model.postgresbase.PostgresBaseConstraint;
import com.intellij.database.model.postgresbase.PostgresBaseDatabase;
import com.intellij.database.model.postgresbase.PostgresBaseRoutine;
import com.intellij.database.model.postgresbase.PostgresBaseSchema;
import com.intellij.database.model.postgresbase.PostgresBaseTable;
import com.intellij.database.model.postgresbase.PostgresBaseTableColumn;
import com.intellij.database.model.postgresbase.PostgresBaseView;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseDropGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.postgres.PostgresBaseDropGenerator;
import com.intellij.database.scripting.postgres.PostgresBaseDropGenerator$WhenMappings;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.JBIterable;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Postgres;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0010\u0018\u0000 &2\u00020\u0001:\u0001&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0002J\n\u0010%\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006'"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresBaseDropGenerator;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptCategory;)V", "argDesc", "", "arg", "Lcom/intellij/database/model/postgresbase/PostgresBaseArgument;", "generateDatabase", "", "db", "Lcom/intellij/database/model/postgresbase/PostgresBaseDatabase;", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateFunction", "Lcom/intellij/database/model/postgresbase/PostgresBaseRoutine;", "generateSchema", "sc", "Lcom/intellij/database/model/postgresbase/PostgresBaseSchema;", "generateTable", "table", "Lcom/intellij/database/model/postgresbase/PostgresBaseTable;", "generateTableColumn", "column", "Lcom/intellij/database/model/postgresbase/PostgresBaseTableColumn;", "generateTableConstraint", "c", "Lcom/intellij/database/model/postgresbase/PostgresBaseConstraint;", "generateView", "view", "Lcom/intellij/database/model/postgresbase/PostgresBaseView;", "isPg", "", "pgIfExists", "Companion", "database-scripting"})
public class PostgresBaseDropGenerator
extends BaseDropGenerator {
    private static final Set<ObjectKind> SUPPORTED;
    public static final Companion Companion;

    @Override
    protected void generateElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof PostgresBaseDatabase) {
            this.generateDatabase((PostgresBaseDatabase)element);
        } else if (basicElement instanceof PostgresBaseRoutine) {
            this.generateFunction((PostgresBaseRoutine)element);
        } else if (basicElement instanceof PostgresBaseSchema) {
            this.generateSchema((PostgresBaseSchema)element);
        } else if (basicElement instanceof PostgresBaseTable) {
            this.generateTable((PostgresBaseTable)element);
        } else if (basicElement instanceof PostgresBaseView) {
            this.generateView((PostgresBaseView)element);
        } else if (basicElement instanceof PostgresBaseTableColumn) {
            this.generateTableColumn((PostgresBaseTableColumn)element);
        } else if (basicElement instanceof PostgresBaseConstraint) {
            this.generateTableConstraint((PostgresBaseConstraint)element);
        } else {
            this.unknownHowToDrop(element);
        }
    }

    private final void generateTableConstraint(PostgresBaseConstraint c) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, c){
            final /* synthetic */ PostgresBaseDropGenerator this$0;
            final /* synthetic */ PostgresBaseConstraint $c;

            public final void invoke() {
                Object object;
                PostgresBaseDropGenerator.access$getBuilder$p(this.this$0).phrase("alter table", (object = this.$c.getLikeTable()) != null && (object = PostgresBaseDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???", "drop constraint", PostgresBaseDropGenerator.access$pgIfExists(this.this$0), PostgresBaseDropGenerator.access$getScr$p(this.this$0, this.$c.getName()), PostgresBaseDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = postgresBaseDropGenerator;
                this.$c = postgresBaseConstraint;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTableColumn(PostgresBaseTableColumn column2) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, column2){
            final /* synthetic */ PostgresBaseDropGenerator this$0;
            final /* synthetic */ PostgresBaseTableColumn $column;

            public final void invoke() {
                PostgresBaseDropGenerator.access$getBuilder$p(this.this$0).phrase("alter table", PostgresBaseDropGenerator.access$currentScopeName(this.this$0, this.$column.getTable()), "drop column", PostgresBaseDropGenerator.access$pgIfExists(this.this$0), PostgresBaseDropGenerator.access$getScr$p(this.this$0, this.$column.getName()), PostgresBaseDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = postgresBaseDropGenerator;
                this.$column = postgresBaseTableColumn;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTable(PostgresBaseTable table) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, table){
            final /* synthetic */ PostgresBaseDropGenerator this$0;
            final /* synthetic */ PostgresBaseTable $table;

            public final void invoke() {
                PostgresBaseDropGenerator.access$getBuilder$p(this.this$0).phrase("drop table", PostgresBaseDropGenerator.access$ifExists(this.this$0), PostgresBaseDropGenerator.access$currentScopeName(this.this$0, this.$table), PostgresBaseDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = postgresBaseDropGenerator;
                this.$table = postgresBaseTable;
                super(0);
            }
        }, 3, null);
    }

    private final void generateView(PostgresBaseView view) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view){
            final /* synthetic */ PostgresBaseDropGenerator this$0;
            final /* synthetic */ PostgresBaseView $view;

            public final void invoke() {
                PostgresBaseDropGenerator.access$getBuilder$p(this.this$0).phrase("drop view", PostgresBaseDropGenerator.access$ifExists(this.this$0), PostgresBaseDropGenerator.access$currentScopeName(this.this$0, this.$view), PostgresBaseDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = postgresBaseDropGenerator;
                this.$view = postgresBaseView;
                super(0);
            }
        }, 3, null);
    }

    private final void generateDatabase(PostgresBaseDatabase db) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, db){
            final /* synthetic */ PostgresBaseDropGenerator this$0;
            final /* synthetic */ PostgresBaseDatabase $db;

            public final void invoke() {
                PostgresBaseDropGenerator.access$getBuilder$p(this.this$0).phrase("drop database", PostgresBaseDropGenerator.access$pgIfExists(this.this$0), PostgresBaseDropGenerator.access$getScr$p(this.this$0, this.$db.getName()));
            }
            {
                this.this$0 = postgresBaseDropGenerator;
                this.$db = postgresBaseDatabase;
                super(0);
            }
        }, 3, null);
    }

    private final void generateSchema(PostgresBaseSchema sc) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, sc){
            final /* synthetic */ PostgresBaseDropGenerator this$0;
            final /* synthetic */ PostgresBaseSchema $sc;

            public final void invoke() {
                PostgresBaseDropGenerator.access$getBuilder$p(this.this$0).phrase("drop schema", PostgresBaseDropGenerator.access$ifExists(this.this$0), PostgresBaseDropGenerator.access$getScr$p(this.this$0, this.$sc.getName()));
            }
            {
                this.this$0 = postgresBaseDropGenerator;
                this.$sc = postgresBaseSchema;
                super(0);
            }
        }, 3, null);
    }

    private final void generateFunction(PostgresBaseRoutine element) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element){
            final /* synthetic */ PostgresBaseDropGenerator this$0;
            final /* synthetic */ PostgresBaseRoutine $element;

            public final void invoke() {
                JBIterable args2 = this.$element.getArguments().jbi().filter((Condition)generateFunction.args.1.INSTANCE);
                PostgresBaseDropGenerator.access$getBuilder$p(this.this$0).phrase("drop function", PostgresBaseDropGenerator.access$pgIfExists(this.this$0), "" + PostgresBaseDropGenerator.access$currentScopeName(this.this$0, this.$element) + '(' + CollectionsKt.joinToString$default((Iterable)((Iterable)args2), null, null, null, (int)0, null, (Function1)((Function1)new Function1<PostgresBaseArgument, String>(this){
                    final /* synthetic */ generateFunction.1 this$0;

                    @NotNull
                    public final String invoke(PostgresBaseArgument it) {
                        PostgresBaseDropGenerator postgresBaseDropGenerator = this.this$0.this$0;
                        PostgresBaseArgument postgresBaseArgument = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)postgresBaseArgument, (String)"it");
                        return PostgresBaseDropGenerator.access$argDesc(postgresBaseDropGenerator, postgresBaseArgument);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)31, null) + ')', PostgresBaseDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = postgresBaseDropGenerator;
                this.$element = postgresBaseRoutine;
                super(0);
            }
        }, 3, null);
    }

    private final String argDesc(PostgresBaseArgument arg) {
        String string;
        block7: {
            String t;
            block6: {
                String string2;
                String dir;
                String string3;
                DataType dataType = arg.getDataType();
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"arg.dataType");
                t = this.script(dataType);
                switch (PostgresBaseDropGenerator$WhenMappings.$EnumSwitchMapping$0[arg.getArgumentDirection().ordinal()]) {
                    case 1: {
                        string3 = "inout";
                        break;
                    }
                    case 2: {
                        string3 = "out";
                        break;
                    }
                    default: {
                        string3 = null;
                    }
                }
                if ((string = (dir = string3)) == null) break block6;
                String it = string2 = string;
                string = "" + dir + ' ' + t;
                if (string != null) break block7;
            }
            string = t;
        }
        return string;
    }

    private final String pgIfExists() {
        return this.isPg() ? this.ifExists() : null;
    }

    private final boolean isPg() {
        return Intrinsics.areEqual((Object)this.getContext().getModel().getRdbms(), (Object)Postgres.RDBMS);
    }

    public PostgresBaseDropGenerator(@NotNull ScriptingContext context, @NotNull ScriptCategory category) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        super(context, category);
    }

    static {
        Companion = new Companion(null);
        SUPPORTED = SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.DATABASE, ObjectKind.SCHEMA, ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.ROUTINE, ObjectKind.KEY, ObjectKind.FOREIGN_KEY});
    }

    @NotNull
    public static final /* synthetic */ CodeTextBuilder access$getBuilder$p(PostgresBaseDropGenerator $this) {
        return $this.getBuilder();
    }

    @NotNull
    public static final /* synthetic */ String access$currentScopeName(PostgresBaseDropGenerator $this, @NotNull BasicElement $receiver) {
        return $this.currentScopeName($receiver);
    }

    @Nullable
    public static final /* synthetic */ String access$pgIfExists(PostgresBaseDropGenerator $this) {
        return $this.pgIfExists();
    }

    @NotNull
    public static final /* synthetic */ String access$getScr$p(PostgresBaseDropGenerator $this, @NotNull String $receiver) {
        return $this.getScr($receiver);
    }

    @Nullable
    public static final /* synthetic */ String access$restrictCascade(PostgresBaseDropGenerator $this) {
        return $this.restrictCascade();
    }

    @Nullable
    public static final /* synthetic */ String access$ifExists(PostgresBaseDropGenerator $this) {
        return $this.ifExists();
    }

    @NotNull
    public static final /* synthetic */ String access$argDesc(PostgresBaseDropGenerator $this, @NotNull PostgresBaseArgument arg) {
        return $this.argDesc(arg);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rR\"\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresBaseDropGenerator$Companion;", "", "()V", "SUPPORTED", "", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "getSUPPORTED", "()Ljava/util/Set;", "canDrop", "", "kind", "context", "", "database-scripting"})
    public static final class Companion {
        private final Set<ObjectKind> getSUPPORTED() {
            return SUPPORTED;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean canDrop(@NotNull ObjectKind kind, @NotNull Iterable<? extends ObjectKind> context) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(context, (String)"context");
            if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.COLUMN)) {
                ObjectKind objectKind = (ObjectKind)CollectionsKt.firstOrNull(context);
                if (objectKind == null) {
                    objectKind = ObjectKind.TABLE;
                }
                if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) return true;
            }
            if (!this.getSUPPORTED().contains(kind)) return false;
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

