/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.redshift;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.redshift.RedshiftExternalTable;
import com.intellij.database.model.redshift.RedshiftUser;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.postgres.PostgresBaseDropGenerator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/scripting/redshift/RedshiftDropGenerator;", "Lcom/intellij/database/scripting/postgres/PostgresBaseDropGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptCategory;)V", "generateElement", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateExternalTable", "table", "Lcom/intellij/database/model/redshift/RedshiftExternalTable;", "generateUser", "user", "Lcom/intellij/database/model/redshift/RedshiftUser;", "Companion", "database-scripting"})
public final class RedshiftDropGenerator
extends PostgresBaseDropGenerator {
    private static final Set<ObjectKind> SUPPORTED;
    public static final Companion Companion;

    @Override
    protected void generateElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof RedshiftUser) {
            this.generateUser((RedshiftUser)element);
        } else if (basicElement instanceof RedshiftExternalTable) {
            this.generateExternalTable((RedshiftExternalTable)element);
        } else {
            super.generateElement(element);
        }
    }

    private final void generateUser(RedshiftUser user) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, user){
            final /* synthetic */ RedshiftDropGenerator this$0;
            final /* synthetic */ RedshiftUser $user;

            public final void invoke() {
                RedshiftDropGenerator.access$getBuilder$p(this.this$0).phrase("drop user", RedshiftDropGenerator.access$ifExists(this.this$0), RedshiftDropGenerator.access$currentScopeName(this.this$0, (BasicElement)this.$user));
            }
            {
                this.this$0 = redshiftDropGenerator;
                this.$user = redshiftUser;
                super(0);
            }
        }, 3, null);
    }

    private final void generateExternalTable(RedshiftExternalTable table) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, table){
            final /* synthetic */ RedshiftDropGenerator this$0;
            final /* synthetic */ RedshiftExternalTable $table;

            public final void invoke() {
                CodeTextBuilder codeTextBuilder = RedshiftDropGenerator.access$getBuilder$p(this.this$0);
                CharSequence[] charSequenceArray = new CharSequence[3];
                charSequenceArray[0] = "drop table";
                charSequenceArray[1] = RedshiftDropGenerator.access$ifExists(this.this$0);
                StringBuilder stringBuilder = new StringBuilder();
                String string = this.$table.getSchemaName();
                if (string == null || (string = RedshiftDropGenerator.access$getScr$p(this.this$0, string)) == null) {
                    string = "???";
                }
                charSequenceArray[2] = stringBuilder.append(string).append(".").append(RedshiftDropGenerator.access$getScr$p(this.this$0, this.$table.getName())).toString();
                codeTextBuilder.phrase(charSequenceArray);
            }
            {
                this.this$0 = redshiftDropGenerator;
                this.$table = redshiftExternalTable;
                super(0);
            }
        }, 3, null);
    }

    public RedshiftDropGenerator(@NotNull ScriptingContext context, @NotNull ScriptCategory category) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        super(context, category);
    }

    static {
        Companion = new Companion(null);
        SUPPORTED = SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.USER, ObjectKind.FOREIGN_TABLE, ObjectKind.EXTERNAL_SCHEMA});
    }

    @NotNull
    public static final /* synthetic */ CodeTextBuilder access$getBuilder$p(RedshiftDropGenerator $this) {
        return $this.getBuilder();
    }

    @Nullable
    public static final /* synthetic */ String access$ifExists(RedshiftDropGenerator $this) {
        return $this.ifExists();
    }

    @NotNull
    public static final /* synthetic */ String access$currentScopeName(RedshiftDropGenerator $this, @NotNull BasicElement $receiver) {
        return $this.currentScopeName($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$getScr$p(RedshiftDropGenerator $this, @NotNull String $receiver) {
        return $this.getScr($receiver);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rR\"\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/scripting/redshift/RedshiftDropGenerator$Companion;", "", "()V", "SUPPORTED", "", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "getSUPPORTED", "()Ljava/util/Set;", "canDrop", "", "kind", "context", "", "database-scripting"})
    public static final class Companion {
        private final Set<ObjectKind> getSUPPORTED() {
            return SUPPORTED;
        }

        public final boolean canDrop(@NotNull ObjectKind kind, @NotNull Iterable<? extends ObjectKind> context) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(context, (String)"context");
            return PostgresBaseDropGenerator.Companion.canDrop(kind, context) || this.getSUPPORTED().contains(kind);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

