/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.model.DasIndex;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.view.editors.DatabaseColumnRefEditor;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseIndexEditor;
import com.intellij.database.view.editors.EmbComboBox;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.database.view.models.IndexEditorModel;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DatabaseIndexColumnEditor
implements DatabaseEditorUtil.EmbeddableEditor {
    private final DatabaseIndexEditor myIndexEditor;
    private final DatabaseEditorCapabilities.IndexColumnEditorCaps myCaps;
    private JPanel myPanel;
    private EditorTextField myColumnEditorComponent;
    private JComboBox mySorting;
    private final DatabaseColumnRefEditor myColumnEditor;
    private boolean myValid;

    public DatabaseIndexColumnEditor(@NotNull DatabaseIndexEditor indexEditor, @NotNull DatabaseEditorCapabilities.IndexColumnEditorCaps caps) {
        if (indexEditor == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(0);
        }
        if (caps == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(1);
        }
        this.myIndexEditor = indexEditor;
        this.myCaps = caps;
        this.myColumnEditor = new DatabaseColumnRefEditor(this.myIndexEditor.getContext());
        this.$$$setupUI$$$();
        this.myColumnEditorComponent.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (!((DatabaseIndexColumnEditor)DatabaseIndexColumnEditor.this).myIndexEditor.myUpdating) {
                    ArrayList items = ContainerUtil.newArrayList(DatabaseIndexColumnEditor.this.getIndexModel().getItems());
                    int index = DatabaseIndexColumnEditor.this.myIndexEditor.getIndex(DatabaseIndexColumnEditor.this);
                    DeColumn item = DatabaseIndexColumnEditor.this.getColumn();
                    items.set(index, new DeIndex.Item(item, ((DeIndex.Item)items.get((int)index)).sorting));
                    DatabaseIndexColumnEditor.this.getIndexModel().setItems(items);
                    DatabaseIndexColumnEditor.this.getIndexModel().commit();
                }
            }
        });
        this.mySorting.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!((DatabaseIndexColumnEditor)DatabaseIndexColumnEditor.this).myIndexEditor.myUpdating) {
                    ArrayList items = ContainerUtil.newArrayList(DatabaseIndexColumnEditor.this.getIndexModel().getItems());
                    int index = DatabaseIndexColumnEditor.this.myIndexEditor.getIndex(DatabaseIndexColumnEditor.this);
                    items.set(index, new DeIndex.Item(((DeIndex.Item)items.get((int)index)).column, (DasIndex.Sorting)e.getItem()));
                    DatabaseIndexColumnEditor.this.getIndexModel().setItems(items);
                    DatabaseIndexColumnEditor.this.getIndexModel().commit();
                }
            }
        });
        this.mySorting.setEnabled(this.myCaps.getSorting().isAvailable());
    }

    @NotNull
    public IndexEditorModel getIndexModel() {
        IndexEditorModel indexEditorModel = this.myIndexEditor.getIndexModel();
        if (indexEditorModel == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(2);
        }
        return indexEditorModel;
    }

    @NotNull
    public DeIndex.Item getItem() {
        DeIndex.Item item = this.myIndexEditor.getIndex().items.get(this.myIndexEditor.getIndex(this));
        if (item == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(3);
        }
        return item;
    }

    @Override
    @NotNull
    public Iterable<Pair<String, TextAttributesKey>> getRowText() {
        String sorting = this.getSorting();
        DeColumn column2 = this.getColumn();
        Iterable<Pair<String, TextAttributesKey>> iterable = new DatabaseEditorUtil.ColoredFragmentsBuilder().appendRef(this.myIndexEditor.getObjectName(column2), DatabaseEditorBaseEx.isGood(column2)).append((sorting.isEmpty() ? "" : " ") + sorting).build();
        if (iterable == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(4);
        }
        return iterable;
    }

    @Override
    public boolean isObjectValid() {
        return this.myValid;
    }

    @NotNull
    public String getSorting() {
        Object item = this.mySorting.getSelectedItem();
        if (item == DasIndex.Sorting.ASCENDING) {
            if ("ASC" == null) {
                DatabaseIndexColumnEditor.$$$reportNull$$$0(5);
            }
            return "ASC";
        }
        if (item == DasIndex.Sorting.DESCENDING) {
            if ("DESC" == null) {
                DatabaseIndexColumnEditor.$$$reportNull$$$0(6);
            }
            return "DESC";
        }
        if ("" == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(7);
        }
        return "";
    }

    @Override
    public boolean canDoAnything() {
        return true;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myColumnEditorComponent.getFocusTarget();
        if (jComponent == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(9);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public JComponent[] getFocusableComponents() {
        JComponent[] jComponentArray = new JComponent[]{this.myColumnEditorComponent.getFocusTarget(), this.mySorting};
        if (jComponentArray == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(10);
        }
        return jComponentArray;
    }

    @NotNull
    public DeColumn getColumn() {
        DeColumn deColumn = this.myColumnEditor.getObjectOrStub(this.myIndexEditor.getTable());
        if (deColumn == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(11);
        }
        return deColumn;
    }

    public void updateFromModel(int idx) {
        DeIndex.Item item = this.getIndexModel().getItems().get(idx);
        this.myColumnEditor.setTable(this.myIndexEditor.getTable());
        this.myColumnEditor.setObject(item.column);
        this.mySorting.setSelectedItem(item.sorting);
        this.myValid = item.column != null && !EditorModelUtil.isStub(item.column) && item.column.isInTable();
    }

    @NotNull
    public EditorTextField getColumnEditor() {
        EditorTextField editorTextField = this.myColumnEditorComponent;
        if (editorTextField == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(12);
        }
        return editorTextField;
    }

    @NotNull
    public JComboBox getSortingEditor() {
        JComboBox jComboBox = this.mySorting;
        if (jComboBox == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(13);
        }
        return jComboBox;
    }

    private void createUIComponents() {
        this.myColumnEditorComponent = this.myColumnEditor.getEditor();
        this.mySorting = new EmbComboBox((ComboBoxModel)new DefaultComboBoxModel<DasIndex.Sorting>(DasIndex.Sorting.values()));
        this.mySorting.setRenderer(EmbComboBox.ENUM_RENDERER);
    }

    @NotNull
    public DatabaseIndexEditor getIndexEditor() {
        DatabaseIndexEditor databaseIndexEditor = this.myIndexEditor;
        if (databaseIndexEditor == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(14);
        }
        return databaseIndexEditor;
    }

    public DatabaseEditorCapabilities.IndexColumnEditorCaps getCaps() {
        return this.myCaps;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseIndexColumnEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseIndexColumnEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getItem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowText";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSorting";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusableComponents";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumn";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnEditor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortingEditor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Name:");
        jBLabel.setDisplayedMnemonic('N');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myColumnEditorComponent;
        jPanel.add((Component)editorTextField, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Sorting:");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = this.mySorting;
        jPanel.add((Component)jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

