/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.google.common.collect.Iterables;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.editors.DatabaseColumnEditor;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseTableColumnsEditor;
import com.intellij.database.view.models.ColumnEditorModel;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.IndexEditorModel;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.models.TableKeyEditorModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableColumnEditor
extends DatabaseEditorBaseEx
implements DatabaseEditorUtil.EmbeddableEditor {
    protected final DatabaseTableColumnsEditor myColumnsEditor;
    private final DatabaseColumnEditor myColumnEditor;
    private final TableEditorModel myTableModel;
    private final DatabaseEditorCapabilities.TableColumnEditorCaps myCaps;
    private final JCheckBox myUniqueCheckBox;
    private final JCheckBox myPrimaryKeyCheckBox;
    private TableKeyEditorModel myCachedPk;
    private IndexEditorModel myCachedUc;
    private Disposable myCachedUcListenerHolder;
    private Disposable myCachedPkListenerHolder;
    private final EditorModelBase.Listener myObjectListener;
    protected Iterable<Pair<String, TextAttributesKey>> myCachedText;

    public DatabaseTableColumnEditor(@NotNull DatabaseEditorState state, @NotNull TableEditorModel tableModel, @NotNull ColumnEditorModel columnModel, @NotNull DatabaseEditorCapabilities.TableColumnEditorCaps columnCaps, @NotNull DatabaseTableColumnsEditor columnsEditor) {
        if (state == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(0);
        }
        if (tableModel == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(1);
        }
        if (columnModel == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(2);
        }
        if (columnCaps == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(3);
        }
        if (columnsEditor == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(4);
        }
        super(state);
        this.myObjectListener = new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseTableColumnEditor.this.fromModelToUi();
            }
        };
        this.myTableModel = tableModel;
        this.myCaps = columnCaps;
        this.myColumnsEditor = columnsEditor;
        this.myColumnEditor = this.createEditor(state, columnModel, columnCaps);
        Disposer.register((Disposable)this, (Disposable)this.myColumnEditor);
        this.myUniqueCheckBox = new JBCheckBox("Unique");
        this.myColumnEditor.addToBoxesPanel(this.myUniqueCheckBox);
        this.myPrimaryKeyCheckBox = new JBCheckBox("Primary key");
        this.myColumnEditor.addToBoxesPanel(this.myPrimaryKeyCheckBox);
        this.myUniqueCheckBox.setMnemonic(85);
        this.myPrimaryKeyCheckBox.setMnemonic(80);
        this.myUniqueCheckBox.setVisible(this.myCaps.getUnique().isSupported());
        this.myUniqueCheckBox.setEnabled(this.myCaps.getUnique().isAvailable());
        this.myPrimaryKeyCheckBox.setVisible(this.myCaps.getPrimaryKey().isSupported());
        this.myPrimaryKeyCheckBox.setEnabled(this.myCaps.getPrimaryKey().isAvailable());
        tableModel.addListener(this::dropCache, this);
        this.initSubscriptions();
        this.updateFromModel();
    }

    @NotNull
    protected DatabaseColumnEditor createEditor(@NotNull DatabaseEditorState state, @NotNull ColumnEditorModel columnModel, @NotNull DatabaseEditorCapabilities.TableColumnEditorCaps columnCaps) {
        if (state == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(5);
        }
        if (columnModel == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(6);
        }
        if (columnCaps == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(7);
        }
        DatabaseColumnEditor databaseColumnEditor = new DatabaseColumnEditor(state, columnModel, columnCaps);
        if (databaseColumnEditor == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(8);
        }
        return databaseColumnEditor;
    }

    @NotNull
    public DatabaseEditorCapabilities.TableColumnEditorCaps getCaps() {
        DatabaseEditorCapabilities.TableColumnEditorCaps tableColumnEditorCaps = this.myCaps;
        if (tableColumnEditorCaps == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(9);
        }
        return tableColumnEditorCaps;
    }

    private void initSubscriptions() {
        this.myTableModel.addListener(this.myObjectListener, this);
        this.getColumnModel().addListener(this.myObjectListener, this);
        this.myUniqueCheckBox.addItemListener(e -> {
            if (!this.myUpdating) {
                this.updateUniqueConstraint(this.myUniqueCheckBox.isSelected());
            }
        });
        this.myPrimaryKeyCheckBox.addItemListener(e -> {
            if (!this.myUpdating) {
                this.updatePrimaryKey(this.myPrimaryKeyCheckBox.isSelected());
            }
        });
    }

    private void updatePrimaryKey(boolean selected) {
        DeTableKey key2;
        DeTableKey constraint = this.getColumnPrimaryKey(this.getColumn());
        if (constraint != null == selected) {
            return;
        }
        if (constraint != null && (this.myCachedPk == null || this.myCachedPk.getObject() != constraint)) {
            this.subscribePrimaryKey(false);
            this.myCachedPk = this.myTableModel.modelsCache.get(constraint, TableKeyEditorModel.class);
        }
        if ((key2 = this.myTableModel.getPrimaryKey()) != null && key2.columns.size() == 1) {
            this.myTableModel.removeTableKey(key2);
        }
        if (!selected) {
            this.myTableModel.setPrimaryKey(null);
            this.subscribeUniqueConstraint(false);
        } else {
            if (this.myCachedPk == null) {
                this.myCachedPk = this.myTableModel.modelsCache.get(this.myTableModel.createTableKey(this.getColumn()), TableKeyEditorModel.class);
            }
            this.myTableModel.setPrimaryKey((DeTableKey)this.myCachedPk.getObject());
        }
        this.myTableModel.commit();
    }

    @NotNull
    public ColumnEditorModel getColumnModel() {
        ColumnEditorModel columnEditorModel = this.myColumnEditor.getColumnModel();
        if (columnEditorModel == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(10);
        }
        return columnEditorModel;
    }

    private void subscribePrimaryKey(boolean sub) {
        if (this.myCachedPkListenerHolder != null) {
            Disposer.dispose((Disposable)this.myCachedPkListenerHolder);
            this.myCachedPkListenerHolder = null;
        }
        if (sub) {
            this.myCachedPkListenerHolder = Disposer.newDisposable();
            Disposer.register((Disposable)this, (Disposable)this.myCachedPkListenerHolder);
            this.myCachedPk.addListener(this.myObjectListener, this.myCachedPkListenerHolder);
        }
    }

    private void subscribeUniqueConstraint(boolean sub) {
        if (this.myCachedUcListenerHolder != null) {
            Disposer.dispose((Disposable)this.myCachedUcListenerHolder);
            this.myCachedUcListenerHolder = null;
        }
        if (sub) {
            this.myCachedUcListenerHolder = Disposer.newDisposable();
            Disposer.register((Disposable)this, (Disposable)this.myCachedUcListenerHolder);
            this.myCachedUc.addListener(this.myObjectListener, this.myCachedUcListenerHolder);
        }
    }

    private void updateUniqueConstraint(boolean selected) {
        DeIndex index = this.getColumnIndex(this.getColumn(), false);
        if ((index != null && index.isUnique()) == selected) {
            return;
        }
        if (index != null && (this.myCachedUc == null || this.myCachedUc.getObject() != index)) {
            this.subscribeUniqueConstraint(false);
            this.myCachedUc = this.myTableModel.modelsCache.get(index, IndexEditorModel.class);
        }
        if (!selected) {
            this.myTableModel.removeIndex(index);
            this.subscribeUniqueConstraint(false);
        } else {
            if (this.myCachedUc == null) {
                this.myCachedUc = this.myTableModel.modelsCache.get(this.myTableModel.createIndex(new DeIndex.Item(this.getColumn(), DasIndex.Sorting.NONE)), IndexEditorModel.class);
            }
            this.myCachedUc.setUnique(true);
            this.myCachedUc.commit();
            this.subscribeUniqueConstraint(true);
            this.myTableModel.addIndex((DeIndex)this.myCachedUc.getObject());
        }
        this.myTableModel.commit();
    }

    @NotNull
    public DeColumn getColumn() {
        DeColumn deColumn = (DeColumn)this.getColumnModel().getObject();
        if (deColumn == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(11);
        }
        return deColumn;
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.getTableModel().getObject();
        if (deTable == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(12);
        }
        return deTable;
    }

    @Override
    @NotNull
    public ObjectEditorModel<DeTable> getModel() {
        TableEditorModel tableEditorModel = this.getTableModel();
        if (tableEditorModel == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(13);
        }
        return tableEditorModel;
    }

    @Override
    protected void updateFromModelImpl() {
        if (this.myCachedUc != null) {
            this.myCachedUc.commit();
        }
        if (this.myCachedPk != null) {
            this.myCachedPk.commit();
        }
        DatabaseTableColumnEditor.setValue(this.myUniqueCheckBox, this.getColumnIndex(this.getColumn(), true) != null);
        DatabaseTableColumnEditor.setValue(this.myPrimaryKeyCheckBox, this.getColumnPrimaryKey(this.getColumn()) != null);
    }

    public DatabaseColumnEditor getColumnEditor() {
        return this.myColumnEditor;
    }

    private DeIndex getColumnIndex(@NotNull DeColumn column2, boolean unique) {
        if (column2 == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(14);
        }
        for (DeIndex o : this.myTableModel.getIndices()) {
            Iterator<DeColumn> it;
            if (unique && !o.unique || !(it = o.getColumns().iterator()).hasNext() || it.next() != column2 || it.hasNext()) continue;
            return o;
        }
        return null;
    }

    private DeTableKey getColumnPrimaryKey(@NotNull DeColumn column2) {
        DeTableKey pk;
        if (column2 == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(15);
        }
        return (pk = this.myTableModel.getPrimaryKey()) == null || !pk.columns.equals(Collections.singletonList(column2)) ? null : pk;
    }

    @NotNull
    public TableEditorModel getTableModel() {
        TableEditorModel tableEditorModel = this.myTableModel;
        if (tableEditorModel == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(16);
        }
        return tableEditorModel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myColumnEditor.getPreferredFocusedComponent();
        if (jComponent == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(17);
        }
        return jComponent;
    }

    @Override
    public boolean canDoAnything() {
        return this.myCaps.canDoAnything() && ((DeColumn)this.myColumnEditor.getColumnModel().getObject()).isEnabled();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myColumnEditor.getComponent();
        if (jComponent == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(18);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public JComponent[] getFocusableComponents() {
        JComponent[] jComponentArray = (JComponent[])ArrayUtil.mergeArrays((Object[])this.myColumnEditor.getFocusableComponents(), (Object[])new JComponent[]{this.myUniqueCheckBox, this.myPrimaryKeyCheckBox});
        if (jComponentArray == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(19);
        }
        return jComponentArray;
    }

    @Override
    @NotNull
    public Iterable<Pair<String, TextAttributesKey>> getRowText() {
        Iterable<Pair<String, TextAttributesKey>> iterable;
        if (this.myColumnsEditor.getActiveEditor() != null && this.myCachedText != null) {
            iterable = this.myCachedText;
        } else {
            this.myCachedText = this.getColumnDefinition();
            iterable = this.myCachedText;
        }
        if (iterable == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(20);
        }
        return iterable;
    }

    void dropCache() {
        this.myCachedText = null;
    }

    @NotNull
    public Iterable<Pair<String, TextAttributesKey>> getColumnDefinition() {
        DatabaseEditorUtil.ColoredFragmentsBuilder res = new DatabaseEditorUtil.ColoredFragmentsBuilder();
        Iterable<Pair<String, TextAttributesKey>> name = this.getColumnName();
        DeColumn column2 = (DeColumn)this.getColumnModel().getObject();
        int length = this.myColumnsEditor.getMaxLength((Function<DatabaseTableColumnEditor, Iterable<Pair<String, TextAttributesKey>>>)((Function)DatabaseTableColumnEditor::getColumnName));
        int currentLength = DatabaseEditorUtil.computeLength(name);
        DatabaseEditorUtil.padText(res, length, currentLength);
        String type = column2.dataType;
        DeTableKey key2 = column2.table.keys.getPrimaryKey();
        String pk = key2 != null && ContainerUtil.find(key2.getColumns(), (Object)column2) != null ? " -- part of primary key" : "";
        String comment = column2.comment != null ? " /*" + column2.comment + "*/" : "";
        String defaultText = column2.defaultValue != null ? " default " + column2.defaultValue : "";
        String text2 = type + defaultText + pk + comment;
        Iterable iterable = Iterables.concat(name, res.append(text2, column2.isEnabled() ? null : DatabaseColors.STRUCTURE_HIDDEN_COLUMN).build());
        if (iterable == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(21);
        }
        return iterable;
    }

    @NotNull
    public Iterable<Pair<String, TextAttributesKey>> getColumnName() {
        JBIterable jBIterable = JBIterable.of((Object)Pair.create((Object)((DeColumn)this.getColumnModel().getObject()).name, null));
        if (jBIterable == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(22);
        }
        return jBIterable;
    }

    @Override
    public boolean isObjectValid() {
        return true;
    }

    @NotNull
    public JCheckBox getUniqueCheckBox() {
        JCheckBox jCheckBox = this.myUniqueCheckBox;
        if (jCheckBox == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(23);
        }
        return jCheckBox;
    }

    @NotNull
    public JCheckBox getPrimaryKeyCheckBox() {
        JCheckBox jCheckBox = this.myPrimaryKeyCheckBox;
        if (jCheckBox == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(24);
        }
        return jCheckBox;
    }

    @Override
    @Nullable
    public DeObject getKeyObject() {
        return this.getColumn();
    }

    @NotNull
    public static DatabaseEditorCapabilities.TableColumnEditorCaps getTableColumnCaps(@NotNull DatabaseEditorCapabilities.TableEditorCaps tableCaps, @Nullable DasTable table, @Nullable DasColumn column2) {
        if (tableCaps == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(25);
        }
        assert (table != null || column2 == null);
        DasTableKey pk = table == null ? null : DasUtil.getPrimaryKey((DasTable)table);
        boolean isPk = pk != null && column2 != null && pk.getColumnsRef().size() == 1 && DasUtil.containsName((String)column2.getName(), (MultiRef)pk.getColumnsRef());
        boolean isUnique = false;
        if (column2 != null) {
            for (DasTableKey o : table.getDasChildren(ObjectKind.KEY).filter(DasTableKey.class)) {
                if (o.getColumnsRef().size() != 1 || !DasUtil.containsName((String)column2.getName(), (MultiRef)o.getColumnsRef())) continue;
                isUnique = true;
                break;
            }
        }
        DatabaseEditorCapabilities.TableColumnEditorCaps tableColumnEditorCaps = new DatabaseEditorCapabilities.TableColumnEditorCaps(tableCaps, tableCaps.getColumnCaps(column2 != null), pk != null, isPk, isUnique);
        if (tableColumnEditorCaps == null) {
            DatabaseTableColumnEditor.$$$reportNull$$$0(26);
        }
        return tableColumnEditorCaps;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableModel";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnModel";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnCaps";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsEditor";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseTableColumnEditor";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableCaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableColumnEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaps";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumn";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableModel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusableComponents";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowText";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnDefinition";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueCheckBox";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryKeyCheckBox";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableColumnCaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getColumnIndex";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getColumnPrimaryKey";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTableColumnCaps";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

