/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.redshift;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.postgres.PostgresDialectBase;
import com.intellij.sql.dialects.postgres.PostgresReservedKeywords;
import com.intellij.sql.dialects.postgres.PostgresTokens;
import com.intellij.sql.dialects.postgres.psi.PgCreatePreparedStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedshiftDialect
extends PostgresDialectBase {
    public static final RedshiftDialect INSTANCE = new RedshiftDialect();

    public RedshiftDialect() {
        super("Redshift");
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        com.intellij.database.dialects.RedshiftDialect redshiftDialect = com.intellij.database.dialects.RedshiftDialect.INSTANCE;
        if (redshiftDialect == null) {
            RedshiftDialect.$$$reportNull$$$0(0);
        }
        return redshiftDialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map<String, SqlFunctionDefinition> map2 = LazyData.ourFunctionMap;
        if (map2 == null) {
            RedshiftDialect.$$$reportNull$$$0(1);
        }
        return map2;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(PostgresTokens.class);
        if (set == null) {
            RedshiftDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            RedshiftDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        PgCreatePreparedStatement preparedStatement;
        if (element == null) {
            RedshiftDialect.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            RedshiftDialect.$$$reportNull$$$0(5);
        }
        if (!super.processReservedEntitiesWithType(name, element, resolve, processor)) {
            return false;
        }
        if (resolve && name != null && LazyData.ARG_PATTERN.matcher(name).matches() && (preparedStatement = (PgCreatePreparedStatement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{PgCreatePreparedStatement.class})) != null && !processor.executeTarget(preparedStatement.getArgument(name), element, (SqlType)SqlType.UNKNOWN, null, ResolveState.initial())) {
            return false;
        }
        if (processor.isExpected(ObjectKind.COLUMN)) {
            for (DasObject entity : LazyData.RESERVED_INTEGER_ENTITIES.values()) {
                if (RedshiftDialect.processReservedEntitiesWithTypeSimple(entity, this.INTEGER, name, element, resolve, processor, true, false)) continue;
                return false;
            }
        }
        if (element instanceof SqlReferenceExpression && resolve && ((SqlReferenceExpression)element).getQualifierExpression() == null) {
            for (ReservedEntity object : LazyData.ourObjects) {
                if (processor.executeTarget(object, element, null, false, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        RawConnectionConfig config = SqlImportUtil.getConnectionConfig(dataSource);
        ObjectName dbname = ObjectName.plain((String)((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtil.getDatabaseName(config), (Object)SqlDialectImplUtil.getUserName(config))));
        DasNamespace namespace = RedshiftDialect.getDefaultNamespace(dataSource, dbname);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)namespace, DbImplUtil.isSchema((DasObject)namespace) ? null : TreePatternUtils.create(ObjectName.quoted((String)"public"), SqlDbElementType.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                RedshiftDialect.$$$reportNull$$$0(6);
            }
            return treePattern;
        }
        TreePattern treePattern = new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.optAr(SqlImportUtil.createPositiveDatabase(dataSource == null, dbname, TreePatternUtils.create(ObjectName.quoted((String)"public"), SqlDbElementType.SCHEMA, new TreePatternNode.Group[0])))));
        if (treePattern == null) {
            RedshiftDialect.$$$reportNull$$$0(7);
        }
        return treePattern;
    }

    @Override
    @NotNull
    public TreePattern applyImplicitImports(@Nullable ObjectName[] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            RedshiftDialect.$$$reportNull$$$0(8);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath(pattern, dsNames, Collections.singletonList(ObjectName.quoted((String)"pg_catalog")), true, SqlImportUtil.DATA_SOURCE, SqlDbElementType.DATABASE, SqlDbElementType.SCHEMA);
        if (treePattern == null) {
            RedshiftDialect.$$$reportNull$$$0(9);
        }
        return treePattern;
    }

    @Override
    public boolean isResolveTargetAccepted(@Nullable PsiElement element, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            RedshiftDialect.$$$reportNull$$$0(10);
        }
        if (!strict && type == SqlDbElementType.USER && expectedTypes.contains(SqlDbElementType.ROLE)) {
            return true;
        }
        if (strict) {
            if (type == SqlDbElementType.FOREIGN_TABLE && expectedTypes.contains(SqlDbElementType.TABLE)) {
                return true;
            }
            if (type == SqlDbElementType.EXTERNAL_SCHEMA && expectedTypes.contains(SqlDbElementType.SCHEMA)) {
                return true;
            }
        }
        return super.isResolveTargetAccepted(element, type, expectedTypes, place, strict, isCompletion);
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            RedshiftDialect.$$$reportNull$$$0(11);
        }
        return true;
    }

    @Override
    public boolean isMajorChild(@NotNull ObjectKind kind) {
        if (kind == null) {
            RedshiftDialect.$$$reportNull$$$0(12);
        }
        return kind == SqlDbElementType.KEY || kind == SqlDbElementType.INDEX;
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        T parentTypes = super.getParentDbTypes(result2, type);
        if (type == SqlDbElementType.TABLE) {
            parentTypes.add((ObjectKind)SqlDbElementType.EXTERNAL_SCHEMA);
        }
        return parentTypes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/redshift/RedshiftDialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/redshift/RedshiftDialect";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isMajorChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LazyData {
        public static final Pattern ARG_PATTERN = Pattern.compile("\\$\\d+");
        static final Map<String, SqlFunctionDefinition> ourFunctionMap = Collections.unmodifiableMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
        static final List<ReservedEntity> ourObjects = SqlDialectImplUtil.loadObjects(INSTANCE, "fallback.txt");
        static final NullableFunction<String, IElementType> ourReservedTokens = SqlTokenRegistry.getTokenProvider(PostgresReservedKeywords.class);
        static final Set<IElementType> ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlTokens.SQL_QUESTION_MARK, SqlTokens.PG_OP_ABS, SqlTokens.SQL_OP_NOT2, SqlTokens.PG_OP_BITWISE_XOR, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_LOGICAL_AND, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_OP_NULLSAFE_EQ, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.PG_OP_PRIME, SqlTokens.PG_OP_CUSTOM, SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_PLUS_EQ, SqlTokens.SQL_OP_MINUS_EQ, SqlTokens.SQL_OP_MUL_EQ, SqlTokens.SQL_OP_DIV_EQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQEQ, SqlTokens.SQL_OP_NEQ3, SqlTokens.SQL_OP_MODULO_EQ, SqlTokens.SQL_OP_BITWISE_AND_EQ, SqlTokens.SQL_OP_BITWISE_OR_EQ, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_BITWISE_XOR, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_NEQ2, SqlTokens.ORA_OP_JOIN});
        static final Map<String, DasObject> RESERVED_INTEGER_ENTITIES = SqlDialectImplUtil.buildEntities(ObjectKind.COLUMN, "OID", "TABLEOID", "XMIN", "CMIN", "XMAX", "CMAX", "CTID");

        private LazyData() {
        }
    }
}

