/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.sybase;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.mssql.MssqlDialect;
import com.intellij.sql.dialects.sybase.SybaseOptionalKeywords;
import com.intellij.sql.dialects.sybase.SybaseReservedKeywords;
import com.intellij.sql.dialects.sybase.SybaseTokens;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SybaseDialect
extends SqlLanguageDialectEx {
    public static final SybaseDialect INSTANCE = new SybaseDialect();

    public SybaseDialect() {
        super("Sybase");
    }

    @NotNull
    public String getDisplayName() {
        if ("Sybase" == null) {
            SybaseDialect.$$$reportNull$$$0(0);
        }
        return "Sybase";
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        com.intellij.database.dialects.SybaseDialect sybaseDialect = com.intellij.database.dialects.SybaseDialect.INSTANCE;
        if (sybaseDialect == null) {
            SybaseDialect.$$$reportNull$$$0(1);
        }
        return sybaseDialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map<String, SqlFunctionDefinition> map2 = LazyData.ourFunctionMap;
        if (map2 == null) {
            SybaseDialect.$$$reportNull$$$0(2);
        }
        return map2;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(SybaseTokens.class);
        if (set == null) {
            SybaseDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            SybaseDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String referenceName, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            SybaseDialect.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            SybaseDialect.$$$reportNull$$$0(6);
        }
        for (ReservedEntity.Typed entity : LazyData.ourTypedEntities) {
            if (SybaseDialect.processReservedEntitiesWithTypeSimple(entity, entity.type, referenceName, element, resolve, processor, true, null)) continue;
            return false;
        }
        return MssqlDialect.INSTANCE.processReservedEntitiesWithType(referenceName, element, resolve, processor);
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public String quoteIdentifier(@NotNull SqlIdentifier identifier, @NotNull String newElementName) {
        ObjectKind type;
        PsiElement parent;
        if (identifier == null) {
            SybaseDialect.$$$reportNull$$$0(7);
        }
        if (newElementName == null) {
            SybaseDialect.$$$reportNull$$$0(8);
        }
        Object object = (parent = identifier.getParent()) instanceof SqlReferenceExpression ? ((SqlReferenceExpression)parent).getReferenceElementType().getTargetKind() : (type = parent instanceof SqlDefinition ? ((SqlDefinition)parent).getKind() : null);
        if (type == ObjectKind.VARIABLE) {
            return newElementName.replace(' ', '_');
        }
        return super.quoteIdentifier(identifier, newElementName);
    }

    @Override
    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        if (type == SqlDbElementType.ANY && MssqlDialect.isExecArg(o)) {
            return false;
        }
        return super.shallResolve(o, type);
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            SybaseDialect.$$$reportNull$$$0(9);
        }
        return !this.getKeywords().contains(ref);
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, ObjectName[] dsNames) {
        ObjectName dbname = SybaseDialect.getDatabaseName(dataSource);
        ObjectName schemaName = SybaseDialect.getSchemaName(dataSource);
        DasNamespace namespace = SybaseDialect.getDefaultNamespace(dataSource, dbname);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)namespace, namespace.getKind() == ObjectKind.SCHEMA ? null : TreePatternUtils.create(schemaName, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                SybaseDialect.$$$reportNull$$$0(10);
            }
            return treePattern;
        }
        TreePattern treePattern = new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.optAr(SqlImportUtil.createPositiveDatabase(dataSource == null, dbname, SqlImportUtil.createNodeIfNotNull(schemaName, ObjectKind.SCHEMA, new TreePatternNode.Group[0])))));
        if (treePattern == null) {
            SybaseDialect.$$$reportNull$$$0(11);
        }
        return treePattern;
    }

    @Nullable
    private static ObjectName getSchemaName(@Nullable DbDataSource dataSource) {
        return ObjectName.plain((String)SqlDialectImplUtil.getUserName(SqlImportUtil.getConnectionConfig(dataSource)));
    }

    @Nullable
    private static ObjectName getDatabaseName(@Nullable DbDataSource dataSource) {
        return ObjectName.plain((String)((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtil.getDatabaseName(SqlImportUtil.getConnectionConfig(dataSource)), (Object)"master")));
    }

    @Override
    @NotNull
    public TreePattern applyImplicitImports(@Nullable ObjectName[] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            SybaseDialect.$$$reportNull$$$0(12);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath(pattern, dsNames, Collections.singletonList(ObjectName.plain((String)"dbo")), false, SqlImportUtil.DATA_SOURCE, ObjectKind.DATABASE, ObjectKind.SCHEMA);
        if (treePattern == null) {
            SybaseDialect.$$$reportNull$$$0(13);
        }
        return treePattern;
    }

    @Override
    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource, @Nullable SearchPath searchPath) {
        ObjectName schemaName = SybaseDialect.getSchemaName(dataSource);
        ObjectName databaseName = SybaseDialect.getDatabaseName(dataSource);
        TreePatternNode.Group[] schemas = schemaName == null ? TreePatternNode.NO_GROUPS : (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{TreePatternUtils.create(schemaName, ObjectKind.SCHEMA, new TreePatternNode.Group[0])});
        TreePatternNode.Group[] databases = databaseName == null ? TreePatternNode.NO_GROUPS : (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{TreePatternUtils.create(databaseName, ObjectKind.DATABASE, schemas)});
        TreePattern treePattern = SybaseDialect.forcedContextExpandedToSchemas(dataSource, this.getDatabaseDialect(), searchPath, schemas, databases);
        if (treePattern == null) {
            SybaseDialect.$$$reportNull$$$0(14);
        }
        return treePattern;
    }

    @Override
    @NotNull
    public TreePattern srcFilePattern(@Nullable DbDataSource dataSource, @NotNull SearchPath searchPath) {
        if (searchPath == null) {
            SybaseDialect.$$$reportNull$$$0(15);
        }
        TreePattern treePattern = this.forcedContextPattern(dataSource, searchPath);
        if (treePattern == null) {
            SybaseDialect.$$$reportNull$$$0(16);
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern forcedContextExpandedToSchemas(@Nullable DbDataSource dataSource, @NotNull DatabaseDialectEx databaseDialect, @Nullable SearchPath searchPath, TreePatternNode.Group[] schemas, TreePatternNode.Group[] databases) {
        if (databaseDialect == null) {
            SybaseDialect.$$$reportNull$$$0(17);
        }
        ObjectName[] dsNames = SqlImportUtil.getRealDsNames(dataSource);
        TreePattern treePattern = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from((Iterable)SearchPath.getElements((SearchPath)searchPath)).transform(n -> {
            if (databaseDialect == null) {
                SybaseDialect.$$$reportNull$$$0(42);
            }
            TreePatternNode.Group[] tail = null;
            if (n.kind == ObjectKind.DATABASE) {
                ObjectName[] currentSchemas = SybaseDialect.getCurrentSchemasFor(dataSource, n);
                tail = currentSchemas == null ? schemas : SqlImportUtil.optAr(TreePatternUtils.create(currentSchemas, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            } else if (n.kind == ObjectKind.NONE) {
                tail = databases;
            }
            return SqlDialectImplUtil.createObjectPattern(dsNames, databaseDialect, n, tail);
        }));
        if (treePattern == null) {
            SybaseDialect.$$$reportNull$$$0(18);
        }
        return treePattern;
    }

    @Nullable
    private static ObjectName[] getCurrentSchemasFor(@Nullable DbDataSource dataSource, @NotNull ObjectPath db) {
        if (db == null) {
            SybaseDialect.$$$reportNull$$$0(19);
        }
        if (dataSource == null) {
            return null;
        }
        List names = DbSqlUtil.findObjects(dataSource, db).filter(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE)).flatten(o -> o.getDasChildren(ObjectKind.SCHEMA).filter(BasicMateNamespace.class).filter(n -> n.isCurrent())).map(o -> new ObjectName(o.getName(), DbSqlUtil.isQuoted(o))).toList();
        return names.isEmpty() ? null : ObjectName.toArray((Iterable)names);
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            SybaseDialect.$$$reportNull$$$0(20);
        }
        switch (cat) {
            case INTEGER: {
                return "int";
            }
            case REAL: {
                return "numeric";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "datetime";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case BYTES: {
                return "blob";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name) {
        if (name == null) {
            SybaseDialect.$$$reportNull$$$0(21);
        }
        if ("integer".equals(name = super.getNormalizedTypeName(name))) {
            if ("int" == null) {
                SybaseDialect.$$$reportNull$$$0(22);
            }
            return "int";
        }
        if ("unsigned integer".equals(name)) {
            if ("unsigned int" == null) {
                SybaseDialect.$$$reportNull$$$0(23);
            }
            return "unsigned int";
        }
        if ("dec".equals(name)) {
            if ("decimal" == null) {
                SybaseDialect.$$$reportNull$$$0(24);
            }
            return "decimal";
        }
        if ("double precision".equals(name)) {
            if ("float" == null) {
                SybaseDialect.$$$reportNull$$$0(25);
            }
            return "float";
        }
        if ("character".equals(name)) {
            if ("char" == null) {
                SybaseDialect.$$$reportNull$$$0(26);
            }
            return "char";
        }
        if ("character varying".equals(name)) {
            if ("varchar" == null) {
                SybaseDialect.$$$reportNull$$$0(27);
            }
            return "varchar";
        }
        if ("char varying".equals(name)) {
            if ("varchar" == null) {
                SybaseDialect.$$$reportNull$$$0(28);
            }
            return "varchar";
        }
        if ("nchar varying".equals(name)) {
            if ("nvarchar" == null) {
                SybaseDialect.$$$reportNull$$$0(29);
            }
            return "nvarchar";
        }
        if ("national char".equals(name)) {
            if ("nchar" == null) {
                SybaseDialect.$$$reportNull$$$0(30);
            }
            return "nchar";
        }
        if ("national character".equals(name)) {
            if ("nchar" == null) {
                SybaseDialect.$$$reportNull$$$0(31);
            }
            return "nchar";
        }
        if ("national char varying".equals(name)) {
            if ("nvarchar" == null) {
                SybaseDialect.$$$reportNull$$$0(32);
            }
            return "nvarchar";
        }
        if ("national character varying".equals(name)) {
            if ("nvarchar" == null) {
                SybaseDialect.$$$reportNull$$$0(33);
            }
            return "nvarchar";
        }
        String string = name;
        if (string == null) {
            SybaseDialect.$$$reportNull$$$0(34);
        }
        return string;
    }

    @Override
    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            SybaseDialect.$$$reportNull$$$0(35);
        }
        if ("smallmoney".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                SybaseDialect.$$$reportNull$$$0(36);
            }
            return category;
        }
        if ("money".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                SybaseDialect.$$$reportNull$$$0(37);
            }
            return category;
        }
        if ("bit".equals(typeName)) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                SybaseDialect.$$$reportNull$$$0(38);
            }
            return category;
        }
        if ("sysname".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                SybaseDialect.$$$reportNull$$$0(39);
            }
            return category;
        }
        if ("longsysname".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                SybaseDialect.$$$reportNull$$$0(40);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            SybaseDialect.$$$reportNull$$$0(41);
        }
        return category;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 35: 
            case 42: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 35: 
            case 42: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/sybase/SybaseDialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPath";
                break;
            }
            case 17: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseDialect";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "db";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 35: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/sybase/SybaseDialect";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "srcFilePattern";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextExpandedToSchemas";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifier";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "srcFilePattern";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "forcedContextExpandedToSchemas";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentSchemasFor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$forcedContextExpandedToSchemas$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 35: 
            case 42: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LazyData {
        static final Map<String, SqlFunctionDefinition> ourFunctionMap = Collections.unmodifiableMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
        static final List<ReservedEntity.Typed> ourTypedEntities = SqlDialectImplUtil.loadEntities(INSTANCE);
        static final NullableFunction<String, IElementType> ourReservedTokens = SqlTokenRegistry.getTokenProvider(SybaseReservedKeywords.class);
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SybaseOptionalKeywords.ASE_GO})});
        static final Set<IElementType> ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_OP_CONCAT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_BITWISE_NOT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT_LT, SqlElementTypes.SQL_OP_NOT_GT, SqlElementTypes.SQL_OP_PLUS_EQ, SqlElementTypes.SQL_OP_MINUS_EQ, SqlElementTypes.SQL_OP_MUL_EQ, SqlElementTypes.SQL_OP_DIV_EQ, SqlElementTypes.SQL_OP_MODULO_EQ, SqlElementTypes.SQL_OP_BITWISE_AND_EQ, SqlElementTypes.SQL_OP_BITWISE_OR_EQ, SqlElementTypes.SQL_OP_BITWISE_XOR_EQ, SybaseReservedKeywords.ASE_XMLTEST});
        private static final EnterHandlerDelegate ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_BEGIN, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_THEN, SqlElementTypes.SQL_THEN_CLAUSE, SqlElementTypes.SQL_IF_STATEMENT}, "", "end if", 2, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_IF, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false))));

        private LazyData() {
        }
    }
}

