/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.intentions.SqlIntentionUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDropStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPrefixedElement;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.OptionalInt;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCompletionUtil {
    public static final InsertHandler<LookupElement> TEMPLATE_SAFE_INSERT_HANDLER = new TemplateSafeInsertHandler("", false);
    private static final ElementPattern<PsiElement> AFTER_NUMERIC_LITERAL = PlatformPatterns.psiElement().afterLeafSkipping(StandardPatterns.alwaysFalse(), (ElementPattern)PlatformPatterns.psiElement().withElementType((ElementPattern)PlatformPatterns.elementType().oneOf((Object[])new IElementType[]{SqlTokens.SQL_INTEGER_TOKEN, SqlTokens.SQL_FLOAT_TOKEN})));
    private static final InsertHandler<LookupElement> DOT_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, LookupElement item) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (context.getCompletionChar() != '.') {
                boolean alreadyDot;
                String text2 = context.getDocument().getText();
                boolean bl = alreadyDot = text2.length() > context.getTailOffset() && text2.charAt(context.getTailOffset()) == '.';
                if (!alreadyDot) {
                    context.getDocument().insertString(context.getTailOffset(), (CharSequence)".");
                }
                context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, true);
                AutoPopupController.getInstance((Project)context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/psi/impl/SqlCompletionUtil$1", "handleInsert"));
        }
    };
    public static final InsertHandler<LookupElement> QUOT_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            int endOff;
            boolean rightIsQuote;
            char leftChar;
            String toInsertQuoted;
            if (context == null) {
                2.$$$reportNull$$$0(0);
            }
            if (item == null) {
                2.$$$reportNull$$$0(1);
            }
            DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)context.getFile()).getDatabaseDialect();
            String toInsert = item.getLookupString();
            if (toInsert.equals(toInsertQuoted = dialect.quoteIdentifier(toInsert, false, false))) {
                return;
            }
            Document document = context.getDocument();
            CharSequence text2 = document.getCharsSequence();
            int start = context.getStartOffset();
            int end = context.getTailOffset();
            char c = leftChar = start > 0 ? text2.charAt(start - 1) : (char)'\u0000';
            char rightExpected = leftChar == dialect.openQuote() ? dialect.closeQuote() : (leftChar == '\"' ? (char)'\"' : '\u0000');
            boolean leftIsQuote = rightExpected != '\u0000';
            char rightChar = end < document.getTextLength() ? text2.charAt(end) : (char)'\u0000';
            boolean bl = rightIsQuote = rightChar == dialect.closeQuote() || rightChar == '\"';
            if (!leftIsQuote) {
                document.insertString(start, (CharSequence)toInsertQuoted.substring(0, 1));
            }
            int n = endOff = !leftIsQuote ? 1 : 0;
            if (leftIsQuote && (!rightIsQuote || rightExpected != rightChar)) {
                document.insertString(end + endOff, (CharSequence)String.valueOf(rightExpected));
            } else if (!leftIsQuote) {
                document.insertString(end + endOff, (CharSequence)toInsertQuoted.substring(toInsertQuoted.length() - 1, toInsertQuoted.length()));
            }
            context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/psi/impl/SqlCompletionUtil$2";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final InsertHandler<LookupElement> QUOT_DOT_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                3.$$$reportNull$$$0(0);
            }
            if (item == null) {
                3.$$$reportNull$$$0(1);
            }
            QUOT_INSERT_HANDLER.handleInsert(context, item);
            DOT_INSERT_HANDLER.handleInsert(context, item);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/psi/impl/SqlCompletionUtil$3";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final InsertHandler<LookupElement> NEW_LINE_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, LookupElement item) {
            int lineEnd;
            if (context == null) {
                4.$$$reportNull$$$0(0);
            }
            String text2 = context.getDocument().getText();
            boolean insert = true;
            int offset = context.getTailOffset();
            if (text2.length() > offset && (lineEnd = context.getDocument().getLineEndOffset(context.getDocument().getLineNumber(offset))) > offset && !StringUtil.isEmptyOrSpaces((String)context.getDocument().getText(TextRange.create((int)offset, (int)lineEnd)))) {
                insert = false;
            }
            if (insert) {
                context.getDocument().insertString(offset, (CharSequence)"\n");
                context.getEditor().getCaretModel().moveToOffset(offset + 1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/psi/impl/SqlCompletionUtil$4", "handleInsert"));
        }
    };
    public static final BasicInsertHandler<LookupElement> DUMMY_HANDLER = new BasicInsertHandler();

    public static boolean addLookupElement(@NotNull SqlLanguageDialectEx dialect, @NotNull Object t, @NotNull Consumer<LookupElement> resultSet, boolean addDot, double forcePriority) {
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(0);
        }
        if (t == null) {
            SqlCompletionUtil.$$$reportNull$$$0(1);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(2);
        }
        return SqlCompletionUtil.addLookupElement(dialect, t, null, resultSet, addDot, forcePriority, null);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean addLookupElement(@NotNull SqlLanguageDialectEx dialect, @NotNull Object t, @Nullable PsiElement forcedContext, @NotNull Consumer<LookupElement> resultSet, boolean addDot, double forcePriority, @Nullable PsiElement psiElement) {
        void context;
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(3);
        }
        if (t == null) {
            SqlCompletionUtil.$$$reportNull$$$0(4);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(5);
        }
        DatabaseDialectEx databaseDialect = dialect.getDatabaseDialect();
        if (t instanceof SqlAsExpression) {
            return SqlCompletionUtil.forAlias((SqlAsExpression)t, resultSet, databaseDialect);
        }
        if (t instanceof SqlFunctionDefinition) {
            return SqlCompletionUtil.forSqlFunction(dialect, (SqlFunctionDefinition)((Object)t), resultSet);
        }
        if (t instanceof DasRoutine && t instanceof PsiNamedElement) {
            return SqlCompletionUtil.forProcedureInfo((PsiNamedElement)t, resultSet, databaseDialect, (PsiElement)context);
        }
        if (t instanceof PsiNamedElement && !(t instanceof SqlReferenceExpression)) {
            return SqlCompletionUtil.forPsiNamedElement((PsiNamedElement)t, forcedContext, resultSet, addDot, forcePriority, databaseDialect, (PsiElement)context);
        }
        if (t instanceof SqlReferenceExpression) {
            return SqlCompletionUtil.forSqlReference((SqlReferenceExpression)t, resultSet, (PsiElement)context);
        }
        return false;
    }

    public static boolean forSqlReference(@NotNull SqlReferenceExpression r, @NotNull Consumer<LookupElement> resultSet, PsiElement context) {
        SqlIdentifier identifier;
        if (r == null) {
            SqlCompletionUtil.$$$reportNull$$$0(6);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(7);
        }
        String prefix = (identifier = r.getIdentifier()) == null ? null : identifier.getNamePrefix();
        DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)r).getDatabaseDialect();
        String name = r.getName();
        LookupElementBuilder builder = prefix != null ? LookupElementBuilder.create((String)(prefix + name)).withPresentableText(prefix + dialect.quoteIdentifier(name, false, false)).withInsertHandler(SqlCompletionUtil.createPrefixHandler(name, prefix, dialect)) : LookupElementBuilder.create((String)name);
        if (SqlCompletionUtil.canResolveConflict(context)) {
            builder = builder.withInsertHandler(SqlCompletionUtil.createQualifierHandler(dialect, (InsertHandler<LookupElement>)builder.getInsertHandler()));
        }
        resultSet.consume((Object)builder);
        return true;
    }

    @NotNull
    public static InsertHandler<LookupElement> createQualifierHandler(final DatabaseDialectEx dialect, final InsertHandler<LookupElement> handler) {
        InsertHandler<LookupElement> insertHandler = new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                SqlIdentifier identifier;
                List<String> forcedContext;
                if (handler != null) {
                    handler.handleInsert(context, item);
                }
                context.commitDocument();
                if (!context.getOffsetMap().containsOffset(InsertionContext.TAIL_OFFSET)) {
                    return;
                }
                int offset = context.getTailOffset();
                PsiElement element = CompletionUtil.getTargetElement((LookupElement)item);
                DasObject obj = (DasObject)ObjectUtils.tryCast((Object)element, DasObject.class);
                if (obj == null) {
                    return;
                }
                SqlQualifiedResolveResult resolveResult = (SqlQualifiedResolveResult)((Object)ObjectUtils.tryCast((Object)item.getObject(), SqlQualifiedResolveResult.class));
                List<String> list = forcedContext = resolveResult == null ? null : resolveResult.getQualification();
                if (forcedContext == null) {
                    forcedContext = this.qualification(obj.getDasParent());
                }
                SqlReferenceExpression ref = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(offset > 1 ? offset - 1 : offset), SqlReferenceExpression.class, (boolean)false);
                SqlIdentifier sqlIdentifier = identifier = ref == null ? null : ref.getIdentifier();
                if (identifier == null || ref.getQualifierExpression() != null || ref.getParent() instanceof SqlReferenceExpression) {
                    return;
                }
                Condition filter = element instanceof SqlElement ? rr -> rr.getElement() instanceof SqlElement : rr -> !(rr.getElement() instanceof SqlElement);
                List resolveResults = ContainerUtil.filter((Object[])ref.multiResolve(false), (Condition)filter);
                if (!this.shouldQualify(resolveResults)) {
                    return;
                }
                List<List<ObjectName>> qualifiers = this.getQualifier(resolveResults, forcedContext, obj);
                if (qualifiers.isEmpty()) {
                    return;
                }
                SqlIntentionUtil.qualifyReference(qualifiers, dialect, identifier, context.getEditor());
            }

            private boolean shouldQualify(List<ResolveResult> resolveResults) {
                ResolveResult result2;
                SqlEditorOptions options = SqlEditorOptions.getInstance();
                ObjectKind kind = ObjectKind.NONE;
                Iterator<ResolveResult> iterator = resolveResults.iterator();
                while (iterator.hasNext() && (kind = DasUtil.getKind((DasObject)((DasObject)ObjectUtils.tryCast((Object)SqlImplUtil.getQualifier(result2 = iterator.next()), DasObject.class)))) == ObjectKind.NONE) {
                }
                SqlEditorOptions.QualificationType qualification = ModelConsts.TABLE_OR_VIEW_KINDS.contains(kind) ? options.getTableQualification() : (kind == SqlDbElementType.LOCAL_ALIAS ? options.getAliasQualification() : options.getNamespaceQualification());
                return qualification.shouldQualify(resolveResults.size());
            }

            @NotNull
            private List<List<ObjectName>> getQualifier(@NotNull Iterable<ResolveResult> results, @Nullable Iterable<String> forcedContext, @NotNull DasObject obj) {
                if (results == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (obj == null) {
                    5.$$$reportNull$$$0(1);
                }
                LinkedHashSet qualifiers = ContainerUtil.newLinkedHashSet();
                HashSet all = ContainerUtil.newHashSet();
                for (ResolveResult result2 : results) {
                    boolean kindUnsuitable;
                    PsiElement psi = SqlImplUtil.getQualifier(result2);
                    DasObject qual = (DasObject)ObjectUtils.tryCast((Object)psi, DasObject.class);
                    DasObject elem = (DasObject)ObjectUtils.tryCast((Object)result2.getElement(), DasObject.class);
                    ObjectKind elementKind = elem == null ? null : elem.getKind();
                    boolean bl = kindUnsuitable = elementKind != ObjectKind.TABLE && elementKind != ObjectKind.VIEW && elementKind != ObjectKind.COLUMN;
                    if (psi != null && qual == null || elem == null || kindUnsuitable) continue;
                    if (qual == null) {
                        qual = elem.getDasParent();
                    }
                    if (qual == null) continue;
                    if (Comparing.equal((String)elem.getName(), (String)obj.getName()) && this.eq((Iterable<String>)this.qualification(qual), forcedContext)) {
                        qualifiers.add(qual);
                    }
                    all.add(qual);
                }
                List qualPaths = ContainerUtil.newSmartList();
                for (DasObject qualifier : qualifiers) {
                    List list = ContainerUtil.newSmartList();
                    all.remove(qualifier);
                    this.appendQualification(qualifier, all, list, dialect);
                    all.add(qualifier);
                    if (list.isEmpty()) continue;
                    qualPaths.add(list);
                }
                List list = qualPaths;
                if (list == null) {
                    5.$$$reportNull$$$0(2);
                }
                return list;
            }

            @Contract(value="null -> null; !null -> !null")
            private JBIterable<String> qualification(@Nullable DasObject obj) {
                return obj == null ? null : DasUtil.dasParents((DasObject)obj).transform(DasUtil.TO_NAME);
            }

            private boolean eq(@Nullable Iterable<String> it1, @Nullable Iterable<String> it2) {
                if (it1 == null || it2 == null) {
                    return it1 == it2;
                }
                Iterator<String> i1 = it1.iterator();
                Iterator<String> i2 = it2.iterator();
                while (i1.hasNext() && i2.hasNext()) {
                    if (Comparing.equal((String)i1.next(), (String)i2.next())) continue;
                    return false;
                }
                return i1.hasNext() == i2.hasNext();
            }

            private void appendQualification(@Nullable DasObject qualifier, @NotNull Set<DasObject> other, @NotNull List<ObjectName> path, @NotNull CasingProvider casingProvider) {
                if (other == null) {
                    5.$$$reportNull$$$0(3);
                }
                if (path == null) {
                    5.$$$reportNull$$$0(4);
                }
                if (casingProvider == null) {
                    5.$$$reportNull$$$0(5);
                }
                if (qualifier == null || StringUtil.isEmpty((String)qualifier.getName())) {
                    return;
                }
                List qualifications = ContainerUtil.map(other, current -> this.fullQualification((DasObject)current));
                List<DasObject> qualification = this.fullQualification(qualifier);
                path.addAll(ContainerUtil.map(this.cutAllFromFirstDifferentElement(qualification, qualifications, casingProvider), DbSqlUtil::getName));
            }

            @NotNull
            private List<DasObject> fullQualification(@NotNull DasObject object) {
                if (object == null) {
                    5.$$$reportNull$$$0(6);
                }
                List list = ContainerUtil.reverse((List)DasUtil.dasParents((DasObject)object).toList());
                if (list == null) {
                    5.$$$reportNull$$$0(7);
                }
                return list;
            }

            @NotNull
            private List<DasObject> cutAllFromFirstDifferentElement(@NotNull List<DasObject> qualification, @NotNull List<List<DasObject>> qualifications, @NotNull CasingProvider provider) {
                OptionalInt indices;
                if (qualification == null) {
                    5.$$$reportNull$$$0(8);
                }
                if (qualifications == null) {
                    5.$$$reportNull$$$0(9);
                }
                if (provider == null) {
                    5.$$$reportNull$$$0(10);
                }
                int firstDifferentIndex = Math.max((indices = qualifications.stream().mapToInt(list -> {
                    if (qualification == null) {
                        5.$$$reportNull$$$0(15);
                    }
                    if (provider == null) {
                        5.$$$reportNull$$$0(16);
                    }
                    return this.firstDifferentElement(qualification, (List<DasObject>)list, provider);
                }).min()).isPresent() ? indices.getAsInt() : (qualifications.isEmpty() ? qualification.size() - 1 : 0), 0);
                List list2 = ContainerUtil.subList(qualification, (int)firstDifferentIndex);
                if (list2 == null) {
                    5.$$$reportNull$$$0(11);
                }
                return list2;
            }

            private int firstDifferentElement(@NotNull List<DasObject> first, @NotNull List<DasObject> second, @NotNull CasingProvider provider) {
                if (first == null) {
                    5.$$$reportNull$$$0(12);
                }
                if (second == null) {
                    5.$$$reportNull$$$0(13);
                }
                if (provider == null) {
                    5.$$$reportNull$$$0(14);
                }
                int firstIdx = first.size() - 1;
                for (int secondIdx = second.size() - 1; firstIdx >= 0 && secondIdx >= 0 && DasUtil.byName((String)first.get(firstIdx).getName(), (CasingProvider)provider).value((Object)second.get(secondIdx)); --firstIdx, --secondIdx) {
                }
                return firstIdx;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 7: 
                    case 11: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 7: 
                    case 11: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "results";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "obj";
                        break;
                    }
                    case 2: 
                    case 7: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/psi/impl/SqlCompletionUtil$5";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "other";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "casingProvider";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "object";
                        break;
                    }
                    case 8: 
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "qualification";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "qualifications";
                        break;
                    }
                    case 10: 
                    case 14: 
                    case 16: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "provider";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "first";
                        break;
                    }
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "second";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/psi/impl/SqlCompletionUtil$5";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getQualifier";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "fullQualification";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cutAllFromFirstDifferentElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getQualifier";
                        break;
                    }
                    case 2: 
                    case 7: 
                    case 11: {
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "appendQualification";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "fullQualification";
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "cutAllFromFirstDifferentElement";
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 14: {
                        objectArray = objectArray;
                        objectArray[2] = "firstDifferentElement";
                        break;
                    }
                    case 15: 
                    case 16: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$cutAllFromFirstDifferentElement$3";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 7: 
                    case 11: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (insertHandler == null) {
            SqlCompletionUtil.$$$reportNull$$$0(8);
        }
        return insertHandler;
    }

    @NotNull
    public static InsertHandler<LookupElement> createPrefixHandler(final String name, final String prefix, final DatabaseDialect dialect) {
        InsertHandler<LookupElement> insertHandler = new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                int start = context.getStartOffset();
                int end = context.getTailOffset();
                context.getDocument().replaceString(start, end, (CharSequence)(prefix + dialect.quoteIdentifier(name, false, false)));
            }
        };
        if (insertHandler == null) {
            SqlCompletionUtil.$$$reportNull$$$0(9);
        }
        return insertHandler;
    }

    private static boolean canResolveConflict(@Nullable PsiElement element) {
        return !(element instanceof SqlReferenceExpression) || ((SqlReferenceExpression)element).getReferenceElementType() != SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE && ((SqlReferenceExpression)element).getReferenceElementType() != SqlCompositeElementTypes.SQL_SHORT_REFERENCE;
    }

    public static boolean forSqlFunction(@NotNull SqlLanguageDialectEx dialect, @NotNull SqlFunctionDefinition f, @NotNull Consumer<LookupElement> resultSet) {
        SqlFunctionDefinition.Prototype[] prototypes;
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(10);
        }
        if (f == null) {
            SqlCompletionUtil.$$$reportNull$$$0(11);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(12);
        }
        if ((prototypes = f.getPrototypes()).length == 0) {
            return false;
        }
        for (SqlFunctionDefinition.Prototype prototype : prototypes) {
            resultSet.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)SqlCompletionUtil.createLookupItem(prototype, dialect), (double)1.0));
        }
        return true;
    }

    public static boolean forAlias(@NotNull SqlAsExpression t, @NotNull Consumer<LookupElement> resultSet, @NotNull DatabaseDialect databaseDialect) {
        String name;
        if (t == null) {
            SqlCompletionUtil.$$$reportNull$$$0(13);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(14);
        }
        if (databaseDialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(15);
        }
        if (StringUtil.isEmpty((String)(name = SqlCompletionUtil.calcName((PsiNamedElement)t, (Function<Project, Case>)((Function)SqlCompletionUtil::getAliasCase))))) {
            return false;
        }
        resultSet.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)PrioritizedLookupElement.withGrouping((LookupElement)LookupElementBuilder.create((Object)t, (String)name).withInsertHandler(SqlCompletionUtil.handler((PsiNamedElement)t, databaseDialect, false)), (int)1), (double)10.0));
        return true;
    }

    public static void addReferenceCompletionVariants(@NotNull SqlReferenceImpl reference, @NotNull PrefixMatcher prefixMatcher, final @NotNull Consumer<LookupElement> resultSet) {
        SqlExpression qualifierExpression;
        if (reference == null) {
            SqlCompletionUtil.$$$reportNull$$$0(16);
        }
        if (prefixMatcher == null) {
            SqlCompletionUtil.$$$reportNull$$$0(17);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(18);
        }
        SqlElement refElement = (SqlElement)reference.getElement();
        Project project = refElement.getProject();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)refElement);
        List<DbDataSource> dataSources2 = SqlImplUtil.getDataSources((PsiElement)SqlImplUtil.getTopLevelSqlFile(refElement.getContainingFile()));
        final CamelHumpMatcher adjustedMatcher = new CamelHumpMatcher(prefixMatcher.getPrefix(), false);
        final boolean missingFrom = SqlCompletionUtil.hasMissingFrom(refElement);
        SqlExpression qualifier = reference.getQualifier();
        final boolean filterPgRoutines = qualifier != null && dialect.getFamilyId().isPostgres() && SqlImplUtil.canResolveToPgFunctionColumn((PsiElement)refElement);
        SqlPrimitiveType qualifierType = filterPgRoutines ? qualifier.getSqlType() : SqlType.UNKNOWN;
        Set<ObjectKind> expectedTypesStrict = reference.getExpectedTargetTypesStrict(dialect);
        final boolean addColumns = SqlCompletionUtil.shouldAddMissingColumns(reference);
        SqlScopeProcessor processor = new SqlScopeProcessor(null, dialect, dataSources2, (PsiElement)refElement, (SqlType)qualifierType, project, expectedTypesStrict, refElement){
            boolean myEmpty;
            boolean myTablesBlocked;
            final /* synthetic */ SqlType val$qualifierType;
            final /* synthetic */ Project val$project;
            final /* synthetic */ Set val$expectedTypesStrict;
            final /* synthetic */ SqlElement val$refElement;
            {
                this.val$qualifierType = sqlType;
                this.val$project = project;
                this.val$expectedTypesStrict = set;
                this.val$refElement = sqlElement;
                super(referenceName, dialect, dataSources2, place);
                this.myEmpty = true;
            }

            @Override
            public boolean isResultEmpty() {
                return this.myEmpty;
            }

            @Override
            public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
                if (event == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (event == IGNORE_TYPE && ((Set)associated).contains(ObjectKind.TABLE)) {
                    this.myTablesBlocked = true;
                }
                super.handleEvent(event, associated);
            }

            @Override
            public boolean executeTarget(@Nullable DasObject target2, @NotNull PsiElement element, @Nullable SqlType sqlType, @Nullable Boolean forcedCaseSens, @NotNull ResolveState state) {
                Consumer consumer;
                if (element == null) {
                    7.$$$reportNull$$$0(1);
                }
                if (state == null) {
                    7.$$$reportNull$$$0(2);
                }
                if (SqlFileImpl.isEmptyFakeNamespace(target2)) {
                    return true;
                }
                if (addColumns && target2 instanceof DasTable) {
                    for (DasColumn column2 : DasUtil.getColumns((DasObject)target2)) {
                        if (!adjustedMatcher.prefixMatches(column2.getName())) continue;
                        this.myEmpty = SqlCompletionUtil.addLookupElement(this.dialect, column2, (Consumer<LookupElement>)resultSet, false, 0.0) && this.myEmpty;
                    }
                }
                if (target2 != null) {
                    if (!adjustedMatcher.prefixMatches(target2.getName())) {
                        return true;
                    }
                } else if (element instanceof SqlReferenceExpression) {
                    String name;
                    SqlIdentifier identifier = ((SqlReferenceExpression)element).getIdentifier();
                    String prefix = identifier == null ? null : identifier.getNamePrefix();
                    String string = name = prefix == null ? ((SqlReferenceExpression)element).getName() : prefix + ((SqlReferenceExpression)element).getName();
                    if (!adjustedMatcher.prefixMatches(name)) {
                        return true;
                    }
                } else {
                    return true;
                }
                boolean weightDown = false;
                if (!this.checkType(ObjectUtils.notNull((Object)target2, (Object)element), sqlType)) {
                    if (!(missingFrom && this.myTablesBlocked && this.checkType(ObjectUtils.notNull((Object)target2, (Object)element), sqlType, this.getInitialExpectedTypes(), Collections.emptySet(), false))) {
                        return true;
                    }
                    weightDown = true;
                }
                if (filterPgRoutines && target2 instanceof DasRoutine) {
                    DasArgument arg;
                    if (target2 instanceof DbElement) {
                        target2 = (DasObject)ObjectUtils.tryCast((Object)((DbElement)target2).getDelegate(), DasRoutine.class);
                    }
                    if ((arg = (DasArgument)SqlFunctionsUtil.getAcceptedArguments(target2).single()) == null || !SqlFunctionsUtil.isAssignable((DasTypedObject)arg, this.val$qualifierType, this.dialect)) {
                        return true;
                    }
                }
                Consumer consumer2 = consumer = weightDown ? e -> {
                    if (resultSet == null) {
                        7.$$$reportNull$$$0(3);
                    }
                    resultSet.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)e, (double)0.0));
                } : resultSet;
                if (target2 instanceof ReservedEntity && sqlType != null) {
                    consumer.consume((Object)SqlCompletionUtil.createEntityLookupItem(this.val$project, target2.getName(), sqlType));
                    this.myEmpty = false;
                } else {
                    Object delegate = target2 instanceof DbElement ? ((DbElement)target2).getDelegate() : null;
                    boolean addDot = !this.checkType(element, sqlType, this.val$expectedTypesStrict, this.getIgnoredTypes(), true);
                    this.myEmpty = SqlCompletionUtil.addLookupElement(this.dialect, delegate instanceof PsiElement ? delegate : element, SqlImplUtil.getQualifier(state), (Consumer<LookupElement>)consumer, addDot, 0.0, (PsiElement)this.val$refElement) && this.myEmpty;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "resultSet";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlCompletionUtil$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleEvent";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "executeTarget";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$executeTarget$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (reference.initExpectedTargetTypes(processor)) {
            reference.processResolveVariants(processor);
        }
        dialect.processReservedEntitiesWithType(null, (PsiElement)refElement, false, processor);
        if (processor.isResultEmpty() && addColumns && (qualifierExpression = reference.getQualifierExpression()) instanceof SqlReferenceExpression && ((SqlReferenceExpression)qualifierExpression).resolve() == null) {
            Set<ObjectKind> expectedTypes = Collections.singleton(reference.getReferenceElementType().getTargetKind());
            processor.handleEvent(SqlScopeProcessor.EXPECTED_TYPE, expectedTypes);
            reference.processUnqualifiedResolveVariants(processor, ResolveState.initial());
        }
    }

    private static boolean hasMissingFrom(SqlElement refElement) {
        boolean missingFrom = false;
        SqlQueryExpression closestSelect = (SqlQueryExpression)SyntaxTraverser.psiApi().parents((Object)refElement).filter(SqlQueryExpression.class).filter(q -> q.getSelectClause() != null).first();
        if (closestSelect != null) {
            SqlTableExpression tableExpression = closestSelect.getTableExpression();
            missingFrom = tableExpression == null || tableExpression.getFromClause() == null;
        }
        return missingFrom;
    }

    private static boolean shouldAddMissingColumns(@NotNull SqlReferenceImpl reference) {
        if (reference == null) {
            SqlCompletionUtil.$$$reportNull$$$0(19);
        }
        if (reference.getReferenceElementType().getTargetKind() != ObjectKind.COLUMN) {
            return false;
        }
        SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), SqlQueryExpression.class);
        if (query == null) {
            return false;
        }
        if (!PsiTreeUtil.isContextAncestor((PsiElement)query.getSelectClause(), (PsiElement)reference.getElement(), (boolean)true)) {
            return false;
        }
        SqlTableExpression tableExpression = query.getTableExpression();
        SqlFromClause fromClause = tableExpression != null ? tableExpression.getFromClause() : null;
        return fromClause == null || fromClause.getFromExpression() == null;
    }

    public static boolean isNumericLiteral(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            SqlCompletionUtil.$$$reportNull$$$0(20);
        }
        return AFTER_NUMERIC_LITERAL.accepts((Object)parameters.getPosition());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean forPsiNamedElement(@NotNull PsiNamedElement o, @Nullable PsiElement forcedContext, @NotNull Consumer<LookupElement> resultSet, boolean addDot, double forcePriority, @NotNull DatabaseDialect databaseDialect, PsiElement psiElement) {
        void element;
        DasObject context;
        String name;
        if (o == null) {
            SqlCompletionUtil.$$$reportNull$$$0(21);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(22);
        }
        if (databaseDialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(23);
        }
        if (StringUtil.isEmpty((String)(name = SqlCompletionUtil.calcName(o, (Function<Project, Case>)((Function)SqlCompletionUtil::getIdentifierCase))))) {
            return false;
        }
        Icon icon = o instanceof PsiPresentableMetaData ? ((PsiPresentableMetaData)o).getIcon() : o.getIcon(0);
        LookupElementBuilder lookup = LookupElementBuilder.create((Object)((Object)new SqlQualifiedResolveResult(forcedContext, (PsiElement)o)), (String)name).withTypeText(SqlCompletionUtil.typeText(o)).withInsertHandler(SqlCompletionUtil.handler(o, databaseDialect, addDot)).withIcon(icon);
        String prefix = SqlCompletionUtil.getPrefix(o);
        if (prefix != null) {
            lookup = lookup.withPresentableText(prefix + databaseDialect.quoteIdentifier(o.getName(), false, false));
        }
        if (name.contains(" ")) {
            lookup = lookup.withLookupString(name.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_")).withLookupString(name.replaceAll(" ", "_"));
        }
        DasObject dasObject = context = forcedContext == null && o instanceof DasObject ? ((DasObject)o).getDasParent() : (DasObject)ObjectUtils.tryCast((Object)forcedContext, DasObject.class);
        if (context != null) {
            String qname;
            String string = qname = context instanceof DbDataSource ? null : QNameUtil.getQualifiedName(context);
            if (StringUtil.isNotEmpty((String)qname)) {
                lookup = lookup.withTailText(" (" + qname + ")", true);
            }
        }
        double priority = o instanceof DbElement ? 5.0 : 10.0;
        for (DasObject cur = (DasObject)ObjectUtils.tryCast((Object)o, DasObject.class); cur != null; cur = cur.getDasParent()) {
            priority += 0.1;
        }
        if (SqlCompletionUtil.canResolveConflict((PsiElement)element)) {
            lookup = lookup.withInsertHandler(SqlCompletionUtil.createQualifierHandler((DatabaseDialectEx)databaseDialect, (InsertHandler<LookupElement>)lookup.getInsertHandler()));
        }
        resultSet.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)lookup, (double)Math.max(forcePriority, priority)));
        return true;
    }

    @Nullable
    public static String calcName(@NotNull PsiNamedElement o, @NotNull Function<Project, Case> plainCaseGetter) {
        String roughName;
        if (o == null) {
            SqlCompletionUtil.$$$reportNull$$$0(24);
        }
        if (plainCaseGetter == null) {
            SqlCompletionUtil.$$$reportNull$$$0(25);
        }
        return StringUtil.isEmpty((String)(roughName = SqlCompletionUtil.roughName(o))) ? null : SqlCompletionUtil.getMode(o.getProject(), o, plainCaseGetter).apply(roughName);
    }

    @Nullable
    public static InsertHandler<LookupElement> handler(PsiNamedElement t, DatabaseDialect databaseDialect, boolean addDot) {
        String prefix;
        SqlPrefixedElement prefixed = SqlCompletionUtil.getPrefixed(t);
        String string = prefix = prefixed == null ? null : prefixed.getNamePrefix();
        if (prefix != null) {
            return SqlCompletionUtil.createPrefixHandler(t.getName(), prefix, databaseDialect);
        }
        return SqlCompletionUtil.hasPlainIdentifier((PsiElement)t) ? (addDot ? DOT_INSERT_HANDLER : null) : (addDot ? QUOT_DOT_INSERT_HANDLER : QUOT_INSERT_HANDLER);
    }

    @NotNull
    public static Case getMode(@NotNull Project project, @NotNull PsiNamedElement o, @NotNull Function<Project, Case> plainCaseGetter) {
        if (project == null) {
            SqlCompletionUtil.$$$reportNull$$$0(26);
        }
        if (o == null) {
            SqlCompletionUtil.$$$reportNull$$$0(27);
        }
        if (plainCaseGetter == null) {
            SqlCompletionUtil.$$$reportNull$$$0(28);
        }
        Case case_ = SqlCompletionUtil.hasPlainIdentifier((PsiElement)o) ? (Case)plainCaseGetter.fun((Object)project) : SqlCompletionUtil.getQuotedIdentifierCase(project);
        if (case_ == null) {
            SqlCompletionUtil.$$$reportNull$$$0(29);
        }
        return case_;
    }

    public static boolean hasPlainIdentifier(PsiElement t) {
        if (t instanceof DasObject) {
            DasObject obj = (DasObject)t;
            boolean isSql = DbSqlUtil.isSqlObject(obj);
            if (isSql) {
                return !DbSqlUtil.isQuoted(obj);
            }
            GenericDialect dialect = t instanceof DbElement ? DbImplUtil.getDatabaseDialect((DbElement)t) : GenericDialect.INSTANCE;
            String id = dialect.quoteIdentifier(obj.getName(), false, false);
            return !dialect.isQuotedIdentifier(id);
        }
        if (t instanceof SqlNameElement) {
            return !DbSqlUtil.isQuoted((SqlNameElement)t);
        }
        return false;
    }

    @Nullable
    public static String roughName(@NotNull PsiNamedElement o) {
        String origin;
        if (o == null) {
            SqlCompletionUtil.$$$reportNull$$$0(30);
        }
        if (o instanceof SqlFileImpl.FakeDefinition && (origin = ((SqlFileImpl.FakeDefinition)o).getOriginalName()) != null) {
            return origin;
        }
        String prefix = SqlCompletionUtil.getPrefix(o);
        return prefix == null ? o.getName() : prefix + o.getName();
    }

    @Nullable
    public static String typeText(@NotNull PsiNamedElement t) {
        if (t == null) {
            SqlCompletionUtil.$$$reportNull$$$0(31);
        }
        if (t instanceof DasTypedObject) {
            return JdbcUtil.getJdbcTypeName((DataType)((DasTypedObject)t).getDataType());
        }
        if (t instanceof SqlFileImpl.FakeDefinition) {
            return ((SqlFileImpl.FakeDefinition)t).getTypeName();
        }
        if (t instanceof DbElement) {
            return ((DbElement)t).getDataSource().getName();
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)t);
        return file == null ? t.getName() : EditorTabbedContainer.calcTabTitle((Project)t.getProject(), (VirtualFile)file);
    }

    @Nullable
    public static SqlPrefixedElement getPrefixed(@NotNull PsiNamedElement o) {
        if (o == null) {
            SqlCompletionUtil.$$$reportNull$$$0(32);
        }
        return (SqlPrefixedElement)ObjectUtils.tryCast((Object)(o instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)o).getNameIdentifier() : o), SqlPrefixedElement.class);
    }

    @Nullable
    public static String getPrefix(@NotNull PsiNamedElement o) {
        SqlPrefixedElement prefixed;
        if (o == null) {
            SqlCompletionUtil.$$$reportNull$$$0(33);
        }
        return (prefixed = SqlCompletionUtil.getPrefixed(o)) == null ? null : prefixed.getNamePrefix();
    }

    public static boolean forProcedureInfo(@NotNull PsiNamedElement o, @NotNull Consumer<LookupElement> resultSet, @NotNull DatabaseDialectEx databaseDialect, @Nullable PsiElement context) {
        if (o == null) {
            SqlCompletionUtil.$$$reportNull$$$0(34);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(35);
        }
        if (databaseDialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(36);
        }
        LookupElement procedureLookup = PrioritizedLookupElement.withPriority((LookupElement)SqlCompletionUtil.createLookupItem(o.getProject(), (DasRoutine)o, databaseDialect, context), (double)0.0);
        resultSet.consume((Object)procedureLookup);
        return true;
    }

    @NotNull
    public static Case getIdentifierCase(@NotNull Project project) {
        SqlCodeStyleSettings settings;
        if (project == null) {
            SqlCompletionUtil.$$$reportNull$$$0(37);
        }
        Case case_ = SqlCodeStyleSettings.getCaseMode((int)((settings = SqlCompletionUtil.settings(project)) == null ? 2 : settings.IDENTIFIER_CASE));
        if (case_ == null) {
            SqlCompletionUtil.$$$reportNull$$$0(38);
        }
        return case_;
    }

    @NotNull
    public static Case getAliasCase(@NotNull Project project) {
        SqlCodeStyleSettings settings;
        if (project == null) {
            SqlCompletionUtil.$$$reportNull$$$0(39);
        }
        Case case_ = SqlCodeStyleSettings.getCaseMode((int)((settings = SqlCompletionUtil.settings(project)) == null ? 2 : (settings.ALIAS_CASE == 4 ? settings.IDENTIFIER_CASE : settings.ALIAS_CASE)));
        if (case_ == null) {
            SqlCompletionUtil.$$$reportNull$$$0(40);
        }
        return case_;
    }

    @NotNull
    public static Case getQuotedIdentifierCase(@NotNull Project project) {
        SqlCodeStyleSettings settings;
        if (project == null) {
            SqlCompletionUtil.$$$reportNull$$$0(41);
        }
        Case case_ = SqlCodeStyleSettings.getCaseMode((int)((settings = SqlCompletionUtil.settings(project)) == null ? 2 : settings.QUOTED_IDENTIFIER_CASE));
        if (case_ == null) {
            SqlCompletionUtil.$$$reportNull$$$0(42);
        }
        return case_;
    }

    @Nullable
    public static SqlCodeStyleSettings settings(@NotNull Project project) {
        if (project == null) {
            SqlCompletionUtil.$$$reportNull$$$0(43);
        }
        return (SqlCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(SqlCodeStyleSettings.class);
    }

    @NotNull
    public static LookupElement createEntityLookupItem(@NotNull Project project, @NotNull String entityName, @NotNull SqlType type) {
        if (project == null) {
            SqlCompletionUtil.$$$reportNull$$$0(44);
        }
        if (entityName == null) {
            SqlCompletionUtil.$$$reportNull$$$0(45);
        }
        if (type == null) {
            SqlCompletionUtil.$$$reportNull$$$0(46);
        }
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)SqlCompletionUtil.getIdentifierCase(project).apply(entityName)).bold().withTypeText(!(type instanceof SqlTableType) ? type.getDisplayName() : null);
        if (lookupElementBuilder == null) {
            SqlCompletionUtil.$$$reportNull$$$0(47);
        }
        return lookupElementBuilder;
    }

    @NotNull
    public static LookupElementBuilder createLookupItem(@NotNull String str, boolean boldness, boolean caseSensitivity, @Nullable InsertHandler<LookupElement> handler, String ... aliases) {
        if (str == null) {
            SqlCompletionUtil.$$$reportNull$$$0(48);
        }
        if (aliases == null) {
            SqlCompletionUtil.$$$reportNull$$$0(49);
        }
        LookupElementBuilder element = LookupElementBuilder.create((String)str).withBoldness(boldness).withCaseSensitivity(caseSensitivity).withInsertHandler(handler);
        for (String alias : aliases) {
            element = element.withLookupString(alias);
        }
        LookupElementBuilder lookupElementBuilder = element;
        if (lookupElementBuilder == null) {
            SqlCompletionUtil.$$$reportNull$$$0(50);
        }
        return lookupElementBuilder;
    }

    public static boolean isJoinUsingColumn(@Nullable PsiElement element) {
        SqlReferenceList usingList = (SqlReferenceList)PsiTreeUtil.getParentOfType((PsiElement)element, SqlReferenceList.class);
        return usingList != null && usingList.getParent() instanceof SqlUsingClause && usingList.getParent().getParent() instanceof SqlJoinExpression;
    }

    public static boolean isDropTarget(@Nullable PsiElement element) {
        SqlDropStatement drop = (SqlDropStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlDropStatement.class);
        return drop != null && PsiTreeUtil.isContextAncestor((PsiElement)drop.getTargetExpression(), (PsiElement)element, (boolean)false);
    }

    public static LookupElement createLookupItem(@NotNull Project project, @NotNull DasRoutine def2, final @NotNull DatabaseDialectEx dialect, @Nullable PsiElement context) {
        if (project == null) {
            SqlCompletionUtil.$$$reportNull$$$0(51);
        }
        if (def2 == null) {
            SqlCompletionUtil.$$$reportNull$$$0(52);
        }
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(53);
        }
        JBIterable parameters = DasUtil.getParameters((DasRoutine)def2);
        List retArg = ContainerUtil.createMaybeSingletonList((Object)def2.getReturnArgument());
        DdlBuilder builder = new DdlBuilder(){

            @Override
            @NotNull
            public DdlBuilder identifier(@NotNull String name) {
                if (name == null) {
                    8.$$$reportNull$$$0(0);
                }
                DdlBuilder ddlBuilder = this.plain(name);
                if (ddlBuilder == null) {
                    8.$$$reportNull$$$0(1);
                }
                return ddlBuilder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/psi/impl/SqlCompletionUtil$8";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/psi/impl/SqlCompletionUtil$8";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "identifier";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "identifier";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.withDialect(dialect).applyCodeStyle(project);
        builder.identifier(def2.getName());
        boolean routineCall = !SqlCompletionUtil.isDropTarget(context);
        boolean supportsOverloads = dialect.getFamilyId().isPostgres();
        boolean noParensCall = dialect.getFamilyId().isMicrosoft() && PsiTreeUtil.getParentOfType((PsiElement)context, SqlSelectClause.class) == null;
        final boolean useSpaces = noParensCall || !routineCall && !supportsOverloads;
        String presentableText = SqlCompletionUtil.addParametersPresentableText(builder, (Iterable<? extends DasArgument>)parameters, false, useSpaces).getStatement();
        String typeText = SqlCompletionUtil.addParametersPresentableText(builder.clear(), retArg, true, useSpaces).getStatement();
        final boolean noParams = Iterables.isEmpty((Iterable)parameters) || !routineCall && !supportsOverloads;
        return LookupElementBuilder.create((Object)def2, (String)builder.clear().identifier(def2.getName()).getStatement()).withIcon(DatabaseIcons.Function).withPresentableText(presentableText).withTypeText(typeText).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    9.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    9.$$$reportNull$$$0(1);
                }
                if (!SqlCompletionUtil.hasPlainIdentifier(item.getPsiElement())) {
                    QUOT_INSERT_HANDLER.handleInsert(context, item);
                }
                if (SqlCompletionUtil.isInsertingInPgFunctionColumn(context, dialect.getFamilyId())) {
                    return;
                }
                this.handler().handleInsert(context, item);
            }

            @NotNull
            public InsertHandler<LookupElement> handler() {
                Object object = useSpaces ? (noParams ? DUMMY_HANDLER : AddSpaceInsertHandler.INSTANCE) : (noParams ? ParenthesesInsertHandler.NO_PARAMETERS : ParenthesesInsertHandler.WITH_PARAMETERS);
                if (object == null) {
                    9.$$$reportNull$$$0(2);
                }
                return object;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/psi/impl/SqlCompletionUtil$9";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/psi/impl/SqlCompletionUtil$9";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "handler";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "handleInsert";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static boolean isInsertingInPgFunctionColumn(@NotNull InsertionContext context, @NotNull DatabaseFamilyId familyId) {
        PsiReference ref;
        if (context == null) {
            SqlCompletionUtil.$$$reportNull$$$0(54);
        }
        if (familyId == null) {
            SqlCompletionUtil.$$$reportNull$$$0(55);
        }
        return familyId.isPostgres() && SqlImplUtil.canResolveToPgFunctionColumn((ref = context.getFile().findReferenceAt(context.getStartOffset())) == null ? null : ref.getElement());
    }

    @NotNull
    public static DdlBuilder addParametersPresentableText(@NotNull DdlBuilder builder, @NotNull Iterable<? extends DasArgument> parameters, boolean result2, boolean useSpaces) {
        boolean parentheses;
        if (builder == null) {
            SqlCompletionUtil.$$$reportNull$$$0(56);
        }
        if (parameters == null) {
            SqlCompletionUtil.$$$reportNull$$$0(57);
        }
        boolean bl = parentheses = !result2 || Iterables.size(parameters) > 1;
        if (parentheses) {
            builder.symbol(useSpaces ? " " : "(");
        }
        boolean first = true;
        for (DasArgument dasArgument : parameters) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            if (!result2) {
                builder.identifier((String)ObjectUtils.notNull((Object)dasArgument.getName(), (Object)"")).symbol(":");
            }
            builder.type((DasTypedObject)dasArgument);
        }
        if (parentheses) {
            builder.symbol(useSpaces ? "" : ")");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            SqlCompletionUtil.$$$reportNull$$$0(58);
        }
        return ddlBuilder;
    }

    public static LookupElement createLookupItem(final @NotNull SqlFunctionDefinition.Prototype prototype, @NotNull SqlLanguageDialect dialect) {
        if (prototype == null) {
            SqlCompletionUtil.$$$reportNull$$$0(59);
        }
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(60);
        }
        LookupElementBuilder element = LookupElementBuilder.create((Object)prototype, (String)prototype.getFunction().getName()).withCaseSensitivity(false).withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(@NotNull LookupElement element, @NotNull LookupElementPresentation presentation) {
                if (element == null) {
                    10.$$$reportNull$$$0(0);
                }
                if (presentation == null) {
                    10.$$$reportNull$$$0(1);
                }
                presentation.setIcon(DatabaseIcons.Function);
                presentation.setItemText(element.getLookupString());
                String params2 = new SqlFunctionDefinition.ParameterBlock(-1, prototype.getBlockType(), prototype.getParams(), false).toString();
                presentation.appendTailText(params2, true);
                presentation.setTypeText(prototype.getReturnType().getDisplayName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "presentation";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/psi/impl/SqlCompletionUtil$10";
                objectArray[2] = "renderElement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!((SqlLanguageDialectEx)dialect).canBeCalledWithoutParens(prototype)) {
            element = element.withInsertHandler((context, item) -> {
                if (dialect == null) {
                    SqlCompletionUtil.$$$reportNull$$$0(65);
                }
                if (prototype == null) {
                    SqlCompletionUtil.$$$reportNull$$$0(66);
                }
                if (SqlCompletionUtil.isInsertingInPgFunctionColumn(context, ((SqlLanguageDialectEx)dialect).getFamilyId())) {
                    return;
                }
                (prototype.getParams().length == 0 ? ParenthesesInsertHandler.NO_PARAMETERS : ParenthesesInsertHandler.WITH_PARAMETERS).handleInsert(context, item);
            });
        }
        return element;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static LookupElement createKeywordLookupElement(@NotNull Case keywordCase, @NotNull String str, @Nullable InsertHandler<LookupElement> handler, double correction, String ... stringArray) {
        void aliases;
        if (keywordCase == null) {
            SqlCompletionUtil.$$$reportNull$$$0(61);
        }
        if (str == null) {
            SqlCompletionUtil.$$$reportNull$$$0(62);
        }
        if (stringArray == null) {
            SqlCompletionUtil.$$$reportNull$$$0(63);
        }
        boolean caseSensitive = keywordCase == Case.UPPER || keywordCase == Case.LOWER;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)SqlCompletionUtil.createLookupItem(keywordCase.apply(str), true, caseSensitive, handler, (String[])aliases), (double)(5.0 + correction));
        if (lookupElement == null) {
            SqlCompletionUtil.$$$reportNull$$$0(64);
        }
        return lookupElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 29: 
            case 38: 
            case 40: 
            case 42: 
            case 47: 
            case 50: 
            case 58: 
            case 64: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 29: 
            case 38: 
            case 40: 
            case 42: 
            case 47: 
            case 50: 
            case 58: 
            case 64: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: 
            case 4: 
            case 13: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 12: 
            case 14: 
            case 18: 
            case 22: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 8: 
            case 9: 
            case 29: 
            case 38: 
            case 40: 
            case 42: 
            case 47: 
            case 50: 
            case 58: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlCompletionUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 15: 
            case 23: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseDialect";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixMatcher";
                break;
            }
            case 20: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plainCaseGetter";
                break;
            }
            case 26: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityName";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 48: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 49: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliases";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "familyId";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 59: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prototype";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlCompletionUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createQualifierHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPrefixHandler";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifierCase";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasCase";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuotedIdentifierCase";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createEntityLookupItem";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupItem";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "addParametersPresentableText";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeywordLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addLookupElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forSqlReference";
                break;
            }
            case 8: 
            case 9: 
            case 29: 
            case 38: 
            case 40: 
            case 42: 
            case 47: 
            case 50: 
            case 58: 
            case 64: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "forSqlFunction";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "forAlias";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addReferenceCompletionVariants";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddMissingColumns";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isNumericLiteral";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "forPsiNamedElement";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "calcName";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getMode";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "roughName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "typeText";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixed";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "forProcedureInfo";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifierCase";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getAliasCase";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getQuotedIdentifierCase";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "settings";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createEntityLookupItem";
                break;
            }
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createLookupItem";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isInsertingInPgFunctionColumn";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "addParametersPresentableText";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createKeywordLookupElement";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createLookupItem$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 29: 
            case 38: 
            case 40: 
            case 42: 
            case 47: 
            case 50: 
            case 58: 
            case 64: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TemplateSafeInsertHandler
    extends AddSpaceInsertHandler {
        public TemplateSafeInsertHandler(String ignoreOnChars, boolean triggerAutoPopup) {
            super(ignoreOnChars, triggerAutoPopup);
        }

        protected boolean shouldOverwriteExistingSpace(Editor editor) {
            TemplateState state = TemplateManagerImpl.getTemplateState((Editor)editor);
            TextRange range = state == null ? null : state.getCurrentVariableRange();
            int offset = editor.getCaretModel().getOffset();
            return range == null || offset != range.getEndOffset();
        }
    }

    private static class SqlQualifiedResolveResult
    extends PsiElementResolveResult {
        private final List<String> myQualification;

        public SqlQualifiedResolveResult(@Nullable PsiElement qualifier, @NotNull PsiElement element) {
            if (element == null) {
                SqlQualifiedResolveResult.$$$reportNull$$$0(0);
            }
            super(element);
            DasObject object = (DasObject)ObjectUtils.tryCast((Object)qualifier, DasObject.class);
            this.myQualification = qualifier == null ? null : (object == null ? Collections.emptyList() : DasUtil.dasParents((DasObject)object).transform(DasUtil.TO_NAME).toList());
        }

        @Nullable
        public List<String> getQualification() {
            return this.myQualification;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SqlQualifiedResolveResult result2 = (SqlQualifiedResolveResult)((Object)o);
            return !(this.myQualification != null ? !this.myQualification.equals(result2.myQualification) : result2.myQualification != null);
        }

        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + (this.myQualification != null ? this.myQualification.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlCompletionUtil$SqlQualifiedResolveResult", "<init>"));
        }
    }
}

