/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.jasmine;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.JstdRunElement;
import com.intellij.javascript.testFramework.jasmine.AbstractJasmineElement;
import com.intellij.javascript.testFramework.jasmine.JasmineSpecStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineSuiteStructure;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JasmineFileStructure
extends AbstractTestFileStructure {
    private final List<JasmineSuiteStructure> mySuiteStructures;
    private final List<JasmineSpecStructure> mySpecStructures;
    private final Map<String, JasmineSuiteStructure> mySuiteMap;
    private final List<AbstractJasmineElement> myChildren;
    private Map<String, JasmineSpecStructure> mySpecMap;
    private final Map<PsiElement, AbstractJasmineElement> myLeafElementToInfoMap;

    public JasmineFileStructure(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            JasmineFileStructure.$$$reportNull$$$0(0);
        }
        super(jsFile);
        this.mySuiteStructures = Lists.newArrayList();
        this.mySpecStructures = Lists.newArrayList();
        this.mySuiteMap = Maps.newHashMap();
        this.myChildren = ContainerUtil.newArrayList();
        this.myLeafElementToInfoMap = ContainerUtil.newIdentityHashMap();
    }

    @NotNull
    public List<JasmineSuiteStructure> getSuites() {
        List<JasmineSuiteStructure> list = this.mySuiteStructures;
        if (list == null) {
            JasmineFileStructure.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public boolean isEmpty() {
        return !this.hasJasmineSymbols();
    }

    public boolean containsCallExpression(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            JasmineFileStructure.$$$reportNull$$$0(2);
        }
        return this.myLeafElementToInfoMap.containsKey(JsPsiUtils.getMethodNameLeafElement(callExpression));
    }

    public void addSuiteStructure(@NotNull JasmineSuiteStructure suiteStructure) {
        if (suiteStructure == null) {
            JasmineFileStructure.$$$reportNull$$$0(3);
        }
        this.mySuiteStructures.add(suiteStructure);
        this.myChildren.add(suiteStructure);
    }

    public void addSpecStructure(@NotNull JasmineSpecStructure spec) {
        if (spec == null) {
            JasmineFileStructure.$$$reportNull$$$0(4);
        }
        this.mySpecStructures.add(spec);
        this.myChildren.add(spec);
    }

    @NotNull
    public List<AbstractJasmineElement> getChildren() {
        List<AbstractJasmineElement> list = this.myChildren;
        if (list == null) {
            JasmineFileStructure.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<JasmineSpecStructure> getSpecs() {
        List<JasmineSpecStructure> list = this.mySpecStructures;
        if (list == null) {
            JasmineFileStructure.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public JasmineSuiteStructure findTopLevelSuiteByName(String suiteName) {
        return this.mySuiteMap.get(suiteName);
    }

    public int getTopLevelSuiteCount() {
        return this.mySuiteStructures.size();
    }

    public boolean hasJasmineSymbols() {
        return this.getTopLevelSuiteCount() > 0 || !this.mySpecStructures.isEmpty();
    }

    @Nullable
    public JasmineSuiteStructure findLowestSuiteStructureContainingOffset(int offset) {
        for (JasmineSuiteStructure suiteStructure : this.mySuiteStructures) {
            JasmineSuiteStructure inner = suiteStructure.findLowestSuiteStructureContainingOffset(offset);
            if (inner == null) continue;
            return inner;
        }
        return null;
    }

    @Nullable
    public JasmineSpecStructure findSpecContainingOffset(int offset) {
        for (JasmineSpecStructure specChild : this.mySpecStructures) {
            TextRange specTextRange = specChild.getEnclosingCallExpression().getTextRange();
            if (!JsPsiUtils.containsOffsetStrictly(specTextRange, offset)) continue;
            return specChild;
        }
        for (JasmineSuiteStructure suiteStructure : this.mySuiteStructures) {
            JasmineSpecStructure specStructure = suiteStructure.findSpecContainingOffset(offset);
            if (specStructure == null) continue;
            return specStructure;
        }
        return null;
    }

    @Override
    @Nullable
    public JstdRunElement findJstdRunElement(@NotNull TextRange textRange) {
        JsTestElementPath testElementPath;
        if (textRange == null) {
            JasmineFileStructure.$$$reportNull$$$0(7);
        }
        if ((testElementPath = this.findTestElementPath(textRange)) == null) {
            return null;
        }
        return new JstdRunElement(StringUtil.join(testElementPath.getSuiteNames(), (String)" "), testElementPath.getTestName());
    }

    @Nullable
    public AbstractJasmineElement findJasmineElement(@NotNull TextRange textRange) {
        if (textRange == null) {
            JasmineFileStructure.$$$reportNull$$$0(8);
        }
        for (JasmineSuiteStructure suiteStructure : this.mySuiteStructures) {
            AbstractJasmineElement result = suiteStructure.findJasmineElement(textRange);
            if (result == null) continue;
            return result;
        }
        for (JasmineSpecStructure spec : this.mySpecStructures) {
            TextRange callTextRange = spec.getEnclosingCallExpression().getTextRange();
            if (!callTextRange.contains(textRange)) continue;
            return spec;
        }
        return null;
    }

    @Override
    @Nullable
    public JsTestElementPath findTestElementPath(@NotNull TextRange textRange) {
        if (textRange == null) {
            JasmineFileStructure.$$$reportNull$$$0(9);
        }
        return JasmineFileStructure.toTestElementPath(this.findJasmineElement(textRange));
    }

    @Override
    @Nullable
    public JsTestElementPath findTestElementPath(@NotNull PsiElement testIdentifierLeafElement) {
        if (testIdentifierLeafElement == null) {
            JasmineFileStructure.$$$reportNull$$$0(10);
        }
        return JasmineFileStructure.toTestElementPath(this.myLeafElementToInfoMap.get(testIdentifierLeafElement));
    }

    @Nullable
    private static JsTestElementPath toTestElementPath(@Nullable AbstractJasmineElement element) {
        JSCallExpression psiElement;
        JasmineSuiteStructure suiteStructure;
        if (element == null) {
            return null;
        }
        String specName = null;
        if (element instanceof JasmineSuiteStructure) {
            suiteStructure = (JasmineSuiteStructure)element;
            psiElement = suiteStructure.getEnclosingCallExpression();
        } else {
            JasmineSpecStructure specStructure = (JasmineSpecStructure)element;
            suiteStructure = element.getParent();
            specName = element.getName();
            psiElement = specStructure.getEnclosingCallExpression();
        }
        List suites = ContainerUtil.newSmartList();
        while (suiteStructure != null) {
            suites.add(suiteStructure.getName());
            suiteStructure = suiteStructure.getParent();
        }
        Collections.reverse(suites);
        return new JsTestElementPath(suites, specName, (PsiElement)psiElement);
    }

    @Nullable
    public PsiElement findPsiElement(@NotNull List<String> suiteNames, @Nullable String specName) {
        if (suiteNames == null) {
            JasmineFileStructure.$$$reportNull$$$0(11);
        }
        if (suiteNames.isEmpty()) {
            return null;
        }
        String topSuiteName = suiteNames.get(0);
        JasmineSuiteStructure suiteStructure = this.mySuiteMap.get(topSuiteName);
        if (suiteStructure == null) {
            JasmineSpecStructure spec;
            if (specName == null && suiteNames.size() == 1 && (spec = this.mySpecMap.get(topSuiteName)) != null) {
                return spec.getNavigationElement();
            }
            return null;
        }
        for (int i = 1; i < suiteNames.size(); ++i) {
            JasmineSpecStructure specStructure;
            if (i == suiteNames.size() - 1 && (specStructure = suiteStructure.getInnerSpecByName(suiteNames.get(i))) != null) {
                return specStructure.getNavigationElement();
            }
            if ((suiteStructure = suiteStructure.getInnerSuiteByName(suiteNames.get(i))) != null) continue;
            return null;
        }
        if (specName == null) {
            return suiteStructure.getNavigationElement();
        }
        JasmineSpecStructure specStructure = suiteStructure.getInnerSpecByName(specName);
        if (specStructure != null) {
            return specStructure.getNavigationElement();
        }
        return null;
    }

    @Override
    public PsiElement findPsiElement(@NotNull String testCaseName, @Nullable String testMethodName) {
        JasmineSuiteStructure suite;
        if (testCaseName == null) {
            JasmineFileStructure.$$$reportNull$$$0(12);
        }
        if ((suite = this.findSuite(testCaseName)) == null) {
            return null;
        }
        if (testMethodName == null) {
            return suite.getEnclosingCallExpression();
        }
        JasmineSpecStructure spec = suite.getInnerSpecByName(testMethodName);
        if (spec != null) {
            return spec.getEnclosingCallExpression();
        }
        return null;
    }

    @Nullable
    private JasmineSuiteStructure findSuite(@NotNull String suiteName) {
        JasmineSuiteStructure suite;
        if (suiteName == null) {
            JasmineFileStructure.$$$reportNull$$$0(13);
        }
        if ((suite = this.mySuiteMap.get(suiteName)) != null) {
            return suite;
        }
        int ind = suiteName.lastIndexOf(32);
        while (ind >= 0) {
            String suffix;
            JasmineSuiteStructure res;
            String prefix = suiteName.substring(0, ind);
            suite = this.mySuiteMap.get(prefix);
            if (suite != null && (res = suite.findSuite(suffix = suiteName.substring(ind + 1))) != null) {
                return res;
            }
            ind = suiteName.lastIndexOf(32, ind - 1);
        }
        return null;
    }

    @Override
    @NotNull
    public List<String> getTopLevelElements() {
        int size = this.mySuiteStructures.size() + this.mySpecStructures.size();
        if (size == 0) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                JasmineFileStructure.$$$reportNull$$$0(14);
            }
            return list;
        }
        ArrayList<String> out = new ArrayList<String>(size);
        for (JasmineSuiteStructure suite : this.mySuiteStructures) {
            out.add(suite.getName());
        }
        for (JasmineSpecStructure spec : this.mySpecStructures) {
            out.add(spec.getName());
        }
        ArrayList<String> arrayList = out;
        if (arrayList == null) {
            JasmineFileStructure.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<String> getChildrenOf(@NotNull String topLevelElementName) {
        JasmineSuiteStructure suiteStructure;
        if (topLevelElementName == null) {
            JasmineFileStructure.$$$reportNull$$$0(16);
        }
        if ((suiteStructure = this.mySuiteMap.get(topLevelElementName)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                JasmineFileStructure.$$$reportNull$$$0(17);
            }
            return list;
        }
        ArrayList<String> out = new ArrayList<String>(suiteStructure.getSpecCount());
        for (JasmineSpecStructure specStructure : suiteStructure.getSpecs()) {
            out.add(specStructure.getName());
        }
        ArrayList<String> arrayList = out;
        if (arrayList == null) {
            JasmineFileStructure.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @Override
    public boolean contains(@NotNull String testCaseName, @Nullable String testMethodName) {
        if (testCaseName == null) {
            JasmineFileStructure.$$$reportNull$$$0(19);
        }
        return this.findPsiElement(testCaseName, testMethodName) != null;
    }

    void postProcess() {
        for (JasmineSuiteStructure suite : this.mySuiteStructures) {
            this.processSuite(suite);
        }
        for (JasmineSpecStructure spec : this.mySpecStructures) {
            this.register(spec.getEnclosingCallExpression(), spec);
        }
        this.mergeTopLevelSuites();
        this.mySpecMap = this.mySpecStructures.isEmpty() ? Collections.emptyMap() : ContainerUtil.newMapFromValues(this.mySpecStructures.iterator(), o -> o.getName());
    }

    private void mergeTopLevelSuites() {
        Iterator<JasmineSuiteStructure> it = this.mySuiteStructures.iterator();
        while (it.hasNext()) {
            JasmineSuiteStructure suite = it.next();
            JasmineSuiteStructure prevSuite = this.mySuiteMap.get(suite.getName());
            if (prevSuite == null) {
                this.mySuiteMap.put(suite.getName(), suite);
                continue;
            }
            prevSuite.mergeWith(suite);
            it.remove();
        }
    }

    private void register(@NotNull JSCallExpression callExpression, @NotNull AbstractJasmineElement element) {
        PsiElement identifierLeafElement;
        if (callExpression == null) {
            JasmineFileStructure.$$$reportNull$$$0(20);
        }
        if (element == null) {
            JasmineFileStructure.$$$reportNull$$$0(21);
        }
        if ((identifierLeafElement = JsPsiUtils.getMethodNameLeafElement(callExpression)) != null) {
            this.myLeafElementToInfoMap.put(identifierLeafElement, element);
        }
    }

    private void processSuite(@NotNull JasmineSuiteStructure suite) {
        if (suite == null) {
            JasmineFileStructure.$$$reportNull$$$0(22);
        }
        for (JasmineSuiteStructure childSuite : suite.getSuites()) {
            this.processSuite(childSuite);
        }
        suite.fillNameMap();
        this.register(suite.getEnclosingCallExpression(), suite);
        for (JasmineSpecStructure spec : suite.getSpecs()) {
            this.register(spec.getEnclosingCallExpression(), spec);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure";
                break;
            }
            case 2: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteStructure";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testIdentifierLeafElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteNames";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCaseName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelElementName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuites";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecs";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelElements";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsCallExpression";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addSuiteStructure";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addSpecStructure";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findJstdRunElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findJasmineElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findTestElementPath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findPsiElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findSuite";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOf";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processSuite";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

