/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.actions;

import com.intellij.guice.GuiceBundle;
import com.intellij.guice.actions.GeneratePluginClassAction;
import com.intellij.guice.actions.GuiceProviderBuilder;
import com.intellij.guice.actions.ProviderDialog;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class NewGuiceProviderAction
extends GeneratePluginClassAction {
    private static final Logger LOGGER = Logger.getInstance((String)"NewGuiceProviderAction");
    private String providedClassName = null;

    public NewGuiceProviderAction() {
        super(GuiceBundle.message("new.guice.provider.action.name", new Object[0]), GuiceBundle.message("new.guice.provider.action.name", new Object[0]), null);
    }

    @Override
    protected PsiElement[] invokeDialogImpl(Project project, PsiDirectory directory) {
        ProviderDialog dialog = new ProviderDialog(project);
        if (dialog.showAndGet()) {
            String providerName = dialog.getProviderName();
            this.providedClassName = dialog.getProvidedClass();
            CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
            validator.canClose(providerName);
            return validator.getCreatedElements();
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) {
        PsiElement[] psiElementArray;
        block6: {
            String beanClassString;
            Project project = directory.getProject();
            PsiFileFactory elementFactory = PsiFileFactory.getInstance((Project)project);
            GuiceProviderBuilder builder = new GuiceProviderBuilder();
            builder.setClassName(newName);
            builder.setProvidedClassName(this.providedClassName);
            try {
                beanClassString = builder.buildProviderClass(project);
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
                if (PsiElement.EMPTY_ARRAY == null) {
                    NewGuiceProviderAction.$$$reportNull$$$0(0);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            try {
                PsiFile newFile = elementFactory.createFileFromText(newName + ".java", beanClassString);
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                PsiElement shortenedFile = codeStyleManager.shortenClassReferences((PsiElement)newFile);
                PsiElement reformattedFile = CodeStyleManager.getInstance((Project)project).reformat(shortenedFile);
                directory.add(reformattedFile);
                psiElementArray = new PsiElement[]{reformattedFile};
                if (psiElementArray != null) break block6;
            }
            catch (IncorrectOperationException e) {
                LOGGER.error((Throwable)e);
                if (PsiElement.EMPTY_ARRAY == null) {
                    NewGuiceProviderAction.$$$reportNull$$$0(2);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            NewGuiceProviderAction.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    protected String getErrorTitle() {
        return GuiceBundle.message("new.guice.provider.error", new Object[0]);
    }

    protected String getCommandName() {
        return GuiceBundle.message("new.guice.provider.command", new Object[0]);
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return GuiceBundle.message("new.guice.provider.name", directory, newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/actions/NewGuiceProviderAction", "create"));
    }
}

