/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.el;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.spring.el.contextProviders.SpringElContextsExtension;
import com.intellij.spring.security.highlighting.SpringSecuritySpElAccessInjector;
import com.intellij.spring.security.model.xml.converters.SecurityExpressionRootMethodsUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class SpringSecurityELContextVariables
extends SpringElContextsExtension {
    private static final List<String> ANNOTATIONS = ContainerUtil.immutableList((Object[])new String[]{"org.springframework.security.access.prepost.PreAuthorize", "org.springframework.security.access.prepost.PreFilter", "org.springframework.security.access.prepost.PostAuthorize", "org.springframework.security.access.prepost.PostFilter"});
    private static PsiElementPattern[] PATTERNS = new PsiElementPattern[]{(PsiElementPattern)PsiJavaPatterns.literalExpression().and((ElementPattern)PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("access")).definedInClass("org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer.AuthorizedUrl")))};

    @NotNull
    public Collection<PsiMethod> getRootMethods(@NotNull PsiElement element) {
        PsiElement context;
        if (element == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(0);
        }
        if ((context = element.getContext()) == null || !SpringSecurityELContextVariables.acceptContext(context)) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                SpringSecurityELContextVariables.$$$reportNull$$$0(1);
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        Set<PsiMethod> set = SecurityExpressionRootMethodsUtil.getExpressionRootMethods(module, SpringSecurityELContextVariables.isSecurityAnnotation(context) ? "org.springframework.security.access.expression.method.MethodSecurityExpressionRoot" : "org.springframework.security.web.access.expression.WebSecurityExpressionRoot");
        if (set == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement psiElement) {
        PsiElement context;
        if (psiElement == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(3);
        }
        if ((context = psiElement.getContext()) == null || !SpringSecurityELContextVariables.acceptContext(context)) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringSecurityELContextVariables.$$$reportNull$$$0(4);
            }
            return list;
        }
        List variables = ContainerUtil.newSmartList();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethod.class);
        if (method != null) {
            PsiParameter[] parameters;
            for (PsiParameter parameter : parameters = method.getParameterList().getParameters()) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (String[])new String[]{"org.springframework.security.access.method.P"});
                if (annotation != null) {
                    String value = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, null);
                    if (!StringUtil.isNotEmpty((String)value)) continue;
                    variables.add(new LightVariableBuilder(value, parameter.getType(), (PsiElement)annotation));
                    continue;
                }
                variables.add(parameter);
            }
            PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)context, PsiAnnotation.class);
            if (annotation != null) {
                SpringSecurityELContextVariables.addPostAuthorizeVariables(annotation, variables, method);
                SpringSecurityELContextVariables.addPreFilterAnnotationVariables(annotation, variables, method);
                SpringSecurityELContextVariables.addPostFilterAnnotationVariables(annotation, variables, method);
            }
        }
        List list = variables;
        if (list == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static boolean acceptContext(@NotNull PsiElement context) {
        if (context == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(6);
        }
        return SpringSecurityELContextVariables.isSecurityAnnotation(context) || SpringSecurityELContextVariables.isXmlAccess(context) || SpringSecurityELContextVariables.isSecuritySpElPatternAccepted(context);
    }

    private static boolean isSecurityAnnotation(@NotNull PsiElement context) {
        UElement element;
        if (context == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(7);
        }
        if ((element = UastContextKt.toUElement((PsiElement)context)) == null) {
            return false;
        }
        UAnnotation annotation = (UAnnotation)UastUtils.getParentOfType((UElement)element, UAnnotation.class);
        return annotation != null && ANNOTATIONS.contains(annotation.getQualifiedName());
    }

    private static boolean isXmlAccess(@NotNull PsiElement context) {
        if (context == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(8);
        }
        return context instanceof XmlAttributeValue && SpringSecuritySpElAccessInjector.ACCESS_ATTR_PATTERN.accepts((Object)context);
    }

    private static void addPostAuthorizeVariables(@NotNull PsiAnnotation annotation, @NotNull Collection<PsiVariable> variables, @NotNull PsiMethod method) {
        if (annotation == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(9);
        }
        if (variables == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(10);
        }
        if (method == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(11);
        }
        if ("org.springframework.security.access.prepost.PostAuthorize".equals(annotation.getQualifiedName())) {
            PsiType returnType = method.getReturnType();
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            if (returnType != null && returnTypeElement != null) {
                variables.add((PsiVariable)new LightVariableBuilder("returnObject", returnType, (PsiElement)returnTypeElement));
            }
        }
    }

    private static void addPostFilterAnnotationVariables(@NotNull PsiAnnotation annotation, @NotNull Collection<PsiVariable> variables, @NotNull PsiMethod method) {
        if (annotation == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(12);
        }
        if (variables == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(13);
        }
        if (method == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(14);
        }
        if ("org.springframework.security.access.prepost.PostFilter".equals(annotation.getQualifiedName())) {
            PsiTypeElement returnTypeElement;
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiType iterableTypeParameter = PsiUtil.extractIterableTypeParameter((PsiType)returnType, (boolean)true);
            if (iterableTypeParameter != null && (returnTypeElement = method.getReturnTypeElement()) != null) {
                variables.add((PsiVariable)new LightVariableBuilder("filterObject", iterableTypeParameter, (PsiElement)returnTypeElement));
            }
        }
    }

    private static void addPreFilterAnnotationVariables(@NotNull PsiAnnotation annotation, @NotNull Collection<PsiVariable> variables, @NotNull PsiMethod method) {
        if (annotation == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(15);
        }
        if (variables == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(16);
        }
        if (method == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(17);
        }
        if ("org.springframework.security.access.prepost.PreFilter".equals(annotation.getQualifiedName())) {
            String filterTarget = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)"filterTarget");
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (StringUtil.isEmptyOrSpaces((String)filterTarget)) {
                if (parameters.length == 1) {
                    SpringSecurityELContextVariables.addFilterObjectParameter(variables, parameters[0]);
                }
            } else {
                for (PsiParameter parameter : parameters) {
                    if (!filterTarget.equals(parameter.getName())) continue;
                    SpringSecurityELContextVariables.addFilterObjectParameter(variables, parameter);
                    return;
                }
            }
        }
    }

    private static void addFilterObjectParameter(@NotNull Collection<PsiVariable> variables, @NotNull PsiParameter parameter) {
        PsiType iterableTypeParameter;
        if (variables == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(18);
        }
        if (parameter == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(19);
        }
        if ((iterableTypeParameter = PsiUtil.extractIterableTypeParameter((PsiType)parameter.getType(), (boolean)true)) != null) {
            variables.add((PsiVariable)new LightVariableBuilder("filterObject", iterableTypeParameter, (PsiElement)parameter));
        }
    }

    public static boolean isSecuritySpElPatternAccepted(PsiElement context) {
        for (PsiElementPattern pattern : PATTERNS) {
            if (!pattern.accepts((Object)context)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/el/SpringSecurityELContextVariables";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/el/SpringSecurityELContextVariables";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootMethods";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootMethods";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getContextVariables";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "acceptContext";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSecurityAnnotation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isXmlAccess";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addPostAuthorizeVariables";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addPostFilterAnnotationVariables";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addPreFilterAnnotationVariables";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addFilterObjectParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

