/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt3.diagnostic.KaptError;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u001a\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a$\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u001a\u0014\u0010\u001b\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\f\u0010\u001c\u001a\u00020\u001d*\u00020\u0004H\u0002\u001a\f\u0010\u001e\u001a\u00020\t*\u00020\u0004H\u0002\u001a\u0014\u0010\u001f\u001a\u00020\u001d*\u00020\u001d2\u0006\u0010 \u001a\u00020\u0004H\u0002\u001a\f\u0010!\u001a\u00020\t*\u00020\u0004H\u0002\u001a\u0014\u0010\"\u001a\u00020\u0004*\u00020\u00042\u0006\u0010#\u001a\u00020\u001dH\u0002\u001a\u0014\u0010$\u001a\u00020\u0004*\u00020\u00042\u0006\u0010#\u001a\u00020\u001dH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0007\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"ADDITIONAL_KOTLIN_POSITION_FROM_KAPT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "COLON", "", "JAVAC_POSITION_PATTERN", "KAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT", "KOTLIN_POSITION_PATTERN", "addMessage", "", "message", "Lcom/android/ide/common/blame/Message;", "messages", "", "createMessage", "messageKind", "Lcom/android/ide/common/blame/Message$Kind;", "text", "findAdditionalKotlinLocationFromKapt", "Lcom/android/ide/common/blame/SourceFilePosition;", "getMessageKind", "kind", "isKaptErrorWhileAnnotationProcessing", "parse", "lineText", "reader", "Lcom/android/ide/common/blame/parser/util/OutputLineReader;", "amendNextLinesIfNeeded", "colon", "", "isNextMessage", "skipDriveOnWin", "line", "startsWithSeverityPrefix", "substringAfterAndTrim", "index", "substringBeforeAndTrim", "idea-android-output-parser"})
public final class KotlinOutputParserHelperKt {
    private static final String COLON = ":";
    private static final Pattern KOTLIN_POSITION_PATTERN;
    private static final Pattern JAVAC_POSITION_PATTERN;
    private static final Pattern ADDITIONAL_KOTLIN_POSITION_FROM_KAPT_PATTERN;
    private static final String KAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT;

    public static final boolean parse(@NotNull String lineText, @NotNull OutputLineReader reader, @NotNull List<Message> messages) {
        Intrinsics.checkParameterIsNotNull((Object)lineText, (String)"lineText");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull(messages, (String)"messages");
        int colonIndex1 = KotlinOutputParserHelperKt.colon(lineText);
        if (colonIndex1 < 0) {
            return false;
        }
        String severity = KotlinOutputParserHelperKt.substringBeforeAndTrim(lineText, colonIndex1);
        if (!KotlinOutputParserHelperKt.startsWithSeverityPrefix(severity)) {
            return false;
        }
        String lineWoSeverity = KotlinOutputParserHelperKt.substringAfterAndTrim(lineText, colonIndex1);
        int colonIndex2 = KotlinOutputParserHelperKt.skipDriveOnWin(KotlinOutputParserHelperKt.colon(lineWoSeverity), lineWoSeverity);
        if (colonIndex2 >= 0) {
            String string;
            String path = KotlinOutputParserHelperKt.substringBeforeAndTrim(lineWoSeverity, colonIndex2);
            File file2 = new File(path);
            String string2 = string = FilesKt.getExtension((File)file2);
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String fileExtension = string3;
            if (!file2.isFile() || Intrinsics.areEqual((Object)fileExtension, (Object)"kt") ^ true && Intrinsics.areEqual((Object)fileExtension, (Object)"java") ^ true) {
                return KotlinOutputParserHelperKt.addMessage(KotlinOutputParserHelperKt.createMessage(KotlinOutputParserHelperKt.getMessageKind(severity), KotlinOutputParserHelperKt.amendNextLinesIfNeeded(lineWoSeverity, reader)), messages);
            }
            String lineWoPath = KotlinOutputParserHelperKt.substringAfterAndTrim(lineWoSeverity, colonIndex2);
            int colonIndex3 = KotlinOutputParserHelperKt.colon(lineWoPath);
            if (colonIndex3 >= 0) {
                String position2 = KotlinOutputParserHelperKt.substringBeforeAndTrim(lineWoPath, colonIndex3);
                Matcher matcher2 = KOTLIN_POSITION_PATTERN.matcher(position2);
                Matcher it = matcher2;
                Matcher matcher3 = it.matches() ? matcher2 : null;
                if (matcher3 == null) {
                    matcher3 = JAVAC_POSITION_PATTERN.matcher(position2);
                }
                Matcher matcher4 = matcher3;
                String message2 = KotlinOutputParserHelperKt.amendNextLinesIfNeeded(KotlinOutputParserHelperKt.substringAfterAndTrim(lineWoPath, colonIndex3), reader);
                if (matcher4.matches()) {
                    int column;
                    int n;
                    Integer line;
                    Integer n2;
                    String string4 = matcher4.group(1);
                    if (string4 != null) {
                        String $i$a$1$takeIf = string4;
                        n2 = Integer.parseInt($i$a$1$takeIf);
                    } else {
                        n2 = line = null;
                    }
                    if (matcher4.groupCount() >= 2) {
                        String string5 = matcher4.group(2);
                        if (string5 != null) {
                            String string6 = string5;
                            n = Integer.parseInt(string6);
                        } else {
                            n = 1;
                        }
                    } else {
                        n = column = 1;
                    }
                    if (line != null) {
                        SourceFilePosition mainPosition = new SourceFilePosition(file2, new SourcePosition(line.intValue(), column, column));
                        SourceFilePosition kotlinKaptPosition = KotlinOutputParserHelperKt.findAdditionalKotlinLocationFromKapt(message2);
                        String string7 = message2;
                        Message.Kind kind2 = KotlinOutputParserHelperKt.getMessageKind(severity);
                        String string8 = string7;
                        if (string8 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        String string9 = ((Object)StringsKt.trim((CharSequence)string8)).toString();
                        SourceFilePosition sourceFilePosition = kotlinKaptPosition;
                        if (sourceFilePosition == null) {
                            sourceFilePosition = mainPosition;
                        }
                        SourceFilePosition[] sourceFilePositionArray = new SourceFilePosition[]{};
                        SourceFilePosition sourceFilePosition2 = sourceFilePosition;
                        String string10 = string9;
                        Message.Kind kind3 = kind2;
                        return KotlinOutputParserHelperKt.addMessage(new Message(kind3, string10, sourceFilePosition2, sourceFilePositionArray), messages);
                    }
                }
                return KotlinOutputParserHelperKt.addMessage(KotlinOutputParserHelperKt.createMessage(KotlinOutputParserHelperKt.getMessageKind(severity), message2), messages);
            }
            return KotlinOutputParserHelperKt.addMessage(KotlinOutputParserHelperKt.createMessage(KotlinOutputParserHelperKt.getMessageKind(severity), KotlinOutputParserHelperKt.amendNextLinesIfNeeded(lineWoSeverity, reader)), messages);
        }
        return false;
    }

    private static final SourceFilePosition findAdditionalKotlinLocationFromKapt(String message2) {
        for (String lineText : StringsKt.lines((CharSequence)message2)) {
            Object object = lineText;
            Pattern pattern = ADDITIONAL_KOTLIN_POSITION_FROM_KAPT_PATTERN;
            String string = object;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
            object = pattern.matcher(string2);
            Object it = object;
            Object object2 = ((Matcher)it).matches() ? object : null;
            if (object2 == null) {
                continue;
            }
            Object matcher2 = object2;
            String string3 = ((Matcher)matcher2).group(1);
            if (string3 == null) {
                break;
            }
            String filePath = string3;
            if (!StringsKt.startsWith$default((String)filePath, (String)"/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)StringsKt.drop((String)filePath, (int)1), (String)":\\", (boolean)false, (int)2, null)) break;
            String string4 = ((Matcher)matcher2).group(2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"matcher.group(2)");
            Integer n = StringsKt.toIntOrNull((String)string4);
            if (n == null) {
                break;
            }
            int line = n;
            String string5 = ((Matcher)matcher2).group(3);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"matcher.group(3)");
            Integer n2 = StringsKt.toIntOrNull((String)string5);
            if (n2 == null) {
                break;
            }
            int column = n2;
            return new SourceFilePosition(new File(filePath), new SourcePosition(line, column, column));
        }
        return null;
    }

    private static final String amendNextLinesIfNeeded(@NotNull String $receiver, OutputLineReader reader) {
        String nextLine = reader.readLine();
        StringBuilder builder = new StringBuilder($receiver);
        while (nextLine != null && !KotlinOutputParserHelperKt.isNextMessage(nextLine)) {
            builder.append("\n").append(nextLine);
            if (!reader.hasNextLine()) break;
            nextLine = reader.readLine();
        }
        if (nextLine != null) {
            Field field2;
            try {
                field2 = reader.getClass().getDeclaredField("myPosition");
            }
            catch (Throwable e) {
                field2 = null;
            }
            Field positionField = field2;
            if (positionField != null) {
                positionField.setAccessible(true);
                positionField.setInt(reader, positionField.getInt(reader) - 1);
            }
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isNextMessage(@NotNull String $receiver) {
        int colonIndex1 = StringsKt.indexOf$default((CharSequence)$receiver, (String)COLON, (int)0, (boolean)false, (int)6, null);
        if (colonIndex1 == 0) return true;
        if (colonIndex1 >= 0) {
            String string = $receiver;
            int n = 0;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, colonIndex1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            if (KotlinOutputParserHelperKt.startsWithSeverityPrefix(string3)) return true;
        }
        if (StringUtil.containsIgnoreCase((String)$receiver, (String)"FAILURE")) return true;
        if (!StringUtil.containsIgnoreCase((String)$receiver, (String)"FAILED")) return false;
        return true;
    }

    private static final boolean startsWithSeverityPrefix(@NotNull String $receiver) {
        return Intrinsics.areEqual((Object)KotlinOutputParserHelperKt.getMessageKind($receiver), (Object)Message.Kind.UNKNOWN) ^ true;
    }

    private static final Message.Kind getMessageKind(String kind2) {
        Message.Kind kind3;
        switch (kind2) {
            case "e": {
                kind3 = Message.Kind.ERROR;
                break;
            }
            case "w": {
                kind3 = Message.Kind.WARNING;
                break;
            }
            case "i": {
                kind3 = Message.Kind.INFO;
                break;
            }
            case "v": {
                kind3 = Message.Kind.SIMPLE;
                break;
            }
            default: {
                kind3 = Message.Kind.UNKNOWN;
            }
        }
        return kind3;
    }

    private static final String substringAfterAndTrim(@NotNull String $receiver, int index2) {
        String string = $receiver;
        int n = index2 + 1;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String string4 = string = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string4)).toString();
    }

    private static final String substringBeforeAndTrim(@NotNull String $receiver, int index2) {
        String string = $receiver;
        int n = 0;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, index2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string4)).toString();
    }

    private static final int colon(@NotNull String $receiver) {
        return StringsKt.indexOf$default((CharSequence)$receiver, (String)COLON, (int)0, (boolean)false, (int)6, null);
    }

    private static final int skipDriveOnWin(int $receiver, String line) {
        return $receiver == 1 ? StringsKt.indexOf$default((CharSequence)line, (String)COLON, (int)($receiver + 1), (boolean)false, (int)4, null) : $receiver;
    }

    private static final boolean isKaptErrorWhileAnnotationProcessing(Message message2) {
        String messageText;
        if (Intrinsics.areEqual((Object)message2.getKind(), (Object)Message.Kind.ERROR) ^ true) {
            return false;
        }
        List list2 = message2.getSourceFilePositions();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"message.sourceFilePositions");
        if (Intrinsics.areEqual((Object)((SourceFilePosition)CollectionsKt.singleOrNull((List)list2)), (Object)SourceFilePosition.UNKNOWN) ^ true) {
            return false;
        }
        String string = messageText = message2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"messageText");
        String string2 = IllegalStateException.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"IllegalStateException::class.java.name");
        return StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)messageText, (CharSequence)KAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT, (boolean)false, (int)2, null);
    }

    private static final boolean addMessage(Message message2, List<Message> messages) {
        if (KotlinOutputParserHelperKt.isKaptErrorWhileAnnotationProcessing(message2)) {
            return true;
        }
        boolean duplicatesPrevious = false;
        int messageCount = messages.size();
        if (messageCount > 0) {
            Message lastMessage = messages.get(messageCount - 1);
            duplicatesPrevious = Intrinsics.areEqual((Object)lastMessage, (Object)message2);
        }
        if (!duplicatesPrevious) {
            messages.add(message2);
        }
        return true;
    }

    private static final Message createMessage(Message.Kind messageKind, String text2) {
        String string = text2;
        Message.Kind kind2 = messageKind;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        ImmutableList immutableList = ImmutableList.of();
        Optional optional = Optional.absent();
        String string4 = text2;
        String string5 = string3;
        Message.Kind kind3 = kind2;
        return new Message(kind3, string5, string4, optional, immutableList);
    }

    static {
        COLON = COLON;
        KOTLIN_POSITION_PATTERN = Pattern.compile("\\(([0-9]*), ([0-9]*)\\)");
        JAVAC_POSITION_PATTERN = Pattern.compile("([0-9]+)");
        ADDITIONAL_KOTLIN_POSITION_FROM_KAPT_PATTERN = Pattern.compile("^Kotlin location: (.+): \\((\\d+), (\\d+)\\)$");
        KAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT = KaptError.class.getCanonicalName() + ": " + KaptError.Kind.ERROR_RAISED.getMessage();
    }
}

