/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.kdsl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.wizard.ExternalModuleSettingsStep;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.kdsl.GradleModuleBuilder;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleParentProjectForm;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleModuleWizardStep
extends ModuleWizardStep {
    private static final Icon WIZARD_ICON = null;
    private static final String INHERIT_GROUP_ID_KEY = "GradleModuleWizard.inheritGroupId";
    private static final String INHERIT_VERSION_KEY = "GradleModuleWizard.inheritVersion";
    private static final String DEFAULT_VERSION = "1.0-SNAPSHOT";
    @Nullable
    private final Project myProjectOrNull;
    @NotNull
    private final GradleModuleBuilder myBuilder;
    @NotNull
    private final WizardContext myContext;
    @NotNull
    private final GradleParentProjectForm myParentProjectForm;
    private String myInheritedGroupId;
    private String myInheritedVersion;
    private JPanel myMainPanel;
    private JTextField myGroupIdField;
    private JCheckBox myInheritGroupIdCheckBox;
    private JTextField myArtifactIdField;
    private JTextField myVersionField;
    private JCheckBox myInheritVersionCheckBox;
    private JPanel myAddToPanel;

    public GradleModuleWizardStep(@NotNull GradleModuleBuilder builder, @NotNull WizardContext context) {
        if (builder == null) {
            GradleModuleWizardStep.$$$reportNull$$$1(0);
        }
        if (context == null) {
            GradleModuleWizardStep.$$$reportNull$$$1(1);
        }
        if (builder == null) {
            GradleModuleWizardStep.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GradleModuleWizardStep.$$$reportNull$$$0(1);
        }
        this.$$$setupUI$$$();
        this.myProjectOrNull = context.getProject();
        this.myBuilder = builder;
        this.myContext = context;
        this.myParentProjectForm = new GradleParentProjectForm(context, parentProject -> this.updateComponents());
        this.initComponents();
        this.loadSettings();
    }

    private void initComponents() {
        this.myAddToPanel.add(this.myParentProjectForm.getComponent());
        ActionListener updatingListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GradleModuleWizardStep.this.updateComponents();
            }
        };
        this.myInheritGroupIdCheckBox.addActionListener(updatingListener);
        this.myInheritVersionCheckBox.addActionListener(updatingListener);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGroupIdField;
    }

    public void onStepLeaving() {
        this.saveSettings();
    }

    private void loadSettings() {
        this.myBuilder.setInheritGroupId(GradleModuleWizardStep.getSavedValue(INHERIT_GROUP_ID_KEY, true));
        this.myBuilder.setInheritVersion(GradleModuleWizardStep.getSavedValue(INHERIT_VERSION_KEY, true));
    }

    private void saveSettings() {
        GradleModuleWizardStep.saveValue(INHERIT_GROUP_ID_KEY, this.myInheritGroupIdCheckBox.isSelected());
        GradleModuleWizardStep.saveValue(INHERIT_VERSION_KEY, this.myInheritVersionCheckBox.isSelected());
    }

    private static boolean getSavedValue(String key, boolean defaultValue) {
        return GradleModuleWizardStep.getSavedValue(key, String.valueOf(defaultValue)).equals(String.valueOf(true));
    }

    private static String getSavedValue(String key, String defaultValue) {
        String value2 = PropertiesComponent.getInstance().getValue(key);
        return value2 == null ? defaultValue : value2;
    }

    private static void saveValue(String key, boolean value2) {
        GradleModuleWizardStep.saveValue(key, String.valueOf(value2));
    }

    private static void saveValue(String key, String value2) {
        PropertiesComponent.getInstance().setValue(key, value2);
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    public boolean validate() throws ConfigurationException {
        if (StringUtil.isEmptyOrSpaces((String)this.myArtifactIdField.getText())) {
            ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getInstance((Project)this.myProjectOrNull).requestFocus((Component)this.myArtifactIdField, true));
            throw new ConfigurationException("Please, specify artifactId");
        }
        return true;
    }

    public void updateStep() {
        ProjectData parentProject = this.myParentProjectForm.getParentProject();
        ProjectId projectId = this.myBuilder.getProjectId();
        if (projectId == null) {
            GradleModuleWizardStep.setTestIfEmpty(this.myArtifactIdField, this.myBuilder.getName());
            GradleModuleWizardStep.setTestIfEmpty(this.myGroupIdField, parentProject == null ? this.myBuilder.getName() : parentProject.getGroup());
            GradleModuleWizardStep.setTestIfEmpty(this.myVersionField, parentProject == null ? DEFAULT_VERSION : parentProject.getVersion());
        } else {
            GradleModuleWizardStep.setTestIfEmpty(this.myArtifactIdField, projectId.getArtifactId());
            GradleModuleWizardStep.setTestIfEmpty(this.myGroupIdField, projectId.getGroupId());
            GradleModuleWizardStep.setTestIfEmpty(this.myVersionField, projectId.getVersion());
        }
        this.myInheritGroupIdCheckBox.setSelected(this.myBuilder.isInheritGroupId());
        this.myInheritVersionCheckBox.setSelected(this.myBuilder.isInheritVersion());
        this.updateComponents();
    }

    private void updateComponents() {
        boolean isAddToVisible = this.myParentProjectForm.isVisible();
        this.myInheritGroupIdCheckBox.setVisible(isAddToVisible);
        this.myInheritVersionCheckBox.setVisible(isAddToVisible);
        this.myParentProjectForm.updateComponents();
        ProjectData parentProject = this.myParentProjectForm.getParentProject();
        if (parentProject == null) {
            this.myContext.putUserData(ExternalModuleSettingsStep.SKIP_STEP_KEY, (Object)Boolean.FALSE);
            this.myGroupIdField.setEnabled(true);
            this.myVersionField.setEnabled(true);
            this.myInheritGroupIdCheckBox.setEnabled(false);
            this.myInheritVersionCheckBox.setEnabled(false);
            GradleModuleWizardStep.setTestIfEmpty(this.myArtifactIdField, this.myBuilder.getName());
            GradleModuleWizardStep.setTestIfEmpty(this.myGroupIdField, "");
            GradleModuleWizardStep.setTestIfEmpty(this.myVersionField, DEFAULT_VERSION);
        } else {
            this.myContext.putUserData(ExternalModuleSettingsStep.SKIP_STEP_KEY, (Object)Boolean.TRUE);
            this.myGroupIdField.setEnabled(!this.myInheritGroupIdCheckBox.isSelected());
            this.myVersionField.setEnabled(!this.myInheritVersionCheckBox.isSelected());
            if (this.myInheritGroupIdCheckBox.isSelected() || this.myGroupIdField.getText().equals(this.myInheritedGroupId)) {
                this.myGroupIdField.setText(parentProject.getGroup());
            }
            if (this.myInheritVersionCheckBox.isSelected() || this.myVersionField.getText().equals(this.myInheritedVersion)) {
                this.myVersionField.setText(parentProject.getVersion());
            }
            this.myInheritedGroupId = this.myGroupIdField.getText();
            this.myInheritedVersion = this.myVersionField.getText();
            this.myInheritGroupIdCheckBox.setEnabled(true);
            this.myInheritVersionCheckBox.setEnabled(true);
        }
    }

    public static boolean isGradleModuleExist(WizardContext myContext) {
        for (Module module : myContext.getModulesProvider().getModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) continue;
            return true;
        }
        return false;
    }

    public void updateDataModel() {
        this.myContext.setProjectBuilder((ProjectBuilder)this.myBuilder);
        ProjectData parentProject = this.myParentProjectForm.getParentProject();
        this.myBuilder.setParentProject(parentProject);
        this.myBuilder.setProjectId(new ProjectId(this.myGroupIdField.getText(), this.myArtifactIdField.getText(), this.myVersionField.getText()));
        this.myBuilder.setInheritGroupId(this.myInheritGroupIdCheckBox.isSelected());
        this.myBuilder.setInheritVersion(this.myInheritVersionCheckBox.isSelected());
        if (StringUtil.isNotEmpty((String)this.myBuilder.getProjectId().getArtifactId())) {
            this.myContext.setProjectName(this.myBuilder.getProjectId().getArtifactId());
        }
        if (parentProject != null) {
            this.myContext.setProjectFileDirectory(parentProject.getLinkedExternalProjectPath() + '/' + this.myContext.getProjectName());
        } else if (this.myProjectOrNull != null) {
            this.myContext.setProjectFileDirectory(this.myProjectOrNull.getBaseDir().getPath() + '/' + this.myContext.getProjectName());
        }
    }

    public Icon getIcon() {
        return WIZARD_ICON;
    }

    private static void setTestIfEmpty(@NotNull JTextField field2, @Nullable String text2) {
        if (field2 == null) {
            GradleModuleWizardStep.$$$reportNull$$$1(2);
        }
        if (field2 == null) {
            GradleModuleWizardStep.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)field2.getText())) {
            field2.setText(StringUtil.notNullize((String)text2));
        }
    }

    public String getHelpId() {
        return "Gradle_Archetype_Dialog";
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myParentProjectForm);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("GroupId");
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("ArtifactId");
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Version");
        jPanel2.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGroupIdField = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myArtifactIdField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myVersionField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myInheritGroupIdCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Inherit");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myInheritVersionCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Inherit");
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAddToPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel3).setEnabled(true);
        jPanel2.add((Component)jPanel3, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor(jTextField3);
        jLabel2.setLabelFor(jTextField2);
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/gradle/kdsl/GradleModuleWizardStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setTestIfEmpty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/gradle/kdsl/GradleModuleWizardStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setTestIfEmpty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

