/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.filters;

import com.intellij.execution.filters.ExceptionFilter;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.filters.impl.HyperlinkInfoFactoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileTypeFactory;
import org.jetbrains.kotlin.idea.debugger.BytecodeDebugInfo;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.SmapData;
import org.jetbrains.kotlin.idea.debugger.SmapUtilKt;
import org.jetbrains.kotlin.idea.debugger.SourceLineKind;
import org.jetbrains.kotlin.idea.filters.InlineFunctionHyperLinkInfo;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\bH\u0002J*\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/filters/KotlinExceptionFilter;", "Lcom/intellij/execution/filters/Filter;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/psi/search/GlobalSearchScope;)V", "exceptionFilter", "Lcom/intellij/execution/filters/ExceptionFilter;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "createHyperlinkInfo", "Lcom/intellij/execution/filters/HyperlinkInfo;", "defaultResult", "createHyperlinks", "Lorg/jetbrains/kotlin/idea/filters/InlineFunctionHyperLinkInfo;", "jvmName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "patchResult", "result", "Companion", "idea"})
public final class KotlinExceptionFilter
implements Filter {
    private final ExceptionFilter exceptionFilter;
    private final GlobalSearchScope searchScope;
    private static final Pattern STACK_TRACE_ELEMENT_PATTERN;
    public static final Companion Companion;

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        Filter.Result result2 = this.exceptionFilter.applyFilter(line, entireLength);
        return result2 == null ? null : this.patchResult(result2, line);
    }

    /*
     * WARNING - void declaration
     */
    private final Filter.Result patchResult(Filter.Result result2, String line) {
        Collection<Filter.ResultItem> collection;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        HyperlinkInfo hyperlinkInfo = this.createHyperlinkInfo(line, result2);
        if (hyperlinkInfo == null) {
            return result2;
        }
        HyperlinkInfo newHyperlinkInfo = hyperlinkInfo;
        List list2 = result2.getResultItems();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"result.resultItems");
        Iterable iterable = $receiver$iv = (Iterable)list2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Filter.ResultItem resultItem = (Filter.ResultItem)item$iv$iv;
            collection = destination$iv$iv;
            Filter.ResultItem resultItem2 = new Filter.ResultItem(it.getHighlightStartOffset(), it.getHighlightEndOffset(), newHyperlinkInfo, it.getHighlightAttributes());
            collection.add(resultItem2);
        }
        collection = (List)destination$iv$iv;
        List list3 = collection;
        return new Filter.Result(list3);
    }

    /*
     * WARNING - void declaration
     */
    private final HyperlinkInfo createHyperlinkInfo(String line, Filter.Result defaultResult) {
        String string;
        Project project = this.searchScope.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        StackTraceElement stackTraceElement = KotlinExceptionFilter.Companion.parseStackTraceLine(line);
        if (stackTraceElement == null) {
            return null;
        }
        StackTraceElement stackTraceElement2 = stackTraceElement;
        String fileName = stackTraceElement2.getFileName();
        String string2 = FileUtilRt.getExtension((String)fileName);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"FileUtilRt.getExtension(fileName)");
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String extension = string4;
        Intrinsics.checkExpressionValueIsNotNull((Object)KotlinFileTypeFactory.KOTLIN_EXTENSIONS, (String)"KotlinFileTypeFactory.KOTLIN_EXTENSIONS");
        if (!ArraysKt.contains((Object[])KotlinFileTypeFactory.KOTLIN_EXTENSIONS, (Object)extension)) {
            return null;
        }
        String fullyQualifiedName = stackTraceElement2.getClassName();
        int lineNumber = stackTraceElement2.getLineNumber() - 1;
        String string5 = fullyQualifiedName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"fullyQualifiedName");
        String internalName = StringsKt.replace$default((String)string5, (char)'.', (char)'/', (boolean)false, (int)4, null);
        JvmClassName jvmClassName = JvmClassName.byInternalName(internalName);
        Project project3 = project2;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        JvmClassName jvmClassName2 = jvmClassName;
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"jvmClassName");
        String string6 = fileName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"fileName");
        KtFile file2 = DebuggerUtils.INSTANCE.findSourceFileForClassIncludeLibrarySources(project3, this.searchScope, jvmClassName2, string6);
        if (file2 == null) {
            void $receiver$iv;
            List list2 = defaultResult.getResultItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"defaultResult.resultItems");
            Iterable iterable = list2;
            Object[] destination$iv = (Object[])new HashSet();
            void $receiver$iv$iv = $receiver$iv;
            for (Object element$iv$iv : $receiver$iv$iv) {
                String string7;
                FileHyperlinkInfo fileHyperlinkInfo;
                Object element$iv = element$iv$iv;
                Filter.ResultItem it = (Filter.ResultItem)element$iv;
                Filter.ResultItem resultItem = it;
                if (!(resultItem instanceof FileHyperlinkInfo)) {
                    resultItem = null;
                }
                String string8 = (fileHyperlinkInfo = (FileHyperlinkInfo)resultItem) != null && (fileHyperlinkInfo = fileHyperlinkInfo.getDescriptor()) != null && (fileHyperlinkInfo = fileHyperlinkInfo.getFile()) != null ? fileHyperlinkInfo.getName() : null;
                if (string8 == null) continue;
                String it$iv = string7 = string8;
                destination$iv.add(it$iv);
            }
            HashSet defaultLinkFileNames = (HashSet)destination$iv;
            if (!defaultLinkFileNames.contains(fileName)) {
                void $receiver$iv2;
                PsiFile[] psiFileArray = FilenameIndex.getFilesByName((Project)project2, (String)fileName, (GlobalSearchScope)this.searchScope);
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFileArray, (String)"FilenameIndex.getFilesBy\u2026t, fileName, searchScope)");
                destination$iv = psiFileArray;
                Collection destination$iv2 = new HashSet();
                void $receiver$iv$iv2 = $receiver$iv2;
                int n = ((void)$receiver$iv$iv2).length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile virtualFile2;
                    PsiFile it;
                    void element$iv$iv;
                    void element$iv = element$iv$iv = $receiver$iv$iv2[i];
                    PsiFile psiFile = it = (PsiFile)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"it");
                    VirtualFile virtualFile3 = !psiFile.isValid() ? null : it.getVirtualFile();
                    if (virtualFile3 == null) continue;
                    VirtualFile it$iv = virtualFile2 = virtualFile3;
                    destination$iv2.add(it$iv);
                }
                HashSet filesByName = (HashSet)destination$iv2;
                Collection collection = filesByName;
                if (!collection.isEmpty()) {
                    return filesByName.size() > 1 ? HyperlinkInfoFactoryImpl.getInstance().createMultipleFilesHyperlinkInfo(CollectionsKt.toList((Iterable)filesByName), lineNumber, project2) : (HyperlinkInfo)new OpenFileHyperlinkInfo(project2, (VirtualFile)CollectionsKt.first((Iterable)filesByName), lineNumber);
                }
            }
            return null;
        }
        VirtualFile virtualFile4 = file2.getVirtualFile();
        if (virtualFile4 == null) {
            return null;
        }
        VirtualFile virtualFile5 = virtualFile4;
        InlineFunctionHyperLinkInfo hyperlinkInfoForInline = this.createHyperlinks(jvmClassName, virtualFile5, lineNumber + 1, project2);
        if (hyperlinkInfoForInline != null) {
            return (HyperlinkInfo)hyperlinkInfoForInline;
        }
        return (HyperlinkInfo)new OpenFileHyperlinkInfo(project2, virtualFile5, lineNumber);
    }

    /*
     * WARNING - void declaration
     */
    private final InlineFunctionHyperLinkInfo createHyperlinks(JvmClassName jvmName, VirtualFile file2, int line, Project project) {
        void inlineFunctionBodyFile;
        if (!NoStrataPositionManagerHelperKt.isInlineFunctionLineNumber(file2, line, project)) {
            return null;
        }
        BytecodeDebugInfo bytecodeDebugInfo = NoStrataPositionManagerHelperKt.readBytecodeInfo(project, jvmName, file2);
        if (bytecodeDebugInfo == null) {
            return null;
        }
        BytecodeDebugInfo debugInfo2 = bytecodeDebugInfo;
        SmapData smapData = debugInfo2.getSmapData();
        if (smapData == null) {
            return null;
        }
        SmapData smapData2 = smapData;
        ArrayList<InlineFunctionHyperLinkInfo.InlineInfo> inlineInfos = new ArrayList<InlineFunctionHyperLinkInfo.InlineInfo>();
        Pair<KtFile, Integer> pair2 = SmapUtilKt.mapStacktraceLineToSource(smapData2, line, project, SourceLineKind.EXECUTED_LINE, this.searchScope);
        if (pair2 == null) {
            return null;
        }
        Pair<KtFile, Integer> pair3 = pair2;
        KtFile ktFile = (KtFile)pair3.component1();
        int inlineFunctionBodyLine = ((Number)pair3.component2()).intValue();
        VirtualFile virtualFile2 = inlineFunctionBodyFile.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"inlineFunctionBodyFile.virtualFile");
        inlineInfos.add(new InlineFunctionHyperLinkInfo.InlineInfo.InlineFunctionBodyInfo(virtualFile2, inlineFunctionBodyLine));
        Pair<KtFile, Integer> inlineFunCallInfo = SmapUtilKt.mapStacktraceLineToSource(smapData2, line, project, SourceLineKind.CALL_LINE, this.searchScope);
        if (inlineFunCallInfo != null) {
            void callSiteFile;
            Pair<KtFile, Integer> pair4 = inlineFunCallInfo;
            KtFile ktFile2 = (KtFile)pair4.component1();
            int callSiteLine = ((Number)pair4.component2()).intValue();
            VirtualFile virtualFile3 = callSiteFile.getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"callSiteFile.virtualFile");
            inlineInfos.add(new InlineFunctionHyperLinkInfo.InlineInfo.CallSiteInfo(virtualFile3, callSiteLine));
        }
        return new InlineFunctionHyperLinkInfo(project, (List<? extends InlineFunctionHyperLinkInfo.InlineInfo>)inlineInfos);
    }

    public KotlinExceptionFilter(@NotNull GlobalSearchScope searchScope2) {
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        this.searchScope = searchScope2;
        this.exceptionFilter = new ExceptionFilter(this.searchScope);
    }

    static {
        Companion = new Companion(null);
        STACK_TRACE_ELEMENT_PATTERN = Pattern.compile("^[\\w|\\s]*at\\s+(.+)\\.(.+)\\((.+):(\\d+)\\)\\s*$");
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/filters/KotlinExceptionFilter$Companion;", "", "()V", "STACK_TRACE_ELEMENT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getSTACK_TRACE_ELEMENT_PATTERN", "()Ljava/util/regex/Pattern;", "parseStackTraceLine", "Ljava/lang/StackTraceElement;", "line", "", "idea"})
    public static final class Companion {
        private final Pattern getSTACK_TRACE_ELEMENT_PATTERN() {
            return STACK_TRACE_ELEMENT_PATTERN;
        }

        private final StackTraceElement parseStackTraceLine(String line) {
            Matcher matcher2 = this.getSTACK_TRACE_ELEMENT_PATTERN().matcher(line);
            if (matcher2.matches()) {
                String declaringClass = matcher2.group(1);
                String methodName = matcher2.group(2);
                String fileName = matcher2.group(3);
                String lineNumber = matcher2.group(4);
                return new StackTraceElement(declaringClass, methodName, fileName, Integer.parseInt(lineNumber));
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

