/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.highlighter.AnnotationPresentationInfo;
import org.jetbrains.kotlin.idea.highlighter.ElementAnnotator$WhenMappings;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.KotlinPsiCheckerKt;
import org.jetbrains.kotlin.idea.highlighter.KotlinSuppressableWarningProblemGroup;
import org.jetbrains.kotlin.idea.inspections.KotlinUniversalQuickFix;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0014\u0010\u0010\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011J\u001e\u0010\u0012\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ElementAnnotator;", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "shouldSuppressUnusedParameter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/lang/annotation/AnnotationHolder;Lkotlin/jvm/functions/Function1;)V", "registerDiagnosticAnnotations", "", "diagnostics", "", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "registerDiagnosticsAnnotations", "", "setUpAnnotations", "data", "Lorg/jetbrains/kotlin/idea/highlighter/AnnotationPresentationInfo;", "Companion", "idea-core"})
final class ElementAnnotator {
    private final PsiElement element;
    private final AnnotationHolder holder;
    private final Function1<KtParameter, Boolean> shouldSuppressUnusedParameter;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public final void registerDiagnosticsAnnotations(@NotNull Collection<? extends Diagnostic> diagnostics2) {
        void $receiver$iv$iv;
        Object $receiver$iv;
        Intrinsics.checkParameterIsNotNull(diagnostics2, (String)"diagnostics");
        Object object = $receiver$iv = (Iterable)diagnostics2;
        Map destination$iv$iv = new LinkedHashMap();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object2;
            Map $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = iterator2.next();
            Diagnostic it = (Diagnostic)element$iv$iv;
            DiagnosticFactory<?> key$iv$iv = it.getFactory();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        object = $receiver$iv;
        Iterator iterator3 = object.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv;
            Map.Entry group = element$iv = iterator3.next();
            this.registerDiagnosticAnnotations((List)group.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void registerDiagnosticAnnotations(List<? extends Diagnostic> diagnostics2) {
        AnnotationPresentationInfo annotationPresentationInfo;
        boolean $receiver$iv3;
        ProblemHighlightType factory2;
        Diagnostic diagnostic;
        block21: {
            boolean bl;
            Diagnostic it;
            void $receiver$iv$iv;
            Iterable $receiver$iv2;
            boolean bl2;
            Collection collection = diagnostics2;
            boolean bl3 = bl2 = !collection.isEmpty();
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Iterable iterable = $receiver$iv2 = (Iterable)diagnostics2;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (Diagnostic)element$iv$iv;
                if (!it.isValid()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List validDiagnostics = (List)destination$iv$iv;
            if (validDiagnostics.isEmpty()) {
                return;
            }
            diagnostic = (Diagnostic)CollectionsKt.first(diagnostics2);
            factory2 = diagnostic.getFactory();
            Iterable $receiver$iv3 = diagnostics2;
            if ($receiver$iv3 instanceof Collection && ((Collection)$receiver$iv3).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv3) {
                    it = (Diagnostic)element$iv;
                    if (Intrinsics.areEqual((Object)it.getPsiElement(), (Object)this.element) && Intrinsics.areEqual(it.getFactory(), factory2)) continue;
                    bl = false;
                    break block21;
                }
                bl = $receiver$iv3 = true;
            }
        }
        if (_Assertions.ENABLED && !$receiver$iv3) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        List<TextRange> ranges = diagnostic.getTextRanges();
        ProblemHighlightType problemHighlightType = factory2;
        Intrinsics.checkExpressionValueIsNotNull(problemHighlightType, (String)"factory");
        switch (ElementAnnotator$WhenMappings.$EnumSwitchMapping$0[problemHighlightType.getSeverity().ordinal()]) {
            case 1: {
                ProblemHighlightType problemHighlightType2 = factory2;
                ImmutableSet<? extends DiagnosticFactory<?>> immutableSet = Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS;
                Intrinsics.checkExpressionValueIsNotNull(immutableSet, (String)"Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS");
                if (CollectionsKt.contains((Iterable)((Iterable)immutableSet), problemHighlightType2)) {
                    PsiElement psiElement2 = this.element;
                    if (psiElement2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtReferenceExpression");
                    }
                    KtReferenceExpression referenceExpression = (KtReferenceExpression)psiElement2;
                    KtReference reference2 = ReferenceUtilKt.getMainReference(referenceExpression);
                    if (reference2 instanceof MultiRangeReference) {
                        Collection<TextRange> collection;
                        void $receiver$iv$iv;
                        Iterable $receiver$iv4;
                        List list2 = ((MultiRangeReference)reference2).getRanges();
                        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"reference.ranges");
                        Iterable $i$f$filter = $receiver$iv4 = (Iterable)list2;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv4, (int)10));
                        for (Object item$iv$iv : $receiver$iv$iv) {
                            void it;
                            TextRange textRange = (TextRange)item$iv$iv;
                            collection = destination$iv$iv;
                            TextRange textRange2 = it.shiftRight(referenceExpression.getTextOffset());
                            collection.add(textRange2);
                        }
                        collection = (List)destination$iv$iv;
                        DefaultConstructorMarker defaultConstructorMarker = null;
                        int n = 10;
                        TextAttributesKey textAttributesKey = null;
                        ProblemHighlightType problemHighlightType3 = ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
                        String string = null;
                        List list3 = collection;
                        annotationPresentationInfo = new AnnotationPresentationInfo(list3, string, problemHighlightType3, textAttributesKey, n, defaultConstructorMarker);
                        break;
                    }
                    List<TextRange> list4 = ranges;
                    Intrinsics.checkExpressionValueIsNotNull(list4, (String)"ranges");
                    annotationPresentationInfo = new AnnotationPresentationInfo(list4, null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, null, 10, null);
                    break;
                }
                if (Intrinsics.areEqual(problemHighlightType2, Errors.ILLEGAL_ESCAPE)) {
                    List<TextRange> list5 = ranges;
                    Intrinsics.checkExpressionValueIsNotNull(list5, (String)"ranges");
                    annotationPresentationInfo = new AnnotationPresentationInfo(list5, null, null, KotlinHighlightingColors.INVALID_STRING_ESCAPE, 6, null);
                    break;
                }
                if (Intrinsics.areEqual(problemHighlightType2, Errors.REDECLARATION)) {
                    List<TextRange> list6 = diagnostic.getTextRanges();
                    Intrinsics.checkExpressionValueIsNotNull(list6, (String)"diagnostic.textRanges");
                    annotationPresentationInfo = new AnnotationPresentationInfo(CollectionsKt.listOf((Object)CollectionsKt.first(list6)), "", null, null, 12, null);
                    break;
                }
                List<TextRange> list7 = ranges;
                Intrinsics.checkExpressionValueIsNotNull(list7, (String)"ranges");
                annotationPresentationInfo = new AnnotationPresentationInfo(list7, null, (ProblemHighlightType)(Intrinsics.areEqual(factory2, Errors.INVISIBLE_REFERENCE) ? ProblemHighlightType.LIKE_UNKNOWN_SYMBOL : null), null, 10, null);
                break;
            }
            case 2: {
                if (Intrinsics.areEqual(factory2, Errors.UNUSED_PARAMETER)) {
                    PsiElement psiElement3 = this.element;
                    if (psiElement3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParameter");
                    }
                    if (((Boolean)this.shouldSuppressUnusedParameter.invoke((Object)((KtParameter)psiElement3))).booleanValue()) {
                        return;
                    }
                }
                List<TextRange> list8 = ranges;
                Intrinsics.checkExpressionValueIsNotNull(list8, (String)"ranges");
                ProblemHighlightType problemHighlightType2 = factory2;
                Object object = Intrinsics.areEqual(problemHighlightType2, Errors.DEPRECATION) ? CodeInsightColors.DEPRECATED_ATTRIBUTES : (Intrinsics.areEqual(problemHighlightType2, Errors.UNUSED_ANONYMOUS_PARAMETER) ? CodeInsightColors.WEAK_WARNING_ATTRIBUTES : null);
                problemHighlightType2 = factory2;
                ImmutableSet<? extends DiagnosticFactory<?>> immutableSet = Errors.UNUSED_ELEMENT_DIAGNOSTICS;
                Intrinsics.checkExpressionValueIsNotNull(immutableSet, (String)"Errors.UNUSED_ELEMENT_DIAGNOSTICS");
                problemHighlightType2 = CollectionsKt.contains((Iterable)((Iterable)immutableSet), problemHighlightType2) ? ProblemHighlightType.LIKE_UNUSED_SYMBOL : (Intrinsics.areEqual((Object)problemHighlightType2, Errors.UNUSED_ANONYMOUS_PARAMETER) ? ProblemHighlightType.WEAK_WARNING : null);
                TextAttributesKey textAttributesKey = object;
                AnnotationPresentationInfo annotationPresentationInfo2 = new AnnotationPresentationInfo(list8, null, problemHighlightType2, textAttributesKey, 2, null);
                annotationPresentationInfo = annotationPresentationInfo2;
                break;
            }
            case 3: {
                List<TextRange> list9 = ranges;
                Intrinsics.checkExpressionValueIsNotNull(list9, (String)"ranges");
                annotationPresentationInfo = new AnnotationPresentationInfo(list9, null, ProblemHighlightType.INFORMATION, null, 10, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        AnnotationPresentationInfo presentationInfo = annotationPresentationInfo;
        this.setUpAnnotations(diagnostics2, presentationInfo);
    }

    private final void setUpAnnotations(List<? extends Diagnostic> diagnostics2, AnnotationPresentationInfo data) {
        MultiMap multiMap;
        try {
            multiMap = KotlinPsiCheckerKt.access$createQuickFixes(diagnostics2);
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw (Throwable)e;
            }
            Companion.getLOG().error((Throwable)e);
            multiMap = new MultiMap();
        }
        MultiMap fixesMap = multiMap;
        for (TextRange range : data.getRanges()) {
            for (Diagnostic diagnostic : diagnostics2) {
                Collection fixes;
                Annotation annotation2 = data.create(diagnostic, range, this.holder);
                Collection collection = fixes = fixesMap.get((Object)diagnostic);
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"fixes");
                Iterable $receiver$iv = collection;
                for (Object element$iv : $receiver$iv) {
                    IntentionAction it = (IntentionAction)element$iv;
                    IntentionAction intentionAction = it;
                    if (intentionAction instanceof KotlinUniversalQuickFix) {
                        annotation2.registerUniversalFix(it, null, null);
                        continue;
                    }
                    if (!(intentionAction instanceof IntentionAction)) continue;
                    annotation2.registerFix(it);
                }
                if (!Intrinsics.areEqual((Object)((Object)diagnostic.getSeverity()), (Object)((Object)Severity.WARNING))) continue;
                DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory, (String)"diagnostic.factory");
                annotation2.setProblemGroup((ProblemGroup)new KotlinSuppressableWarningProblemGroup(diagnosticFactory));
                if (!fixes.isEmpty()) continue;
                DiagnosticFactory<?> diagnosticFactory2 = diagnostic.getFactory();
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory2, (String)"diagnostic.factory");
                annotation2.registerFix((IntentionAction)new EmptyIntentionAction(diagnosticFactory2.getName()));
            }
        }
    }

    public ElementAnnotator(@NotNull PsiElement element3, @NotNull AnnotationHolder holder, @NotNull Function1<? super KtParameter, Boolean> shouldSuppressUnusedParameter) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull(shouldSuppressUnusedParameter, (String)"shouldSuppressUnusedParameter");
        this.element = element3;
        this.holder = holder;
        this.shouldSuppressUnusedParameter = shouldSuppressUnusedParameter;
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(ElementAnnotator.class);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ElementAnnotator$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "idea-core"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

