/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.KotlinRedundantOverrideInspectionKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinRedundantOverrideInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "isSameArguments", "superCallElement", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isSameFunctionName", "superSelectorExpression", "Companion", "RedundantOverrideFix", "idea"})
public final class KotlinRedundantOverrideInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    private static final List<KtModifierKeywordToken> MODIFIER_EXCLUDE_OVERRIDE;
    public static final Companion Companion;

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(this, holder, isOnTheFly){
            final /* synthetic */ KotlinRedundantOverrideInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;

            public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                KtExpression ktExpression;
                KtExpression ktExpression2;
                Object element$iv2;
                boolean bl;
                Iterable $receiver$iv;
                KtModifierList modifierList;
                PsiElement funKeyword;
                block29: {
                    Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
                    super.visitNamedFunction(function2);
                    PsiElement psiElement2 = function2.getFunKeyword();
                    if (psiElement2 == null) {
                        return;
                    }
                    funKeyword = psiElement2;
                    KtModifierList ktModifierList = function2.getModifierList();
                    if (ktModifierList == null) {
                        return;
                    }
                    modifierList = ktModifierList;
                    if (!modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                        return;
                    }
                    $receiver$iv = org.jetbrains.kotlin.idea.inspections.KotlinRedundantOverrideInspection$Companion.access$getMODIFIER_EXCLUDE_OVERRIDE$p(KotlinRedundantOverrideInspection.Companion);
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $receiver$iv) {
                            KtModifierKeywordToken it = (KtModifierKeywordToken)((Object)element$iv2);
                            if (!modifierList.hasModifier(it)) continue;
                            bl = true;
                            break block29;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return;
                }
                List<KtAnnotationEntry> list2 = function2.getAnnotationEntries();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"function.annotationEntries");
                $receiver$iv = list2;
                if (!$receiver$iv.isEmpty()) {
                    return;
                }
                KtClass ktClass2 = KtPsiUtilKt.containingClass(function2);
                if (ktClass2 != null) {
                    if (ktClass2.isData()) {
                        return;
                    }
                }
                KtExpression ktExpression3 = function2.getBodyExpression();
                if (ktExpression3 == null) {
                    return;
                }
                KtExpression bodyExpression = ktExpression3;
                element$iv2 = bodyExpression;
                if (element$iv2 instanceof KtDotQualifiedExpression) {
                    ktExpression2 = bodyExpression;
                } else if (element$iv2 instanceof KtBlockExpression) {
                    KtExpression body2;
                    KtExpression ktExpression4 = bodyExpression;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"bodyExpression");
                    List<KtExpression> list3 = ((KtBlockExpression)ktExpression4).getStatements();
                    Intrinsics.checkExpressionValueIsNotNull(list3, (String)"bodyExpression.statements");
                    KtExpression $i$a$1$any = body2 = (KtExpression)CollectionsKt.singleOrNull(list3);
                    if ($i$a$1$any instanceof KtReturnExpression) {
                        ktExpression2 = ((KtReturnExpression)body2).getReturnedExpression();
                    } else if ($i$a$1$any instanceof KtDotQualifiedExpression) {
                        KtExpression ktExpression5 = body2;
                        KtDotQualifiedExpression it = (KtDotQualifiedExpression)ktExpression5;
                        KtTypeReference ktTypeReference = function2.getTypeReference();
                        KtTypeReference it2 = ktTypeReference;
                        ktExpression2 = it2 == null || Intrinsics.areEqual((Object)it2.getText(), (Object)"Unit") ? ktExpression5 : null;
                    } else {
                        ktExpression2 = null;
                    }
                } else {
                    ktExpression2 = ktExpression = null;
                }
                if (!(ktExpression2 instanceof KtDotQualifiedExpression)) {
                    ktExpression = null;
                }
                KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)ktExpression;
                if (ktDotQualifiedExpression == null) {
                    return;
                }
                KtDotQualifiedExpression qualifiedExpression = ktDotQualifiedExpression;
                KtExpression ktExpression6 = qualifiedExpression.getReceiverExpression();
                if (!(ktExpression6 instanceof KtSuperExpression)) {
                    ktExpression6 = null;
                }
                KtSuperExpression ktSuperExpression = (KtSuperExpression)ktExpression6;
                if (ktSuperExpression == null) {
                    return;
                }
                KtSuperExpression superExpression = ktSuperExpression;
                if (superExpression.getSuperTypeQualifier() != null) {
                    return;
                }
                KtExpression ktExpression7 = qualifiedExpression.getSelectorExpression();
                if (!(ktExpression7 instanceof KtCallElement)) {
                    ktExpression7 = null;
                }
                KtCallElement ktCallElement = (KtCallElement)((Object)ktExpression7);
                if (ktCallElement == null) {
                    return;
                }
                KtCallElement superCallElement = ktCallElement;
                if (!KotlinRedundantOverrideInspection.access$isSameFunctionName(this.this$0, superCallElement, function2)) {
                    return;
                }
                if (!KotlinRedundantOverrideInspection.access$isSameArguments(this.this$0, superCallElement, function2)) {
                    return;
                }
                if (KotlinRedundantOverrideInspectionKt.access$isDefinedInDelegatedSuperType(function2, qualifiedExpression)) {
                    return;
                }
                InspectionManager inspectionManager = this.$holder.getManager();
                PsiElement psiElement3 = function2;
                KtModifierList ktModifierList = modifierList;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktModifierList, (String)"modifierList");
                int n = ktModifierList.getStartOffsetInParent();
                PsiElement psiElement4 = funKeyword;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"funKeyword");
                ProblemDescriptor descriptor2 = inspectionManager.createProblemDescriptor(psiElement3, new TextRange(n, PsiUtilsKt.getEndOffset(psiElement4) - PsiUtilsKt.getStartOffset(function2)), "Redundant override", ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.$isOnTheFly, new LocalQuickFix[]{new RedundantOverrideFix()});
                this.$holder.registerProblem(descriptor2);
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
                this.$isOnTheFly = $captured_local_variable$2;
            }
        };
    }

    private final boolean isSameArguments(KtCallElement superCallElement, KtNamedFunction function2) {
        boolean bl;
        block4: {
            List<? extends ValueArgument> arguments2 = superCallElement.getValueArguments();
            List<KtParameter> parameters2 = function2.getValueParameters();
            if (arguments2.size() != parameters2.size()) {
                return false;
            }
            List<? extends ValueArgument> list2 = arguments2;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"arguments");
            Iterable iterable = list2;
            List<KtParameter> list3 = parameters2;
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"parameters");
            Iterable $receiver$iv = CollectionsKt.zip((Iterable)iterable, (Iterable)list3);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Pair $argument_parameter = (Pair)element$iv;
                    ValueArgument argument2 = (ValueArgument)$argument_parameter.component1();
                    KtParameter parameter = (KtParameter)$argument_parameter.component2();
                    KtExpression ktExpression = argument2.getArgumentExpression();
                    String string = ktExpression != null ? ktExpression.getText() : null;
                    KtParameter ktParameter = parameter;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"parameter");
                    if (Intrinsics.areEqual((Object)string, (Object)ktParameter.getName())) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isSameFunctionName(KtCallElement superSelectorExpression, KtNamedFunction function2) {
        Object object = KtPsiUtilKt.getCallNameExpression(superSelectorExpression);
        if (object == null || (object = object.getText()) == null) {
            return false;
        }
        Object superCallMethodName = object;
        return Intrinsics.areEqual((Object)function2.getName(), (Object)superCallMethodName);
    }

    static {
        Companion = new Companion(null);
        Intrinsics.checkExpressionValueIsNotNull((Object)KtTokens.MODIFIER_KEYWORDS_ARRAY, (String)"KtTokens.MODIFIER_KEYWORDS_ARRAY");
        MODIFIER_EXCLUDE_OVERRIDE = CollectionsKt.minus((Iterable)ArraysKt.asList((Object[])((Object[])KtTokens.MODIFIER_KEYWORDS_ARRAY)), (Object)((Object)KtTokens.OVERRIDE_KEYWORD));
    }

    public static final /* synthetic */ boolean access$isSameFunctionName(KotlinRedundantOverrideInspection $this, @NotNull KtCallElement superSelectorExpression, @NotNull KtNamedFunction function2) {
        return $this.isSameFunctionName(superSelectorExpression, function2);
    }

    public static final /* synthetic */ boolean access$isSameArguments(KotlinRedundantOverrideInspection $this, @NotNull KtCallElement superCallElement, @NotNull KtNamedFunction function2) {
        return $this.isSameArguments(superCallElement, function2);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinRedundantOverrideInspection$RedundantOverrideFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    private static final class RedundantOverrideFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return "Remove redundant override";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            descriptor2.getPsiElement().delete();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinRedundantOverrideInspection$Companion;", "", "()V", "MODIFIER_EXCLUDE_OVERRIDE", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "kotlin.jvm.PlatformType", "getMODIFIER_EXCLUDE_OVERRIDE", "()Ljava/util/List;", "idea"})
    public static final class Companion {
        private final List<KtModifierKeywordToken> getMODIFIER_EXCLUDE_OVERRIDE() {
            return MODIFIER_EXCLUDE_OVERRIDE;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ List access$getMODIFIER_EXCLUDE_OVERRIDE$p(Companion $this) {
            return $this.getMODIFIER_EXCLUDE_OVERRIDE();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

